/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_ctl_regs_0.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:08 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_ctl_regs_0.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_CTL_REGS_0_H__
#define BCHP_DDR23_CTL_REGS_0_H__

/***************************************************************************
 *DDR23_CTL_REGS_0 - DDR23 controller registers
 ***************************************************************************/
#define BCHP_DDR23_CTL_REGS_0_REVISION           0x01800000 /* DDR23 Controller revision register */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS         0x01800004 /* DDR23 Controller status register */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1            0x01800010 /* DDR23 Controller Configuration Set #1 */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2            0x01800014 /* DDR23 Controller Configuration Set #2 */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3            0x01800018 /* DDR23 Controller Configuration Set #3 */
#define BCHP_DDR23_CTL_REGS_0_REFRESH            0x0180001c /* DDR23 Controller Automated Refresh Configuration */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD        0x01800020 /* Host Initiated Refresh Control */
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD      0x01800024 /* Host Initiated Precharge Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD      0x01800028 /* Host Initiated Load Mode Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD     0x0180002c /* Host Initiated Load Extended Mode Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD    0x01800030 /* Host Initiated Load Extended Mode #2 Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD    0x01800034 /* Host Initiated Load Extended Mode #3 Control */
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE       0x01800038 /* Host Initiated ZQ Calibration Cycle */
#define BCHP_DDR23_CTL_REGS_0_CMD_STATUS         0x0180003c /* Host Command Interface Status */
#define BCHP_DDR23_CTL_REGS_0_LATENCY            0x01800040 /* DDR2 Controller Access Latency Control */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE0         0x01800044 /* Semaphore Register #0 */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE1         0x01800048 /* Semaphore Register #1 */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE2         0x0180004c /* Semaphore Register #2 */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE3         0x01800050 /* Semaphore Register #3 */
#define BCHP_DDR23_CTL_REGS_0_SCRATCH            0x01800058 /* Scratch Register */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_WIDTH       0x01800060 /* Stripe Width */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0    0x01800070 /* Stripe Height for picture buffers 0 through 23 */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1    0x01800074 /* Stripe Height for picture buffers 24 through 27 */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2    0x01800078 /* Stripe Height for picture buffers 28 through 31 */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL      0x01800090 /* DDR Phy-Bist Control and Status */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_SEED       0x01800094 /* DDR Phy-Bist PRPG Seed Value */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS 0x01800098 /* DDR Phy-Bist Address & Control Status */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS  0x0180009c /* DDR Phy-Bist DQ Status */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS 0x018000a0 /* DDR Phy-Bist Miscellaneous Status */
#define BCHP_DDR23_CTL_REGS_0_VDL_CTL            0x018000b0 /* Dynamic VDL Changes Control */
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_BASE       0x018000b4 /* Dynamic VDL Changes Base Address */
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_END        0x018000b8 /* Dynamic VDL Changes End Address */
#define BCHP_DDR23_CTL_REGS_0_PMON_CTL           0x018000c0 /* Performance Monitoring Control */
#define BCHP_DDR23_CTL_REGS_0_PMON_PERIOD        0x018000c4 /* Performance Monitoring Period Control */
#define BCHP_DDR23_CTL_REGS_0_PMON_CYCLE_CNT     0x018000c8 /* Performance Monitoring Active Cycles Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_IDLE_CNT      0x018000cc /* Performance Monitoring Idle Cycles Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT1       0x018000d0 /* Performance Monitoring Data Channel #1 Read Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT2       0x018000d4 /* Performance Monitoring Data Channel #2 Read Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT3       0x018000d8 /* Performance Monitoring Data Channel #3 Read Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT1       0x018000dc /* Performance Monitoring Data Channel #1 Write Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT2       0x018000e0 /* Performance Monitoring Data Channel #2 Write Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT3       0x018000e4 /* Performance Monitoring Data Channel #3 Write Accesses Count */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM             0x018000e8 /* RAM Macro TM Control */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL         0x018000f0 /* RAM Macro TM Control */

/***************************************************************************
 *REVISION - DDR23 Controller revision register
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: REVISION :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_REVISION_reserved0_MASK              0xffff0000
#define BCHP_DDR23_CTL_REGS_0_REVISION_reserved0_SHIFT             16

/* DDR23_CTL_REGS_0 :: REVISION :: MAJOR [15:08] */
#define BCHP_DDR23_CTL_REGS_0_REVISION_MAJOR_MASK                  0x0000ff00
#define BCHP_DDR23_CTL_REGS_0_REVISION_MAJOR_SHIFT                 8

/* DDR23_CTL_REGS_0 :: REVISION :: MINOR [07:00] */
#define BCHP_DDR23_CTL_REGS_0_REVISION_MINOR_MASK                  0x000000ff
#define BCHP_DDR23_CTL_REGS_0_REVISION_MINOR_SHIFT                 0

/***************************************************************************
 *CTL_STATUS - DDR23 Controller status register
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: CTL_STATUS :: reserved0 [31:07] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_reserved0_MASK            0xffffff80
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_reserved0_SHIFT           7

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: rd_fifo3_empty [06:06] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo3_empty_MASK       0x00000040
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo3_empty_SHIFT      6

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: rd_fifo2_empty [05:05] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo2_empty_MASK       0x00000020
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo2_empty_SHIFT      5

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: rd_fifo1_empty [04:04] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo1_empty_MASK       0x00000010
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_rd_fifo1_empty_SHIFT      4

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: reserved1 [03:02] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_reserved1_MASK            0x0000000c
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_reserved1_SHIFT           2

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: clke [01:01] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_clke_MASK                 0x00000002
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_clke_SHIFT                1

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: idle [00:00] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_idle_MASK                 0x00000001
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_idle_SHIFT                0

/***************************************************************************
 *PARAMS1 - DDR23 Controller Configuration Set #1
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS1 :: trtp [31:28] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trtp_MASK                    0xf0000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trtp_SHIFT                   28

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twl [27:24] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twl_MASK                     0x0f000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twl_SHIFT                    24

/* DDR23_CTL_REGS_0 :: PARAMS1 :: tcas [23:20] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_tcas_MASK                    0x00f00000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_tcas_SHIFT                   20

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twtr [19:16] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twtr_MASK                    0x000f0000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twtr_SHIFT                   16

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twr [15:12] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twr_MASK                     0x0000f000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twr_SHIFT                    12

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trrd [11:08] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trrd_MASK                    0x00000f00
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trrd_SHIFT                   8

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trp [07:04] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trp_MASK                     0x000000f0
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trp_SHIFT                    4

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trcd [03:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trcd_MASK                    0x0000000f
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trcd_SHIFT                   0

/***************************************************************************
 *PARAMS2 - DDR23 Controller Configuration Set #2
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS2 :: auto_idle [31:31] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_auto_idle_MASK               0x80000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_auto_idle_SHIFT              31

/* DDR23_CTL_REGS_0 :: PARAMS2 :: row_bits [30:30] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_row_bits_MASK                0x40000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_row_bits_SHIFT               30

/* DDR23_CTL_REGS_0 :: PARAMS2 :: use_chr_hgt [29:29] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_use_chr_hgt_MASK             0x20000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_use_chr_hgt_SHIFT            29

/* DDR23_CTL_REGS_0 :: PARAMS2 :: clke [28:28] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_clke_MASK                    0x10000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_clke_SHIFT                   28

/* DDR23_CTL_REGS_0 :: PARAMS2 :: sd_col_bits [27:26] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_sd_col_bits_MASK             0x0c000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_sd_col_bits_SHIFT            26

/* DDR23_CTL_REGS_0 :: PARAMS2 :: il_sel [25:25] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_il_sel_MASK                  0x02000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_il_sel_SHIFT                 25

/* DDR23_CTL_REGS_0 :: PARAMS2 :: dis_itlv [24:24] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_dis_itlv_MASK                0x01000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_dis_itlv_SHIFT               24

/* DDR23_CTL_REGS_0 :: PARAMS2 :: reserved0 [23:23] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_reserved0_MASK               0x00800000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_reserved0_SHIFT              23

/* DDR23_CTL_REGS_0 :: PARAMS2 :: cs0_only [22:22] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_cs0_only_MASK                0x00400000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_cs0_only_SHIFT               22

/* DDR23_CTL_REGS_0 :: PARAMS2 :: allow_pictmem_rd [21:21] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_allow_pictmem_rd_MASK        0x00200000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_allow_pictmem_rd_SHIFT       21

/* DDR23_CTL_REGS_0 :: PARAMS2 :: bank_bits [20:20] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_bank_bits_MASK               0x00100000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_bank_bits_SHIFT              20

/* DDR23_CTL_REGS_0 :: PARAMS2 :: trfc [19:12] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_trfc_MASK                    0x000ff000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_trfc_SHIFT                   12

/* DDR23_CTL_REGS_0 :: PARAMS2 :: tfaw [11:06] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tfaw_MASK                    0x00000fc0
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tfaw_SHIFT                   6

/* DDR23_CTL_REGS_0 :: PARAMS2 :: tras [05:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tras_MASK                    0x0000003f
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tras_SHIFT                   0

/***************************************************************************
 *PARAMS3 - DDR23 Controller Configuration Set #3
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS3 :: ddr3_reset [31:31] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr3_reset_MASK              0x80000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr3_reset_SHIFT             31

/* DDR23_CTL_REGS_0 :: PARAMS3 :: reserved0 [30:06] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_reserved0_MASK               0x7fffffc0
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_reserved0_SHIFT              6

/* DDR23_CTL_REGS_0 :: PARAMS3 :: ddr_bl [05:05] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr_bl_MASK                  0x00000020
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr_bl_SHIFT                 5

/* DDR23_CTL_REGS_0 :: PARAMS3 :: cmd_2t [04:04] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_cmd_2t_MASK                  0x00000010
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_cmd_2t_SHIFT                 4

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_mode [03:03] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_mode_MASK             0x00000008
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_mode_SHIFT            3

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_te_adj [02:02] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_te_adj_MASK           0x00000004
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_te_adj_SHIFT          2

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_le_adj [01:01] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_le_adj_MASK           0x00000002
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_le_adj_SHIFT          1

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_en [00:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_en_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_en_SHIFT              0

/***************************************************************************
 *REFRESH - DDR23 Controller Automated Refresh Configuration
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: REFRESH :: reserved0 [31:13] */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_reserved0_MASK               0xffffe000
#define BCHP_DDR23_CTL_REGS_0_REFRESH_reserved0_SHIFT              13

/* DDR23_CTL_REGS_0 :: REFRESH :: enable [12:12] */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_enable_MASK                  0x00001000
#define BCHP_DDR23_CTL_REGS_0_REFRESH_enable_SHIFT                 12

/* DDR23_CTL_REGS_0 :: REFRESH :: period [11:00] */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_period_MASK                  0x00000fff
#define BCHP_DDR23_CTL_REGS_0_REFRESH_period_SHIFT                 0

/***************************************************************************
 *REFRESH_CMD - Host Initiated Refresh Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: REFRESH_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD_reserved0_MASK           0xffff0000
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD_reserved0_SHIFT          16

/* DDR23_CTL_REGS_0 :: REFRESH_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD_cmd_MASK                 0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD_cmd_SHIFT                0

/***************************************************************************
 *PRECHARGE_CMD - Host Initiated Precharge Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PRECHARGE_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD_reserved0_MASK         0xffff0000
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD_reserved0_SHIFT        16

/* DDR23_CTL_REGS_0 :: PRECHARGE_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD_cmd_MASK               0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD_cmd_SHIFT              0

/***************************************************************************
 *LOAD_MODE_CMD - Host Initiated Load Mode Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: LOAD_MODE_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD_reserved0_MASK         0xffff0000
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD_reserved0_SHIFT        16

/* DDR23_CTL_REGS_0 :: LOAD_MODE_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD_cmd_MASK               0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD_cmd_SHIFT              0

/***************************************************************************
 *LOAD_EMODE_CMD - Host Initiated Load Extended Mode Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: LOAD_EMODE_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD_reserved0_MASK        0xffff0000
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD_reserved0_SHIFT       16

/* DDR23_CTL_REGS_0 :: LOAD_EMODE_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD_cmd_MASK              0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD_cmd_SHIFT             0

/***************************************************************************
 *LOAD_EMODE2_CMD - Host Initiated Load Extended Mode #2 Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: LOAD_EMODE2_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD_reserved0_MASK       0xffff0000
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD_reserved0_SHIFT      16

/* DDR23_CTL_REGS_0 :: LOAD_EMODE2_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD_cmd_MASK             0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD_cmd_SHIFT            0

/***************************************************************************
 *LOAD_EMODE3_CMD - Host Initiated Load Extended Mode #3 Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: LOAD_EMODE3_CMD :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD_reserved0_MASK       0xffff0000
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD_reserved0_SHIFT      16

/* DDR23_CTL_REGS_0 :: LOAD_EMODE3_CMD :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD_cmd_MASK             0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD_cmd_SHIFT            0

/***************************************************************************
 *ZQ_CALIBRATE - Host Initiated ZQ Calibration Cycle
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: ZQ_CALIBRATE :: reserved0 [31:16] */
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE_reserved0_MASK          0xffff0000
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE_reserved0_SHIFT         16

/* DDR23_CTL_REGS_0 :: ZQ_CALIBRATE :: cmd [15:00] */
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE_cmd_MASK                0x0000ffff
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE_cmd_SHIFT               0

/***************************************************************************
 *CMD_STATUS - Host Command Interface Status
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: CMD_STATUS :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_CMD_STATUS_reserved0_MASK            0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_CMD_STATUS_reserved0_SHIFT           1

/* DDR23_CTL_REGS_0 :: CMD_STATUS :: status [00:00] */
#define BCHP_DDR23_CTL_REGS_0_CMD_STATUS_status_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_CMD_STATUS_status_SHIFT              0

/***************************************************************************
 *LATENCY - DDR2 Controller Access Latency Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: LATENCY :: reserved0 [31:10] */
#define BCHP_DDR23_CTL_REGS_0_LATENCY_reserved0_MASK               0xfffffc00
#define BCHP_DDR23_CTL_REGS_0_LATENCY_reserved0_SHIFT              10

/* DDR23_CTL_REGS_0 :: LATENCY :: limit [09:00] */
#define BCHP_DDR23_CTL_REGS_0_LATENCY_limit_MASK                   0x000003ff
#define BCHP_DDR23_CTL_REGS_0_LATENCY_limit_SHIFT                  0

/***************************************************************************
 *SEMAPHORE0 - Semaphore Register #0
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: SEMAPHORE0 :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE0_reserved0_MASK            0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE0_reserved0_SHIFT           1

/* DDR23_CTL_REGS_0 :: SEMAPHORE0 :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE0_enable_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE0_enable_SHIFT              0

/***************************************************************************
 *SEMAPHORE1 - Semaphore Register #1
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: SEMAPHORE1 :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE1_reserved0_MASK            0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE1_reserved0_SHIFT           1

/* DDR23_CTL_REGS_0 :: SEMAPHORE1 :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE1_enable_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE1_enable_SHIFT              0

/***************************************************************************
 *SEMAPHORE2 - Semaphore Register #2
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: SEMAPHORE2 :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE2_reserved0_MASK            0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE2_reserved0_SHIFT           1

/* DDR23_CTL_REGS_0 :: SEMAPHORE2 :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE2_enable_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE2_enable_SHIFT              0

/***************************************************************************
 *SEMAPHORE3 - Semaphore Register #3
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: SEMAPHORE3 :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE3_reserved0_MASK            0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE3_reserved0_SHIFT           1

/* DDR23_CTL_REGS_0 :: SEMAPHORE3 :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE3_enable_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_SEMAPHORE3_enable_SHIFT              0

/***************************************************************************
 *SCRATCH - Scratch Register
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: SCRATCH :: scratch [31:00] */
#define BCHP_DDR23_CTL_REGS_0_SCRATCH_scratch_MASK                 0xffffffff
#define BCHP_DDR23_CTL_REGS_0_SCRATCH_scratch_SHIFT                0

/***************************************************************************
 *STRIPE_WIDTH - Stripe Width
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: STRIPE_WIDTH :: reserved0 [31:02] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_WIDTH_reserved0_MASK          0xfffffffc
#define BCHP_DDR23_CTL_REGS_0_STRIPE_WIDTH_reserved0_SHIFT         2

/* DDR23_CTL_REGS_0 :: STRIPE_WIDTH :: swidth [01:00] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_WIDTH_swidth_MASK             0x00000003
#define BCHP_DDR23_CTL_REGS_0_STRIPE_WIDTH_swidth_SHIFT            0

/***************************************************************************
 *STRIPE_HEIGHT_0 - Stripe Height for picture buffers 0 through 23
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_0 :: reserved0 [31:27] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_reserved0_MASK       0xf8000000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_reserved0_SHIFT      27

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_0 :: chroma_height [26:16] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_chroma_height_MASK   0x07ff0000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_chroma_height_SHIFT  16

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_0 :: reserved1 [15:11] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_reserved1_MASK       0x0000f800
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_reserved1_SHIFT      11

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_0 :: luma_height [10:00] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_luma_height_MASK     0x000007ff
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_0_luma_height_SHIFT    0

/***************************************************************************
 *STRIPE_HEIGHT_1 - Stripe Height for picture buffers 24 through 27
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_1 :: reserved0 [31:27] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_reserved0_MASK       0xf8000000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_reserved0_SHIFT      27

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_1 :: chroma_height [26:16] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_chroma_height_MASK   0x07ff0000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_chroma_height_SHIFT  16

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_1 :: reserved1 [15:11] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_reserved1_MASK       0x0000f800
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_reserved1_SHIFT      11

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_1 :: luma_height [10:00] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_luma_height_MASK     0x000007ff
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_1_luma_height_SHIFT    0

/***************************************************************************
 *STRIPE_HEIGHT_2 - Stripe Height for picture buffers 28 through 31
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_2 :: reserved0 [31:27] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_reserved0_MASK       0xf8000000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_reserved0_SHIFT      27

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_2 :: chroma_height [26:16] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_chroma_height_MASK   0x07ff0000
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_chroma_height_SHIFT  16

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_2 :: reserved1 [15:11] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_reserved1_MASK       0x0000f800
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_reserved1_SHIFT      11

/* DDR23_CTL_REGS_0 :: STRIPE_HEIGHT_2 :: luma_height [10:00] */
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_luma_height_MASK     0x000007ff
#define BCHP_DDR23_CTL_REGS_0_STRIPE_HEIGHT_2_luma_height_SHIFT    0

/***************************************************************************
 *PHYBIST_CNTRL - DDR Phy-Bist Control and Status
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: reserved0 [31:18] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved0_MASK         0xfffc0000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved0_SHIFT        18

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_error_pos [17:16] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_error_pos_MASK   0x00030000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_error_pos_SHIFT  16

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: reserved1 [15:14] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved1_MASK         0x0000c000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved1_SHIFT        14

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_error_sel [13:08] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_error_sel_MASK   0x00003f00
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_error_sel_SHIFT  8

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: reserved2 [07:05] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved2_MASK         0x000000e0
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_reserved2_SHIFT        5

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_dat_error [04:04] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_dat_error_MASK   0x00000010
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_dat_error_SHIFT  4

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_ctl_error [03:03] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_ctl_error_MASK   0x00000008
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_ctl_error_SHIFT  3

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_cs_n [02:02] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_cs_n_MASK        0x00000004
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_cs_n_SHIFT       2

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: force_odt [01:01] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_odt_MASK         0x00000002
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_force_odt_SHIFT        1

/* DDR23_CTL_REGS_0 :: PHYBIST_CNTRL :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_enable_MASK            0x00000001
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CNTRL_enable_SHIFT           0

/***************************************************************************
 *PHYBIST_SEED - DDR Phy-Bist PRPG Seed Value
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PHYBIST_SEED :: seed [31:00] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_SEED_seed_MASK               0xffffffff
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_SEED_seed_SHIFT              0

/***************************************************************************
 *PHYBIST_CTL_STATUS - DDR Phy-Bist Address & Control Status
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: reserved0 [31:27] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_reserved0_MASK    0xf8000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_reserved0_SHIFT   27

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_ras_n [26:26] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ras_n_MASK    0x04000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ras_n_SHIFT   26

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_cas_n [25:25] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_cas_n_MASK    0x02000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_cas_n_SHIFT   25

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_we_n [24:24] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_we_n_MASK     0x01000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_we_n_SHIFT    24

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_cke [23:23] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_cke_MASK      0x00800000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_cke_SHIFT     23

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_odt [22:22] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_odt_MASK      0x00400000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_odt_SHIFT     22

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_reset [21:21] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_reset_MASK    0x00200000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_reset_SHIFT   21

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_ad [20:07] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ad_MASK       0x001fff80
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ad_SHIFT      7

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_ba [06:04] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ba_MASK       0x00000070
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_ba_SHIFT      4

/* DDR23_CTL_REGS_0 :: PHYBIST_CTL_STATUS :: ddr_aux [03:00] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_aux_MASK      0x0000000f
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_CTL_STATUS_ddr_aux_SHIFT     0

/***************************************************************************
 *PHYBIST_DQ_STATUS - DDR Phy-Bist DQ Status
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PHYBIST_DQ_STATUS :: ddr_dq3 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq3_MASK       0xff000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq3_SHIFT      24

/* DDR23_CTL_REGS_0 :: PHYBIST_DQ_STATUS :: ddr_dq2 [23:16] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq2_MASK       0x00ff0000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq2_SHIFT      16

/* DDR23_CTL_REGS_0 :: PHYBIST_DQ_STATUS :: ddr_dq1 [15:08] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq1_MASK       0x0000ff00
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq1_SHIFT      8

/* DDR23_CTL_REGS_0 :: PHYBIST_DQ_STATUS :: ddr_dq0 [07:00] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq0_MASK       0x000000ff
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_DQ_STATUS_ddr_dq0_SHIFT      0

/***************************************************************************
 *PHYBIST_MISC_STATUS - DDR Phy-Bist Miscellaneous Status
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PHYBIST_MISC_STATUS :: dat_done [31:31] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_dat_done_MASK    0x80000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_dat_done_SHIFT   31

/* DDR23_CTL_REGS_0 :: PHYBIST_MISC_STATUS :: ctl_done [30:30] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ctl_done_MASK    0x40000000
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ctl_done_SHIFT   30

/* DDR23_CTL_REGS_0 :: PHYBIST_MISC_STATUS :: reserved0 [29:08] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_reserved0_MASK   0x3fffff00
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_reserved0_SHIFT  8

/* DDR23_CTL_REGS_0 :: PHYBIST_MISC_STATUS :: ddr_dm [07:04] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ddr_dm_MASK      0x000000f0
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ddr_dm_SHIFT     4

/* DDR23_CTL_REGS_0 :: PHYBIST_MISC_STATUS :: ddr_clk [03:00] */
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ddr_clk_MASK     0x0000000f
#define BCHP_DDR23_CTL_REGS_0_PHYBIST_MISC_STATUS_ddr_clk_SHIFT    0

/***************************************************************************
 *VDL_CTL - Dynamic VDL Changes Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: VDL_CTL :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_VDL_CTL_reserved0_MASK               0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_VDL_CTL_reserved0_SHIFT              1

/* DDR23_CTL_REGS_0 :: VDL_CTL :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_VDL_CTL_enable_MASK                  0x00000001
#define BCHP_DDR23_CTL_REGS_0_VDL_CTL_enable_SHIFT                 0

/***************************************************************************
 *VDL_ADR_BASE - Dynamic VDL Changes Base Address
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: VDL_ADR_BASE :: addr [31:00] */
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_BASE_addr_MASK               0xffffffff
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_BASE_addr_SHIFT              0

/***************************************************************************
 *VDL_ADR_END - Dynamic VDL Changes End Address
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: VDL_ADR_END :: addr [31:00] */
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_END_addr_MASK                0xffffffff
#define BCHP_DDR23_CTL_REGS_0_VDL_ADR_END_addr_SHIFT               0

/***************************************************************************
 *PMON_CTL - Performance Monitoring Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_CTL :: reserved0 [31:01] */
#define BCHP_DDR23_CTL_REGS_0_PMON_CTL_reserved0_MASK              0xfffffffe
#define BCHP_DDR23_CTL_REGS_0_PMON_CTL_reserved0_SHIFT             1

/* DDR23_CTL_REGS_0 :: PMON_CTL :: enable [00:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_CTL_enable_MASK                 0x00000001
#define BCHP_DDR23_CTL_REGS_0_PMON_CTL_enable_SHIFT                0

/***************************************************************************
 *PMON_PERIOD - Performance Monitoring Period Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_PERIOD :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_PERIOD_reserved0_MASK           0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_PERIOD_reserved0_SHIFT          24

/* DDR23_CTL_REGS_0 :: PMON_PERIOD :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_PERIOD_count_MASK               0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_PERIOD_count_SHIFT              0

/***************************************************************************
 *PMON_CYCLE_CNT - Performance Monitoring Active Cycles Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_CYCLE_CNT :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_CYCLE_CNT_reserved0_MASK        0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_CYCLE_CNT_reserved0_SHIFT       24

/* DDR23_CTL_REGS_0 :: PMON_CYCLE_CNT :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_CYCLE_CNT_count_MASK            0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_CYCLE_CNT_count_SHIFT           0

/***************************************************************************
 *PMON_IDLE_CNT - Performance Monitoring Idle Cycles Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_IDLE_CNT :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_IDLE_CNT_reserved0_MASK         0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_IDLE_CNT_reserved0_SHIFT        24

/* DDR23_CTL_REGS_0 :: PMON_IDLE_CNT :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_IDLE_CNT_count_MASK             0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_IDLE_CNT_count_SHIFT            0

/***************************************************************************
 *PMON_RD_CNT1 - Performance Monitoring Data Channel #1 Read Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_RD_CNT1 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT1_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT1_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_RD_CNT1 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT1_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT1_count_SHIFT             0

/***************************************************************************
 *PMON_RD_CNT2 - Performance Monitoring Data Channel #2 Read Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_RD_CNT2 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT2_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT2_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_RD_CNT2 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT2_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT2_count_SHIFT             0

/***************************************************************************
 *PMON_RD_CNT3 - Performance Monitoring Data Channel #3 Read Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_RD_CNT3 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT3_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT3_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_RD_CNT3 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT3_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_RD_CNT3_count_SHIFT             0

/***************************************************************************
 *PMON_WR_CNT1 - Performance Monitoring Data Channel #1 Write Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_WR_CNT1 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT1_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT1_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_WR_CNT1 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT1_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT1_count_SHIFT             0

/***************************************************************************
 *PMON_WR_CNT2 - Performance Monitoring Data Channel #2 Write Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_WR_CNT2 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT2_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT2_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_WR_CNT2 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT2_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT2_count_SHIFT             0

/***************************************************************************
 *PMON_WR_CNT3 - Performance Monitoring Data Channel #3 Write Accesses Count
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PMON_WR_CNT3 :: reserved0 [31:24] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT3_reserved0_MASK          0xff000000
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT3_reserved0_SHIFT         24

/* DDR23_CTL_REGS_0 :: PMON_WR_CNT3 :: count [23:00] */
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT3_count_MASK              0x00ffffff
#define BCHP_DDR23_CTL_REGS_0_PMON_WR_CNT3_count_SHIFT             0

/***************************************************************************
 *DDR_TM - RAM Macro TM Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: DDR_TM :: reserved0 [31:22] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_reserved0_MASK                0xffc00000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_reserved0_SHIFT               22

/* DDR23_CTL_REGS_0 :: DDR_TM :: sdc [21:20] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_sdc_MASK                      0x00300000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_sdc_SHIFT                     20

/* DDR23_CTL_REGS_0 :: DDR_TM :: row [19:18] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_row_MASK                      0x000c0000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_row_SHIFT                     18

/* DDR23_CTL_REGS_0 :: DDR_TM :: col [17:16] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_col_MASK                      0x00030000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_col_SHIFT                     16

/* DDR23_CTL_REGS_0 :: DDR_TM :: pic [15:14] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_pic_MASK                      0x0000c000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_pic_SHIFT                     14

/* DDR23_CTL_REGS_0 :: DDR_TM :: wrf3 [13:12] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf3_MASK                     0x00003000
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf3_SHIFT                    12

/* DDR23_CTL_REGS_0 :: DDR_TM :: wrf2 [11:10] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf2_MASK                     0x00000c00
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf2_SHIFT                    10

/* DDR23_CTL_REGS_0 :: DDR_TM :: wrf1 [09:08] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf1_MASK                     0x00000300
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_wrf1_SHIFT                    8

/* DDR23_CTL_REGS_0 :: DDR_TM :: rdf3 [07:06] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf3_MASK                     0x000000c0
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf3_SHIFT                    6

/* DDR23_CTL_REGS_0 :: DDR_TM :: rdf2 [05:04] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf2_MASK                     0x00000030
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf2_SHIFT                    4

/* DDR23_CTL_REGS_0 :: DDR_TM :: rdf1_1 [03:02] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf1_1_MASK                   0x0000000c
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf1_1_SHIFT                  2

/* DDR23_CTL_REGS_0 :: DDR_TM :: rdf1_0 [01:00] */
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf1_0_MASK                   0x00000003
#define BCHP_DDR23_CTL_REGS_0_DDR_TM_rdf1_0_SHIFT                  0

/***************************************************************************
 *UPDATE_VDL - RAM Macro TM Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: UPDATE_VDL :: reserved0 [31:02] */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_reserved0_MASK            0xfffffffc
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_reserved0_SHIFT           2

/* DDR23_CTL_REGS_0 :: UPDATE_VDL :: force [01:01] */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_force_MASK                0x00000002
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_force_SHIFT               1

/* DDR23_CTL_REGS_0 :: UPDATE_VDL :: refresh [00:00] */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_refresh_MASK              0x00000001
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_refresh_SHIFT             0

/***************************************************************************
 *PICT_BASE%i - Picture Buffer Base Address Ram
 ***************************************************************************/
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_ARRAY_BASE                0x01800100
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_ARRAY_START               0
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_ARRAY_END                 63
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_ARRAY_ELEMENT_SIZE        32

/***************************************************************************
 *PICT_BASE%i - Picture Buffer Base Address Ram
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PICT_BASEi :: address [31:12] */
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_address_MASK              0xfffff000
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_address_SHIFT             12

/* DDR23_CTL_REGS_0 :: PICT_BASEi :: reserved0 [11:00] */
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_reserved0_MASK            0x00000fff
#define BCHP_DDR23_CTL_REGS_0_PICT_BASEi_reserved0_SHIFT           0


#endif /* #ifndef BCHP_DDR23_CTL_REGS_0_H__ */

/* End of File */
