/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_sun_top_ctrl.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:20p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:07 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_sun_top_ctrl.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:20p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_SUN_TOP_CTRL_H__
#define BCHP_SUN_TOP_CTRL_H__

/***************************************************************************
 *SUN_TOP_CTRL - Top Control registers
 ***************************************************************************/
#define BCHP_SUN_TOP_CTRL_PROD_REVISION          0x00404000 /* Product Revision ID */
#define BCHP_SUN_TOP_CTRL_SUN_REVISION           0x00404004 /* Sundry Revision ID */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL             0x00404008 /* Reset control */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL               0x00404010 /* Control register for NMI */
#define BCHP_SUN_TOP_CTRL_SW_RESET               0x00404014 /* Software reset register */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY          0x00404018 /* Reset history */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0          0x0040401c /* Strapping values */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1          0x00404020 /* Strapping values */
#define BCHP_SUN_TOP_CTRL_BOND_STATUS            0x00404024 /* Bond option value register */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0      0x00404028 /* OTP option test register */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_1      0x0040402c /* OTP option test register */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0    0x00404030 /* OTP option status register */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_1    0x00404034 /* OTP option status register */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_0            0x00404038 /* Semaphore channel 0 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_1            0x0040403c /* Semaphore channel 1 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_2            0x00404040 /* Semaphore channel 2 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_3            0x00404044 /* Semaphore channel 3 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_4            0x00404048 /* Semaphore channel 4 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_5            0x0040404c /* Semaphore channel 5 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_6            0x00404050 /* Semaphore channel 6 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_7            0x00404054 /* Semaphore channel 7 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_8            0x00404058 /* Semaphore channel 8 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_9            0x0040405c /* Semaphore channel 9 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_10           0x00404060 /* Semaphore channel 10 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_11           0x00404064 /* Semaphore channel 11 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_12           0x00404068 /* Semaphore channel 12 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_13           0x0040406c /* Semaphore channel 13 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_14           0x00404070 /* Semaphore channel 14 */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_15           0x00404074 /* Semaphore channel 15 */
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_0         0x00404078 /* General watchdog timer 0 */
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_1         0x0040407c /* General watchdog timer 1 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0         0x00404080 /* General control register 0 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1         0x00404084 /* General control register 1 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_2         0x00404088 /* General control register 2 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3         0x0040408c /* General control register 3 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_4         0x00404090 /* General control register 4 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5         0x00404094 /* General control register 5 */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_0       0x00404098 /* General status register 0 */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_1       0x0040409c /* General status register 1 */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2       0x004040a0 /* General status register 2 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0 0x004040a4 /* General control register without scan 0 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1 0x004040a8 /* General control register without scan 1 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2 0x004040ac /* General control register without scan 2 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3 0x004040b0 /* General control register without scan 3 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4 0x004040b4 /* General control register without scan 4 */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5 0x004040b8 /* General control register without scan 5 */
#define BCHP_SUN_TOP_CTRL_UNCLEARED_SCRATCH      0x004040bc /* Scratch register */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL             0x004040c0 /* Spare control bits reserved for future use */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0         0x00404100 /* Pinmux control register 0 */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1         0x00404104 /* Pinmux control register 1 */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0     0x00404180 /* Bypass clock unselect register 0 */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL         0x00404200 /* Test port control */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_PEEK     0x00404204 /* Testport peek register */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_POKE     0x00404208 /* Testport poke register */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_PEEK      0x0040420c /* Testport peek register */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_POKE      0x00404210 /* Testport poke register */
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN         0x00404214 /* EJTAG input bus enables */
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL       0x00404218 /* EJTAG output select */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL        0x0040421c /* UART Router select */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG             0x00404300 /* Serial Slave Port configuration register */
#define BCHP_SUN_TOP_CTRL_SERS_REV               0x00404320 /* SERS Revision Register */
#define BCHP_SUN_TOP_CTRL_SERS_CFG               0x00404324 /* SERS Configuration Register */
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL      0x00404400 /* Block select for RO testmode */
#define BCHP_SUN_TOP_CTRL_TEST_MODE_CTRL         0x00404500 /* Test_mode control register */
#define BCHP_SUN_TOP_CTRL_TEST_MODE              0x00404504 /* Register source for test_mode */
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE          0x00404508 /* Register source for sub_test_mode */
#define BCHP_SUN_TOP_CTRL_LATCHED_TEST_MODE      0x0040450c /* Final latched testmode value */
#define BCHP_SUN_TOP_CTRL_LATCHED_SUB_TEST_MODE  0x00404510 /* Final latched sub-testmode value */
#define BCHP_SUN_TOP_CTRL_PM_CTRL                0x00404600 /* Control register for Power Controller */
#define BCHP_SUN_TOP_CTRL_PM_IRQ_INPUT_STATUS    0x00404604 /* Power Management IRQ input status */
#define BCHP_SUN_TOP_CTRL_PM_MIPS_WAIT_COUNT     0x00404608 /* Power Management Wait counter in place of Wait for MIPS IRQ */

/***************************************************************************
 *PROD_REVISION - Product Revision ID
 ***************************************************************************/
/* SUN_TOP_CTRL :: PROD_REVISION :: product_revision [31:00] */
#define BCHP_SUN_TOP_CTRL_PROD_REVISION_product_revision_MASK      0xffffffff
#define BCHP_SUN_TOP_CTRL_PROD_REVISION_product_revision_SHIFT     0

/***************************************************************************
 *SUN_REVISION - Sundry Revision ID
 ***************************************************************************/
/* SUN_TOP_CTRL :: SUN_REVISION :: reserved0 [31:16] */
#define BCHP_SUN_TOP_CTRL_SUN_REVISION_reserved0_MASK              0xffff0000
#define BCHP_SUN_TOP_CTRL_SUN_REVISION_reserved0_SHIFT             16

/* SUN_TOP_CTRL :: SUN_REVISION :: sundry_revision [15:00] */
#define BCHP_SUN_TOP_CTRL_SUN_REVISION_sundry_revision_MASK        0x0000ffff
#define BCHP_SUN_TOP_CTRL_SUN_REVISION_sundry_revision_SHIFT       0

/***************************************************************************
 *RESET_CTRL - Reset control
 ***************************************************************************/
/* SUN_TOP_CTRL :: RESET_CTRL :: reset_outb_monitor [31:31] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_outb_monitor_MASK       0x80000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_outb_monitor_SHIFT      31

/* SUN_TOP_CTRL :: RESET_CTRL :: front_panel_reset_monitor [30:30] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_monitor_MASK 0x40000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_monitor_SHIFT 30

/* SUN_TOP_CTRL :: RESET_CTRL :: reset_outb_def_val_monitor [29:29] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_outb_def_val_monitor_MASK 0x20000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_outb_def_val_monitor_SHIFT 29

/* SUN_TOP_CTRL :: RESET_CTRL :: reset_ext_mode_monitor [28:28] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_ext_mode_monitor_MASK   0x10000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_ext_mode_monitor_SHIFT  28

/* SUN_TOP_CTRL :: RESET_CTRL :: reset_timer_205_monitor [27:27] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_timer_205_monitor_MASK  0x08000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_timer_205_monitor_SHIFT 27

/* SUN_TOP_CTRL :: RESET_CTRL :: reset_timer_200_monitor [26:26] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_timer_200_monitor_MASK  0x04000000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reset_timer_200_monitor_SHIFT 26

/* SUN_TOP_CTRL :: RESET_CTRL :: reserved0 [25:12] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reserved0_MASK                0x03fff000
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reserved0_SHIFT               12

/* SUN_TOP_CTRL :: RESET_CTRL :: clear_reset_history [11:11] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_clear_reset_history_MASK      0x00000800
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_clear_reset_history_SHIFT     11

/* SUN_TOP_CTRL :: RESET_CTRL :: aux_chip_edge_reset_enable_lock [10:10] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_aux_chip_edge_reset_enable_lock_MASK 0x00000400
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_aux_chip_edge_reset_enable_lock_SHIFT 10

/* SUN_TOP_CTRL :: RESET_CTRL :: aux_chip_edge_reset_enable [09:09] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_aux_chip_edge_reset_enable_MASK 0x00000200
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_aux_chip_edge_reset_enable_SHIFT 9

/* SUN_TOP_CTRL :: RESET_CTRL :: watchdog_reset_enable_lock [08:08] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_watchdog_reset_enable_lock_MASK 0x00000100
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_watchdog_reset_enable_lock_SHIFT 8

/* SUN_TOP_CTRL :: RESET_CTRL :: watchdog_reset_enable [07:07] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_watchdog_reset_enable_MASK    0x00000080
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_watchdog_reset_enable_SHIFT   7

/* SUN_TOP_CTRL :: RESET_CTRL :: front_panel_reset_enable_lock [06:06] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_enable_lock_MASK 0x00000040
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_enable_lock_SHIFT 6

/* SUN_TOP_CTRL :: RESET_CTRL :: front_panel_reset_enable [05:05] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_enable_MASK 0x00000020
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_enable_SHIFT 5

/* SUN_TOP_CTRL :: RESET_CTRL :: front_panel_reset_polarity [04:04] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_polarity_MASK 0x00000010
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_front_panel_reset_polarity_SHIFT 4

/* SUN_TOP_CTRL :: RESET_CTRL :: master_reset_en [03:03] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_master_reset_en_MASK          0x00000008
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_master_reset_en_SHIFT         3

/* SUN_TOP_CTRL :: RESET_CTRL :: reserved1 [02:01] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reserved1_MASK                0x00000006
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_reserved1_SHIFT               1

/* SUN_TOP_CTRL :: RESET_CTRL :: sc_insert_reset_en [00:00] */
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_sc_insert_reset_en_MASK       0x00000001
#define BCHP_SUN_TOP_CTRL_RESET_CTRL_sc_insert_reset_en_SHIFT      0

/***************************************************************************
 *NMI_CTRL - Control register for NMI
 ***************************************************************************/
/* SUN_TOP_CTRL :: NMI_CTRL :: nmi_config_lock [31:31] */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_nmi_config_lock_MASK            0x80000000
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_nmi_config_lock_SHIFT           31

/* SUN_TOP_CTRL :: NMI_CTRL :: reserved0 [30:03] */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_reserved0_MASK                  0x7ffffff8
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_reserved0_SHIFT                 3

/* SUN_TOP_CTRL :: NMI_CTRL :: nmi_pad_monitor [02:02] */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_nmi_pad_monitor_MASK            0x00000004
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_nmi_pad_monitor_SHIFT           2

/* SUN_TOP_CTRL :: NMI_CTRL :: config_nmi_polarity [01:01] */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_config_nmi_polarity_MASK        0x00000002
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_config_nmi_polarity_SHIFT       1

/* SUN_TOP_CTRL :: NMI_CTRL :: disable_pad_nmi [00:00] */
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_disable_pad_nmi_MASK            0x00000001
#define BCHP_SUN_TOP_CTRL_NMI_CTRL_disable_pad_nmi_SHIFT           0

/***************************************************************************
 *SW_RESET - Software reset register
 ***************************************************************************/
/* SUN_TOP_CTRL :: SW_RESET :: chip_master_reset [31:31] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_chip_master_reset_MASK          0x80000000
#define BCHP_SUN_TOP_CTRL_SW_RESET_chip_master_reset_SHIFT         31

/* SUN_TOP_CTRL :: SW_RESET :: cpu_sw_reset_1shot [30:30] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_cpu_sw_reset_1shot_MASK         0x40000000
#define BCHP_SUN_TOP_CTRL_SW_RESET_cpu_sw_reset_1shot_SHIFT        30

/* SUN_TOP_CTRL :: SW_RESET :: ext_sys_reset_1shot [29:29] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_ext_sys_reset_1shot_MASK        0x20000000
#define BCHP_SUN_TOP_CTRL_SW_RESET_ext_sys_reset_1shot_SHIFT       29

/* SUN_TOP_CTRL :: SW_RESET :: reserved0 [28:22] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved0_MASK                  0x1fc00000
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved0_SHIFT                 22

/* SUN_TOP_CTRL :: SW_RESET :: ext_sys_reset_level [21:21] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_ext_sys_reset_level_MASK        0x00200000
#define BCHP_SUN_TOP_CTRL_SW_RESET_ext_sys_reset_level_SHIFT       21

/* SUN_TOP_CTRL :: SW_RESET :: reserved1 [20:12] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved1_MASK                  0x001ff000
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved1_SHIFT                 12

/* SUN_TOP_CTRL :: SW_RESET :: xpt_sw_reset [11:11] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_xpt_sw_reset_MASK               0x00000800
#define BCHP_SUN_TOP_CTRL_SW_RESET_xpt_sw_reset_SHIFT              11

/* SUN_TOP_CTRL :: SW_RESET :: bvn_sw_reset [10:10] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_bvn_sw_reset_MASK               0x00000400
#define BCHP_SUN_TOP_CTRL_SW_RESET_bvn_sw_reset_SHIFT              10

/* SUN_TOP_CTRL :: SW_RESET :: sharf_sw_reset [09:09] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_sharf_sw_reset_MASK             0x00000200
#define BCHP_SUN_TOP_CTRL_SW_RESET_sharf_sw_reset_SHIFT            9

/* SUN_TOP_CTRL :: SW_RESET :: avd0_sw_reset [08:08] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_avd0_sw_reset_MASK              0x00000100
#define BCHP_SUN_TOP_CTRL_SW_RESET_avd0_sw_reset_SHIFT             8

/* SUN_TOP_CTRL :: SW_RESET :: misc_sw_reset [07:07] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_misc_sw_reset_MASK              0x00000080
#define BCHP_SUN_TOP_CTRL_SW_RESET_misc_sw_reset_SHIFT             7

/* SUN_TOP_CTRL :: SW_RESET :: ddr0_sw_reset [06:06] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_ddr0_sw_reset_MASK              0x00000040
#define BCHP_SUN_TOP_CTRL_SW_RESET_ddr0_sw_reset_SHIFT             6

/* SUN_TOP_CTRL :: SW_RESET :: blink_sw_reset [05:05] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_blink_sw_reset_MASK             0x00000020
#define BCHP_SUN_TOP_CTRL_SW_RESET_blink_sw_reset_SHIFT            5

/* SUN_TOP_CTRL :: SW_RESET :: jtag_otp_sw_reset [04:04] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_jtag_otp_sw_reset_MASK          0x00000010
#define BCHP_SUN_TOP_CTRL_SW_RESET_jtag_otp_sw_reset_SHIFT         4

/* SUN_TOP_CTRL :: SW_RESET :: cpu_sw_reset_level [03:03] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_cpu_sw_reset_level_MASK         0x00000008
#define BCHP_SUN_TOP_CTRL_SW_RESET_cpu_sw_reset_level_SHIFT        3

/* SUN_TOP_CTRL :: SW_RESET :: reserved2 [02:01] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved2_MASK                  0x00000006
#define BCHP_SUN_TOP_CTRL_SW_RESET_reserved2_SHIFT                 1

/* SUN_TOP_CTRL :: SW_RESET :: sundry_sw_reset [00:00] */
#define BCHP_SUN_TOP_CTRL_SW_RESET_sundry_sw_reset_MASK            0x00000001
#define BCHP_SUN_TOP_CTRL_SW_RESET_sundry_sw_reset_SHIFT           0

/***************************************************************************
 *RESET_HISTORY - Reset history
 ***************************************************************************/
/* SUN_TOP_CTRL :: RESET_HISTORY :: reserved0 [31:12] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_reserved0_MASK             0xfffff000
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_reserved0_SHIFT            12

/* SUN_TOP_CTRL :: RESET_HISTORY :: aux_chip_edge_reset [11:11] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_aux_chip_edge_reset_MASK   0x00000800
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_aux_chip_edge_reset_SHIFT  11

/* SUN_TOP_CTRL :: RESET_HISTORY :: cpu_chip_sft_sft_rst_b [10:10] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_cpu_chip_sft_sft_rst_b_MASK 0x00000400
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_cpu_chip_sft_sft_rst_b_SHIFT 10

/* SUN_TOP_CTRL :: RESET_HISTORY :: cpu_chip_hrd_sft_rst_b [09:09] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_cpu_chip_hrd_sft_rst_b_MASK 0x00000200
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_cpu_chip_hrd_sft_rst_b_SHIFT 9

/* SUN_TOP_CTRL :: RESET_HISTORY :: smartcard_insert_reset [08:08] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_smartcard_insert_reset_MASK 0x00000100
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_smartcard_insert_reset_SHIFT 8

/* SUN_TOP_CTRL :: RESET_HISTORY :: aux_chip_level_reset [07:07] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_aux_chip_level_reset_MASK  0x00000080
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_aux_chip_level_reset_SHIFT 7

/* SUN_TOP_CTRL :: RESET_HISTORY :: special_sw_reset [06:06] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_special_sw_reset_MASK      0x00000040
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_special_sw_reset_SHIFT     6

/* SUN_TOP_CTRL :: RESET_HISTORY :: reserved1 [05:05] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_reserved1_MASK             0x00000020
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_reserved1_SHIFT            5

/* SUN_TOP_CTRL :: RESET_HISTORY :: watchdog_timer_reset [04:04] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_watchdog_timer_reset_MASK  0x00000010
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_watchdog_timer_reset_SHIFT 4

/* SUN_TOP_CTRL :: RESET_HISTORY :: software_master_reset [03:03] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_software_master_reset_MASK 0x00000008
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_software_master_reset_SHIFT 3

/* SUN_TOP_CTRL :: RESET_HISTORY :: front_panel_4sec_reset [02:02] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_front_panel_4sec_reset_MASK 0x00000004
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_front_panel_4sec_reset_SHIFT 2

/* SUN_TOP_CTRL :: RESET_HISTORY :: main_chip_reset_input [01:01] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_main_chip_reset_input_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_main_chip_reset_input_SHIFT 1

/* SUN_TOP_CTRL :: RESET_HISTORY :: power_on_reset [00:00] */
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_power_on_reset_MASK        0x00000001
#define BCHP_SUN_TOP_CTRL_RESET_HISTORY_power_on_reset_SHIFT       0

/***************************************************************************
 *STRAP_VALUE_0 - Strapping values
 ***************************************************************************/
/* SUN_TOP_CTRL :: STRAP_VALUE_0 :: reserved0 [31:04] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_reserved0_MASK             0xfffffff0
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_reserved0_SHIFT            4

/* SUN_TOP_CTRL :: STRAP_VALUE_0 :: strap_test_enable [03:03] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_test_enable_MASK     0x00000008
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_test_enable_SHIFT    3

/* SUN_TOP_CTRL :: STRAP_VALUE_0 :: strap_config_use_default [02:02] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_config_use_default_MASK 0x00000004
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_config_use_default_SHIFT 2

/* SUN_TOP_CTRL :: STRAP_VALUE_0 :: strap_eeprom_16_bit [01:01] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_eeprom_16_bit_MASK   0x00000002
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_eeprom_16_bit_SHIFT  1

/* SUN_TOP_CTRL :: STRAP_VALUE_0 :: strap_config_use_otp [00:00] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_config_use_otp_MASK  0x00000001
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_0_strap_config_use_otp_SHIFT 0

/***************************************************************************
 *STRAP_VALUE_1 - Strapping values
 ***************************************************************************/
/* SUN_TOP_CTRL :: STRAP_VALUE_1 :: reserved0 [31:03] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_reserved0_MASK             0xfffffff8
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_reserved0_SHIFT            3

/* SUN_TOP_CTRL :: STRAP_VALUE_1 :: strap_reserved_for_ECO_2 [02:02] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_2_MASK 0x00000004
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_2_SHIFT 2

/* SUN_TOP_CTRL :: STRAP_VALUE_1 :: strap_reserved_for_ECO_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_1_SHIFT 1

/* SUN_TOP_CTRL :: STRAP_VALUE_1 :: strap_reserved_for_ECO_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_STRAP_VALUE_1_strap_reserved_for_ECO_0_SHIFT 0

/***************************************************************************
 *BOND_STATUS - Bond option value register
 ***************************************************************************/
/* SUN_TOP_CTRL :: BOND_STATUS :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_BOND_STATUS_reserved0_MASK               0xfffffffe
#define BCHP_SUN_TOP_CTRL_BOND_STATUS_reserved0_SHIFT              1

/* SUN_TOP_CTRL :: BOND_STATUS :: bond_reserved [00:00] */
#define BCHP_SUN_TOP_CTRL_BOND_STATUS_bond_reserved_MASK           0x00000001
#define BCHP_SUN_TOP_CTRL_BOND_STATUS_bond_reserved_SHIFT          0

/***************************************************************************
 *OTP_OPTION_TEST_0 - OTP option test register
 ***************************************************************************/
/* SUN_TOP_CTRL :: OTP_OPTION_TEST_0 :: reserved0 [31:05] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_reserved0_MASK         0xffffffe0
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_reserved0_SHIFT        5

/* SUN_TOP_CTRL :: OTP_OPTION_TEST_0 :: otp_option0_spare_1 [04:04] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option0_spare_1_MASK 0x00000010
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option0_spare_1_SHIFT 4

/* SUN_TOP_CTRL :: OTP_OPTION_TEST_0 :: otp_option0_spare_0 [03:03] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option0_spare_0_MASK 0x00000008
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option0_spare_0_SHIFT 3

/* SUN_TOP_CTRL :: OTP_OPTION_TEST_0 :: otp_option_en_cr [02:01] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option_en_cr_MASK  0x00000006
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option_en_cr_SHIFT 1

/* SUN_TOP_CTRL :: OTP_OPTION_TEST_0 :: otp_option_en_testport [00:00] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option_en_testport_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_0_otp_option_en_testport_SHIFT 0

/***************************************************************************
 *OTP_OPTION_TEST_1 - OTP option test register
 ***************************************************************************/
/* SUN_TOP_CTRL :: OTP_OPTION_TEST_1 :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_1_reserved0_MASK         0xfffffffe
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_1_reserved0_SHIFT        1

/* SUN_TOP_CTRL :: OTP_OPTION_TEST_1 :: otp_option1_spare_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_1_otp_option1_spare_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_TEST_1_otp_option1_spare_0_SHIFT 0

/***************************************************************************
 *OTP_OPTION_STATUS_0 - OTP option status register
 ***************************************************************************/
/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_0 :: reserved0 [31:05] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_reserved0_MASK       0xffffffe0
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_reserved0_SHIFT      5

/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_0 :: otp_option0_spare_1 [04:04] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option0_spare_1_MASK 0x00000010
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option0_spare_1_SHIFT 4

/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_0 :: otp_option0_spare_0 [03:03] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option0_spare_0_MASK 0x00000008
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option0_spare_0_SHIFT 3

/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_0 :: otp_option_en_cr [02:01] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option_en_cr_MASK 0x00000006
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option_en_cr_SHIFT 1

/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_0 :: otp_option_en_testport [00:00] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option_en_testport_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_0_otp_option_en_testport_SHIFT 0

/***************************************************************************
 *OTP_OPTION_STATUS_1 - OTP option status register
 ***************************************************************************/
/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_1 :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_1_reserved0_MASK       0xfffffffe
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_1_reserved0_SHIFT      1

/* SUN_TOP_CTRL :: OTP_OPTION_STATUS_1 :: otp_option1_spare_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_1_otp_option1_spare_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_OTP_OPTION_STATUS_1_otp_option1_spare_0_SHIFT 0

/***************************************************************************
 *SEMAPHORE_0 - Semaphore channel 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_0 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_0_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_0_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_0 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_0_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_0_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_1 - Semaphore channel 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_1 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_1_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_1_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_1 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_1_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_1_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_2 - Semaphore channel 2
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_2 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_2_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_2_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_2 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_2_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_2_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_3 - Semaphore channel 3
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_3 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_3_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_3_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_3 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_3_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_3_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_4 - Semaphore channel 4
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_4 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_4_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_4_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_4 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_4_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_4_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_5 - Semaphore channel 5
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_5 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_5_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_5_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_5 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_5_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_5_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_6 - Semaphore channel 6
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_6 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_6_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_6_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_6 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_6_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_6_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_7 - Semaphore channel 7
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_7 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_7_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_7_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_7 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_7_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_7_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_8 - Semaphore channel 8
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_8 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_8_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_8_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_8 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_8_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_8_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_9 - Semaphore channel 9
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_9 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_9_reserved0_MASK               0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_9_reserved0_SHIFT              8

/* SUN_TOP_CTRL :: SEMAPHORE_9 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_9_semaphore_ctrl_MASK          0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_9_semaphore_ctrl_SHIFT         0

/***************************************************************************
 *SEMAPHORE_10 - Semaphore channel 10
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_10 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_10_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_10_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_10 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_10_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_10_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *SEMAPHORE_11 - Semaphore channel 11
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_11 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_11_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_11_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_11 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_11_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_11_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *SEMAPHORE_12 - Semaphore channel 12
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_12 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_12_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_12_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_12 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_12_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_12_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *SEMAPHORE_13 - Semaphore channel 13
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_13 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_13_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_13_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_13 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_13_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_13_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *SEMAPHORE_14 - Semaphore channel 14
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_14 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_14_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_14_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_14 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_14_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_14_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *SEMAPHORE_15 - Semaphore channel 15
 ***************************************************************************/
/* SUN_TOP_CTRL :: SEMAPHORE_15 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_15_reserved0_MASK              0xffffff00
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_15_reserved0_SHIFT             8

/* SUN_TOP_CTRL :: SEMAPHORE_15 :: semaphore_ctrl [07:00] */
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_15_semaphore_ctrl_MASK         0x000000ff
#define BCHP_SUN_TOP_CTRL_SEMAPHORE_15_semaphore_ctrl_SHIFT        0

/***************************************************************************
 *GEN_WATCHDOG_0 - General watchdog timer 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: GEN_WATCHDOG_0 :: watchdog_timeout_value [31:00] */
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_0_watchdog_timeout_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_0_watchdog_timeout_value_SHIFT 0

/***************************************************************************
 *GEN_WATCHDOG_1 - General watchdog timer 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: GEN_WATCHDOG_1 :: watchdog_timeout_value [31:00] */
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_1_watchdog_timeout_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_GEN_WATCHDOG_1_watchdog_timeout_value_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_0 - General control register 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_reserved [31:25] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_reserved_MASK    0xfe000000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_reserved_SHIFT   25

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_burst_stat_sel [24:24] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_burst_stat_sel_MASK 0x01000000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_burst_stat_sel_SHIFT 24

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_access_mode [23:22] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_access_mode_MASK 0x00c00000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_access_mode_SHIFT 22

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_otp_prog_en [21:21] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_otp_prog_en_MASK 0x00200000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_otp_prog_en_SHIFT 21

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_otp_debug_mode [20:20] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_otp_debug_mode_MASK 0x00100000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_otp_debug_mode_SHIFT 20

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_continue_on_fail [19:19] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_continue_on_fail_MASK 0x00080000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_continue_on_fail_SHIFT 19

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_time_margin [18:16] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_time_margin_MASK 0x00070000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_time_margin_SHIFT 16

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_sadbyp [15:15] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_sadbyp_MASK 0x00008000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_sadbyp_SHIFT 15

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_unused [14:14] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_unused_MASK 0x00004000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_unused_SHIFT 14

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_pbyp [13:13] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_pbyp_MASK 0x00002000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_pbyp_SHIFT 13

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_pcount [12:10] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_pcount_MASK 0x00001c00
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_pcount_SHIFT 10

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_vsel [09:06] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_vsel_MASK 0x000003c0
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_vsel_SHIFT 6

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_wrp_prog_sel [05:05] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_prog_sel_MASK 0x00000020
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_wrp_prog_sel_SHIFT 5

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_command [04:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_command_MASK 0x0000001e
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_command_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_0 :: jtag_otp_ctrl_start [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_start_MASK  0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_0_jtag_otp_ctrl_start_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_1 - General control register 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_1 :: jtag_otp_cpu_addr [31:16] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_jtag_otp_cpu_addr_MASK    0xffff0000
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_jtag_otp_cpu_addr_SHIFT   16

/* SUN_TOP_CTRL :: GENERAL_CTRL_1 :: reserved0 [15:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_reserved0_MASK            0x0000fffe
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_reserved0_SHIFT           1

/* SUN_TOP_CTRL :: GENERAL_CTRL_1 :: jtag_otp_cpu_mode [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_jtag_otp_cpu_mode_MASK    0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_1_jtag_otp_cpu_mode_SHIFT   0

/***************************************************************************
 *GENERAL_CTRL_2 - General control register 2
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_2 :: general_ctrl_2 [31:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_2_general_ctrl_2_MASK       0xffffffff
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_2_general_ctrl_2_SHIFT      0

/***************************************************************************
 *GENERAL_CTRL_3 - General control register 3
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_3 :: reserved0 [31:04] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_reserved0_MASK            0xfffffff0
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_reserved0_SHIFT           4

/* SUN_TOP_CTRL :: GENERAL_CTRL_3 :: general_ctrl3_3 [03:03] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_3_MASK      0x00000008
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_3_SHIFT     3

/* SUN_TOP_CTRL :: GENERAL_CTRL_3 :: general_ctrl3_2 [02:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_2_MASK      0x00000004
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_2_SHIFT     2

/* SUN_TOP_CTRL :: GENERAL_CTRL_3 :: general_ctrl3_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_1_MASK      0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_1_SHIFT     1

/* SUN_TOP_CTRL :: GENERAL_CTRL_3 :: general_ctrl3_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_0_MASK      0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_3_general_ctrl3_0_SHIFT     0

/***************************************************************************
 *GENERAL_CTRL_4 - General control register 4
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_4 :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_4_reserved0_MASK            0xfffffffe
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_4_reserved0_SHIFT           1

/* SUN_TOP_CTRL :: GENERAL_CTRL_4 :: general_ctrl4_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_4_general_ctrl4_0_MASK      0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_4_general_ctrl4_0_SHIFT     0

/***************************************************************************
 *GENERAL_CTRL_5 - General control register 5
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_reserved0_MASK            0xffffff00
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_reserved0_SHIFT           8

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_7 [07:07] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_7_MASK      0x00000080
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_7_SHIFT     7

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_6 [06:06] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_6_MASK      0x00000040
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_6_SHIFT     6

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_5 [05:05] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_5_MASK      0x00000020
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_5_SHIFT     5

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_4 [04:04] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_4_MASK      0x00000010
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_4_SHIFT     4

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_3 [03:03] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_3_MASK      0x00000008
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_3_SHIFT     3

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_2 [02:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_2_MASK      0x00000004
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_2_SHIFT     2

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_1_MASK      0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_1_SHIFT     1

/* SUN_TOP_CTRL :: GENERAL_CTRL_5 :: general_ctrl5_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_0_MASK      0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_5_general_ctrl5_0_SHIFT     0

/***************************************************************************
 *GENERAL_STATUS_0 - General status register 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_STATUS_0 :: jtag_otp_data_out [31:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_0_jtag_otp_data_out_MASK  0xffffffff
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_0_jtag_otp_data_out_SHIFT 0

/***************************************************************************
 *GENERAL_STATUS_1 - General status register 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_STATUS_1 :: reserved0 [31:08] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_1_reserved0_MASK          0xffffff00
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_1_reserved0_SHIFT         8

/* SUN_TOP_CTRL :: GENERAL_STATUS_1 :: jtag_otp_status [07:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_1_jtag_otp_status_MASK    0x000000ff
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_1_jtag_otp_status_SHIFT   0

/***************************************************************************
 *GENERAL_STATUS_2 - General status register 2
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_STATUS_2 :: reserved0 [31:04] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_reserved0_MASK          0xfffffff0
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_reserved0_SHIFT         4

/* SUN_TOP_CTRL :: GENERAL_STATUS_2 :: general_status2_03 [03:03] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_03_MASK 0x00000008
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_03_SHIFT 3

/* SUN_TOP_CTRL :: GENERAL_STATUS_2 :: general_status2_02 [02:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_02_MASK 0x00000004
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_02_SHIFT 2

/* SUN_TOP_CTRL :: GENERAL_STATUS_2 :: general_status2_01 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_01_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_01_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_STATUS_2 :: general_status2_00 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_00_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_STATUS_2_general_status2_00_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_0 - General control register without scan 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_0 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_0 :: general_ctrl_no_scan0_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_general_ctrl_no_scan0_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_general_ctrl_no_scan0_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_0 :: general_ctrl_no_scan0_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_general_ctrl_no_scan0_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_0_general_ctrl_no_scan0_0_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_1 - General control register without scan 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_1 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_1 :: general_ctrl_no_scan1_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_general_ctrl_no_scan1_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_general_ctrl_no_scan1_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_1 :: general_ctrl_no_scan1_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_general_ctrl_no_scan1_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_1_general_ctrl_no_scan1_0_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_2 - General control register without scan 2
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_2 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_2 :: general_ctrl_no_scan2_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_general_ctrl_no_scan2_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_general_ctrl_no_scan2_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_2 :: general_ctrl_no_scan2_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_general_ctrl_no_scan2_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_2_general_ctrl_no_scan2_0_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_3 - General control register without scan 3
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_3 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_3 :: general_ctrl_no_scan3_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_general_ctrl_no_scan3_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_general_ctrl_no_scan3_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_3 :: general_ctrl_no_scan3_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_general_ctrl_no_scan3_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_3_general_ctrl_no_scan3_0_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_4 - General control register without scan 4
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_4 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_4 :: general_ctrl_no_scan4_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_general_ctrl_no_scan4_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_general_ctrl_no_scan4_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_4 :: general_ctrl_no_scan4_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_general_ctrl_no_scan4_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_4_general_ctrl_no_scan4_0_SHIFT 0

/***************************************************************************
 *GENERAL_CTRL_NO_SCAN_5 - General control register without scan 5
 ***************************************************************************/
/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_5 :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_reserved0_MASK    0xfffffffc
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_reserved0_SHIFT   2

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_5 :: general_ctrl_no_scan5_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_general_ctrl_no_scan5_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_general_ctrl_no_scan5_1_SHIFT 1

/* SUN_TOP_CTRL :: GENERAL_CTRL_NO_SCAN_5 :: general_ctrl_no_scan5_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_general_ctrl_no_scan5_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_GENERAL_CTRL_NO_SCAN_5_general_ctrl_no_scan5_0_SHIFT 0

/***************************************************************************
 *UNCLEARED_SCRATCH - Scratch register
 ***************************************************************************/
/* SUN_TOP_CTRL :: UNCLEARED_SCRATCH :: uncleared_scratch [31:00] */
#define BCHP_SUN_TOP_CTRL_UNCLEARED_SCRATCH_uncleared_scratch_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_UNCLEARED_SCRATCH_uncleared_scratch_SHIFT 0

/***************************************************************************
 *SPARE_CTRL - Spare control bits reserved for future use
 ***************************************************************************/
/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_31 [31:31] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_31_MASK            0x80000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_31_SHIFT           31

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_30 [30:30] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_30_MASK            0x40000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_30_SHIFT           30

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_29 [29:29] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_29_MASK            0x20000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_29_SHIFT           29

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_28 [28:28] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_28_MASK            0x10000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_28_SHIFT           28

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_27 [27:27] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_27_MASK            0x08000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_27_SHIFT           27

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_26 [26:26] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_26_MASK            0x04000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_26_SHIFT           26

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_25 [25:25] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_25_MASK            0x02000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_25_SHIFT           25

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_24 [24:24] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_24_MASK            0x01000000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_24_SHIFT           24

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_23 [23:23] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_23_MASK            0x00800000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_23_SHIFT           23

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_22 [22:22] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_22_MASK            0x00400000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_22_SHIFT           22

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_21 [21:21] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_21_MASK            0x00200000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_21_SHIFT           21

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_20 [20:20] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_20_MASK            0x00100000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_20_SHIFT           20

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_19 [19:19] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_19_MASK            0x00080000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_19_SHIFT           19

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_18 [18:18] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_18_MASK            0x00040000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_18_SHIFT           18

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_17 [17:17] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_17_MASK            0x00020000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_17_SHIFT           17

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_16 [16:16] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_16_MASK            0x00010000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_16_SHIFT           16

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_15 [15:15] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_15_MASK            0x00008000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_15_SHIFT           15

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_14 [14:14] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_14_MASK            0x00004000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_14_SHIFT           14

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_13 [13:13] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_13_MASK            0x00002000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_13_SHIFT           13

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_12 [12:12] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_12_MASK            0x00001000
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_12_SHIFT           12

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_11 [11:11] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_11_MASK            0x00000800
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_11_SHIFT           11

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_10 [10:10] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_10_MASK            0x00000400
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_10_SHIFT           10

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_09 [09:09] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_09_MASK            0x00000200
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_09_SHIFT           9

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_08 [08:08] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_08_MASK            0x00000100
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_08_SHIFT           8

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_07 [07:07] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_07_MASK            0x00000080
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_07_SHIFT           7

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_06 [06:06] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_06_MASK            0x00000040
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_06_SHIFT           6

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_05 [05:05] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_05_MASK            0x00000020
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_05_SHIFT           5

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_04 [04:04] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_04_MASK            0x00000010
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_04_SHIFT           4

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_03 [03:03] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_03_MASK            0x00000008
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_03_SHIFT           3

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_02 [02:02] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_02_MASK            0x00000004
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_02_SHIFT           2

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_01 [01:01] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_01_MASK            0x00000002
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_01_SHIFT           1

/* SUN_TOP_CTRL :: SPARE_CTRL :: spare_ctrl_00 [00:00] */
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_00_MASK            0x00000001
#define BCHP_SUN_TOP_CTRL_SPARE_CTRL_spare_ctrl_00_SHIFT           0

/***************************************************************************
 *PIN_MUX_CTRL_0 - Pinmux control register 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_07 [31:28] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_MASK              0xf0000000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_SHIFT             28
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_GPIO_07           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_SPARE0_ON_GPIO_07 1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_TEST_OUT0         2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_TP_IN7            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_TP_OUT7           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_07_RC_TP_OUT7        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_06 [27:24] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_MASK              0x0f000000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_SHIFT             24
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_GPIO_06           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_SPARE0_ON_GPIO_06 1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_TEST_ACK          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_TP_IN6            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_TP_OUT6           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_06_RC_TP_OUT6        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_05 [23:20] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_MASK              0x00f00000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_SHIFT             20
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_GPIO_05           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_DBG_UART2_RX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_TEST_REQ          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_TP_IN5            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_TP_OUT5           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_05_RC_TP_OUT5        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_04 [19:16] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_MASK              0x000f0000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_SHIFT             16
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_GPIO_04           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_DBG_UART2_TX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_TEST_CLK          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_TP_IN4            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_TP_OUT4           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_04_RC_TP_OUT4        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_03 [15:12] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_MASK              0x0000f000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_SHIFT             12
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_GPIO_03           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_DBG_UART1_RX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_TEST_IN3          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_TP_IN3            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_TP_OUT3           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_03_RC_TP_OUT3        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_02 [11:08] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_MASK              0x00000f00
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_SHIFT             8
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_GPIO_02           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_DBG_UART1_TX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_TEST_IN2          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_TP_IN2            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_TP_OUT2           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_02_RC_TP_OUT2        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_01 [07:04] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_MASK              0x000000f0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_SHIFT             4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_GPIO_01           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_DBG_UART0_RX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_TEST_IN1          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_TP_IN1            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_TP_OUT1           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_01_RC_TP_OUT1        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_0 :: gpio_00 [03:00] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_MASK              0x0000000f
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_SHIFT             0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_GPIO_00           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_DBG_UART0_TX      1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_TEST_IN0          2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_TP_IN0            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_TP_OUT0           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0_gpio_00_RC_TP_OUT0        5

/***************************************************************************
 *PIN_MUX_CTRL_1 - Pinmux control register 1
 ***************************************************************************/
/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: reserved0 [31:24] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_reserved0_MASK            0xff000000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_reserved0_SHIFT           24

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: eeprom_data [23:20] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_data_MASK          0x00f00000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_data_SHIFT         20
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_data_EEPROM_DATA   0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_data_PCIE_MDIO_RST 1

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: eeprom_clk [19:16] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_clk_MASK           0x000f0000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_clk_SHIFT          16
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_clk_EEPROM_CLK     0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_eeprom_clk_PCIE_MDC       1

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: gpio_11 [15:12] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_MASK              0x0000f000
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_SHIFT             12
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_GPIO_11           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_PCIE_MDIO         1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_SPARE0_ON_GPIO_11 2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_TP_IN11           3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_TP_OUT11          4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_11_RC_TP_OUT11       5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: gpio_10 [11:08] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_MASK              0x00000f00
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_SHIFT             8
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_GPIO_10           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_RO_IO_TESTOUT     1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_TEST_OUT3         2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_TP_IN10           3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_TP_OUT10          4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_10_RC_TP_OUT10       5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: gpio_09 [07:04] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_MASK              0x000000f0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_SHIFT             4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_GPIO_09           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_RO_CORE_TESTOUT   1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_TEST_OUT2         2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_TP_IN9            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_TP_OUT9           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_09_RC_TP_OUT9        5

/* SUN_TOP_CTRL :: PIN_MUX_CTRL_1 :: gpio_08 [03:00] */
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_MASK              0x0000000f
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_SHIFT             0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_GPIO_08           0
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_SPARE0_ON_GPIO_08 1
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_TEST_OUT1         2
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_TP_IN8            3
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_TP_OUT8           4
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_1_gpio_08_RC_TP_OUT8        5

/***************************************************************************
 *BYP_CLK_UNSELECT_0 - Bypass clock unselect register 0
 ***************************************************************************/
/* SUN_TOP_CTRL :: BYP_CLK_UNSELECT_0 :: reserved0 [31:04] */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_reserved0_MASK        0xfffffff0
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_reserved0_SHIFT       4

/* SUN_TOP_CTRL :: BYP_CLK_UNSELECT_0 :: unsel_byp_clk_on_low_pwr_n [03:03] */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_low_pwr_n_MASK 0x00000008
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_low_pwr_n_SHIFT 3

/* SUN_TOP_CTRL :: BYP_CLK_UNSELECT_0 :: unsel_byp_clk_on_eeprom_clk [02:02] */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_eeprom_clk_MASK 0x00000004
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_eeprom_clk_SHIFT 2

/* SUN_TOP_CTRL :: BYP_CLK_UNSELECT_0 :: unsel_byp_clk_on_bsc_s_sda [01:01] */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_bsc_s_sda_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_bsc_s_sda_SHIFT 1

/* SUN_TOP_CTRL :: BYP_CLK_UNSELECT_0 :: unsel_byp_clk_on_bsc_s_scl [00:00] */
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_bsc_s_scl_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_BYP_CLK_UNSELECT_0_unsel_byp_clk_on_bsc_s_scl_SHIFT 0

/***************************************************************************
 *TEST_PORT_CTRL - Test port control
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_PORT_CTRL :: sundry_local_tp_out_sel [31:28] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_MASK 0xf0000000
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_SHIFT 28
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_SEMAPHORE_0 0
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_SEMAPHORE_1 1
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_FP_RST_CNT 2
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_MISC_TEST 3
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_SSP 4
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_TP_OUT_POKE_REG 5
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_TP_IN 6
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_ARB_TP_0 7
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_ARB_TP_1 8
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_ARB_TP_2 9
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_ARB_TP_3 10
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_PWR_CTRL_STATUS 11
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_PWR_CTRL_IRQ_IN 12
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_UNUSED_13 13
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_UNUSED_14 14
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_sundry_local_tp_out_sel_TOP_AUX_TP_OUT 15

/* SUN_TOP_CTRL :: TEST_PORT_CTRL :: reserved0 [27:10] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_reserved0_MASK            0x0ffffc00
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_reserved0_SHIFT           10

/* SUN_TOP_CTRL :: TEST_PORT_CTRL :: tp_in_source_select [09:09] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_tp_in_source_select_MASK  0x00000200
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_tp_in_source_select_SHIFT 9

/* SUN_TOP_CTRL :: TEST_PORT_CTRL :: tp_select [08:07] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_tp_select_MASK            0x00000180
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_tp_select_SHIFT           7

/* SUN_TOP_CTRL :: TEST_PORT_CTRL :: encoded_tp_enable [06:00] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_MASK    0x0000007f
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_SHIFT   0
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_AVD     0
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_MISC    1
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_BLINK   2
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_DDR_IF0 3
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_SUN     4
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_CLK     5
#define BCHP_SUN_TOP_CTRL_TEST_PORT_CTRL_encoded_tp_enable_UNUSED_31 31

/***************************************************************************
 *TEST_PORT_OUT_PEEK - Testport peek register
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_PORT_OUT_PEEK :: test_port_out_peek_value [31:00] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_PEEK_test_port_out_peek_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_PEEK_test_port_out_peek_value_SHIFT 0

/***************************************************************************
 *TEST_PORT_OUT_POKE - Testport poke register
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_PORT_OUT_POKE :: test_port_out_poke_value [31:00] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_POKE_test_port_out_poke_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_TEST_PORT_OUT_POKE_test_port_out_poke_value_SHIFT 0

/***************************************************************************
 *TEST_PORT_IN_PEEK - Testport peek register
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_PORT_IN_PEEK :: test_port_in_peek_value [31:00] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_PEEK_test_port_in_peek_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_PEEK_test_port_in_peek_value_SHIFT 0

/***************************************************************************
 *TEST_PORT_IN_POKE - Testport poke register
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_PORT_IN_POKE :: test_port_in_poke_value [31:00] */
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_POKE_test_port_in_poke_value_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_TEST_PORT_IN_POKE_test_port_in_poke_value_SHIFT 0

/***************************************************************************
 *EJTAG_INPUT_EN - EJTAG input bus enables
 ***************************************************************************/
/* SUN_TOP_CTRL :: EJTAG_INPUT_EN :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_reserved0_MASK            0xfffffffc
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_reserved0_SHIFT           2

/* SUN_TOP_CTRL :: EJTAG_INPUT_EN :: ejtag_input_enable [01:00] */
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_ejtag_input_enable_MASK   0x00000003
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_ejtag_input_enable_SHIFT  0
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_ejtag_input_enable_DO_NOT_USE_CPU_ONE_HOT 1
#define BCHP_SUN_TOP_CTRL_EJTAG_INPUT_EN_ejtag_input_enable_ARM_CPU_ONE_HOT 2

/***************************************************************************
 *EJTAG_OUTPUT_SEL - EJTAG output select
 ***************************************************************************/
/* SUN_TOP_CTRL :: EJTAG_OUTPUT_SEL :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_reserved0_MASK          0xfffffffc
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_reserved0_SHIFT         2

/* SUN_TOP_CTRL :: EJTAG_OUTPUT_SEL :: ejtag_output_sel [01:00] */
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_ejtag_output_sel_MASK   0x00000003
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_ejtag_output_sel_SHIFT  0
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_ejtag_output_sel_DO_NOT_USE_CPU 0
#define BCHP_SUN_TOP_CTRL_EJTAG_OUTPUT_SEL_ejtag_output_sel_ARM_CPU 1

/***************************************************************************
 *UART_ROUTER_SEL - UART Router select
 ***************************************************************************/
/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_7_cpu_sel [31:28] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_7_cpu_sel_MASK      0xf0000000
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_7_cpu_sel_SHIFT     28

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_6_cpu_sel [27:24] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_6_cpu_sel_MASK      0x0f000000
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_6_cpu_sel_SHIFT     24

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_5_cpu_sel [23:20] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_5_cpu_sel_MASK      0x00f00000
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_5_cpu_sel_SHIFT     20

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_4_cpu_sel [19:16] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_4_cpu_sel_MASK      0x000f0000
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_4_cpu_sel_SHIFT     16

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_3_cpu_sel [15:12] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_3_cpu_sel_MASK      0x0000f000
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_3_cpu_sel_SHIFT     12

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_2_cpu_sel [11:08] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_MASK      0x00000f00
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_SHIFT     8
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_NO_CPU    0
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_ARM       1
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_AVD0_OL   2
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_AVD0_IL   3
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_04 4
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_05 5
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_06 6
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_07 7
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_08 8
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_09 9
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_10 10
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_11 11
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_12 12
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_13 13
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_14 14
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_2_cpu_sel_UNUSED_15 15

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_1_cpu_sel [07:04] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_MASK      0x000000f0
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_SHIFT     4
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_NO_CPU    0
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_ARM       1
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_AVD0_OL   2
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_AVD0_IL   3
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_04 4
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_05 5
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_06 6
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_07 7
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_08 8
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_09 9
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_10 10
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_11 11
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_12 12
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_13 13
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_14 14
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_1_cpu_sel_UNUSED_15 15

/* SUN_TOP_CTRL :: UART_ROUTER_SEL :: port_0_cpu_sel [03:00] */
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_MASK      0x0000000f
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_SHIFT     0
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_NO_CPU    0
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_ARM       1
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_AVD0_OL   2
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_AVD0_IL   3
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_04 4
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_05 5
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_06 6
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_07 7
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_08 8
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_09 9
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_10 10
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_11 11
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_12 12
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_13 13
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_14 14
#define BCHP_SUN_TOP_CTRL_UART_ROUTER_SEL_port_0_cpu_sel_UNUSED_15 15

/***************************************************************************
 *SSP_CONFIG - Serial Slave Port configuration register
 ***************************************************************************/
/* SUN_TOP_CTRL :: SSP_CONFIG :: reserved0 [31:11] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_reserved0_MASK                0xfffff800
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_reserved0_SHIFT               11

/* SUN_TOP_CTRL :: SSP_CONFIG :: serial_adr_cfg [10:07] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_serial_adr_cfg_MASK           0x00000780
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_serial_adr_cfg_SHIFT          7

/* SUN_TOP_CTRL :: SSP_CONFIG :: probe_mux_sel [06:03] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_probe_mux_sel_MASK            0x00000078
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_probe_mux_sel_SHIFT           3

/* SUN_TOP_CTRL :: SSP_CONFIG :: dly_disable [02:02] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_dly_disable_MASK              0x00000004
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_dly_disable_SHIFT             2

/* SUN_TOP_CTRL :: SSP_CONFIG :: spi_mode [01:01] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_spi_mode_MASK                 0x00000002
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_spi_mode_SHIFT                1

/* SUN_TOP_CTRL :: SSP_CONFIG :: ssp_module_enable [00:00] */
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_ssp_module_enable_MASK        0x00000001
#define BCHP_SUN_TOP_CTRL_SSP_CONFIG_ssp_module_enable_SHIFT       0

/***************************************************************************
 *SERS_REV - SERS Revision Register
 ***************************************************************************/
/* SUN_TOP_CTRL :: SERS_REV :: reserved0 [31:16] */
#define BCHP_SUN_TOP_CTRL_SERS_REV_reserved0_MASK                  0xffff0000
#define BCHP_SUN_TOP_CTRL_SERS_REV_reserved0_SHIFT                 16

/* SUN_TOP_CTRL :: SERS_REV :: reserved_for_eco1 [15:08] */
#define BCHP_SUN_TOP_CTRL_SERS_REV_reserved_for_eco1_MASK          0x0000ff00
#define BCHP_SUN_TOP_CTRL_SERS_REV_reserved_for_eco1_SHIFT         8

/* SUN_TOP_CTRL :: SERS_REV :: BLOCK_SERS_REVISION [07:00] */
#define BCHP_SUN_TOP_CTRL_SERS_REV_BLOCK_SERS_REVISION_MASK        0x000000ff
#define BCHP_SUN_TOP_CTRL_SERS_REV_BLOCK_SERS_REVISION_SHIFT       0

/***************************************************************************
 *SERS_CFG - SERS Configuration Register
 ***************************************************************************/
/* SUN_TOP_CTRL :: SERS_CFG :: reserved_for_eco0 [31:29] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_reserved_for_eco0_MASK          0xe0000000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_reserved_for_eco0_SHIFT         29

/* SUN_TOP_CTRL :: SERS_CFG :: CMD_MODE [28:28] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_CMD_MODE_MASK                   0x10000000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_CMD_MODE_SHIFT                  28
#define BCHP_SUN_TOP_CTRL_SERS_CFG_CMD_MODE_mapped_buffer_mode     0
#define BCHP_SUN_TOP_CTRL_SERS_CFG_CMD_MODE_cmd_fifo_mode          1

/* SUN_TOP_CTRL :: SERS_CFG :: Little_Endian [27:27] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_Little_Endian_MASK              0x08000000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_Little_Endian_SHIFT             27

/* union - case mapped_buffer_mode [26:08] */
/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: W_PKT_OFFSET_4 [26:22] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_4_MASK 0x07c00000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_4_SHIFT 22

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: W_PKT_OFFSET_3 [21:17] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_3_MASK 0x003e0000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_3_SHIFT 17

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: W_PKT_OFFSET_2 [16:12] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_2_MASK 0x0001f000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_W_PKT_OFFSET_2_SHIFT 12

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: DATA_CHG_IRQ_ONLY_4 [11:11] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_4_MASK 0x00000800
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_4_SHIFT 11

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: DATA_CHG_IRQ_ONLY_3 [10:10] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_3_MASK 0x00000400
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_3_SHIFT 10

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: DATA_CHG_IRQ_ONLY_2 [09:09] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_2_MASK 0x00000200
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_2_SHIFT 9

/* SUN_TOP_CTRL :: SERS_CFG :: mapped_buffer_mode :: DATA_CHG_IRQ_ONLY_1 [08:08] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_1_MASK 0x00000100
#define BCHP_SUN_TOP_CTRL_SERS_CFG_mapped_buffer_mode_DATA_CHG_IRQ_ONLY_1_SHIFT 8

/* union - case cmd_fifo_mode [26:08] */
/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: CMD_W_PTR [26:22] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_W_PTR_MASK    0x07c00000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_W_PTR_SHIFT   22

/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: CMD_R_PTR [21:17] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_R_PTR_MASK    0x003e0000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_R_PTR_SHIFT   17

/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: FIFO_THRESHOLD [16:12] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_FIFO_THRESHOLD_MASK 0x0001f000
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_FIFO_THRESHOLD_SHIFT 12

/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: NOT_USED [11:10] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_NOT_USED_MASK     0x00000c00
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_NOT_USED_SHIFT    10

/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: CMD_FIFO_OV [09:09] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_FIFO_OV_MASK  0x00000200
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_CMD_FIFO_OV_SHIFT 9

/* SUN_TOP_CTRL :: SERS_CFG :: cmd_fifo_mode :: DROP_CMDS [08:08] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_DROP_CMDS_MASK    0x00000100
#define BCHP_SUN_TOP_CTRL_SERS_CFG_cmd_fifo_mode_DROP_CMDS_SHIFT   8

/* SUN_TOP_CTRL :: SERS_CFG :: SER_ADR [07:01] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_SER_ADR_MASK                    0x000000fe
#define BCHP_SUN_TOP_CTRL_SERS_CFG_SER_ADR_SHIFT                   1

/* SUN_TOP_CTRL :: SERS_CFG :: SOFT_SER_ADR [00:00] */
#define BCHP_SUN_TOP_CTRL_SERS_CFG_SOFT_SER_ADR_MASK               0x00000001
#define BCHP_SUN_TOP_CTRL_SERS_CFG_SOFT_SER_ADR_SHIFT              0

/***************************************************************************
 *SERS_CMD_BUF_%i - Host Serial Write Command Buffer
 ***************************************************************************/
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_ARRAY_BASE                0x00404328
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_ARRAY_START               0
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_ARRAY_END                 7
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_ARRAY_ELEMENT_SIZE        32

/***************************************************************************
 *SERS_CMD_BUF_%i - Host Serial Write Command Buffer
 ***************************************************************************/
/* SUN_TOP_CTRL :: SERS_CMD_BUF_i :: SERS_CMD_BUF [31:00] */
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_SERS_CMD_BUF_MASK         0xffffffff
#define BCHP_SUN_TOP_CTRL_SERS_CMD_BUF_i_SERS_CMD_BUF_SHIFT        0


/***************************************************************************
 *SERS_STAT_BUF_%i - Host Serial Read Status Buffer
 ***************************************************************************/
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_ARRAY_BASE               0x00404348
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_ARRAY_START              0
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_ARRAY_END                1
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_ARRAY_ELEMENT_SIZE       32

/***************************************************************************
 *SERS_STAT_BUF_%i - Host Serial Read Status Buffer
 ***************************************************************************/
/* SUN_TOP_CTRL :: SERS_STAT_BUF_i :: SERS_STAT_BUF [31:00] */
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_SERS_STAT_BUF_MASK       0xffffffff
#define BCHP_SUN_TOP_CTRL_SERS_STAT_BUF_i_SERS_STAT_BUF_SHIFT      0


/***************************************************************************
 *RO_TEST_BLOCK_SEL - Block select for RO testmode
 ***************************************************************************/
/* SUN_TOP_CTRL :: RO_TEST_BLOCK_SEL :: reserved0 [31:05] */
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_reserved0_MASK         0xffffffe0
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_reserved0_SHIFT        5

/* SUN_TOP_CTRL :: RO_TEST_BLOCK_SEL :: ro_test_sub_block_select [04:03] */
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_sub_block_select_MASK 0x00000018
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_sub_block_select_SHIFT 3

/* SUN_TOP_CTRL :: RO_TEST_BLOCK_SEL :: ro_test_block_select [02:00] */
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_MASK 0x00000007
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_SHIFT 0
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_DO_NOT_USE_RO_TEST_ID 0
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_SUN_RO_TEST_ID 1
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_DDR_IF_RO_TEST_ID 2
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_MISC_RO_TEST_ID 3
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_BLINK_RO_TEST_ID 4
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_AVD_RO_TEST_ID 5
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_RES0_RO_TEST_ID 6
#define BCHP_SUN_TOP_CTRL_RO_TEST_BLOCK_SEL_ro_test_block_select_CLK_GEN_RO_TEST_ID 7

/***************************************************************************
 *TEST_MODE_CTRL - Test_mode control register
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_MODE_CTRL :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_TEST_MODE_CTRL_reserved0_MASK            0xfffffffe
#define BCHP_SUN_TOP_CTRL_TEST_MODE_CTRL_reserved0_SHIFT           1

/* SUN_TOP_CTRL :: TEST_MODE_CTRL :: use_test_mode_reg_src [00:00] */
#define BCHP_SUN_TOP_CTRL_TEST_MODE_CTRL_use_test_mode_reg_src_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_TEST_MODE_CTRL_use_test_mode_reg_src_SHIFT 0

/***************************************************************************
 *TEST_MODE - Register source for test_mode
 ***************************************************************************/
/* SUN_TOP_CTRL :: TEST_MODE :: reserved0 [31:04] */
#define BCHP_SUN_TOP_CTRL_TEST_MODE_reserved0_MASK                 0xfffffff0
#define BCHP_SUN_TOP_CTRL_TEST_MODE_reserved0_SHIFT                4

/* SUN_TOP_CTRL :: TEST_MODE :: test_mode [03:00] */
#define BCHP_SUN_TOP_CTRL_TEST_MODE_test_mode_MASK                 0x0000000f
#define BCHP_SUN_TOP_CTRL_TEST_MODE_test_mode_SHIFT                0

/***************************************************************************
 *SUB_TEST_MODE - Register source for sub_test_mode
 ***************************************************************************/
/* SUN_TOP_CTRL :: SUB_TEST_MODE :: reserved0 [31:02] */
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_reserved0_MASK             0xfffffffc
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_reserved0_SHIFT            2

/* SUN_TOP_CTRL :: SUB_TEST_MODE :: sub_test_mode_spare_1 [01:01] */
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_sub_test_mode_spare_1_MASK 0x00000002
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_sub_test_mode_spare_1_SHIFT 1

/* SUN_TOP_CTRL :: SUB_TEST_MODE :: sub_test_mode_spare_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_sub_test_mode_spare_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_SUB_TEST_MODE_sub_test_mode_spare_0_SHIFT 0

/***************************************************************************
 *LATCHED_TEST_MODE - Final latched testmode value
 ***************************************************************************/
/* SUN_TOP_CTRL :: LATCHED_TEST_MODE :: latched_test_mode [31:00] */
#define BCHP_SUN_TOP_CTRL_LATCHED_TEST_MODE_latched_test_mode_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_LATCHED_TEST_MODE_latched_test_mode_SHIFT 0

/***************************************************************************
 *LATCHED_SUB_TEST_MODE - Final latched sub-testmode value
 ***************************************************************************/
/* SUN_TOP_CTRL :: LATCHED_SUB_TEST_MODE :: latched_sub_test_mode [31:00] */
#define BCHP_SUN_TOP_CTRL_LATCHED_SUB_TEST_MODE_latched_sub_test_mode_MASK 0xffffffff
#define BCHP_SUN_TOP_CTRL_LATCHED_SUB_TEST_MODE_latched_sub_test_mode_SHIFT 0

/***************************************************************************
 *PM_CTRL - Control register for Power Controller
 ***************************************************************************/
/* SUN_TOP_CTRL :: PM_CTRL :: pm_wait_count_upper_bits [31:20] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_wait_count_upper_bits_MASK    0xfff00000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_wait_count_upper_bits_SHIFT   20

/* SUN_TOP_CTRL :: PM_CTRL :: pm_wait_counter_active [19:19] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_wait_counter_active_MASK      0x00080000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_wait_counter_active_SHIFT     19

/* SUN_TOP_CTRL :: PM_CTRL :: pm_rst_clock_div [18:18] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_rst_clock_div_MASK            0x00040000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_rst_clock_div_SHIFT           18

/* SUN_TOP_CTRL :: PM_CTRL :: pm_pwrdn_pll_req [17:17] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_pwrdn_pll_req_MASK            0x00020000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_pwrdn_pll_req_SHIFT           17

/* SUN_TOP_CTRL :: PM_CTRL :: pm_dis_cml_clocks [16:16] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_cml_clocks_MASK           0x00010000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_cml_clocks_SHIFT          16

/* SUN_TOP_CTRL :: PM_CTRL :: pm_dis_all_clocks [15:15] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_all_clocks_MASK           0x00008000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_all_clocks_SHIFT          15

/* SUN_TOP_CTRL :: PM_CTRL :: pm_dis_cpu_clock [14:14] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_cpu_clock_MASK            0x00004000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_cpu_clock_SHIFT           14

/* SUN_TOP_CTRL :: PM_CTRL :: pm_dis_avd_rptd_clock [13:13] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_avd_rptd_clock_MASK       0x00002000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dis_avd_rptd_clock_SHIFT      13

/* SUN_TOP_CTRL :: PM_CTRL :: pm_pll_lock [12:12] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_pll_lock_MASK                 0x00001000
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_pll_lock_SHIFT                12

/* SUN_TOP_CTRL :: PM_CTRL :: pm_dram_ready_for_pwrdn [11:11] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dram_ready_for_pwrdn_MASK     0x00000800
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_dram_ready_for_pwrdn_SHIFT    11

/* SUN_TOP_CTRL :: PM_CTRL :: pm_bsp_ready_for_pwrdn [10:10] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_bsp_ready_for_pwrdn_MASK      0x00000400
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_bsp_ready_for_pwrdn_SHIFT     10

/* SUN_TOP_CTRL :: PM_CTRL :: pm_mips_ready_for_pwrdn [09:09] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_mips_ready_for_pwrdn_MASK     0x00000200
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_mips_ready_for_pwrdn_SHIFT    9

/* SUN_TOP_CTRL :: PM_CTRL :: pm_sec_avd_rptd_clk_disable [08:08] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_sec_avd_rptd_clk_disable_MASK 0x00000100
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_sec_avd_rptd_clk_disable_SHIFT 8

/* SUN_TOP_CTRL :: PM_CTRL :: pm_state [07:04] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_MASK                    0x000000f0
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_SHIFT                   4
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_ACTIVE               0
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_PWRDN_RDY            1
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_DISABLE_AVD_RPTD     2
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_DISABLE_CPU          3
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_TRANSITION_TO_STANDBY 4
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_STANDBY              5
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_STANDBY_WITH_PLLS_ON 6
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_RESET_216_108_CLKS   7
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_state_PM_TRANSITION_TO_ACTIVE 8

/* SUN_TOP_CTRL :: PM_CTRL :: pm_power_ctrl_disable [03:03] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_power_ctrl_disable_MASK       0x00000008
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_power_ctrl_disable_SHIFT      3

/* SUN_TOP_CTRL :: PM_CTRL :: pm_use_mips_ready_ctrl [02:02] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_use_mips_ready_ctrl_MASK      0x00000004
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_use_mips_ready_ctrl_SHIFT     2

/* SUN_TOP_CTRL :: PM_CTRL :: pm_enable_pll_pwrdn [01:01] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_enable_pll_pwrdn_MASK         0x00000002
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_enable_pll_pwrdn_SHIFT        1

/* SUN_TOP_CTRL :: PM_CTRL :: pm_start_pwrdn [00:00] */
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_start_pwrdn_MASK              0x00000001
#define BCHP_SUN_TOP_CTRL_PM_CTRL_pm_start_pwrdn_SHIFT             0

/***************************************************************************
 *PM_IRQ_INPUT_STATUS - Power Management IRQ input status
 ***************************************************************************/
/* SUN_TOP_CTRL :: PM_IRQ_INPUT_STATUS :: reserved0 [31:01] */
#define BCHP_SUN_TOP_CTRL_PM_IRQ_INPUT_STATUS_reserved0_MASK       0xfffffffe
#define BCHP_SUN_TOP_CTRL_PM_IRQ_INPUT_STATUS_reserved0_SHIFT      1

/* SUN_TOP_CTRL :: PM_IRQ_INPUT_STATUS :: spare_wakeup_event_0 [00:00] */
#define BCHP_SUN_TOP_CTRL_PM_IRQ_INPUT_STATUS_spare_wakeup_event_0_MASK 0x00000001
#define BCHP_SUN_TOP_CTRL_PM_IRQ_INPUT_STATUS_spare_wakeup_event_0_SHIFT 0

/***************************************************************************
 *PM_MIPS_WAIT_COUNT - Power Management Wait counter in place of Wait for MIPS IRQ
 ***************************************************************************/
/* SUN_TOP_CTRL :: PM_MIPS_WAIT_COUNT :: reserved0 [31:16] */
#define BCHP_SUN_TOP_CTRL_PM_MIPS_WAIT_COUNT_reserved0_MASK        0xffff0000
#define BCHP_SUN_TOP_CTRL_PM_MIPS_WAIT_COUNT_reserved0_SHIFT       16

/* SUN_TOP_CTRL :: PM_MIPS_WAIT_COUNT :: counter_start_value [15:00] */
#define BCHP_SUN_TOP_CTRL_PM_MIPS_WAIT_COUNT_counter_start_value_MASK 0x0000ffff
#define BCHP_SUN_TOP_CTRL_PM_MIPS_WAIT_COUNT_counter_start_value_SHIFT 0

#endif /* #ifndef BCHP_SUN_TOP_CTRL_H__ */

/* End of File */
