DACSHTTP(1)                  DACS Commands Manual                  DACSHTTP(1)



[1mNAME[0m
       dacshttp - perform an HTTP/HTTPS request

[1mSYNOPSIS[0m
       [1mdacshttp [22m[[1m-get [22m| [1m-post [22m| [1m-delete [22m| [1m-head [22m| [1m-options [22m| [1m-soptions [22m| [1m-put[22m]
                [[1m-ll [4m[22mlog_level[24m]
                [[1m-prompt[22m] [[1m-v[22m] [[1m--version[22m] [[[1m-ct [4m[22mstring[24m] |
                [[1m--content-type [4m[22mstring[24m]]
                [{[1m-header [4m[22mname[24m [4mvalue[24m}...] [[1m-headers [4m[22mfilename[24m] [[1m-body [4m[22mfilename[24m]
                [[1m-ih[22m]
                [[1m-user-agent [4m[22mstring[24m] [{[1m-p [4m[22mname[24m [4mvalue[24m}...] [[1m-proto [4m[22mversion-num[24m]
                [[1m-proxy [4m[22mproxyhost[24m:[4mproxyport[24m]
                [[1m-proxymatch [4m[22mhostname[24m[:[4mport[24m] [4mproxyhost[24m:[4mproxyport[24m]
                [[1m-f [4m[22mname[24m [4mfilename[24m] [{[1m-cookies [4m[22mfilename[24m}...] [[1m-ah[22m]
                [[1m-ssl [4m[22mcommand-line[24m] [[1m-ssl-flags [4m[22mflags[24m] [4muri[0m

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite. It is a stand-alone program
       that neither accepts the usual [1mDACS [22mcommand line options
       ([34m[1mdacsoptions[0m[1m[22m[1]) nor accesses any [1mDACS [22mconfiguration files.

       This general-purpose utility sends an HTTP/HTTPS request for [4muri[24m to a
       web server and prints the reply to its standard output.

       [1mdacshttp [22mwill automatically follow redirects according to [34m[1mRFC 2616[0m[1m[22m[2]
       and up to a compile-time maximum, unless the [1m-prompt [22mflag is given. A
       non-standard extension is that a redirect to a non-absolute URI is
       interpreted in a manner compatible with most browsers.

       In versions 1.4.27b and earlier, this command was called [1mhttp[22m.

           [1mNote[0m
           [1mDACS [22mcan issue its own HTTP requests, such as from
           [1mdacs_authenticate [22mto an external authentication module. This HTTP
           functionality is provided by the same support code that the
           [1mdacshttp [22mcommand uses, and therefore much of the following
           information applies to these internally generated requests also
           (e.g., [34m[1mHTTP_PROG[0m[1m[22m[3], [34m[1mSSL_PROG[0m[1m[22m[4], [34m[1mSSL_PROG_ARGS[0m[1m[22m[5],
           [34m[1mSSL_PROG_CA_CRT[0m[1m[22m[6], [34m[1mSSL_PROG_CLIENT_CRT[0m[1m[22m[7], [34m[1mVFS[0m[1m[22m[8]).

[1mOPTIONS[0m
       The HTTP GET method is used by default, but some flags implicitly
       select a different method (e.g., [1m-f [22mand [1m-p[22m). One of the following flags
       can be used to explicitly specify the HTTP method, provided it is
       compatible with the other options:

       [1m-get[0m
           Use the GET method (the default).

       [1m-post[0m
           Use the POST method.

       [1m-head[0m
           Use the HEAD method.

       [1m-put[0m
           Use the PUT method.

       [1m-delete[0m
           Use the DELETE method.

       [1m-options[0m
           Use the OPTIONS method.

       [1m-soptions[0m
           Use the OPTIONS method but ignore anything that follows the
           authority component of [4muri[24m and instead use the special case "*"
           request URI that means that the request applies to the server
           itself rather than to a particular resource.

       These command line flags are also recognized:

       [1m-ah[0m
           If cookies (credentials) are to be sent (see [1m-cookies[22m), use an
           Authorization header rather than a Cookie header.

       [1m-body [4m[22mfilename[0m
           Read the message body from [4mfilename[24m. It is assumed that the body
           has already been appropriately formatted for the request's content
           type.

       [1m-cookies [4m[22mfilename[0m
           Obtain cookies from [4mfilename[24m, one per line, to send with the
           request using the Cookie header. Multiple cookies are separated
           using a semi-colon, which follows the [34m[1mNetscape spec[0m[1m[22m[9].
           Alternatively, multiple cookies can be combined on a single line,
           separated by either a semi-colon or a comma (following [34m[1mRFC 2109[0m[1m[22m[10]
           or [34m[1mRFC 2965[0m[1m[22m[11]). This argument may be repeated.

       [1m-ct [4m[22mstring[0m
       [1m--content-type [4m[22mstring[0m
           Set the Content-Type request-header to [4mstring[24m. If the request has
           an entity-body, the default Content-Type is
           application/x-www-form-urlencoded; if the request does not have an
           entity-body, by default the Content-Type request-header is not set.

       [1m-f [4m[22mname[24m [4mfilename[0m
           Passes and encodes the contents of [4mfilename[24m as the value for name.
           By default, the POST method will be used, although PUT and OPTIONS
           can be selected. If [4mfilename[24m is "[1m-[22m", the standard input is read;
           this form can only be used once on the command line. This argument
           may be repeated.

       [1m-header [4m[22mname[24m [4mvalue[0m
           This flag, which may be repeated, causes the HTTP header [4mname[24m:
           [4mvalue[24m to be sent with the request. Neither [4mname[24m nor [4mvalue[24m are
           checked in any way.

               [1mNote[0m
               This will not override headers required or implied by other
               command line flags; for example, the following flags are not
               equivalent:



                   [1m-header [22mUser-Agent foo
                   [1m-user-agent [22mfoo

               The former case will send the User-Agent header twice.

       [1m-headers [4m[22mfilename[0m
           Read additional message headers from [4mfilename[24m, one per line, and
           send them with the request (refer to the [1m-header [22mflag). This flag
           may be repeated.

       [1m-ih[0m
           Include the HTTP response headers in the output. They are
           terminated by a blank line. The status line is labelled
           "Status-Line".

       [1m-ll [4m[22mlog_level[0m
           Set the debugging output level to [4mlog_level[24m (see [34m[1mdacs(1)[0m[1m[22m[12]). The
           default level is warn, and the [1m-v [22mflag bumps the level to debug or
           trace.

       [1m-p [4m[22mname[24m [4mvalue[0m
           Passes and encodes name=value as part of the entity-body. By
           default, the POST method will be used, although PUT and OPTIONS can
           be selected. This argument may be repeated.

       [1m-prompt[0m
           Prompt the user for permission to proceed after certain events,
           such as receiving a redirect; the response is affirmative only if
           it is "yes" or "y". If this option is not specified, the
           affirmative action will automatically be taken.

       [1m-proto [4m[22mversion-num[0m
           Function in compliance with [4mversion-num[24m of the HTTP protocol (e.g.,
           1.0).

       [1m-proxy [4m[22mproxyhost[24m:[4mproxyport[0m
           Forward all HTTP requests (except for those that match a
           [1m-proxymatch [22mflag) to the proxy server at [4mproxyport[24m (a numeric port
           number or recognized service name) on [4mproxyhost[24m (a domain name or
           IP address). Proxying is not fully supported by [1mdacshttp[22m, but it
           will connect to the specified proxy server instead of the server
           implied by [4muri[24m.

       [1m-proxymatch [4m[22mhostname[24m[:[4mport[24m] [4mproxyhost[24m:[4mproxyport[0m
           If [4mhostname[24m matches the host specified in [4muri[24m, proxy the HTTP
           request through [4mproxyhost[24m (a domain name or IP address) at
           [4mproxyport[24m (a numeric port number or recognized service name). If
           [4mport[24m is not given, it is assumed to be 80 (for the http scheme) or
           443 (for the https scheme). Matching is done by resolving [4mhostname[0m
           to an IP address (if necessary) and comparing it to the effective
           IP address that is specified by [4muri[24m. This flag is given priority
           over the [1m-proxy [22mflag, so it can be used to override a default proxy
           server.

               [1mNote[0m
               This option is not implemented. The SSL flags apply to [4mall[0m
               connections; this is probably a bug.

       [1m-ssl [4m[22mcommand-line[0m
           This flag indicates that HTTPS (i.e, HTTP over an SSL connection)
           is to be used, regardless of the scheme specified by [4muri[24m. Because
           [1mdacshttp [22mdoes not directly include SSL functionality, it uses pipes
           to communicate with an external program that provides the SSL
           connection. The [34m[1msslclient(1)[0m[1m[22m[13] command is strongly recommended
           for this purpose (version 3.26 of [1mstunnel(1) [22mand [1mstunnel3[22m, which
           comes with some releases of [1mstunnel-4.x[22m, might also work).

           The [4mcommand-line[24m is a complete shell command line that will be used
           to run the program as a filter. For example, this argument might
           look like either of:

               -ssl "/usr/local/dacs/bin/sslclient example.com:443"

               -ssl "/usr/local/bin/stunnel -c -r example.com:443"

           If the [1m-ssl [22margument is absent but the [4muri[24m argument uses the https
           scheme, [1mdacshttp [22mwill still try to use SSL. It will attempt to use
           [34m[1msslclient(1)[0m[1m[22m[13] and assume it is in its default location. If the
           [1m-ssl [22margument is present but specifies only one string, that string
           is assumed to be the path to [34m[1msslclient(1)[0m[1m[22m[13]. The first example
           below will run [34m[1msslclient(1)[0m[1m[22m[13] from /tmp/sslclient to connect to
           port 443 at example.com; the second example has the same effect but
           will run [34m[1msslclient(1)[0m[1m[22m[13] from its default location:

               % dacshttp -ssl "/tmp/sslclient" https://example.com
               % dacshttp https://example.com


       [1m-ssl-flags [4m[22mflags[0m
           If SSL operation is enabled but the [1m-ssl [22mflag is absent or did not
           simply specify a pathname, append [4mflags[24m to the list of arguments to
           be passed to the external SSL provider; when the [1m-ssl [22mflag
           specifies more than one argument, this flag is ignored. The [4mflags[0m
           string is a space-separated list of arguments. This flag may be
           repeated.

           For example, in this example [1mdacshttp [22mwill invoke [1msslclient [22mwith
           the two arguments [4m-sm[24m and [4mbobo.example.com[24m:

               % dacshttp -ssl-flags "-sm bobo.example.com" https://example.com

           If a wildcard server certificate is used, it may be necessary to
           explicitly match all hosts within a specific domain:

               % dacshttp -ssl-flags "-sm .*\.example\.com" https://example.com


               [1mImportant[0m
               When called by [1mdacshttp[22m, error messages produced by [1msslclient[0m
               may be lost. If you encounter problems with SSL operation, work
               with [34m[1msslclient(1)[0m[1m[22m[13] to ensure that an SSL connection can be
               established, or to determine and resolve the problem. If you
               discover that [1msslclient [22mrequires command line flags for proper
               operation, you will need to make sure that [1mdacshttp [22mpasses
               those flags to it.

       [1m-user-agent [4m[22mstring[0m
           Set the User-Agent request-header to [4mstring[24m. If not provided, this
           string will have the prefix "DACS-http/", followed by a [1mDACS[0m
           release identifier (example: "DACS-http/1.4.1").

       [1m-v[0m
           Increase the level of debugging output. This will cause response
           headers to be displayed, for example. The flag may be repeated.

       [1m--version[0m
           Print version information to stderr, then exit immediately.

       The [4muri[24m argument is the URL to invoke. It may include a query string
       suffix (even if HTTP POST is selected).

       Whether selected implicitly or explicitly, the command line must
       specify exactly one of the HTTP methods.

       Request headers specified using the [1m-header [22mor [1m-headers [22mflags are sent
       in the order in which the flags appear on the command line. If they are
       read from a file, there ordering is maintained.

[1mEXAMPLES[0m
       The following will retrieve [34m[1mRFC 2616[0m[1m[22m[2] and save it in rfc2616.txt:

           % dacshttp "http://www.rfc-editor.org/rfc/rfc2616.txt" > rfc2616.txt

       This will do a GET on the given URL, passing the query string [4mfoo=baz[24m,
       and writing the result to stdout:

           % dacshttp "https://example.com/cgi-bin/dacs/dacs_prenv?foo=baz"

       This will do a POST on the given URL, passing two arguments:

           % dacshttp -p foo baz -p bar zork https://example.com/cgi-bin/dacs/dacs_prenv

       This will make an HTTP GET method request over SSL to the given URL:

           % dacshttp -ssl "/usr/local/dacs/bin/sslclient example.com:443" \
               https://example.com/cgi-bin/dacs/dacs_prenv

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       Use of an SSL provider other than [34m[1msslclient(1)[0m[1m[22m[13] is officially
       deprecated. Recent development makes it doubtful that any other program
       will function properly with [1mdacshttp[22m.

       It is only a partial implementation of [34m[1mRFC 2616[0m[1m[22m[2] (HTTP 1.0). It only
       talks HTTP (no other URI schemes are supported). Received cookies are
       discarded, there is no support for [34m[1mRFC 2617[0m[1m[22m[14] authentication,
       including proxy authentication, and no client-side caching is
       performed.  [1mdacshttp [22mshould not require an external program to provide
       SSL functionality. The program is a bit confused about when it should
       be able to send a message body.

[1mSEE ALSO[0m
       [34m[1msslclient(1)[0m[1m[22m[13], [34m[1mlynx(1)[0m[1m[22m[15], [34m[1mcurl(1)[0m[1m[22m[16], [34m[1mWget(1)[0m[1m[22m[17], [34m[1mRFC 1738[0m[1m[22m[18],
       [34m[1mRFC 2396[0m[1m[22m[19], [34m[1mRFC 2616[0m[1m[22m[2], [34m[1mRFC 3986[0m[1m[22m[20]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[21])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[22] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

        3. HTTP_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_PROG

        4. SSL_PROG
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG

        5. SSL_PROG_ARGS
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_ARGS

        6. SSL_PROG_CA_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CA_CRT

        7. SSL_PROG_CLIENT_CRT
           http://dacs.dss.ca/man/dacs.conf.5.html#SSL_PROG_CLIENT_CRT

        8. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        9. Netscape spec
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       10. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

       11. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       12. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       13. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       14. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       15. lynx(1)
           http://lynx.isc.org

       16. curl(1)
           http://directory.fsf.org/All_Packages_in_Directory/cURL.html

       17. Wget(1)
           http://www.gnu.org/software/wget/wget.html

       18. RFC 1738
           http://www.rfc-editor.org/rfc/rfc1738.txt

       19. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       20. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACSHTTP(1)
