/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "mocap.h"
#include "basic_editor.h"

#include <iostream>
using namespace std;

mocap::mocap () {
  clear ();
}

void mocap::clear () {

  x.clear ();
  y.clear ();

  x.reserve (1);
  y.reserve (1);

  cur = 0;

  state = empty;

}

bool mocap::get (float& gx, float& gy) {

  if (cur >= x.size ()) cur = 0;

  gx = x[cur];
  gy = y[cur++];

  return true;

}

bool mocap::add (float wx, float wy) {
  x.push_back (wx);
  y.push_back (wy);
  state = capturing;
  return true;
}

void mocap::finish (basic_editor* b) {

  for (int i = 0, j = x.size (); i < j; ++i) {
    float wx = x[i], wy = y[i];
    b->win2obj (wx, wy, x[i], y[i]); // win to obj space
  }

  cur = 0;
  state = finished;

}

int mocap::operator() () {
  return (state == finished);
}

