/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.StringTokenizer;

public class CMITime
implements Serializable {
    private int CMIHours;
    private int CMIMinutes;
    private float CMISeconds;

    public CMITime(String timeString) {
        StringTokenizer st = new StringTokenizer(timeString, ":");
        String lmsHours = st.nextToken();
        String lmsMinutes = st.nextToken();
        String lmsSeconds = st.nextToken();
        this.CMIHours = Integer.parseInt(lmsHours);
        this.CMIMinutes = Integer.parseInt(lmsMinutes);
        this.CMISeconds = Float.valueOf(lmsSeconds).floatValue();
    }

    public int getHours() {
        return this.CMIHours;
    }

    public int getMinutes() {
        return this.CMIMinutes;
    }

    public float getSeconds() {
        return this.CMISeconds;
    }

    public void setHours(int iHours) {
        this.CMIHours = iHours;
    }

    public void setMinutes(int iMinutes) {
        this.CMIMinutes = iMinutes;
    }

    public void setSeconds(float iSeconds) {
        this.CMISeconds = iSeconds;
    }

    public String toString() {
        String temp = new String("0");
        String hours = Integer.toString(this.CMIHours, 10);
        if (hours.length() == 1) {
            hours = "0" + hours;
        } else if (hours.length() == 0) {
            hours = "00";
        }
        String minutes = Integer.toString(this.CMIMinutes, 10);
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        } else if (minutes.length() == 0) {
            minutes = "00";
        }
        String seconds = Float.toString(this.CMISeconds);
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        } else if (seconds.length() == 0) {
            seconds = "00";
        }
        return String.valueOf(hours) + ":" + minutes + ":" + seconds;
    }

    public void add(CMITime addTime) {
        int newHours = 0;
        int newMinutes = 0;
        float newSeconds = 0.0f;
        newSeconds = this.CMISeconds + addTime.CMISeconds;
        if ((double)newSeconds > 60.0) {
            newSeconds -= 60.0f;
            ++newMinutes;
        }
        newSeconds = (float)((int)(newSeconds * 100.0f)) / 100.0f;
        if ((newMinutes = newMinutes + this.CMIMinutes + addTime.CMIMinutes) > 60) {
            newMinutes -= 60;
            ++newHours;
        }
        this.CMIHours = newHours = newHours + this.CMIHours + addTime.CMIHours;
        this.CMIMinutes = newMinutes;
        this.CMISeconds = newSeconds;
    }
}

