/////////////////////////////////////////////////////////////////////////////
// Name:        TemplateDlg.cpp
// Purpose:     Select DVD menu template dialog
// Author:      Alex Thuering
// Created:     20.10.2009
// RCS-ID:      $Id: TemplateDlg.cpp,v 1.9 2011/09/11 18:51:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "TemplateDlg.h"
#include "wxVillaLib/utils.h"
#include "wxVillaLib/rc/loading.png.h"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/dir.h>

// begin wxGlade: ::extracode

// end wxGlade

#define TEMPLATES_DIR wxFindDataDirectory(_T("templates"))

enum {
	CATEGORY_LIST_BOX_ID = 2000,
	THUMBNAILS_ID
};

BEGIN_EVENT_TABLE(TemplateDlg, wxDialog)
    // begin wxGlade: TemplateDlg::event_table
    EVT_LISTBOX(CATEGORY_LIST_BOX_ID, TemplateDlg::OnCategorySelect)
    // end wxGlade
	EVT_THUMBNAILS_DCLICK(THUMBNAILS_ID, TemplateDlg::OnThumbDoubleClick)
END_EVENT_TABLE()

TemplateDlg::TemplateDlg(wxWindow* parent, AspectRatio aspectRatio): wxDialog(parent, wxID_ANY, wxEmptyString,
		wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER) {
    // begin wxGlade: TemplateDlg::TemplateDlg
    m_categoryLabel = new wxStaticText(this, wxID_ANY, _("Category:"));
    m_titleLabel = new wxStaticText(this, wxID_ANY, _("Title:"));
    m_titleText = new wxTextCtrl(this, wxID_ANY, _("Disc Title"));
    const wxString m_categoryListBox_choices[] = {
        _("All")
    };
    m_categoryListBox = new wxListBox(this, CATEGORY_LIST_BOX_ID, wxDefaultPosition, wxDefaultSize, 1, m_categoryListBox_choices, wxLB_SINGLE|wxLB_NEEDED_SB);
    m_thumbnails = new wxThumbnails(this, THUMBNAILS_ID);
    m_staticLine = new wxStaticLine(this, wxID_ANY);
    m_okBt = new wxButton(this, wxID_OK, wxEmptyString);
    m_cancelBt = new wxButton(this, wxID_CANCEL, _("&No template"));

    set_properties();
    do_layout();
    // end wxGlade
    
    m_aspectRatio = aspectRatio;
    if (m_aspectRatio == ar16_9)
    	SetSize(wxSize(798, -1));
    m_thumbnails->SetCaption(_("Templates"));
    m_thumbnails->SetThumbImageSize(m_aspectRatio == ar16_9 ? 205 : 145, 54);
    
    // load categories
	wxString dir = wxFindFirstFile(TEMPLATES_DIR + wxT("*"), wxDIR);
	while (!dir.IsEmpty()) {
		wxString subDir = dir.AfterLast(wxFILE_SEP_PATH);
		if (subDir != wxT("CVS") && !subDir.StartsWith(wxT("."))) {
			m_categoryListBox->Append(wxGetTranslation(subDir.c_str()));
			m_dirs.push_back(subDir);
		}
		dir = wxFindNextFile();
	}
	wxStandardPaths paths;
	wxString tempateDir = paths.GetUserDataDir() + wxFILE_SEP_PATH + wxT("templates");
	if (wxDir::Exists(tempateDir)) {
		dir = wxFindFirstFile(tempateDir + wxFILE_SEP_PATH + wxT("*"), wxDIR);
		while (!dir.IsEmpty()) {
			wxString subDir = dir.AfterLast(wxFILE_SEP_PATH);
			if (!subDir.StartsWith(wxT(".")) && m_dirs.Index(subDir) == wxNOT_FOUND) {
				m_categoryListBox->Append(wxGetTranslation(subDir.c_str()));
				m_dirs.push_back(subDir);
			}
			dir = wxFindNextFile();
		}
	}
    wxCommandEvent evt;
    OnCategorySelect(evt);
	
	m_titleText->SetFocus();
}

void TemplateDlg::set_properties() {
    // begin wxGlade: TemplateDlg::set_properties
    SetTitle(_("Select template for DVD menus"));
    SetSize(wxSize(634, 427));
    m_categoryLabel->SetFont(wxFont(8, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    m_titleLabel->SetFont(wxFont(8, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    m_categoryListBox->SetMinSize(wxSize(100, -1));
    m_categoryListBox->SetSelection(0);
    m_okBt->SetDefault();
    // end wxGlade
}

void TemplateDlg::do_layout() {
    // begin wxGlade: TemplateDlg::do_layout
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* btSizer = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* mainGridSizer = new wxFlexGridSizer(2, 2, 0, 0);
    wxBoxSizer* titleSizer = new wxBoxSizer(wxHORIZONTAL);
    mainGridSizer->Add(m_categoryLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    titleSizer->Add(50, 10, 0, wxEXPAND, 0);
    titleSizer->Add(m_titleLabel, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 4);
    titleSizer->Add(m_titleText, 1, wxEXPAND, 0);
    titleSizer->Add(50, 10, 0, wxEXPAND, 0);
    mainGridSizer->Add(titleSizer, 1, wxEXPAND, 0);
    mainGridSizer->Add(m_categoryListBox, 0, wxEXPAND, 0);
    mainGridSizer->Add(m_thumbnails, 1, wxALL|wxEXPAND, 2);
    mainGridSizer->AddGrowableRow(1);
    mainGridSizer->AddGrowableCol(1);
    mainSizer->Add(mainGridSizer, 1, wxALL|wxEXPAND, 4);
    mainSizer->Add(m_staticLine, 0, wxEXPAND, 0);
    btSizer->Add(10, 10, 1, wxEXPAND, 0);
    btSizer->Add(m_okBt, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 8);
    btSizer->Add(m_cancelBt, 0, 0, 0);
    btSizer->Add(10, 10, 1, wxEXPAND, 0);
    mainSizer->Add(btSizer, 0, wxALL|wxEXPAND, 10);
    SetSizer(mainSizer);
    Layout();
    Centre();
    // end wxGlade
}

wxString TemplateDlg::GetTemplate() {
	return m_thumbnails->GetSelectedItem() ? m_thumbnails->GetSelectedItem()->GetFilename() : wxT("");
}

wxString TemplateDlg::GetTitle() {
	return m_titleText->GetValue();
}

void TemplateDlg::OnThumbDoubleClick(wxCommandEvent& event) {
	EndModal(wxID_OK);
}

void TemplateDlg::LoadThumbnails(wxString dir) {
	if (!wxDir::Exists(dir))
		return;
	wxString fname = wxFindFirstFile(dir + wxFILE_SEP_PATH + _T("*.dvdt"));
	while (!fname.IsEmpty()) {
		if ((m_aspectRatio != ar16_9 && !fname.EndsWith(wxT("WS.dvdt")))
				|| (m_aspectRatio == ar16_9 && (fname.EndsWith(wxT("WS.dvdt"))
						|| !wxFile::Exists(fname.substr(0, fname.length() - 5) + wxT("WS.dvdt"))))) {
			wxLogNull log;
			wxImage img;
			wxString imgFile = fname.BeforeLast(wxT('.')) + wxT(".png");
			if (!wxFile::Exists(imgFile)) {
				DVD dvd;
				if (dvd.Open(fname))
					dvd.RenderThumbnail(imgFile);
			}
			img.LoadFile(imgFile);
			wxThumb* thumb = new wxThumb(img, wxT(""), fname);
			m_thumbnails->InsertItem(thumb);
		}
		fname = wxFindNextFile();
	}
}

// wxGlade: add TemplateDlg event handlers
void TemplateDlg::OnCategorySelect(wxCommandEvent &event) {
	m_thumbnails->Clear();
	wxStandardPaths paths;
	wxString tempateDir = paths.GetUserDataDir() + wxFILE_SEP_PATH + wxT("templates");
	if (m_categoryListBox->GetSelection() == 0) {
		for (wxArrayString::const_iterator it = m_dirs.begin(); it != m_dirs.end(); it++) {
			LoadThumbnails(TEMPLATES_DIR + *it);
			LoadThumbnails(tempateDir + wxFILE_SEP_PATH + *it);
		}
	} else {
		wxString subDir = m_dirs[m_categoryListBox->GetSelection() - 1];
		LoadThumbnails(TEMPLATES_DIR + subDir);
		LoadThumbnails(tempateDir + wxFILE_SEP_PATH + subDir);
	}
	m_thumbnails->SortItems();
	
	if (m_thumbnails->GetItemCount() > 0)
		m_thumbnails->SetSelected(0);
	m_thumbnails->Update();
}
