/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */
#ifdef USE_CHUNKS_AND_TASKS

#include "chunks_and_tasks.h"
#include "cht_type_lib.h"
#include "cht_matrix_lib.h"
#include "DistrBasisSetChunk.h"
#include "IntegralInfoChunk.h"

// ergo_real 
// compute_one_element_of_overlap_mat(const BasisInfoStruct & b, int i, int j);

class CreateAtomCenteredBasisSet : public cht::Task {
public:
  cht::ID execute(const chttl::ChunkVector<Atom> &, const cht::ChunkID &, const cht::ChunkID &, const chttl::ChunkBasic<ergo_real> &);
  CHT_TASK_INPUT((chttl::ChunkVector<Atom>, // atom list
		  cht::ChunkID, // ChunkID for basisset_struct
		  cht::ChunkID, // ChunkID for IntegralInfoChunk
		  chttl::ChunkBasic<ergo_real> // coordDiffLimit determining lowest level
		  ));
  CHT_TASK_OUTPUT((DistrBasisSetChunk));
  CHT_TASK_TYPE_DECLARATION;
};

class SetFuncIndexesForBasisSet : public cht::Task {
public:
  cht::ID execute(const DistrBasisSetChunk &, const chttl::ChunkVector<int> &);
  CHT_TASK_INPUT((DistrBasisSetChunk, chttl::ChunkVector<int>));
  CHT_TASK_OUTPUT((DistrBasisSetChunk));
  CHT_TASK_TYPE_DECLARATION;
};

class SetExtentsForBasisSet : public cht::Task {
public:
  cht::ID execute(const DistrBasisSetChunk &, const chttl::ChunkBasic<ergo_real> &);
  CHT_TASK_INPUT((DistrBasisSetChunk, chttl::ChunkBasic<ergo_real>));
  CHT_TASK_OUTPUT((DistrBasisSetChunk));
  CHT_TASK_TYPE_DECLARATION;
};

class GetLargestSimpleIntegralForBasisSet : public cht::Task {
 public:
  cht::ID execute(const DistrBasisSetChunk &);
  CHT_TASK_INPUT((DistrBasisSetChunk));
  CHT_TASK_OUTPUT((chttl::ChunkBasic<ergo_real>));
  CHT_TASK_TYPE_DECLARATION;
};

struct CoordStruct {
  ergo_real coords[3]; // x, y, z coordinates.
};

class GetBasisSetCoords : public cht::Task {
public:
  cht::ID execute(const DistrBasisSetChunk &);
  CHT_TASK_INPUT((DistrBasisSetChunk));
  CHT_TASK_OUTPUT((chttl::ChunkVector<CoordStruct>));
  CHT_TASK_TYPE_DECLARATION;
};

#endif
