/*
	FATSort, utility for sorting FAT directory structures
	Copyright (C) 2004 Boris Leidner <fatsort(at)formenos.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	This file contains/describes the cluster chain ADO with its structures and
	functions. Cluster chain ADOs hold a linked list of cluster numbers.
	Together all clusters in a cluster chain hold the date of a file or a
	directory in a FAT filesystem.
*/

#ifndef __FAT_fs_win32_h__
#define __FAT_fs_win32_h__

#include <stdio.h>
#include <sys/types.h>
#include "platform.h"

#ifdef __WIN32__
// #define off_t off64_t
#endif

int fs_seek(FILE *stream, off_t offset, int whence);
off_t fs_read(void *ptr, u_int32_t size, u_int32_t n, FILE *stream);
off_t fs_write(const void *ptr, u_int32_t size, u_int32_t n, FILE *stream);
int fs_close(FILE* file);

#endif	// FAT_fs_win32
