# split question pool file into separate file for each question
# Copyright (C) 2012-2015 John Nogatch <jnogatch@gmail.com>

# discard empty lines
(NF == 0){ next}

# change all tab to space
{gsub( /\t/, " ")}

# remove leading whitespace
{sub( /^[ ]*/, "")}

# remove spurious \r
{gsub( /\r/, "")}

# replace \222 apostrophes
{gsub( /\222/, "\47")}

# replace 3-char hyphen
{gsub( /\342\200\223/, "-")}

# replace \223 quotes
{gsub( /\223/, "\42")}

# replace \224 quotes
{gsub( /\224/, "\42")}

# replace \226 hyphen
{gsub( /\226/, "-")}

# replace \240 space
{gsub( /\240/, " ")}

# replace 3-char exponent leader
{gsub( / \342\200.E/, "^")}

# replace 3-char apostrophes
{gsub( /\342\200\231/, "\47")}

# replace 3-char quotes
{gsub( /\342\200\234/, "\42")}

# replace 3-char quotes
{gsub( /\342\200\235/, "\42")}

# recognize answer/distractor lines
/^[ABCD]\./{
    # output answer/distractor to file
    print $0 > question
    next
    }

# recognize answer/distractor lines (elements 7, 7R)
/^[a-f])/{
    # output answer/distractor to file
    print $0 > question
    next
    }

# anything other than answer/distractor line
{
    close( question)	# avoid leaving too many descriptors open
    question = ""	# no current output file
    }

# recognize answer key lines (elements 1, 3, 8)
/^Answer Key:/{
    sub( /^Answer Key:/, "")
    gsub( /:/, "")
    for (i = NF - 1; i > 0; i -= 2) {
	print $i " " $(i+1) > "answer"
	close( "answer")
	system( "cat " $i " >> answer")
	system( "mv answer " $i)
	}
    next
    }

# recognize answer key lines (element 9)
/^Answers:[^-]+$/{
    sub( /^Answers:/, "")
    gsub( /:/, "")
    for (i = NF - 1; i > 0; i -= 2) {
	print "9-" $i " " $(i+1) > "answer"
	close( "answer")
	system( "cat 9-" $i " >> answer")
	system( "mv answer 9-" $i)
	}
    next
    }

# discard "Section-.:" line (elements 7, 7R)
/^Section-[A-Z]: /{ next}

# discard page number line (elements 7, 7R)
/^- [0-9]+ -$/{ next}

# recognize answer key lines (elements 7, 7R)
/^Answers:[ 	]+[0-9]+[A-Z][0-9]+ - [A-D]/{
    sub( /^Answers:/, "")
    gsub( /-/, "")
    for (i = NF - 1; i > 0; i -= 2) {
	print element "-" $i " " $(i+1) > "answer"
	close( "answer")
	system( "cat " $i " >> answer")
	system( "mv answer " element "-" $i)
	}
    next
    }

# recognize new question (elements 1, 3, 8)
/^[0-9]-[0-9]*/{
    question = $1	# new current output file

    $1 = ""	# remove # from question text
    sub( /^ /, "")

    # output question to file
    print $0 > question
    next
    }

# recognize new question (elements 5 & 6)
/^[0-9][AB][0-9]*$/{
    question = $1	# new current output file

    if (getline != 1) print "unable to read answer line " NR	# read another line & exit if error
    if (NF != 1) print "invalid answer line " NR	# expecting answer

    print question " " $1 > question	# output # & answer to file

    if (getline != 1) print "unable to read question line " NR	# read another line & exit if error
    print $0 > question		# output question text to file
    next
    }

# recognize new question (elements 7, 7R)
/^[0-9]+[A-Z][0-9]+ /{
    question = $1	# new current output file
    sub( /-/, "", question)	# remove "-"
#    print "e7: " $0	# display question # to help correct typos

    $1 = ""		# remove question # from question text
    print $0 > question	# output question text to question file
    next
    }

# recognize new question (element 7)
/^[0-9]+[A-Z][0-9]* */{
    question = "7-" $1	# new current output file

    sub( /^[0-9]+[A-Z][0-9]*/, "")	# remove question #

    print $0 > question	# output complete question text to file
    next
    }

# recognize new question (element 9)
/^[0-9]+[A-Z][0-9]* */{
    question = "9-" $1	# new current output file

    sub( /^[0-9]+[A-Z][0-9]*/, "")	# remove question #

    print $0 > question	# output complete question text to file
    next
    }

# display any line that did not get captured
{ print $0}

