;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                             ;;
;;;           Duration models autotrained by festvox                            ;;
;;;                                                                             ;;
;;;  Copyright (c) 2005, DONLab, Dept. of CS&E,                                 ;; 
;;;                      IIT Madras <speech@lantana.tenet.res.in>               ;; 
;;;                                                                             ;;
;;;  This program is a part of festival-mr.					;;
;;;  										;;
;;;  festival-mr is free software; you can redistribute it and/or modify        ;;
;;;  it under the terms of the GNU General Public License as published by	;;
;;;  the Free Software Foundation; either version 2 of the License, or		;;
;;;  (at your option) any later version.					;;
;;;										;;
;;;  This program is distributed in the hope that it will be useful,		;;
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		;;
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		;;
;;;  GNU General Public License for more details.				;;
;;;										;;
;;;  You should have received a copy of the GNU General Public License		;;
;;;  along with this program; if not, write to the Free Software		;;
;;;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA  ;;
;;;										;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set! marathi_NSK::phone_durs '
(
 (pau 0.2 0.5)
 (td 0.05575 0.005773)
 (aw 0.117927 0.028076)
 (L 0.042229 0.012849)
 (N 0.04161 0.012704)
 (f 0.072697 0.024593)
 (tth 0.06532 0.024089)
 (uw 0.079412 0.021271)
 (ddh 0.062404 0.025056)
 (ay 0.111036 0.024453)
 (kh 0.087158 0.026215)
 (D 0.040692 0.02273)
 (eh 0.058062 0.019693)
 (h 0.051313 0.021314)
 (b 0.051264 0.016827)
 (oh 0.057972 0.01666)
 (s 0.077156 0.021181)
 (T 0.055532 0.015637)
 (t 0.055532 0.015637)
 (ee 0.090637 0.02362)
 (ch 0.069544 0.017851)
 (g 0.046106 0.018937)
 (y 0.032813 0.017976)
 (bh 0.078615 0.029398)
 (p 0.065823 0.0203)
 (ih 0.056484 0.029013)
 (n 0.050979 0.017913)
 (dh 0.043912 0.018824)
 (v 0.037464 0.015166)
 (th 0.066434 0.017208)
 (x 0.0212103 0.015235)      
 (oo 0.090384 0.026338)
 (l 0.044951 0.014744)
 (r 0.027877 0.011719)
 (iy 0.08877 0.026607)
 (sh 0.084929 0.024857)
 (aa 0.097435 0.028046)
 (k 0.063973 0.018776)
 (uh 0.050407 0.036288)
 (m 0.057773 0.018004)
 (a 0.050956 0.020084)
 (j 0.063143 0.025996)
 (@ 0.090637 0.02362))
)


(set! marathi_NSK::zdur_tree '
((name is pau)
 ((p.R:SylStructure.parent.parent.pbreak is BB)
  ((0.0 2.0))
  ((0.0 0.0)))
((name is pau)
 ((p.name is pau)
  ((n.name is m)
   ((0.0298048 0.240135))
   ((n.name is n)
    ((0.0248163 0.190157))
    ((n.name is 0) ((0.0472385 0.196152)) ((0.0618728 0.211965)))))
  ((n.name is x)
   ((0.067086 0.038152))
   ((n.name is s)
    ((0.0636678 0.0687188))
    ((p.name is r)
     ((0.0695288 0.223005))
     ((n.name is a)
      ((0.0547058 0.17483))
      ((n.name is ch)
       ((0.0755618 0.08574))
       ((n.name is n)
        ((0.088058 0.190287))
        ((p.name is 0)
         ((n.name is j)
          ((0.00317955 0.0756758))
          ((n.name is pau)
           ((0.0646425 0.112044))
           ((n.name is p)
            ((0.0938901 0.107898))
            ((n.name is aa)
             ((0.0553995 0.101529))
             ((0.0749848 0.1353))))))
         ((n.name is 0)
          ((p.name is uw)
           ((0.0606921 0.08999))
           ((p.name is a)
            ((0.0620511 0.114105))
            ((0.0721246 0.130512))))
          ((n.name is pau)
           ((6.25759e-07 0.15))
           ((p.name is ih)
            ((0.0303755 0.255747))
            ((0.0551457 0.181029)))))))))))))
 ((name is aa)
  ((n.name is k)
   ((p.name is p) ((0.0151123 0.132976)) ((0.0202031 0.112897)))
   ((p.name is bh)
    ((n.name is r) ((0.0325599 0.149785)) ((0.018391 0.0833203)))
    ((n.name is x)
     ((0.0284362 0.141339))
     ((n.name is s)
      ((0.0232161 0.124585))
      ((n.name is sh)
       ((0.0183131 0.119591))
       ((n.name is pau)
        ((0.0283347 0.11951))
        ((p.name is k)
         ((syl_initial is 0)
          ((n.name is r) ((0.039514 0.130745)) ((0.0089475 0.0900864)))
          ((syl_final is 0)
           ((n.name is r)
            ((0.0113913 0.092128))
            ((0.0209297 0.0788273)))
           ((0.0200417 0.100093))))
         ((n.name is th)
          ((0.0319322 0.107217))
          ((p.name is dh)
           ((n.name is D)
            ((0.0151854 0.122499))
            ((0.0180335 0.100488)))
           ((n.name is h)
            ((0.0170041 0.124761))
            ((p.name is b)
             ((n.name is b)
              ((0.00556554 0.0910367))
              ((0.0181756 0.10129)))
             ((p.name is v)
              ((n.name is r)
               ((0.0222649 0.105303))
               ((n.name is n)
                ((0.00640788 0.0864692))
                ((0.0113225 0.091457))))
              ((p.name is x)
               ((0.0212354 0.114938))
               ((syl_initial is 0)
                ((p.name is r)
                 ((n.name is r)
                  ((0.00953026 0.086409))
                  ((n.name is n)
                   ((0.020516 0.104618))
                   ((0.0356577 0.124844))))
                 ((n.name is m)
                  ((0.00269316 0.0689264))
                  ((p.name is p)
                   ((0.0252744 0.07541))
                   ((p.name is y)
                    ((n.name is l)
                     ((0.00314675 0.0664434))
                     ((0.0284536 0.0797971)))
                    ((n.name is l)
                     ((0.0243336 0.119156))
                     ((p.name is s)
                      ((n.name is kh)
                       ((0.0134089 0.0869835))
                       ((0.0189444 0.104863)))
                      ((n.name is n)
                       ((0.0127396 0.0949241))
                       ((syl_final is 0)
                        ((n.name is y)
                         ((0.0137205 0.0758333))
                         ((0.0199829 0.0851102)))
                        ((0.00972297 0.0931965))))))))))
                ((p.name is p)
                 ((0.0163078 0.100105))
                 ((n.name is y)
                  ((0.0156068 0.0648225))
                  ((n.name is T)
                   ((0.0181259 0.112089))
                   ((p.name is g)
                    ((0.0178969 0.107245))
                    ((p.name is m)
                     ((0.00868933 0.0661811))
                     ((n.name is b)
                      ((0.0362739 0.0545167))
                      ((p.name is ch)
                       ((0.0211149 0.0672478))
                       ((p.name is y)
                        ((0.0136454 0.069845))
                        ((p.name is s)
                         ((n.name is n)
                          ((0.0113067 0.0716962))
                          ((n.name is l)
                           ((0.00948171 0.0721697))
                           ((0.0204947 0.0823533))))
                         ((p.name is h)
                          ((0.0206322 0.074734))
                          ((p.name is r)
                           ((0.0196531 0.0797925))
                           ((p.name is th)
                            ((0.00508908 0.0802755))
                            ((p.name is D)
                             ((0.00917173 0.0791624))
                             ((n.name is r)
                              ((0.0128138 0.111813))
                              ((p.name is T)
                               ((0.00707304 0.0836834))
                               ((0.0215715 0.0905629)))))))))))))))))))))))))))))))
  ((name is x)
   ((p.name is n)
    ((0.0327642 0.15876))
    ((n.name is m)
     ((0.00927568 0.150803))
     ((p.name is m)
      ((0.0205825 0.0830005))
      ((n.name is a)
       ((0.0268677 0.084124))
       ((n.name is 0)
        ((p.name is ih)
         ((0.0260708 0.06826))
         ((p.name is a) ((0.0257572 0.0984083)) ((0.0280613 0.112958))))
        ((p.name is a)
         ((0.0682996 0.135106))
         ((n.name is p)
          ((0.0571015 0.13075))
          ((n.name is th)
           ((0.029063 0.125102))
           ((n.name is aa)
            ((0.00876196 0.0964843))
            ((0.0411764 0.106251)))))))))))
   ((name is r)
    ((n.name is a)
     ((syl_initial is 0)
      ((p.name is T)
       ((0.00580279 0.0140085))
       ((p.name is aa)
        ((0.00556239 0.0176991))
        ((p.name is a)
         ((0.00748009 0.0183177))
         ((p.name is oh)
          ((0.00436069 0.0242017))
          ((0.00670316 0.0223759))))))
      ((p.name is g)
       ((0.0059248 0.022778))
       ((p.name is dh)
        ((0.00978622 0.0243837))
        ((p.name is k)
         ((0.00141832 0.0267243))
         ((0.0138424 0.0371795))))))
     ((n.name is aa)
      ((p.name is a)
       ((0.00727702 0.0195276))
       ((syl_final is 0)
        ((p.name is pau)
         ((0.00556658 0.022187))
         ((p.name is p)
          ((0.00641284 0.0248418))
          ((0.0216815 0.0389335))))
        ((p.name is aa)
         ((0.00613434 0.025072))
         ((0.00476582 0.020699)))))
      ((n.name is uh)
       ((syl_final is 0)
        ((0.00951262 0.0339914))
        ((p.name is uh)
         ((0.00546851 0.0211563))
         ((p.name is a)
          ((0.00460428 0.0231678))
          ((0.0100113 0.0258005)))))
       ((n.name is ih)
        ((syl_initial is 0)
         ((0.00931756 0.0249642))
         ((0.00847608 0.0315776)))
        ((n.name is oo)
         ((syl_initial is 0)
          ((0.00372523 0.0264826))
          ((0.00523764 0.0229812)))
         ((n.name is v)
          ((0.00285673 0.052257))
          ((n.name is th)
           ((0.0111517 0.052703))
           ((n.name is k)
            ((0.00947553 0.0493562))
            ((n.name is g)
             ((0.00589957 0.0429987))
             ((syl_initial is 0)
              ((n.name is iy)
               ((0.00827586 0.0313379))
               ((syl_final is 0)
                ((n.name is s)
                 ((0.0120808 0.0355419))
                 ((0.0148712 0.0448179)))
                ((p.name is aa)
                 ((0.00782857 0.0306124))
                 ((0.0130894 0.0342071)))))
              ((0.00824894 0.0413041))))))))))))
    ((n.name is pau)
     ((p.name is r)
      ((name is ih) ((0.0113207 0.0863244)) ((0.0130775 0.0331928)))
      ((p.name is dh)
       ((0.0216944 0.036784))
       ((p.name is a)
        ((0.0271513 0.0693133))
        ((name is a)
         ((p.name is n)
          ((0.0192367 0.0701464))
          ((p.name is k)
           ((0.0231664 0.076409))
           ((p.name is l)
            ((0.0178498 0.0860052))
            ((0.0243157 0.102496)))))
         ((p.name is aa)
          ((0.0161768 0.0643025))
          ((p.name is T)
           ((0.0222509 0.140385))
           ((name is oo)
            ((syl_initial is 0)
             ((0.0186458 0.126035))
             ((0.0267191 0.11001)))
            ((p.name is l)
             ((0.0388597 0.0640386))
             ((name is ay)
              ((0.0115248 0.131007))
              ((syl_initial is 0)
               ((0.0388344 0.0852524))
               ((p.name is th)
                ((0.0151412 0.09343))
                ((p.name is D)
                 ((0.014826 0.0907366))
                 ((0.0569739 0.111964))))))))))))))
     ((n.name is x)
      ((p.name is k)
       ((name is a) ((0.03924 0.137318)) ((0.0485763 0.113161)))
       ((p.name is aa)
        ((name is dh) ((0.00842435 0.0361084)) ((0.012652 0.0612767)))
        ((name is oo)
         ((syl_initial is 0)
          ((0.0178056 0.12917))
          ((0.0242852 0.103833)))
         ((name is ay)
          ((0.0139481 0.121965))
          ((p.name is th)
           ((0.0202604 0.0997133))
           ((name is m)
            ((0.00800911 0.0667542))
            ((p.name is r)
             ((syl_initial is 0)
              ((0.0214692 0.0823246))
              ((0.0223784 0.0646707)))
             ((name is ih)
              ((0.049011 0.104542))
              ((0.0317769 0.0826647))))))))))
      ((name is ay)
       ((p.name is p)
        ((0.00863945 0.086344))
        ((n.name is n)
         ((p.name is s)
          ((0.019403 0.115078))
          ((p.name is m)
           ((0.00345814 0.0838629))
           ((0.0155769 0.0945577))))
         ((p.name is v)
          ((0.0200101 0.104881))
          ((syl_initial is 0)
           ((n.name is dh)
            ((0.0239149 0.104654))
            ((0.0318201 0.122919)))
           ((0.00745017 0.137091))))))
       ((name is iy)
        ((n.name is uh)
         ((0.00280863 0.145163))
         ((p.name is pau)
          ((0.0164675 0.113243))
          ((n.name is r)
           ((syl_initial is 0)
            ((p.name is v)
             ((0.00504752 0.112275))
             ((0.0269748 0.0845928)))
            ((0.0190028 0.122569)))
           ((p.name is l)
            ((0.00632224 0.0622585))
            ((p.name is r)
             ((n.name is k)
              ((0.0112283 0.095082))
              ((syl_final is 0)
               ((0.0140014 0.085859))
               ((n.name is n)
                ((0.00786815 0.0585427))
                ((0.0180643 0.0704394)))))
             ((syl_initial is 0)
              ((n.name is s)
               ((p.name is v)
                ((0.00695318 0.0791967))
                ((0.0200108 0.0893859)))
               ((0.0239907 0.0972703)))
              ((0.0249816 0.0781867))))))))
        ((name is ee)
         ((p.name is ch)
          ((syl_initial is 0)
           ((0.0102247 0.068368))
           ((0.0129389 0.0790325)))
          ((n.name is r)
           ((0.0172142 0.07405))
           ((n.name is k)
            ((0.0200786 0.0841646))
            ((n.name is sh)
             ((0.011018 0.0873673))
             ((n.name is s)
              ((p.name is dh)
               ((syl_initial is 0)
                ((0.00540191 0.0908294))
                ((0.0119753 0.101334)))
               ((0.0112089 0.0838876)))
              ((p.name is n)
               ((0.0174145 0.0884334))
               ((p.name is k)
                ((n.name is n)
                 ((0.0213888 0.102405))
                 ((0.017987 0.0831505)))
                ((n.name is kh)
                 ((syl_initial is 0)
                  ((0.00506828 0.10267))
                  ((0.00635988 0.0940837)))
                 ((n.name is n)
                  ((0.0307687 0.100949))
                  ((syl_initial is 0)
                   ((0.0284324 0.112081))
                   ((0.0277683 0.140062))))))))))))
         ((name is s)
          ((p.name is ee)
           ((n.name is aa)
            ((0.0317857 0.106529))
            ((n.name is ih)
             ((0.0183634 0.0976083))
             ((0.0173529 0.06908))))
           ((n.name is tth)
            ((0.0102071 0.0436605))
            ((n.name is th)
             ((p.name is ih)
              ((0.0114562 0.0637429))
              ((0.0127535 0.0561626)))
             ((n.name is y)
              ((0.00594605 0.110502))
              ((n.name is r)
               ((0.0175067 0.0687581))
               ((p.name is s)
                ((0.0245749 0.0510637))
                ((p.name is ih)
                 ((syl_initial is 0)
                  ((n.name is aa)
                   ((0.00990585 0.058357))
                   ((0.0131918 0.0691567)))
                  ((0.0078443 0.0779508)))
                 ((p.name is a)
                  ((n.name is a)
                   ((syl_initial is 0)
                    ((0.00986522 0.0588166))
                    ((0.00626103 0.068185)))
                   ((n.name is aa)
                    ((0.0103075 0.0859011))
                    ((syl_initial is 0)
                     ((0.0138421 0.0731192))
                     ((0.0202121 0.0871323)))))
                  ((p.name is r)
                   ((0.00847571 0.096371))
                   ((p.name is x)
                    ((n.name is ay)
                     ((0.0113909 0.0871913))
                     ((0.0128201 0.096739)))
                    ((syl_initial is 0)
                     ((0.0169599 0.0870117))
                     ((p.name is iy)
                      ((0.00740101 0.0842891))
                      ((0.0160489 0.0785845))))))))))))))
          ((name is oo)
           ((n.name is j)
            ((0.0118706 0.105449))
            ((n.name is y)
             ((0.00392431 0.051601))
             ((n.name is r)
              ((p.name is h)
               ((0.0117701 0.0844204))
               ((0.0172386 0.0985722)))
              ((p.name is N)
               ((0.0209312 0.0657133))
               ((n.name is l)
                ((0.0188233 0.065394))
                ((n.name is n)
                 ((0.00866509 0.0741627))
                 ((n.name is p)
                  ((0.0178911 0.0707124))
                  ((n.name is dh)
                   ((0.0127341 0.0751823))
                   ((syl_final is 0)
                    ((0.0199216 0.0872124))
                    ((0.0173772 0.0792748)))))))))))
           ((name is sh)
            ((n.name is N)
             ((0.0124161 0.119206))
             ((n.name is T)
              ((0.014182 0.066577))
              ((p.name is k)
               ((n.name is a)
                ((0.0100305 0.0517932))
                ((0.0182732 0.0869521)))
               ((p.name is aa)
                ((0.011752 0.111381))
                ((n.name is td)
                 ((0.00698512 0.0742564))
                 ((p.name is ee)
                  ((0.0229213 0.082092))
                  ((0.0187216 0.0973761))))))))
            ((name is th)
             ((p.name is uh)
              ((syl_initial is 0)
               ((n.name is v)
                ((0.0175191 0.100443))
                ((n.name is uh)
                 ((0.0161738 0.0858756))
                 ((0.00977567 0.0774083))))
               ((0.0103667 0.0597347)))
              ((n.name is y)
               ((0.0314023 0.106881))
               ((p.name is th)
                ((n.name is a)
                 ((0.0167725 0.0425922))
                 ((0.0100802 0.0522319)))
                ((n.name is iy)
                 ((0.0100805 0.0758))
                 ((p.name is p)
                  ((0.0207455 0.0846201))
                  ((n.name is ih)
                   ((0.0119236 0.0572283))
                   ((n.name is th)
                    ((0.0141728 0.0568128))
                    ((n.name is oo)
                     ((0.0180279 0.0743201))
                     ((n.name is a)
                      ((syl_initial is 0)
                       ((p.name is ih)
                        ((0.00763965 0.055875))
                        ((0.0120486 0.0666228)))
                       ((0.00813497 0.0564147)))
                      ((p.name is aa)
                       ((n.name is r)
                        ((0.00658381 0.0797675))
                        ((0.00785363 0.064415)))
                       ((p.name is n)
                        ((n.name is aa)
                         ((0.00661148 0.0711713))
                         ((0.0151494 0.0613948)))
                        ((n.name is uh)
                         ((0.00940794 0.0636015))
                         ((n.name is aa)
                          ((0.0138695 0.0651575))
                          ((n.name is eh)
                           ((0.0197986 0.0653883))
                           ((0.0155139 0.08448))))))))))))))))
             ((name is p)
              ((p.name is x)
               ((n.name is aa)
                ((0.0114463 0.0588642))
                ((0.0135078 0.043844)))
               ((n.name is aa)
                ((syl_initial is 0)
                 ((p.name is a)
                  ((0.0251102 0.0818376))
                  ((0.0278355 0.107648)))
                 ((p.name is pau)
                  ((0.0176745 0.063691))
                  ((p.name is a)
                   ((0.00998245 0.0617387))
                   ((0.0134147 0.0808601)))))
                ((p.name is p)
                 ((0.0166353 0.038391))
                 ((n.name is ih)
                  ((0.0268997 0.0860678))
                  ((n.name is oo)
                   ((p.name is ih)
                    ((0.0106294 0.0737733))
                    ((0.0249344 0.0869475)))
                   ((n.name is ay)
                    ((0.00954265 0.0755764))
                    ((syl_final is 0)
                     ((p.name is pau)
                      ((n.name is a)
                       ((0.014866 0.0654742))
                       ((0.0138203 0.0532208)))
                      ((p.name is ih)
                       ((0.00857367 0.07721))
                       ((p.name is m)
                        ((0.00680397 0.0622323))
                        ((n.name is r)
                         ((p.name is uh)
                          ((0.00906544 0.0538335))
                          ((p.name is a)
                           ((0.0113232 0.0703541))
                           ((0.0138499 0.0643521))))
                         ((n.name is a)
                          ((0.0139538 0.0662749))
                          ((0.0175594 0.082261)))))))
                     ((n.name is a)
                      ((p.name is uh)
                       ((0.0135497 0.067524))
                       ((0.0156078 0.0476112)))
                      ((n.name is p)
                       ((0.0115307 0.0581861))
                       ((0.0202305 0.0648619)))))))))))
              ((name is k)
               ((n.name is sh)
                ((0.0142687 0.0456978))
                ((n.name is a)
                 ((p.name is a)
                  ((0.0158646 0.0498561))
                  ((p.name is ih)
                   ((0.0186417 0.0542853))
                   ((p.name is pau)
                    ((0.0170222 0.0553016))
                    ((0.0243079 0.0665256)))))
                 ((n.name is T)
                  ((0.0105763 0.0484924))
                  ((p.name is ih)
                   ((n.name is ih)
                    ((0.0252541 0.0506798))
                    ((syl_initial is 0)
                     ((n.name is uh)
                      ((0.00400307 0.069729))
                      ((n.name is ee)
                       ((0.012204 0.071259))
                       ((n.name is aa)
                        ((0.0123679 0.0652116))
                        ((0.0171706 0.0514857)))))
                     ((0.00593132 0.070782))))
                   ((p.name is x)
                    ((0.00615304 0.0571217))
                    ((p.name is pau)
                     ((0.0113871 0.0633772))
                     ((p.name is iy)
                      ((0.0141972 0.085865))
                      ((p.name is m)
                       ((0.0109727 0.0572987))
                       ((p.name is k)
                        ((0.0150083 0.05683))
                        ((p.name is aa)
                         ((0.0133529 0.0677756))
                         ((p.name is n)
                          ((0.00999436 0.0828818))
                          ((n.name is uh)
                           ((p.name is a)
                            ((0.015875 0.0901708))
                            ((0.0184476 0.0704096)))
                           ((syl_initial is 0)
                            ((n.name is ih)
                             ((0.0160886 0.0783002))
                             ((p.name is a)
                              ((n.name is r)
                               ((0.00888804 0.0698524))
                               ((0.0081965 0.049032)))
                              ((0.0156178 0.0714135))))
                            ((0.0123355 0.0746605)))))))))))))))
               ((name is ch)
                ((n.name is aa)
                 ((p.name is n)
                  ((0.0169731 0.0901314))
                  ((0.00864962 0.0733316)))
                 ((p.name is ch)
                  ((0.0118764 0.0489857))
                  ((n.name is oh)
                   ((0.0160541 0.0602382))
                   ((n.name is eh)
                    ((0.0222858 0.0626009))
                    ((n.name is ch)
                     ((p.name is a)
                      ((0.0163665 0.048652))
                      ((0.0103358 0.0732642)))
                     ((p.name is a)
                      ((0.0144133 0.0788995))
                      ((0.0163913 0.0710434))))))))
                ((name is kh)
                 ((n.name is y)
                  ((0.0117984 0.110797))
                  ((0.0235661 0.0777174)))
                 ((name is y)
                  ((p.name is v)
                   ((0.0194419 0.056932))
                   ((n.name is a)
                    ((p.name is ih)
                     ((0.00821183 0.0222522))
                     ((0.0125608 0.0268298)))
                    ((n.name is ih)
                     ((0.00755302 0.0267915))
                     ((n.name is uh)
                      ((0.00609593 0.023155))
                      ((n.name is aa)
                       ((p.name is n)
                        ((0.0196238 0.045982))
                        ((0.00972969 0.0344823)))
                       ((0.00582491 0.046833)))))))
                  ((p.name is pau)
                   ((name is bh)
                    ((0.0393342 0.10809))
                    ((name is m)
                     ((n.name is aa)
                      ((0.0122093 0.0375325))
                      ((n.name is uh)
                       ((0.0172675 0.0409792))
                       ((n.name is a)
                        ((0.0240511 0.0455341))
                        ((0.0298654 0.0722379)))))
                     ((n.name is ih)
                      ((name is n)
                       ((0.00713451 0.030831))
                       ((0.0156742 0.0500666)))
                      ((name is ih)
                       ((0.0129836 0.0419144))
                       ((n.name is n)
                        ((0.0161699 0.0531624))
                        ((n.name is iy)
                         ((0.0299145 0.0880802))
                         ((name is j)
                          ((0.0383536 0.085964))
                          ((n.name is a)
                           ((0.0182739 0.0564948))
                           ((n.name is ay)
                            ((name is h)
                             ((0.0133421 0.0665925))
                             ((0.00244 0.0557875)))
                            ((name is a)
                             ((0.0131357 0.0662604))
                             ((n.name is oo)
                              ((0.0176549 0.0650273))
                              ((n.name is k)
                               ((0.00710699 0.084567))
                               ((0.0192716 0.0771221))))))))))))))
                   ((name is v)
                    ((syl_final is 0)
                     ((n.name is uh)
                      ((0.0107571 0.0253893))
                      ((n.name is a)
                       ((0.0141601 0.0360144))
                       ((p.name is dh)
                        ((0.0186924 0.0519125))
                        ((p.name is x)
                         ((0.0141262 0.0458496))
                         ((n.name is ih)
                          ((0.0144714 0.0441677))
                          ((p.name is a)
                           ((0.0113568 0.0431113))
                           ((p.name is iy)
                            ((0.00769268 0.0396637))
                            ((n.name is aa)
                             ((0.00494595 0.0387233))
                             ((0.0100676 0.0334399))))))))))
                     ((n.name is aa)
                      ((0.00862942 0.0347255))
                      ((p.name is ih)
                       ((n.name is a)
                        ((0.00751965 0.0352967))
                        ((0.00847147 0.0266227)))
                       ((0.00801615 0.027348)))))
                    ((n.name is n)
                     ((p.name is j)
                      ((0.0146434 0.0693948))
                      ((p.name is y)
                       ((0.00955283 0.0302893))
                       ((name is a)
                        ((syl_initial is 0)
                         ((p.name is g)
                          ((0.0114633 0.061741))
                          ((p.name is s)
                           ((0.0171789 0.038924))
                           ((p.name is m)
                            ((0.0108016 0.0464659))
                            ((0.0121159 0.0517078)))))
                         ((p.name is dh)
                          ((0.00835732 0.0507383))
                          ((p.name is kh)
                           ((0.00524532 0.0250497))
                           ((p.name is m)
                            ((0.0106489 0.0367159))
                            ((p.name is v)
                             ((0.0133211 0.0337316))
                             ((p.name is ch)
                              ((0.00292899 0.0351097))
                              ((0.0137784 0.0451877))))))))
                        ((name is uh)
                         ((p.name is k)
                          ((0.00480725 0.0238864))
                          ((p.name is b)
                           ((0.00176029 0.0266167))
                           ((p.name is th)
                            ((syl_initial is 0)
                             ((0.0140816 0.0376575))
                             ((0.00758992 0.0273083)))
                            ((0.0104171 0.0376592)))))
                         ((p.name is uh)
                          ((0.0119427 0.0335601))
                          ((p.name is v)
                           ((0.0142069 0.057448))
                           ((syl_initial is 0)
                            ((name is l)
                             ((0.015057 0.029301))
                             ((p.name is a)
                              ((0.0108554 0.0517747))
                              ((name is n)
                               ((0.0122134 0.0400484))
                               ((0.0139554 0.0459521)))))
                            ((p.name is dh)
                             ((0.00486626 0.0307733))
                             ((p.name is th)
                              ((0.0107798 0.03161))
                              ((p.name is g)
                               ((0.00818884 0.0330435))
                               ((name is oh)
                                ((0.0119488 0.0316266))
                                ((p.name is r)
                                 ((0.00407184 0.0360684))
                                 ((p.name is ch)
                                  ((0.010771 0.0370316))
                                  ((0.0133043 0.0430876)))))))))))))))
                     ((p.name is n)
                      ((name is dh)
                       ((n.name is r)
                        ((0.00568628 0.0221325))
                        ((n.name is ih)
                         ((0.00790011 0.0263482))
                         ((n.name is uh)
                          ((0.00506759 0.0238105))
                          ((0.0146372 0.0336714)))))
                       ((name is n)
                        ((n.name is a)
                         ((0.0121747 0.0326031))
                         ((0.0179513 0.0409579)))
                        ((name is D)
                         ((0.00668161 0.0278608))
                         ((n.name is r)
                          ((0.0179263 0.0756627))
                          ((n.name is m)
                           ((syl_final is 0)
                            ((0.0123715 0.037229))
                            ((0.0028815 0.0463067)))
                           ((name is g)
                            ((n.name is aa)
                             ((0.0164746 0.0449556))
                             ((0.0173938 0.0341287)))
                            ((name is uh)
                             ((0.00840352 0.0339816))
                             ((n.name is dh)
                              ((0.00916791 0.0404525))
                              ((n.name is a)
                               ((0.0193688 0.0608035))
                               ((n.name is g)
                                ((0.0264839 0.061441))
                                ((name is T)
                                 ((n.name is uh)
                                  ((0.017342 0.0664672))
                                  ((0.0108139 0.0507442)))
                                 ((n.name is v)
                                  ((0.0245602 0.0593637))
                                  ((0.0150418 0.048934))))))))))))))
                      ((name is uh)
                       ((p.name is m)
                        ((n.name is kh)
                         ((0.00961684 0.0627471))
                         ((0.0219856 0.073163)))
                        ((n.name is l)
                         ((p.name is k)
                          ((0.00477294 0.0211033))
                          ((p.name is dh)
                           ((0.00800576 0.0378253))
                           ((p.name is r)
                            ((0.0181573 0.0378681))
                            ((syl_initial is 0)
                             ((0.00727414 0.0386533))
                             ((0.00811718 0.0281375))))))
                         ((p.name is iy)
                          ((0.0107222 0.0682033))
                          ((n.name is j)
                           ((0.0065678 0.0239035))
                           ((n.name is r)
                            ((0.0132812 0.0517988))
                            ((p.name is bh)
                             ((0.0186051 0.058443))
                             ((p.name is dh)
                              ((n.name is k)
                               ((0.00987222 0.0508993))
                               ((0.00436613 0.0422762)))
                              ((p.name is l)
                               ((syl_final is 0)
                                ((0.00563324 0.038301))
                                ((n.name is p)
                                 ((0.0351314 0.044914))
                                 ((0.026217 0.067151))))
                               ((p.name is g)
                                ((0.0115823 0.0486071))
                                ((n.name is p)
                                 ((0.00712585 0.0477498))
                                 ((p.name is th)
                                  ((0.00839267 0.0454393))
                                  ((n.name is s)
                                   ((0.00306207 0.0303063))
                                   ((syl_final is 0)
                                    ((syl_initial is 0)
                                     ((n.name is th)
                                      ((0.0136539 0.051034))
                                      ((n.name is k)
                                       ((0.00817222 0.0430143))
                                       ((0.00824689 0.032781))))
                                     ((n.name is dh)
                                      ((0.0099857 0.0375583))
                                      ((p.name is r)
                                       ((0.00508496 0.0261764))
                                       ((n.name is th)
                                        ((0.00362201 0.02803))
                                        ((0.00909152 0.0343569))))))
                                    ((n.name is D)
                                     ((0.0131301 0.053792))
                                     ((p.name is k)
                                      ((0.0032165 0.043864))
                                      ((0.0129895 0.0371209)))))))))))))))))
                       ((syl_final is 0)
                        ((name is a)
                         ((syl_initial is 0)
                          ((p.name is dh)
                           ((n.name is L)
                            ((0.00592653 0.0773592))
                            ((n.name is th)
                             ((0.0171606 0.07259))
                             ((0.00646074 0.0602357))))
                           ((p.name is b)
                            ((0.0157104 0.072854))
                            ((p.name is g)
                             ((0.0172539 0.0692546))
                             ((p.name is j)
                              ((n.name is r)
                               ((0.0115679 0.0443754))
                               ((0.0107838 0.0786073)))
                              ((n.name is ch)
                               ((0.00528982 0.073839))
                               ((p.name is y)
                                ((n.name is m)
                                 ((0.00581928 0.0285576))
                                 ((n.name is l)
                                  ((0.00307462 0.042818))
                                  ((0.0127857 0.0498038))))
                                ((n.name is b)
                                 ((0.0138272 0.0366613))
                                 ((p.name is v)
                                  ((0.0111493 0.0448089))
                                  ((n.name is l)
                                   ((0.0155062 0.044348))
                                   ((n.name is bh)
                                    ((0.0145076 0.042375))
                                    ((n.name is y)
                                     ((0.0135824 0.0403067))
                                     ((n.name is T)
                                      ((0.0122377 0.0438456))
                                      ((n.name is h)
                                       ((0.0111892 0.0597487))
                                       ((n.name is s)
                                        ((p.name is r)
                                         ((0.0152473 0.0431982))
                                         ((0.0104727 0.0533584)))
                                        ((p.name is m)
                                         ((0.00983265 0.0483281))
                                         ((n.name is ddh)
                                          ((0.0137317 0.0575131))
                                          ((p.name is p)
                                           ((0.00510498 0.0449768))
                                           ((0.0163813 0.0529591)))))))))))))))))))
                          ((p.name is iy)
                           ((0.010637 0.0686868))
                           ((p.name is y)
                            ((0.00980208 0.0353431))
                            ((p.name is N)
                             ((0.012055 0.0613787))
                             ((p.name is g)
                              ((0.0190274 0.0546809))
                              ((n.name is T)
                               ((0.00945489 0.0347626))
                               ((n.name is v)
                                ((0.0166087 0.0540011))
                                ((n.name is dh)
                                 ((0.0146797 0.0545034))
                                 ((n.name is g)
                                  ((0.00970465 0.0545678))
                                  ((n.name is s)
                                   ((0.00785473 0.053411))
                                   ((p.name is p)
                                    ((0.015664 0.0501083))
                                    ((n.name is b)
                                     ((0.0147336 0.0481839))
                                     ((p.name is r)
                                      ((n.name is k)
                                       ((0.012265 0.046626))
                                       ((0.0155385 0.0382105)))
                                      ((n.name is th)
                                       ((0.0262639 0.0584438))
                                       ((p.name is v)
                                        ((0.012411 0.0475013))
                                        ((n.name is y)
                                         ((0.0134266 0.0482305))
                                         ((p.name is s)
                                          ((0.0160232 0.0478256))
                                          ((n.name is ddh)
                                           ((0.00723724 0.0319854))
                                           ((p.name is dh)
                                            ((0.0110973 0.0388011))
                                            ((0.0129707 0.0426531)))))))))))))))))))))
                         ((name is ih)
                          ((n.name is s)
                           ((p.name is k)
                            ((0.0108602 0.0520473))
                            ((p.name is r)
                             ((0.0111077 0.0543456))
                             ((0.0136366 0.0612426))))
                           ((p.name is sh)
                            ((0.00744092 0.0270325))
                            ((n.name is h)
                             ((0.00526877 0.06785))
                             ((n.name is g)
                              ((p.name is th)
                               ((0.00359442 0.0421401))
                               ((0.00720837 0.037934)))
                              ((p.name is D)
                               ((0.0130607 0.0641916))
                               ((n.name is k)
                                ((0.0171371 0.0506788))
                                ((p.name is r)
                                 ((n.name is sh)
                                  ((0.0055609 0.044866))
                                  ((0.0113341 0.0357915)))
                                 ((n.name is sh)
                                  ((0.0184143 0.0614437))
                                  ((n.name is th)
                                   ((0.0110897 0.0384295))
                                   ((n.name is v)
                                    ((0.0123391 0.0512077))
                                    ((0.0141087 0.0455342))))))))))))
                          ((name is l)
                           ((n.name is a)
                            ((p.name is r)
                             ((0.0058543 0.0308713))
                             ((0.0108695 0.0450622)))
                            ((p.name is r)
                             ((0.015886 0.0652406))
                             ((p.name is l)
                              ((0.0117833 0.0440619))
                              ((p.name is k)
                               ((0.0147162 0.0426735))
                               ((syl_initial is 0)
                                ((0.0147224 0.060572))
                                ((0.0131854 0.0510567)))))))
                           ((name is bh)
                            ((n.name is aa)
                             ((0.0180337 0.0901212))
                             ((0.014855 0.076467)))
                            ((n.name is a)
                             ((name is dh)
                              ((p.name is ih)
                               ((0.00876601 0.0344933))
                               ((p.name is dh)
                                ((0.00877143 0.0369527))
                                ((0.0175708 0.0557423))))
                              ((p.name is ih)
                               ((0.0140429 0.0736663))
                               ((p.name is T)
                                ((0.00147228 0.0388766))
                                ((name is j)
                                 ((0.0197299 0.0640297))
                                 ((p.name is k)
                                  ((0.0125327 0.0612262))
                                  ((p.name is iy)
                                   ((0.00333443 0.060187))
                                   ((name is td)
                                    ((0.00156131 0.0597063))
                                    ((0.0140452 0.0514524)))))))))
                             ((n.name is l)
                              ((0.0182984 0.0459913))
                              ((p.name is sh)
                               ((n.name is oo)
                                ((0.0145754 0.0429087))
                                ((0.0127708 0.0544075)))
                               ((p.name is bh)
                                ((0.0124365 0.08651))
                                ((name is j)
                                 ((p.name is aa)
                                  ((0.00318443 0.0885167))
                                  ((0.0219164 0.0705103)))
                                 ((n.name is eh)
                                  ((0.00725791 0.0427538))
                                  ((n.name is dh)
                                   ((p.name is ee)
                                    ((0.0101513 0.0683476))
                                    ((p.name is ih)
                                     ((0.0155076 0.0493797))
                                     ((0.0169096 0.0571117))))
                                   ((n.name is g)
                                    ((name is m)
                                     ((0.00957765 0.0439267))
                                     ((0.0149904 0.0564514)))
                                    ((p.name is L)
                                     ((0.00744246 0.0468977))
                                     ((name is uw)
                                      ((p.name is k)
                                       ((0.0109783 0.0465147))
                                       ((syl_initial is 0)
                                        ((0.0169475 0.079519))
                                        ((0.00372062 0.0699907))))
                                      ((p.name is v)
                                       ((0.015339 0.04358))
                                       ((n.name is k)
                                        ((name is eh)
                                         ((0.0142771 0.082924))
                                         ((0.0194125 0.0649141)))
                                        ((n.name is oo)
                                         ((0.0181665 0.0759556))
                                         ((n.name is y)
                                          ((0.0112312 0.0723246))
                                          ((n.name is th)
                                           ((p.name is k)
                                            ((0.0146525 0.0571737))
                                            ((name is n)
                                             ((p.name is a)
                                              ((0.0138399 0.0666436))
                                              ((0.0133717 0.0613965)))
                                             ((0.0131756 0.07436))))
                                           ((name is oh)
                                            ((0.0102189 0.056524))
                                            ((n.name is s)
                                             ((0.00786143 0.0688037))
                                             ((name is h)
                                              ((0.0143996 0.0520356))
                                              ((p.name is iy)
                                               ((0.00999537 0.0691698))
                                               ((name is b)
                                                ((p.name is l)
                                                 ((0.0051184 0.0582693))
                                                 ((0.0137372 0.0505547)))
                                                ((name is n)
                                                 ((n.name is aa)
                                                  ((0.0109731
                                                    0.0427349))
                                                  ((p.name is a)
                                                   ((n.name is T)
                                                    ((0.0116912
                                                      0.0513599))
                                                    ((n.name is ch)
                                                     ((0.0050781
                                                       0.057067))
                                                     ((0.0169748
                                                       0.0677328))))
                                                   ((n.name is ih)
                                                    ((0.0131634
                                                      0.0569499))
                                                    ((0.0146893
                                                      0.0625313)))))
                                                 ((p.name is ih)
                                                  ((n.name is aa)
                                                   ((0.015362 0.081937))
                                                   ((0.0127332
                                                     0.0644978)))
                                                  ((p.name is s)
                                                   ((0.016747
                                                     0.0546577))
                                                   ((name is dh)
                                                    ((0.0125081
                                                      0.0571316))
                                                    ((name is D)
                                                     ((0.0130899
                                                       0.0594289))
                                                     ((p.name is r)
                                                      ((0.0117929
                                                        0.0692819))
                                                      ((n.name is ih)
                                                       ((0.00989944
                                                         0.0553084))
                                                       ((p.name is T)
                                                        ((0.0181876
                                                          0.0535462))
                                                        ((0.0227802
                                                          0.0656301))))))))))))))))))))))))))))))))))
                        ((n.name is y)
                         ((0.0161373 0.0857387))
                         ((name is D)
                          ((p.name is aa)
                           ((0.00516109 0.026629))
                           ((p.name is uw)
                            ((0.00325665 0.0287868))
                            ((0.0110873 0.0328516))))
                          ((name is l)
                           ((n.name is a)
                            ((p.name is aa)
                             ((0.00736585 0.0416899))
                             ((p.name is a)
                              ((0.00692499 0.0306274))
                              ((0.00801473 0.0352646))))
                            ((n.name is s)
                             ((0.0109762 0.0709654))
                             ((n.name is ee)
                              ((0.00302534 0.0535137))
                              ((n.name is dh)
                               ((0.00743972 0.058464))
                               ((n.name is p)
                                ((0.0153518 0.0578818))
                                ((p.name is oo)
                                 ((0.00108505 0.0322733))
                                 ((p.name is a)
                                  ((n.name is l)
                                   ((0.00374757 0.044871))
                                   ((n.name is ih)
                                    ((0.00275641 0.0353817))
                                    ((0.0135025 0.0400882))))
                                  ((n.name is ih)
                                   ((0.00527867 0.042079))
                                   ((0.0127872 0.046234))))))))))
                           ((n.name is l)
                            ((name is T)
                             ((0.00959872 0.0888332))
                             ((0.0103619 0.0628434)))
                            ((name is g)
                             ((n.name is a)
                              ((0.0114269 0.0369065))
                              ((n.name is uh)
                               ((p.name is uh)
                                ((0.0105523 0.032094))
                                ((0.00959596 0.04085)))
                               ((n.name is r)
                                ((0.0174056 0.0355883))
                                ((p.name is a)
                                 ((0.0119823 0.0404561))
                                 ((p.name is ih)
                                  ((0.0141406 0.0422096))
                                  ((p.name is m)
                                   ((0.0161483 0.0430327))
                                   ((0.00680699 0.0573102))))))))
                             ((n.name is p)
                              ((p.name is kh)
                               ((0.0143994 0.0791863))
                               ((name is a)
                                ((syl_initial is 0)
                                 ((0.00338048 0.0484993))
                                 ((0.0195296 0.060001)))
                                ((0.0174393 0.0657742))))
                              ((name is f)
                               ((0.0293328 0.0790914))
                               ((name is bh)
                                ((n.name is a)
                                 ((0.0148691 0.0566976))
                                 ((0.0147839 0.0692193)))
                                ((p.name is m)
                                 ((0.0088615 0.0291607))
                                 ((p.name is r)
                                  ((n.name is m)
                                   ((0.0224309 0.0442902))
                                   ((0.0171473 0.063656)))
                                  ((name is m)
                                   ((p.name is ay)
                                    ((0.00952424 0.0722533))
                                    ((n.name is th)
                                     ((0.00274148 0.067507))
                                     ((p.name is a)
                                      ((n.name is a)
                                       ((0.0139227 0.045852))
                                       ((n.name is eh)
                                        ((0.00871717 0.0454657))
                                        ((n.name is ay)
                                         ((0.0168429 0.0473224))
                                         ((0.0154748 0.0574267)))))
                                      ((n.name is a)
                                       ((p.name is aa)
                                        ((0.00781998 0.0639675))
                                        ((0.00819439 0.0560718)))
                                       ((0.0138464 0.0550341))))))
                                   ((name is ddh)
                                    ((n.name is aa)
                                     ((0.0204225 0.0724741))
                                     ((n.name is ih)
                                      ((p.name is aa)
                                       ((0.015244 0.0464234))
                                       ((0.00442327 0.0360331)))
                                      ((0.0137052 0.0534762))))
                                    ((name is T)
                                     ((n.name is uh)
                                      ((0.0170365 0.0467509))
                                      ((p.name is aa)
                                       ((0.0174537 0.0691018))
                                       ((n.name is T)
                                        ((0.0107367 0.0488585))
                                        ((n.name is ih)
                                         ((p.name is a)
                                          ((0.0140404 0.0543354))
                                          ((0.0150184 0.0374154)))
                                         ((0.0105761 0.0605444))))))
                                     ((n.name is a)
                                      ((name is h)
                                       ((0.00284446 0.02685))
                                       ((name is dh)
                                        ((p.name is uh)
                                         ((0.00761898 0.0560325))
                                         ((0.00640179 0.0467873)))
                                        ((0.0134104 0.0418608))))
                                      ((n.name is dh)
                                       ((name is a)
                                        ((0.0105311 0.0264082))
                                        ((p.name is th)
                                         ((0.00670984 0.0441023))
                                         ((0.00633778 0.0379313))))
                                       ((name is ih)
                                        ((n.name is 0)
                                         ((0.00630881 0.03296))
                                         ((p.name is k)
                                          ((0.00879908 0.0359833))
                                          ((p.name is T)
                                           ((0.0127369 0.0402922))
                                           ((0.0223998 0.0519102)))))
                                        ((n.name is v)
                                         ((p.name is l)
                                          ((0.0119196 0.0446))
                                          ((p.name is a)
                                           ((0.0060586 0.0677957))
                                           ((0.0124485 0.0577962))))
                                         ((p.name is uh)
                                          ((name is dh)
                                           ((0.0100064 0.0617881))
                                           ((n.name is ih)
                                            ((0.004935 0.0394027))
                                            ((0.0101159 0.0451112))))
                                          ((n.name is aa)
                                           ((name is n)
                                            ((0.0112519 0.0352837))
                                            ((0.0103276 0.0453955)))
                                           ((name is dh)
                                            ((n.name is ee)
                                             ((0.0145822 0.0523954))
                                             ((n.name is ih)
                                              ((0.00915926 0.0346064))
                                              ((p.name is aa)
                                               ((0.0157417 0.0354468))
                                               ((0.00974077 0.0470365)))))
                                            ((n.name is ih)
                                             ((p.name is aa)
                                              ((0.00913027 0.0409618))
                                              ((p.name is ay)
                                               ((0.00187181 0.0455986))
                                               ((0.0159686 0.0501805))))
                                             ((p.name is aa)
                                              ((name is n)
                                               ((0.0168561 0.0675373))
                                               ((0.00145854 0.0492326)))
                                              ((n.name is D)
                                               ((0.005294 0.0377093))
                                               ((n.name is ch)
                                                ((0.0158421 0.0387716))
                                                ((n.name is eh)
                                                 ((0.0127085 0.0381047))
                                                 ((name is b)
                                                  ((0.0172603
                                                    0.0388436))
                                                  ((p.name is th)
                                                   ((0.034793 0.068746))
                                                   ((n.name is ee)
                                                    ((0.0128129
                                                      0.039461))
                                                    ((syl_initial is 0)
                                                     ((n.name is uh)
                                                      ((name is a)
                                                       ((0.0218115
                                                         0.0591572))
                                                       ((0.0140275
                                                         0.0470056)))
                                                      ((name is a)
                                                       ((0.00743677
                                                         0.0510769))
                                                       ((p.name is ih)
                                                        ((0.0188402
                                                          0.0513843))
                                                        ((n.name is L)
                                                         ((0.0190662
                                                           0.0524907))
                                                         ((0.00653353
                                                           0.0733243))))))
                                                     ((n.name is s)
                                                      ((0.00706557
                                                        0.0506358))
                                                      ((0.0110857
                                                        0.0460468))))))))))))))))))))))))))))))))))))))))))))))))))))))))
)
)

(provide 'marathi_NSK_dur)


