/* dummy-backend.c generated by valac 0.28.0.16-b1323, the Vala compiler
 * generated from dummy-backend.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-internal.h>


#define FOLKS_DUMMY_TYPE_BACKEND (folks_dummy_backend_get_type ())
#define FOLKS_DUMMY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend))
#define FOLKS_DUMMY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackendClass))
#define FOLKS_DUMMY_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_BACKEND))
#define FOLKS_DUMMY_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_BACKEND))
#define FOLKS_DUMMY_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackendClass))

typedef struct _FolksDummyBackend FolksDummyBackend;
typedef struct _FolksDummyBackendClass FolksDummyBackendClass;
typedef struct _FolksDummyBackendPrivate FolksDummyBackendPrivate;

#define FOLKS_DUMMY_TYPE_PERSONA_STORE (folks_dummy_persona_store_get_type ())
#define FOLKS_DUMMY_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore))
#define FOLKS_DUMMY_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))
#define FOLKS_DUMMY_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))

typedef struct _FolksDummyPersonaStore FolksDummyPersonaStore;
typedef struct _FolksDummyPersonaStoreClass FolksDummyPersonaStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksDummyBackendPrepareData FolksDummyBackendPrepareData;
typedef struct _FolksDummyBackendUnprepareData FolksDummyBackendUnprepareData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyBackend {
	FolksBackend parent_instance;
	FolksDummyBackendPrivate * priv;
};

struct _FolksDummyBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksDummyBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _all_persona_stores;
	GeeHashMap* _enabled_persona_stores;
	GeeMap* _enabled_persona_stores_ro;
};

struct _FolksDummyBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_;
};

struct _FolksDummyBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksDummyPersonaStore** enabled_stores;
	GeeHashMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gint _tmp7_;
	gpointer* _tmp8_;
	FolksDummyPersonaStore** _tmp9_;
	gint _tmp9__length1;
	gint enabled_stores_length1;
	gint _enabled_stores_size_;
	FolksDummyPersonaStore** _tmp10_;
	gint _tmp10__length1;
	FolksDummyPersonaStore** persona_store_collection;
	gint persona_store_collection_length1;
	gint _persona_store_collection_size_;
	gint persona_store_it;
	FolksDummyPersonaStore* _tmp11_;
	FolksDummyPersonaStore* persona_store;
	FolksDummyPersonaStore* _tmp12_;
	GError * _inner_error_;
};


static gpointer folks_dummy_backend_parent_class = NULL;

GType folks_dummy_backend_get_type (void) G_GNUC_CONST;
GType folks_dummy_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_DUMMY_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackendPrivate))
enum  {
	FOLKS_DUMMY_BACKEND_DUMMY_PROPERTY,
	FOLKS_DUMMY_BACKEND_IS_PREPARED,
	FOLKS_DUMMY_BACKEND_IS_QUIESCENT,
	FOLKS_DUMMY_BACKEND_NAME,
	FOLKS_DUMMY_BACKEND_PERSONA_STORES
};
FolksDummyBackend* folks_dummy_backend_new (void);
FolksDummyBackend* folks_dummy_backend_construct (GType object_type);
static void folks_dummy_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_dummy_backend_disable_persona_store (FolksDummyBackend* self, FolksPersonaStore* store);
static void folks_dummy_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_dummy_backend_enable_persona_store (FolksDummyBackend* self, FolksDummyPersonaStore* store);
static void folks_dummy_backend_real_set_persona_stores (FolksBackend* base, GeeSet* store_ids);
static void _vala_array_add1 (FolksDummyPersonaStore*** array, int* length, int* size, FolksDummyPersonaStore* value);
static void _folks_dummy_backend_store_removed_cb (FolksDummyBackend* self, FolksPersonaStore* store);
static void __folks_dummy_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_dummy_backend_real_prepare_data_free (gpointer _data);
static void folks_dummy_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_dummy_backend_real_prepare_co (FolksDummyBackendPrepareData* _data_);
static void folks_dummy_backend_real_unprepare_data_free (gpointer _data);
static void folks_dummy_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_dummy_backend_real_unprepare_co (FolksDummyBackendUnprepareData* _data_);
void folks_dummy_backend_register_persona_stores (FolksDummyBackend* self, GeeSet* stores, gboolean enable_stores);
void folks_dummy_backend_unregister_persona_stores (FolksDummyBackend* self, GeeSet* stores);
static GObject * folks_dummy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_dummy_backend_finalize (GObject* obj);
static void _vala_folks_dummy_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
FolksDummyBackend* folks_dummy_backend_construct (GType object_type) {
	FolksDummyBackend * self = NULL;
	self = (FolksDummyBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksDummyBackend* folks_dummy_backend_new (void) {
	return folks_dummy_backend_construct (FOLKS_DUMMY_TYPE_BACKEND);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static void folks_dummy_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksDummyBackend * self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (FolksDummyBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_dummy_backend_disable_persona_store (self, _tmp0_);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static void folks_dummy_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksDummyBackend * self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (FolksDummyBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_dummy_backend_enable_persona_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore));
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksDummyPersonaStore*** array, int* length, int* size, FolksDummyPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksDummyPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_dummy_backend_real_set_persona_stores (FolksBackend* base, GeeSet* store_ids) {
	FolksDummyBackend * self;
	GeeSet* _tmp0_ = NULL;
	FolksDummyPersonaStore** stores_to_remove = NULL;
	FolksDummyPersonaStore** _tmp26_ = NULL;
	gint stores_to_remove_length1 = 0;
	gint _stores_to_remove_size_ = 0;
	FolksDummyPersonaStore** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	self = (FolksDummyBackend*) base;
	_tmp0_ = store_ids;
	if (_tmp0_ == NULL) {
		g_object_freeze_notify ((GObject*) self);
		{
			GeeIterator* _store_it = NULL;
			GeeHashMap* _tmp1_ = NULL;
			GeeCollection* _tmp2_ = NULL;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_ = NULL;
			GeeIterator* _tmp5_ = NULL;
			GeeIterator* _tmp6_ = NULL;
			_tmp1_ = self->priv->_all_persona_stores;
			_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			_store_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				FolksDummyPersonaStore* store = NULL;
				GeeIterator* _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
				FolksDummyPersonaStore* _tmp11_ = NULL;
				_tmp7_ = _store_it;
				_tmp8_ = gee_iterator_next (_tmp7_);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = _store_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				store = (FolksDummyPersonaStore*) _tmp10_;
				_tmp11_ = store;
				_folks_dummy_backend_enable_persona_store (self, _tmp11_);
				_g_object_unref0 (store);
			}
			_g_object_unref0 (_store_it);
		}
		g_object_thaw_notify ((GObject*) self);
		return;
	}
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _id_it = NULL;
		GeeSet* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		_tmp12_ = store_ids;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_id_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			gchar* id = NULL;
			GeeIterator* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			GeeHashMap* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp14_ = _id_it;
			_tmp15_ = gee_iterator_next (_tmp14_);
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = _id_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			id = (gchar*) _tmp17_;
			_tmp18_ = self->priv->_enabled_persona_stores;
			_tmp19_ = id;
			_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp19_);
			if (!_tmp20_) {
				FolksDummyPersonaStore* store = NULL;
				GeeHashMap* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gpointer _tmp23_ = NULL;
				FolksDummyPersonaStore* _tmp24_ = NULL;
				_tmp21_ = self->priv->_all_persona_stores;
				_tmp22_ = id;
				_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
				store = (FolksDummyPersonaStore*) _tmp23_;
				_tmp24_ = store;
				if (_tmp24_ != NULL) {
					FolksDummyPersonaStore* _tmp25_ = NULL;
					_tmp25_ = store;
					_folks_dummy_backend_enable_persona_store (self, _tmp25_);
				}
				_g_object_unref0 (store);
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp26_ = g_new0 (FolksDummyPersonaStore*, 0 + 1);
	stores_to_remove = _tmp26_;
	stores_to_remove_length1 = 0;
	_stores_to_remove_size_ = stores_to_remove_length1;
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp27_ = NULL;
		GeeCollection* _tmp28_ = NULL;
		GeeCollection* _tmp29_ = NULL;
		GeeCollection* _tmp30_ = NULL;
		GeeIterator* _tmp31_ = NULL;
		GeeIterator* _tmp32_ = NULL;
		_tmp27_ = self->priv->_enabled_persona_stores;
		_tmp28_ = gee_abstract_map_get_values ((GeeMap*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
		_tmp32_ = _tmp31_;
		_g_object_unref0 (_tmp30_);
		_store_it = _tmp32_;
		while (TRUE) {
			GeeIterator* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			GeeSet* _tmp37_ = NULL;
			FolksDummyPersonaStore* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			_tmp33_ = _store_it;
			_tmp34_ = gee_iterator_next (_tmp33_);
			if (!_tmp34_) {
				break;
			}
			_tmp35_ = _store_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			store = (FolksDummyPersonaStore*) _tmp36_;
			_tmp37_ = store_ids;
			_tmp38_ = store;
			_tmp39_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = gee_collection_contains ((GeeCollection*) _tmp37_, _tmp40_);
			if (!_tmp41_) {
				FolksDummyPersonaStore** _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				FolksDummyPersonaStore* _tmp43_ = NULL;
				FolksDummyPersonaStore* _tmp44_ = NULL;
				_tmp42_ = stores_to_remove;
				_tmp42__length1 = stores_to_remove_length1;
				_tmp43_ = store;
				_tmp44_ = _g_object_ref0 (_tmp43_);
				_vala_array_add1 (&stores_to_remove, &stores_to_remove_length1, &_stores_to_remove_size_, _tmp44_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_tmp45_ = stores_to_remove;
	_tmp45__length1 = stores_to_remove_length1;
	{
		FolksDummyPersonaStore** store_collection = NULL;
		gint store_collection_length1 = 0;
		gint _store_collection_size_ = 0;
		gint store_it = 0;
		store_collection = _tmp45_;
		store_collection_length1 = _tmp45__length1;
		for (store_it = 0; store_it < _tmp45__length1; store_it = store_it + 1) {
			FolksDummyPersonaStore* _tmp46_ = NULL;
			FolksDummyPersonaStore* store = NULL;
			_tmp46_ = _g_object_ref0 (store_collection[store_it]);
			store = _tmp46_;
			{
				FolksDummyPersonaStore* _tmp47_ = NULL;
				_tmp47_ = store;
				_folks_dummy_backend_disable_persona_store (self, (FolksPersonaStore*) _tmp47_);
				_g_object_unref0 (store);
			}
		}
	}
	g_object_thaw_notify ((GObject*) self);
	stores_to_remove = (_vala_array_free (stores_to_remove, stores_to_remove_length1, (GDestroyNotify) g_object_unref), NULL);
}


static void __folks_dummy_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_dummy_backend_store_removed_cb ((FolksDummyBackend*) self, _sender);
}


static void _folks_dummy_backend_enable_persona_store (FolksDummyBackend* self, FolksDummyPersonaStore* store) {
	GeeHashMap* _tmp0_ = NULL;
	FolksDummyPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	FolksDummyPersonaStore* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	FolksDummyPersonaStore* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	FolksDummyPersonaStore* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	FolksDummyPersonaStore* _tmp15_ = NULL;
	FolksDummyPersonaStore* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_enabled_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->_all_persona_stores;
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp8_);
	_vala_assert (_tmp9_, "this._all_persona_stores.has_key (store.id)");
	_tmp10_ = store;
	g_signal_connect_object ((FolksPersonaStore*) _tmp10_, "removed", (GCallback) __folks_dummy_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp11_ = self->priv->_enabled_persona_stores;
	_tmp12_ = store;
	_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp14_, _tmp15_);
	_tmp16_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp16_);
	g_object_notify ((GObject*) self, "persona-stores");
}


static void _folks_dummy_backend_disable_persona_store (FolksDummyBackend* self, FolksPersonaStore* store) {
	GeeHashMap* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	FolksPersonaStore* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	FolksPersonaStore* _tmp10_ = NULL;
	FolksPersonaStore* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_enabled_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp3_, NULL);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->_all_persona_stores;
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp8_);
	_vala_assert (_tmp9_, "this._all_persona_stores.has_key (store.id)");
	_tmp10_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp10_);
	g_object_notify ((GObject*) self, "persona-stores");
	_tmp11_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) __folks_dummy_backend_store_removed_cb_folks_persona_store_removed, self);
}


static void _folks_dummy_backend_store_removed_cb (FolksDummyBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_dummy_backend_disable_persona_store (self, _tmp0_);
}


static void folks_dummy_backend_real_prepare_data_free (gpointer _data) {
	FolksDummyBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyBackendPrepareData, _data_);
}


static void folks_dummy_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyBackend * self;
	FolksDummyBackendPrepareData* _data_;
	FolksDummyBackend* _tmp0_ = NULL;
	self = (FolksDummyBackend*) base;
	_data_ = g_slice_new0 (FolksDummyBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_backend_real_prepare_co (_data_);
}


static void folks_dummy_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksDummyBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gboolean folks_dummy_backend_real_prepare_co (FolksDummyBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Dummy.Backend", NULL);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	folks_internal_profiling_end ("preparing Dummy.Backend", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_dummy_backend_real_unprepare_data_free (gpointer _data) {
	FolksDummyBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyBackendUnprepareData, _data_);
}


static void folks_dummy_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyBackend * self;
	FolksDummyBackendUnprepareData* _data_;
	FolksDummyBackend* _tmp0_ = NULL;
	self = (FolksDummyBackend*) base;
	_data_ = g_slice_new0 (FolksDummyBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_backend_real_unprepare_co (_data_);
}


static void folks_dummy_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksDummyBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gboolean folks_dummy_backend_real_unprepare_co (FolksDummyBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->_enabled_persona_stores;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp3_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = 0;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = gee_collection_to_array (_data_->_tmp6_, &_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9__length1 = 0;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp9__length1 = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->enabled_stores_length1 = 0;
		_data_->_enabled_stores_size_ = 0;
		_data_->enabled_stores = _data_->_tmp9_;
		_data_->enabled_stores_length1 = _data_->_tmp9__length1;
		_data_->_enabled_stores_size_ = _data_->enabled_stores_length1;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10__length1 = 0;
		_data_->_tmp10_ = _data_->enabled_stores;
		_data_->_tmp10__length1 = _data_->enabled_stores_length1;
		{
			_data_->persona_store_collection_length1 = 0;
			_data_->_persona_store_collection_size_ = 0;
			_data_->persona_store_collection = _data_->_tmp10_;
			_data_->persona_store_collection_length1 = _data_->_tmp10__length1;
			for (_data_->persona_store_it = 0; _data_->persona_store_it < _data_->_tmp10__length1; _data_->persona_store_it = _data_->persona_store_it + 1) {
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _g_object_ref0 (_data_->persona_store_collection[_data_->persona_store_it]);
				_data_->persona_store = _data_->_tmp11_;
				{
					_data_->_tmp12_ = NULL;
					_data_->_tmp12_ = _data_->persona_store;
					_folks_dummy_backend_disable_persona_store (_data_->self, (FolksPersonaStore*) _data_->_tmp12_);
					_g_object_unref0 (_data_->persona_store);
				}
			}
		}
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->enabled_stores = (_vala_array_free (_data_->enabled_stores, _data_->enabled_stores_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	__finally1:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Register and enable some {@link FolksDummy.PersonaStore}s.
   *
   * For each of the persona stores in ``stores``, register it with this
   * backend. If ``enable_stores`` is ``true``, added stores will also be
   * enabled, emitting {@link Folks.Backend.persona_store_added} for each
   * newly-enabled store. After all addition signals are emitted, a change
   * notification for {@link Folks.Backend.persona_stores} will be emitted (but
   * only if at least one addition signal is emitted).
   *
   * Persona stores are identified by their {@link Folks.PersonaStore.id}; if a
   * store in ``stores`` has the same ID as a store previously registered
   * through this method, the duplicate will be ignored (so
   * {@link Folks.Backend.persona_store_added} won't be emitted for that store).
   *
   * Persona stores must be instances of {@link FolksDummy.PersonaStore} or
   * subclasses of it, allowing for different persona store implementations to
   * be tested.
   *
   * @param stores set of persona stores to register
   * @param enable_stores whether to automatically enable the stores
   * @since 0.9.7
   */
void folks_dummy_backend_register_persona_stores (FolksDummyBackend* self, GeeSet* stores, gboolean enable_stores) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stores != NULL);
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp0_ = stores;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_store_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			FolksDummyPersonaStore* _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
			FolksDummyPersonaStore* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GeeHashMap* _tmp12_ = NULL;
			FolksDummyPersonaStore* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			FolksDummyPersonaStore* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp2_ = _store_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _store_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			store = (FolksDummyPersonaStore*) _tmp5_;
			_tmp6_ = store;
			_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, FOLKS_DUMMY_TYPE_PERSONA_STORE), "store is FolksDummy.PersonaStore");
			_tmp7_ = self->priv->_all_persona_stores;
			_tmp8_ = store;
			_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp10_);
			if (_tmp11_) {
				_g_object_unref0 (store);
				continue;
			}
			_tmp12_ = self->priv->_all_persona_stores;
			_tmp13_ = store;
			_tmp14_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = store;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp15_, _tmp16_);
			_tmp17_ = enable_stores;
			if (_tmp17_ == TRUE) {
				FolksDummyPersonaStore* _tmp18_ = NULL;
				_tmp18_ = store;
				_folks_dummy_backend_enable_persona_store (self, _tmp18_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	g_object_thaw_notify ((GObject*) self);
}


/**
   * Disable and unregister some {@link FolksDummy.PersonaStore}s.
   *
   * For each of the persona stores in ``stores``, disable it (if it was
   * enabled) and unregister it from the backend so that it cannot be re-enabled
   * using {@link Folks.Backend.enable_persona_store} or
   * {@link Folks.Backend.set_persona_stores}.
   *
   * {@link Folks.Backend.persona_store_removed} will be emitted for all persona
   * stores in ``stores`` which were previously enabled. After all removal
   * signals are emitted, a change notification for
   * {@link Folks.Backend.persona_stores} will be emitted (but only if at least
   * one removal signal is emitted).
   *
   * @since 0.9.7
   */
void folks_dummy_backend_unregister_persona_stores (FolksDummyBackend* self, GeeSet* stores) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stores != NULL);
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _store_it = NULL;
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp0_ = stores;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_store_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			FolksDummyPersonaStore* _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
			FolksDummyPersonaStore* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			FolksDummyPersonaStore* _tmp12_ = NULL;
			GeeHashMap* _tmp13_ = NULL;
			FolksDummyPersonaStore* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp2_ = _store_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _store_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			store = (FolksDummyPersonaStore*) _tmp5_;
			_tmp6_ = store;
			_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, FOLKS_DUMMY_TYPE_PERSONA_STORE), "store is FolksDummy.PersonaStore");
			_tmp7_ = self->priv->_all_persona_stores;
			_tmp8_ = store;
			_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp10_);
			if (!_tmp11_) {
				_g_object_unref0 (store);
				continue;
			}
			_tmp12_ = store;
			_folks_dummy_backend_disable_persona_store (self, (FolksPersonaStore*) _tmp12_);
			_tmp13_ = self->priv->_all_persona_stores;
			_tmp14_ = store;
			_tmp15_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp14_);
			_tmp16_ = _tmp15_;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp16_, NULL);
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	g_object_thaw_notify ((GObject*) self);
}


static gboolean folks_dummy_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksDummyBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksDummyBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_dummy_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksDummyBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksDummyBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static const gchar* folks_dummy_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksDummyBackend* self;
	self = (FolksDummyBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_dummy_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksDummyBackend* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksDummyBackend*) base;
	_tmp0_ = self->priv->_enabled_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static GObject * folks_dummy_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksDummyBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_dummy_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_DUMMY_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_all_persona_stores);
	self->priv->_all_persona_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_DUMMY_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_enabled_persona_stores);
	self->priv->_enabled_persona_stores = _tmp1_;
	_tmp2_ = self->priv->_enabled_persona_stores;
	_tmp3_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_enabled_persona_stores_ro);
	self->priv->_enabled_persona_stores_ro = _tmp4_;
	return obj;
}


static void folks_dummy_backend_class_init (FolksDummyBackendClass * klass) {
	folks_dummy_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksDummyBackendPrivate));
	((FolksBackendClass *) klass)->disable_persona_store = folks_dummy_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = folks_dummy_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = folks_dummy_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = folks_dummy_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = folks_dummy_backend_real_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = folks_dummy_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = folks_dummy_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_dummy_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_dummy_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_dummy_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_dummy_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_dummy_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_backend_finalize;
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_dummy_backend_instance_init (FolksDummyBackend * self) {
	self->priv = FOLKS_DUMMY_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_dummy_backend_finalize (GObject* obj) {
	FolksDummyBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	_g_object_unref0 (self->priv->_all_persona_stores);
	_g_object_unref0 (self->priv->_enabled_persona_stores);
	_g_object_unref0 (self->priv->_enabled_persona_stores_ro);
	G_OBJECT_CLASS (folks_dummy_backend_parent_class)->finalize (obj);
}


/**
 * A backend which allows {@link FolksDummy.PersonaStore}s and
 * {@link FolksDummy.Persona}s to be programmatically created and manipulated,
 * for the purposes of testing the core of libfolks itself.
 *
 * This backend is not meant to be enabled in production use. The methods on
 * {@link FolksDummy.Backend} (and other classes) for programmatically
 * manipulating the backend's state are considered internal to libfolks and are
 * not stable.
 *
 * This backend maintains two sets of persona stores: the set of all persona
 * stores, and the set of enabled persona stores (which must be a subset of the
 * former). {@link FolksDummy.Backend.register_persona_stores} adds persona
 * stores to the set of all stores. Optionally it also enables them, adding them
 * to the set of enabled stores. The set of persona stores advertised by the
 * backend as {@link Folks.Backend.persona_stores} is the set of enabled stores.
 * libfolks may internally enable or disable stores using
 * {@link Folks.Backend.enable_persona_store},
 * {@link Folks.Backend.disable_persona_store}
 * and {@link Folks.Backend.set_persona_stores}.  The ``register_`` and
 * ``unregister_`` prefixes are commonly used for backend methods.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
GType folks_dummy_backend_get_type (void) {
	static volatile gsize folks_dummy_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_dummy_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksDummyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyBackend), 0, (GInstanceInitFunc) folks_dummy_backend_instance_init, NULL };
		GType folks_dummy_backend_type_id;
		folks_dummy_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksDummyBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_dummy_backend_type_id__volatile, folks_dummy_backend_type_id);
	}
	return folks_dummy_backend_type_id__volatile;
}


static void _vala_folks_dummy_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksDummyBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	switch (property_id) {
		case FOLKS_DUMMY_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



