/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef DLGEDIT_H
#define DLGEDIT_H

#include <QDialog>
#include <QTableWidgetItem>
#include <QJsonObject>
#include <QTimer>
#include "common.h"

namespace Ui {
class dlgEdit;
}

class dlgEdit : public QDialog
{
    Q_OBJECT

public:
    explicit dlgEdit(QWidget *parent = nullptr);
    ~dlgEdit();
    void EditOpen(QList<QStringList> *topicdata);
    bool event(QEvent* ev) override;
    void    GetUiText(QJsonObject *uitext);
    void    SetUiText(QJsonObject *uitext);

signals:
    void    Savefile();

private slots:
    void on_pbSave_clicked();
    void on_pbExit_clicked();
    void on_grid1_cellChanged(int row, int column);
    void on_timer();

private:
    Ui::dlgEdit *ui;
    void        fDestroyGrid();
    void        fAddRow();
    void        fCellsResize();
    bool    vDataInitInProgress;
    QList<QStringList>  *TopicData;
    QTimer      vTimer;

    //Strings for translation
    QString     sColoumn0;
    QString     sColoumn1;
};

#endif // DLGEDIT_H
