/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef DLGTEST1_H
#define DLGTEST1_H

#include <QDialog>
#include <QJsonObject>

namespace Ui {
class dlgTest1;
}

class dlgTest1 : public QDialog
{
    Q_OBJECT

public:
    explicit dlgTest1(QWidget *parent = nullptr);
    ~dlgTest1();
    enum TestType
    {
        DirectTest,
        ReverseTest
    };

    void    TestStart(QList<QStringList> *topicdata, TestType tt=DirectTest);
    bool    event(QEvent* ev) override;
    void    GetUiText(QJsonObject *uitext);
    void    SetUiText(QJsonObject *uitext);
    void    TurnOffSpeech();

signals:
    void textToSpeech(QString);

private slots:
    void on_pbQuestion_clicked();
    void on_pbAnswer1_clicked();
    void on_pbAnswer2_clicked();
    void on_pbAnswer3_clicked();
    void on_pbAnswer4_clicked();
    void on_pbAnswer5_clicked();
    void on_pbExit_clicked();

private:
    Ui::dlgTest1 *ui;
    void    Init();
    void    SetButtons();
    void    fCheck(int n);

    QList<QStringList>  *lTopicData;//          0-foreign word, 1-native word
    QList<QStringList>  lTopicDataReverse;//          0-foreign word, 1-native word

    int  aButtonDim[5];
    bool        vSucceed;//                     true if clicked proper button
    int         vTotalEfforts;//                #total number of attempts
    int         vSucceedEfforts;//               #number of right attempts
    int         vDictRandVal;//                 #a random value for test dim
    int         vButtonNumber;//                #number of botton of the correct ansver
    QList<int>  aDictIndex;//                       #array of indexes
    int         vLenth;
    QString     vWordsNumber;
    QString     vQuestion;

    //Strings for translation
    QString     sPrompt;
    QString     sResult;
    QString     sResultComplete;
    QString     sStatistic;
};

#endif // DLGTEST1_H


