/* $Id: environment.h,v 1.4 2001/04/24 17:18:55 japh Exp $ */
#ifndef __HAVE_ENVIRONMENT_H__
#define __HAVE_ENVIRONMENT_H__

/*
 * some information on your system-environment:
 *
 * these macros are strings of the complete file-names
 * including the whole path to them:
 *
 *  FILENAME_LOGIN_LOGGING  filename login.logging
 *  FILENAME_USERTTY        filename usertty
 *  FILENAME_SECURETTY      filename securetty
 *  FILENAME_LASTLOG        filename lastlog
 *  SHELL_PARAMS            parameters to pass to shell
 *  EMERGENCY_LOGIN         filename of program to execute
 *                          if fatal errors occur
 */


#define FILENAME_LOGIN_LOGGING  "/etc/login.logging"

#define FILENAME_USERTTY        "/etc/usertty"

#define FILENAME_SECURETTY      "/etc/securetty"

#define FILENAME_LASTLOG        "/var/log/lastlog"

#define FILENAME_DEFAULTFLT     "/etc/default.flt"

#define EMERGENCY_LOGIN         "/bin/login"

#define MAILBOX_PATH 		"/var/spool/mail"

#define SPEECH_DEVICE 		"/dev/speech"

/*
 * define SUPPORT_USERTTY to get support for /etc/usertty-files
 * if unsure, don't do it.
 */

/* #define SUPPORT_USERTTY */


/*
 * define SUPPORT_USERTTY_NETWORK to get support for /etc/usertty's
 * network-functionality
 * if unsure, don't do it. 
 */

/* #define SUPPORT_USERTTY_NETWORK */


/*
 * define SUPPORT_USERTTY_TIME to get support for /etc/usertty's
 * time-functionality
 * if unsure, don't do it.
 */

/* #define SUPPORT_USERTTY_TIME */


/*
 * define SUPPORT_SYSLOG if you want francine to support
 * logging through syslogd.
 * if unsure don't do it.
 */

#define SUPPORT_SYSLOG


/*
 * define SUPPORT_FILELOG if you want francine to support
 * logging through log-files.
 * if unsure define it.
 */

#define SUPPORT_FILELOG



/*
 * define ALLOW_NORMAL if you want to allow non-shadow password-verification.
 * if unsure define it.
 */

#define ALLOW_NORMAL


/*
 * set CLOSE_AFTER_FAILED if you want login to terminate
 * after CLOSE_AFTER_FAILED failed logins.
 *
 * #define CLOSE_AFTER_FAILED 3
 *
 * for example means, that login terminates after 3 failed
 * logins
 *
 * if you don't want login to terminate at all, don't define it.
 */

#define CLOSE_AFTER_FAILED 5


/*
 * set EXECUTE_EMERGENCY_LOGIN if you want emergency-login
 * (EMERGENCY_LOGIN from environment.h) to be called on fatal
 * errors
 */

#define EXECUTE_EMERGENCY_LOGIN


/*
 * define ALLOW_NORMAL if you want to allow authenticating
 * using DES-encryption. If you are unsure define it.
 */

#define ALLOW_DES


/*
 * define ALLOW_MD5 if you want to allow authenticating
 * using MD5-encryption. If you are unsure define it.
 */

#define ALLOW_MD5


#define MSG_NEWMAIL "You've got mail!"
#define MSG_SEENMAIL "You've got old mail."
#define MSG_NOMAIL "No mails for you."


#define SPEECH_LOGIN_SUCCESS "Log in successful."
#define SPEECH_ENTER_USERNAME "Please enter your username and password."
#define SPEECH_LOGIN_FAILED "Log in failed. Please try again."

#endif
