#!/bin/sh

# fetch installation patch
DEFAULT_INSTALL_PATH='/usr/local/freeplayer/'

if [ $# -lt 1 ]; then
    echo -n "Enter the installation path [$DEFAULT_INSTALL_PATH]: "
    read INSTALL_PATH
    [ "z$INSTALL_PATH" = "z" ] && INSTALL_PATH=$DEFAULT_INSTALL_PATH
else
    INSTALL_PATH="$1"
fi

echo -n "This will install the Freeplayer package in \"$INSTALL_PATH\" [y/n] "
read answer
if [ "$answer" != 'y' -a "$answer" != 'Y' ]; then
    echo "abort"
    exit 1
fi

# install the package
echo "Installing package..."
install -d $INSTALL_PATH || exit 1
cp -Ra . $INSTALL_PATH/ || exit 1
rm -f $INSTALL_PATH/install.sh || exit 1

sed s^%HTTP_PATH%^$INSTALL_PATH/share/http-fbx/^ -i $INSTALL_PATH/bin/vlc-fbx.sh

echo "Done, have fun"
