/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.gui;

import gmonitor.gui.GraphMonitorModel;
import gmonitor.gui.RawData;
import gmonitor.gui.RawDataElement;
import gmonitor.gui.ViewData;
import gmonitor.gui.ViewDataElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;

public class GraphMonitor
extends JPanel
implements ComponentListener {
    private boolean stylePlot = true;
    private boolean styleJoin = true;
    private boolean styleFill = true;
    private Color gridColor = Color.GRAY;
    private Color backColor = Color.WHITE;
    private Color labelColor = Color.BLACK;
    private String title = "";
    private long maxValue = Long.MAX_VALUE;
    private int unitX = 2;
    private int unitY = 2;
    private String[] unitLabelX;
    private String[] unitLabelY;
    private int offsetX;
    private String axisLabelX = "";
    private String axisLabelY = "";
    private String valueUnit = "";
    private ArrayList viewdata = new ArrayList();
    private GraphMonitorModel model;
    private int y_label_width_max;
    private int x_label_width_max;
    private int grid_width;
    private int grid_height;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final int[] X_DIVISION = new int[]{100, 50, 25, 10, 5, 2, 1};
    private static final int[] Y_DIVISION = new int[]{100, 50, 25, 10, 5, 2, 1};

    public GraphMonitor() {
        this.addComponentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.clearRect(0, 0, rectangle.width, rectangle.height);
        if (this.model == null) {
            this.draw_nodata(graphics);
            return;
        }
        GraphMonitorModel graphMonitorModel = this.model;
        synchronized (graphMonitorModel) {
            this.recalc();
            this.createDecoration();
            this.recalc();
            this.draw_graph(graphics);
            this.draw_decoration(graphics);
        }
    }

    private void draw_graph(Graphics graphics) {
        ArrayList arrayList = this.viewdata;
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        Graphics graphics2 = graphics;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getHeight();
        int n3 = 0 + n2 + this.grid_height;
        int n4 = 0 + n2 + this.y_label_width_max;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            int n7;
            graphics = graphics2.create();
            ViewData viewData = (ViewData)arrayList.get(i);
            if (viewData == null || !viewData.isValid()) continue;
            ViewDataElement[] viewDataElementArray = viewData.getData();
            graphics.setClip(n4, n3 - this.grid_height, this.grid_width, this.grid_height);
            int n8 = n4;
            int n9 = 0;
            boolean bl = false;
            int n10 = n3;
            if (viewDataElementArray == null) continue;
            Color color = viewData.getFillColor();
            Color color2 = viewData.getJoinColor();
            for (n7 = 0; n7 < viewDataElementArray.length; ++n7) {
                if (!viewDataElementArray[n7].isValid()) {
                    bl = false;
                    continue;
                }
                n6 = viewDataElementArray[n7].getPos() + n4;
                int n11 = viewDataElementArray[n7].getHeight();
                if (viewData.isFill()) {
                    int n12 = 0;
                    n12 = bl ? (n6 - n8) / 2 : 0;
                    int n13 = n7 + 1;
                    if (n13 >= viewDataElementArray.length) {
                        n13 = n7;
                    }
                    int n14 = (int)Math.ceil((double)(viewDataElementArray[n13].getPos() + n4 - n6) / 2.0);
                    n5 = n12 + n14;
                    graphics.setColor(color);
                    graphics.fillRect(n6 - n12, n10 - n11, n5, n11);
                }
                if (viewData.isJoin() && bl) {
                    graphics.setColor(color2);
                    graphics.drawLine(n8, n9, n6, n10 - n11);
                    graphics.drawLine(n8, n9 - 1, n6, n10 - n11 - 1);
                }
                n8 = n6;
                n9 = n10 - n11;
                bl = true;
            }
            if (viewData.isPlot()) {
                n7 = viewData.getPlotRadius();
                n6 = n7 * 2;
                Color color3 = viewData.getPlotColor();
                Color color4 = color3.darker();
                Color color5 = Color.ORANGE;
                Color color6 = color5.darker();
                for (n5 = 0; n5 < viewDataElementArray.length; ++n5) {
                    int n15 = viewDataElementArray[n5].getPos() + n4;
                    int n16 = viewDataElementArray[n5].getHeight();
                    if (!viewDataElementArray[n5].isValid()) {
                        graphics.setColor(color5);
                        graphics.fillOval(n15 - n7, n3 - n7, n6, n6);
                        graphics.setColor(color6);
                        graphics.drawOval(n15 - n7, n3 - n7, n6, n6);
                        continue;
                    }
                    graphics.setColor(color3);
                    graphics.fillOval(n15 - n7, n10 - n16 - n7, n6, n6);
                    graphics.setColor(color4);
                    graphics.drawOval(n15 - n7, n10 - n16 - n7, n6, n6);
                }
            }
            if (!viewData.isLevel()) continue;
            if (viewDataElementArray.length == 0) break;
            n7 = viewDataElementArray[viewDataElementArray.length - 1].getHeight();
            graphics.setColor(viewData.getLevelColor());
            graphics.drawLine(n4, n3 - n7, n4 + this.grid_width - n2, n3 - n7);
            graphics.drawLine(n4, n3 - n7 - 1, n4 + this.grid_width - n2, n3 - n7 - 1);
        }
    }

    private void draw_nodata(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics.drawString("No data model.", 0, n);
    }

    private void recalc() {
    }

    private void draw_decoration(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getHeight();
        int n3 = this.getUnitY();
        int n4 = this.getUnitX();
        Rectangle rectangle = this.getBounds();
        int n5 = fontMetrics.getAscent();
        int n6 = 0;
        int n7 = this.getOffsetX();
        graphics.setColor(this.getLabelColor());
        Object object = this.getTitle();
        Object object2 = fontMetrics.getStringBounds((String)object, graphics);
        Rectangle2D rectangle2D = ((RectangularShape)object2).getBounds();
        int n8 = rectangle.width / 2 - ((Rectangle)rectangle2D).width / 2;
        int n9 = n5;
        graphics.drawString((String)object, n8, n9);
        graphics.setColor(this.getLabelColor());
        object = (Graphics2D)graphics.create();
        ((Graphics)object).setColor(this.getLabelColor());
        object2 = this.getAxisLabelY();
        rectangle2D = fontMetrics.getStringBounds((String)object2, graphics);
        Rectangle rectangle2 = rectangle2D.getBounds();
        n9 = 0 + n5;
        int n10 = (rectangle.height - n2 - n2 - n2 - n2) / 2 + rectangle2.width / 2;
        ((Graphics2D)object).translate(n9, n10);
        ((Graphics2D)object).rotate(-1.5707963267948966);
        ((Graphics2D)object).drawString((String)object2, 0.0f, 0.0f);
        graphics.setColor(this.getLabelColor());
        int n11 = 0 + n2;
        int n12 = 0;
        rectangle2D = this.getUnitLabelY();
        if (rectangle2D == null) {
            rectangle2D = new String[]{"0"};
        }
        for (n = n2 + this.grid_height; n >= 0 + n2; n -= n3) {
            Object object3 = rectangle2D[n12];
            if (object3 == null) {
                object3 = "";
            }
            Rectangle2D rectangle2D2 = fontMetrics.getStringBounds((String)object3, graphics);
            Rectangle rectangle3 = rectangle2D2.getBounds();
            graphics.clearRect(n11, n - n2, rectangle3.width, n2);
            graphics.drawString((String)object3, n11 + (this.y_label_width_max - rectangle3.width), n - n6);
            if (++n12 >= ((Rectangle2D)rectangle2D).length) break;
        }
        graphics.setColor(this.getLabelColor());
        n11 = 0 + n2 + this.grid_height;
        n12 = 0;
        rectangle2D = this.getUnitLabelX();
        if (rectangle2D == null) {
            rectangle2D = new String[]{"0"};
        }
        for (n = 0 + this.y_label_width_max + n2 + n7; n <= this.grid_width + this.y_label_width_max + n2; n += n4) {
            Object object4 = rectangle2D[n12];
            if (object4 == null) {
                object4 = "";
            }
            String[] stringArray = ((String)object4).split("\n", 2);
            for (int i = 0; i < stringArray.length; ++i) {
                Rectangle2D rectangle2D3 = fontMetrics.getStringBounds(stringArray[i], graphics);
                Rectangle rectangle4 = rectangle2D3.getBounds();
                int n13 = n - rectangle4.width / 2;
                graphics.drawString(stringArray[i], n13, n11 + n5 + n2 * i);
            }
            if (++n12 >= ((Rectangle2D)rectangle2D).length) break;
        }
        graphics.setColor(this.getGridColor());
        for (n11 = 0 + this.y_label_width_max + n2 + n7; n11 <= this.grid_width + this.y_label_width_max + n2 + n7; n11 += n4) {
            graphics.drawLine(n11, 0 + n2, n11, n2 + this.grid_height);
        }
        for (n11 = n2 + this.grid_height; n11 >= 0 + n2; n11 -= n3) {
            graphics.drawLine(0 + this.y_label_width_max + n2, n11, this.y_label_width_max + this.grid_width + n2, n11);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentResized(ComponentEvent componentEvent) {
        if (this.model == null) {
            return;
        }
        GraphMonitorModel graphMonitorModel = this.model;
        synchronized (graphMonitorModel) {
            this.recalc();
            this.createDecoration();
            this.recalc();
            this.createViewData();
        }
    }

    protected String[] createYLabels(int n, long l, long l2, long l3) {
        String[] stringArray = new String[n + 1];
        long l4 = (l2 - l) / l3 / (long)n;
        if (l4 == 0L) {
            l4 = 1L;
        }
        for (int i = 0; i < n + 1; ++i) {
            stringArray[i] = Long.toString(l + l4 * (long)i);
        }
        return stringArray;
    }

    protected String[] createXLabels(int n, long l, long l2) {
        String[] stringArray = new String[n + 1];
        long l3 = l2 / (long)n;
        Date date = new Date(l);
        for (int i = 0; i < n + 1; ++i) {
            long l4 = l + l3 * (long)i;
            date.setTime(l4);
            stringArray[i] = this.dateFormat.format(date);
            stringArray[i] = stringArray[i].replace(' ', '\n');
        }
        return stringArray;
    }

    private int calc_division(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = n2 * nArray[i];
            if (n3 >= n) continue;
            return nArray[i];
        }
        return nArray[nArray.length - 1];
    }

    private void createDecoration() {
        this.y_label_width_max = 0;
        Rectangle rectangle = this.getBounds();
        Font font = this.getFont();
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = rectangle.height - n - n - n - n;
        int n3 = this.calc_division(Y_DIVISION, n2, 16);
        long l = this.model.getTopValue() / this.model.getPrefixFactor();
        if (l < (long)n3) {
            n3 = (int)l;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this.grid_height = n2 / n3 * n3;
        String[] stringArray = this.createYLabels(n3, 0L, this.model.getTopValue(), this.model.getPrefixFactor());
        this.setMaxValue(Long.parseLong(stringArray[stringArray.length - 1]) * this.model.getPrefixFactor());
        this.setUnitLabelY(stringArray);
        String[] stringArray2 = this.getUnitLabelY();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds("0000", graphics);
        Rectangle rectangle2 = rectangle2D.getBounds();
        this.y_label_width_max = rectangle2.width;
        rectangle2D = fontMetrics.getStringBounds("0000/00/00", graphics);
        rectangle2 = rectangle2D.getBounds();
        this.x_label_width_max = rectangle2.width;
        int n4 = rectangle.width - this.y_label_width_max - n - this.x_label_width_max / 2;
        int n5 = this.calc_division(X_DIVISION, n4, this.x_label_width_max + 10);
        this.grid_width = n4 / n5 * n5;
        int n6 = this.getGrid_width() / n5;
        int n7 = this.getGrid_height() / n3;
        this.setUnitX(n6);
        this.setUnitY(n7);
        String[] stringArray3 = this.createXLabels(n5, this.model.getBegin(), this.model.getTerm());
        this.setUnitLabelX(stringArray3);
    }

    public void setStylePlot(boolean bl) {
        this.stylePlot = bl;
    }

    public void setStyleJoin(boolean bl) {
        this.styleJoin = bl;
    }

    public void setStyleFill(boolean bl) {
        this.styleFill = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createViewData() {
        if (this.model == null) {
            return;
        }
        GraphMonitorModel graphMonitorModel = this.model;
        synchronized (graphMonitorModel) {
            ArrayList<ViewData> arrayList = new ArrayList<ViewData>();
            ArrayList arrayList2 = this.model.getRawDataSeries();
            long l = this.model.getBegin();
            long l2 = this.model.getTerm();
            for (int i = 0; i < arrayList2.size(); ++i) {
                RawData rawData = (RawData)arrayList2.get(i);
                if (!rawData.isValid()) continue;
                ViewDataElement[] viewDataElementArray = this.renderRawData(rawData, l, l2);
                ViewData viewData = new ViewData();
                viewData.setData(viewDataElementArray);
                viewData.setValid(true);
                viewData.setPlot(this.stylePlot);
                viewData.setJoin(this.styleJoin);
                viewData.setFill(this.styleFill);
                viewData.setPlotColor(rawData.getPlotColor());
                viewData.setFillColor(rawData.getBarColor());
                viewData.setJoinColor(rawData.getLineColor());
                viewData.setLevelColor(rawData.getLevelColor());
                arrayList.add(viewData);
            }
            this.setViewdata(arrayList);
        }
    }

    private ViewDataElement[] renderRawData(RawData rawData, long l, long l2) {
        ArrayList<ViewDataElement> arrayList = new ArrayList<ViewDataElement>();
        RawDataElement[] rawDataElementArray = rawData.getData();
        int n = this.search_first_valid_element(rawDataElementArray);
        int n2 = this.search_last_valid_element(rawDataElementArray);
        if (n < 0 || n2 < 0 || l2 <= 0L || this.maxValue <= 0L) {
            return null;
        }
        long l3 = rawDataElementArray[n].getTime();
        long l4 = rawDataElementArray[n2].getTime();
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            RawDataElement rawDataElement = rawDataElementArray[i];
            long l5 = rawDataElement.getTime() - l3;
            long l6 = rawDataElement.getValue();
            int n3 = (int)(l5 * (long)this.grid_width / l2);
            int n4 = (int)(l6 * (long)this.grid_height / this.maxValue);
            ViewDataElement viewDataElement = new ViewDataElement();
            viewDataElement.setPos(n3);
            viewDataElement.setHeight(n4);
            if (rawDataElement.isValid()) {
                viewDataElement.setValid(true);
            } else {
                viewDataElement.setValid(false);
            }
            arrayList.add(viewDataElement);
        }
        ViewDataElement[] viewDataElementArray = new ViewDataElement[arrayList.size()];
        viewDataElementArray = arrayList.toArray(viewDataElementArray);
        return viewDataElementArray;
    }

    private int search_last_valid_element(RawDataElement[] rawDataElementArray) {
        int n = -1;
        for (int i = rawDataElementArray.length - 1; i >= 0; --i) {
            if (!rawDataElementArray[i].isValid()) continue;
            n = i;
            break;
        }
        return n;
    }

    private int search_first_valid_element(RawDataElement[] rawDataElementArray) {
        int n = -1;
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            if (!rawDataElementArray[i].isValid()) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getAxisLabelX() {
        return this.axisLabelX;
    }

    public String getAxisLabelY() {
        return this.axisLabelY;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public int getGrid_height() {
        return this.grid_height;
    }

    public int getGrid_width() {
        return this.grid_width;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getUnitLabelX() {
        return this.unitLabelX;
    }

    public String[] getUnitLabelY() {
        return this.unitLabelY;
    }

    public int getUnitX() {
        return this.unitX;
    }

    public int getUnitY() {
        return this.unitY;
    }

    public ArrayList getViewdata() {
        return this.viewdata;
    }

    public int getY_label_width_max() {
        return this.y_label_width_max;
    }

    public void setAxisLabelX(String string) {
        this.axisLabelX = string;
    }

    public void setAxisLabelY(String string) {
        this.axisLabelY = string;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public void setGrid_height(int n) {
        this.grid_height = n;
    }

    public void setGrid_width(int n) {
        this.grid_width = n;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setMaxValue(long l) {
        this.maxValue = l;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUnitLabelX(String[] stringArray) {
        this.unitLabelX = stringArray;
    }

    public void setUnitLabelY(String[] stringArray) {
        this.unitLabelY = stringArray;
    }

    public void setUnitX(int n) {
        this.unitX = n;
    }

    public void setUnitY(int n) {
        this.unitY = n;
    }

    public void setViewdata(ArrayList arrayList) {
        this.viewdata = arrayList;
    }

    public void setY_label_width_max(int n) {
        this.y_label_width_max = n;
    }

    public GraphMonitorModel getModel() {
        return this.model;
    }

    public void setModel(GraphMonitorModel graphMonitorModel) {
        this.model = graphMonitorModel;
        if (graphMonitorModel != null) {
            this.setMaxValue(graphMonitorModel.getTopValue());
            this.createDecoration();
            this.createViewData();
        }
    }

    public boolean isStyleFill() {
        return this.styleFill;
    }

    public boolean isStyleJoin() {
        return this.styleJoin;
    }

    public boolean isStylePlot() {
        return this.stylePlot;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(String string) {
        this.valueUnit = string;
    }
}

