/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.tools;

import gmonitor.logdata.FirstMetaBlock;
import gmonitor.logdata.SecondMetaBlock;
import gmonitor.logdata.UTY;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DumpLogFile {
    protected boolean swFMBOutput = true;
    protected boolean swSMBOutput = true;
    protected boolean swDBOoutput = true;
    protected String filename = "glogger.bin";

    public DumpLogFile() {
    }

    public DumpLogFile(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) continue;
            this.filename = stringArray[i];
        }
    }

    public void run() {
        try {
            File file = new File(this.filename);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[2];
            fileInputStream.read(byArray);
            int n = UTY.byte2int(byArray);
            FirstMetaBlock firstMetaBlock = FirstMetaBlock.newInstance(fileInputStream, n);
            byArray = new byte[4];
            fileInputStream.read(byArray);
            n = UTY.byte2int(byArray);
            SecondMetaBlock secondMetaBlock = SecondMetaBlock.newInstance(fileInputStream, n);
            if (this.swFMBOutput) {
                System.out.println(firstMetaBlock.asDump());
            }
            if (this.swSMBOutput) {
                System.out.println(secondMetaBlock.asDump());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        DumpLogFile dumpLogFile = new DumpLogFile(stringArray);
        dumpLogFile.run();
    }
}

