# ![RealWorld Example Applications](media/realworld.png)

### Stay on the bleeding edge — [join our Gitter room!](https://gitter.im/realworld-dev/main) 🎉

[![Travis](https://img.shields.io/travis/gothinkster/realworld.svg)](https://travis-ci.org/gothinkster/realworld) [![Gitter](https://img.shields.io/gitter/room/realworld-dev/main.svg)](https://gitter.im/realworld-dev/main) [![Twitter](https://img.shields.io/twitter/follow/gothinkster.svg?style=social&label=Follow)](https://twitter.com/gothinkster)

<p align="center">
<img src="media/stacks_hr.gif"  />
</p>

<a href="https://demo.realworld.io/"><img src="media/conduit_l.png" align="right" width="250px" /></a>

### See how *the exact same* Medium.com clone (called [Conduit](https://demo.realworld.io)) is built using any of our supported [frontends](#frontends) and  [backends](#backends). Yes, you can mix and match them, because **they all adhere to the same [API spec](spec/)** 😮😎

While most "todo" demos provide an excellent cursory glance at a framework's capabilities, they typically don't convey the knowledge & perspective required to actually build _real_ applications with it.

RealWorld solves this by allowing you to choose any frontend (React, Angular 2, & more) and any backend (Node, Django, & more) and see how they power a real world, beautifully designed fullstack app called "[Conduit](https://demo.realworld.io)".

*Read the [full blog post announcing RealWorld on Medium.](https://medium.com/@ericsimons/introducing-realworld-6016654d36b5)*


# Frontends
>_Sorted by popularity every 24 hours._

| 🥇 | 🥈 | 🥉 |
| :---:         |     :---:      |          :---: |
| [**React / Redux**<br />![React / Redux](https://raw.githubusercontent.com/gothinkster/react-redux-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/react-redux-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/react-redux-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/react-redux-realworld-example-app)| [**Elm**<br />![Elm](https://cloud.githubusercontent.com/assets/556934/25448178/3e7dc5c0-2a7d-11e7-8069-06da5169dae6.png) ![Star](https://img.shields.io/github/stars/rtfeldman/elm-spa-example.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/rtfeldman/elm-spa-example.svg?style=social&label=Fork)](https://github.com/rtfeldman/elm-spa-example)| [**Angular 5+**<br />![Angular 5+](https://raw.githubusercontent.com/gothinkster/angular2-realworld-example-app/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/angular-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/angular-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/angular-realworld-example-app) |
| [**React / MobX**<br />![React / MobX](https://raw.githubusercontent.com/gothinkster/react-mobx-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/react-mobx-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/react-mobx-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/react-mobx-realworld-example-app)| [**Angular 1.5+**<br />![Angular 1.5+](https://raw.githubusercontent.com/gothinkster/angularjs-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/angularjs-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/angularjs-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/angularjs-realworld-example-app)| [**ClojureScript + Keechma**<br />![ClojureScript + Keechma](https://raw.githubusercontent.com/gothinkster/clojurescript-keechma-realworld-example-app/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/clojurescript-keechma-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/clojurescript-keechma-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/clojurescript-keechma-realworld-example-app) |
| [**Svelte / Sapper**<br />![Svelte / Sapper](https://github.com/sveltejs/realworld/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/sveltejs/realworld.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/sveltejs/realworld.svg?style=social&label=Fork)](https://github.com/sveltejs/realworld) | [**ClojureScript + re-frame**<br />![ClojureScript + re-frame](https://cloud.githubusercontent.com/assets/556934/25448267/85369fdc-2a7d-11e7-9613-ab5ce5e1800f.png) ![Star](https://img.shields.io/github/stars/gothinkster/clojurescript-reframe-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/clojurescript-reframe-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/clojurescript-reframe-realworld-example-app) | [**AppRun**<br />![AppRun](https://github.com/gothinkster/apprun-realworld-example-app/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/apprun-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/apprun-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/apprun-realworld-example-app) |
| [**Crizmas MVC**<br />![Crizmas MVC](https://raw.githubusercontent.com/gothinkster/crizmas-mvc-realworld-example-app/master/crizmas.png) ![Star](https://img.shields.io/github/stars/gothinkster/crizmas-mvc-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/crizmas-mvc-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/crizmas-mvc-realworld-example-app) | |

Work In Progress: **[Ember](https://github.com/gothinkster/realworld/issues/22) | [Vue](https://github.com/gothinkster/realworld/issues/7) | [React+Relay](https://github.com/gothinkster/realworld/issues/48) | [Svelte](https://github.com/gothinkster/realworld/issues/19) | [Aurelia](https://github.com/gothinkster/realworld/issues/27) | [ClojureScript](https://github.com/gothinkster/realworld/issues/61) | [Mithril](https://github.com/gothinkster/realworld/issues/69) | [Vanilla JS (Web Components)](https://github.com/gothinkster/realworld/issues/111)**

# Backends
>_Sorted by popularity every 24 hours._

| 🥇 | 🥈 | 🥉 |
| :---:         |     :---:      |          :---: |
| [**Node / Express**<br />![Node / Express](https://raw.githubusercontent.com/gothinkster/node-express-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/node-express-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/node-express-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/node-express-realworld-example-app)| [**Laravel**<br />![Laravel](https://github.com/gothinkster/laravel-realworld-example-app/blob/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/laravel-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/laravel-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/laravel-realworld-example-app)| [**Django**<br />![Django](https://raw.githubusercontent.com/gothinkster/django-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/django-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/django-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/django-realworld-example-app) |
| [**ASP.NET Core**<br />![ASP.NET Core](https://raw.githubusercontent.com/gothinkster/aspnetcore-realworld-example-app/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/aspnetcore-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/aspnetcore-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/aspnetcore-realworld-example-app)| [**Elixir + Phoenix**<br />![Elixir + Phoenix](https://github.com/gothinkster/elixir-phoenix-realworld-example-app/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/elixir-phoenix-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/elixir-phoenix-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/elixir-phoenix-realworld-example-app) | [**Rails**<br />![Rails](https://raw.githubusercontent.com/gothinkster/rails-realworld-example-app/master/project-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/rails-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/rails-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/rails-realworld-example-app) |
| [**Kotlin / Spring**<br />![Kotlin / Spring](https://raw.githubusercontent.com/gothinkster/kotlin-spring-realworld-example-app/master/kotlin-spring.png) ![Star](https://img.shields.io/github/stars/gothinkster/kotlin-spring-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/kotlin-spring-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/kotlin-spring-realworld-example-app) | [**Flask**<br />![Flask](https://raw.githubusercontent.com/gothinkster/flask-realworld-example-app/master/image.png) ![Star](https://img.shields.io/github/stars/gothinkster/flask-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/flask-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/flask-realworld-example-app) | [**Slim**<br />![Slim](https://github.com/gothinkster/slim-php-realworld-example-app/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/slim-php-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/slim-php-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/slim-php-realworld-example-app) |
| [**Spring**<br />![Spring](https://github.com/gothinkster/spring-boot-realworld-example-app/raw/master/example-logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/spring-boot-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/spring-boot-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/spring-boot-realworld-example-app) | [**CakePHP**<br />![CakePHP](https://github.com/gothinkster/cakephp-realworld-example-app/raw/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/cakephp-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/cakephp-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/cakephp-realworld-example-app) | [**Koa / Knex**<br />![Koa / Knex](https://github.com/gothinkster/koa-knex-realworld-example/raw/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/koa-knex-realworld-example.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/koa-knex-realworld-example.svg?style=social&label=Fork)](https://github.com/gothinkster/koa-knex-realworld-example)|
| [**Golang + Gin**<br />![Golang + Gin](https://github.com/gothinkster/golang-gin-realworld-example-app/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/golang-gin-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/golang-gin-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/golang-gin-realworld-example-app) | [**Rust**<br />![Rust](https://github.com/gothinkster/rust-realworld-example-app/raw/master/logo.png) ![Star](https://img.shields.io/github/stars/gothinkster/rust-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/rust-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/rust-realworld-example-app) | [**GCP Cloud Functions + Datastore**<br />![Serverless GCP Cloud Functions + Datastore](https://github.com/gothinkster/gcp-datastore-cloud-functions-realworld-example-app/raw/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/gcp-datastore-cloud-functions-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/gcp-datastore-cloud-functions-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/gcp-datastore-cloud-functions-realworld-example-app) |
| [**Hapi.js**<br />![Hapi.js](https://github.com/gothinkster/hapijs-realworld-example-app/blob/master/.github/project-logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/hapijs-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/hapijs-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/hapijs-realworld-example-app) | [**QEWD.js**<br />![QEWD.js](https://cloud.githubusercontent.com/assets/556934/25587724/182f95fc-2e5a-11e7-83db-1541c1bee128.png) ![Star](https://img.shields.io/github/stars/gothinkster/QEWD-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/QEWD-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/QEWD-realworld-example-app) | [**Moleculer**<br />![Moleculer](https://github.com/gothinkster/moleculer-node-realworld-example-app/blob/master/rw-logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/moleculer-node-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/moleculer-node-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/moleculer-node-realworld-example-app) |
| [**F#**<br />![F#](https://github.com/gothinkster/fsharp-realworld-example-app/blob/master/logo.png?raw=true) ![Star](https://img.shields.io/github/stars/gothinkster/fsharp-realworld-example-app.svg?style=social&label=Star) ![Fork](https://img.shields.io/github/forks/gothinkster/fsharp-realworld-example-app.svg?style=social&label=Fork)](https://github.com/gothinkster/fsharp-realworld-example-app) | | |



Work In Progress: **[Clojure](https://github.com/gothinkster/realworld/issues/57) | [Crystal + Kemal](https://github.com/gothinkster/realworld/issues/112) | [Dotnet Core (C#)](https://github.com/gothinkster/realworld/issues/31) | [Dropwizard](https://github.com/gothinkster/realworld/issues/95) | [Elixir + Phoenix](https://github.com/gothinkster/realworld/issues/17) | [F#](https://github.com/gothinkster/realworld/issues/58) | [Falcon + GAE](https://github.com/gothinkster/realworld/issues/59) | [Firebase + GCP Cloud](https://github.com/gothinkster/realworld/issues/21) | [Go + Gin](https://github.com/gothinkster/realworld/issues/9) | [Go + Gorilla mux](https://github.com/gothinkster/realworld/issues/99) | [Go + net/http](https://github.com/gothinkster/realworld/issues/45) | [HapiJS](https://github.com/gothinkster/realworld/issues/40) | [Haskell / Servant](https://github.com/gothinkster/realworld/issues/73) | [Loopback 3.0](https://github.com/gothinkster/realworld/issues/105) | [Nim](https://github.com/gothinkster/realworld/issues/60) | [Node + GraphQL](https://github.com/gothinkster/realworld/issues/46) | [Node (Lambda + DynamoDB)](https://github.com/gothinkster/realworld/issues/37) | [Node + Moleculer](https://github.com/gothinkster/realworld/issues/146) | [Phalcon](https://github.com/gothinkster/realworld/issues/88) | [Scala + Play](https://github.com/gothinkster/realworld/issues/63) | [Slim](https://github.com/gothinkster/realworld/issues/50) | [Spring (w/ Spring Boot)](https://github.com/gothinkster/realworld/issues/55) | [Symfony](https://github.com/gothinkster/realworld/issues/66)**


# Mobile

Work In Progress: **[React Native](https://github.com/gothinkster/realworld/issues/10) | [Ionic 2+](https://github.com/gothinkster/realworld/issues/16) | [Xamarin](https://github.com/gothinkster/realworld/issues/70)**

# Fullstack

_Since these implementations are reponsible for the entire stack, they obviously cannot be mixed and matched but they still adhere to the same functionality & UX specs._

Work In Progress: **[Meteor]() | [Ruby Hyperloop]() | [Firebase]()**

# Create a new stack

[![Create a new stack](media/upcoming_stacks.png)](/spec)

### Know any of these frameworks (or one that isn't listed)?<br />[**Create a new framework implementation >>>**](/spec)

Or you can [view upcoming stacks (WIPs)](https://github.com/gothinkster/realworld/issues?q=is%3Aopen+is%3Aissue+label%3Awip)

Note: All stacks that are a WIP are experimental and incomplete.

Don't expect everything to work perfectly out of the box!

<br />

# How do I get up & running?

Simply follow the instructions in the README of whatever frontend and/or backend repo's you want to get up and running.

### Can you teach me how to build each stack from scratch?

Yup! We've built step-by-step tutorials for all of our stacks that teach you how to go from `git init` all the way to the production ready application. [**Start learning now >>>**](https://thinkster.io/tutorials/fullstack)

<br />

# Community created resources

Forks, tutorials, workshops, and other resources based on the RealWorld project:

- [**React+Redux / Node testing workshop**](https://github.com/kentcdodds/testing-workshop) by [**Kent C. Dodds**](https://github.com/kentcdodds)
  - Example repo showing the React+Redux and Node stacks working together w/ TDD
  - Live recording of his workshop is [**available on YouTube**](https://www.youtube.com/watch?v=DdqiXcYDv-8)
- [**A Real-World Comparison of Front-End Frameworks with Benchmarks**](https://medium.freecodecamp.org/a-real-world-comparison-of-front-end-frameworks-with-benchmarks-e1cb62fd526c) by [**Jacek Schae**](https://medium.freecodecamp.org/@jacekschae)
  - Medium post comparing performance of various [RealWorld](https://realworld.io/) frontends
- [**RealWorld React/NodeJS E2E Tests**](https://github.com/anishkny/realworld-e2e-test) by [**Anish Karandikar**](https://github.com/anishkny)
  - A repo showing how to wire [React](https://github.com/gothinkster/react-redux-realworld-example-app) frontend with [NodeJS](https://github.com/gothinkster/node-express-realworld-example-app) backend for a RealWorld fullstack
  - Includes E2E integration tests that use [Chrome Puppeteer](https://github.com/GoogleChrome/puppeteer) and [Mocha](https://mochajs.org) and work with CI systems like [Travis CI](https://travis-ci.org/anishkny/realworld-e2e-test) and [CircleCI](https://circleci.com/gh/anishkny/realworld-e2e-test)
  - Also demonstrates usage of [Greenkeeper](https://greenkeeper.io) for automatic dependency updates and [Snyk](https://snyk.io/) for vulnerability monitoring

<br />

# Learn more

- ["Introducing RealWorld 🙌"](https://medium.com/@ericsimons/introducing-realworld-6016654d36b5) by Eric Simons
- Every tutorial is built against the same [API spec](api/) to ensure modularity of every frontend & backend
- Every frontend utilizes the same hand crafted [Bootstrap 4 theme](https://github.com/gothinkster/conduit-bootstrap-template) for identical UI/UX
- There is a hosted version of the backend API available for public usage, no API keys required
- Interested in creating a new RealWorld stack? View our [starter guide & spec](/spec)

<br />


# Who made this?

RealWorld would not be possible without the [open source community](#special-thanks-to) continuously helping push the project forward. In addition, we have a core project team composed of:

#### [Eric Simons](https://twitter.com/ericsimons40) - Founder/Lead

<img align="left" width="40" height="40" src="https://avatars1.githubusercontent.com/u/556934?v=3&s=100">

Eric is a Software Engineer, UI Designer, and author of many technical books & tutorials. He oversees the project direction, maintenance and organizes the planning and development efforts of the team.


#### [Albert Pai](https://twitter.com/iamalbertpai) - Founder/Lead

<img align="left" width="40" height="40" src="https://avatars0.githubusercontent.com/u/1776432?v=3&s=100">

Albert is a Software Engineer, DevOps ninja, and author of many technical books & tutorials. He oversees the project direction, maintenance and organizes the planning and development efforts of the team.

#### [Thinkster](https://twitter.com/gothinkster) - Funding/Support

<img align="left" width="40" height="40" src="https://avatars0.githubusercontent.com/u/8601733?v=3&s=100">

[Thinkster](https://thinkster.io) creates high quality resources that help Javascript developers succeed. The RealWorld project wouldn't exist without their funding, so please consider investing in [a Pro subscription](https://thinkster.io/pro) to help support us!


#### [James Brewer](https://twitter.com/brwr_) - Admin

<img align="left" width="40" height="40" src="https://avatars1.githubusercontent.com/u/4095660?v=3&s=100">

James is a Software Engineer at Square and a contributor to the Django project. He created & maintains the RW Django codebase and continually provides guidance for the RealWorld project itself.

#### [Anish Karandikar](https://github.com/anishkny) - Admin

<img align="left" width="40" height="40" src="https://avatars1.githubusercontent.com/u/357499?v=3&s=100">

MathWorker, ex-Google, ex-Computational Fluid Dynamicist, forever lover of tech & humanities ❤️


#### [Sandeesh S.](https://github.com/SandeeshS) - Admin

<img align="left" width="40" height="40" src="https://avatars1.githubusercontent.com/u/16877877?v=3&s=100">

Full stack developer, Laravel enthusiast, Digital marketing specialist and an avid gamer.


#### [Cameron Chapman](https://github.com/Cameron-C-Chapman) - Admin

<img align="left" width="40" height="40" src="https://avatars1.githubusercontent.com/u/1323581?v=3&s=100">

Cameron Chapman is a Software Engineer at FanThreeSixty. He's an open source enthusiast and is helping to teach a local web development boot camp at Kansas University.



## Special thanks to...

RealWorld wouldn't be possible without the help of the open source community reviewing codebases, creating new app implementations, and many other tasks that help push this project forward. We especially appreciate the OSS leaders who have helped contribute to RealWorld:

- **Dan Abramov** (creator of Redux) for  helping [spark the initial idea](https://twitter.com/dan_abramov/status/692009757775896577), [getting the Redux community involved](https://github.com/reactjs/redux/issues/1353), as well as graciously taking the time to provide feedback on the Redux codebase
- **Max Lynch** (creator of Ionic) for taking the time to provide guidance in the early days of this project
- **Addy Osmani** (creator of TodoMVC) for helping [spark the initial idea](https://twitter.com/addyosmani/status/762828483433144320) and his amazing work with TodoMVC
- **TodoMVC** ([team & contributors](https://github.com/tastejs/todomvc#team)) for their exemplary & successful work; their project & org has been an invaluable analogy for us as we've built out RealWorld
- **James Brewer** (docs contributor to Django) for countless brainstorming sessions, helping name this project, and creating the Django codebase + tutorial




# License
All of the codebases are **MIT licensed** unless otherwise specified.

<br />

[![Brought to you by Thinkster](media/end.png)](https://thinkster.io)
