You can contribute to Golf by 
* testing of features and bug fixes,
* suggesting bug fixes and enhancements both for code and documentation (or new blog topics) via [email](mailto:team@golf-lang.com). Please do not use issues page on github, gitlab, sourceforge or others, as that makes it difficult for us to keep track of in different places. You can also contact us via the contact form at [Golf blog](https://golf-lang.blogspot.com/).
* giving credit by including Golf home page link (golf-lang.com) and its logo in your web pages,
* spreading the word on blogs, forums and social media.

Golf, like Lua, SQLite and others, is a free open source project that does not accept external code patches \- only the core team can make changes to the project. The reason for this approach comes from core team's previous experiences, with some of the factors being:
* long\-term maintenance of external code patches (be it features or bugs) can be a burden, 
* often times more time and energy is spent to review pull requests that to do it ourselves (less overhead), 
* better and tighter design and quality control, 
* consistent vision of project direction, 
* licensing issues especially with code that appears to be AI generated or copied from sources that are licensed differently, 
* making it harder in the future to change the license without the unpopular CLAs which are lots of work for us too. There are no plans to change the license but no one can say for sure it won't happen either. For instance, recently Golf license changed from EPL to Apache, arguably a more permissive FOSS license \- that might have been difficult otherwise.
* legal issues with whether the code comes from a source that may or may not have the right to contribute, 
* duplicate work from lack of communication, 
* lack of consensus and resulting frictions.

Of course much can be said in support of the opposite approach for each of these points, we do get that! The decision to take this approach is not made lightly, and we believe is in the interest of keeping Golf software and the experience of user community the best possible.


