/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Criteria for showing/hiding rows in a pivot table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotFilterCriteria extends com.google.api.client.json.GenericJson {

  /**
   * A condition that must be true for values to be shown. (`visibleValues` does not override this
   * -- even if a value is listed there, it is still hidden if it does not meet the condition.)
   * Condition values that refer to ranges in A1-notation are evaluated relative to the pivot table
   * sheet. References are treated absolutely, so are not filled down the pivot table. For example,
   * a condition value of `=A1` on "Pivot Table 1" is treated as `'Pivot Table 1'!$A$1`. The source
   * data of the pivot table can be referenced by column header name. For example, if the source
   * data has columns named "Revenue" and "Cost" and a condition is applied to the "Revenue" column
   * with type `NUMBER_GREATER` and value `=Cost`, then only columns where "Revenue" > "Cost" are
   * included.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BooleanCondition condition;

  /**
   * Whether values are visible by default. If true, the visible_values are ignored, all values that
   * meet condition (if specified) are shown. If false, values that are both in visible_values and
   * meet condition are shown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean visibleByDefault;

  /**
   * Values that should be included. Values not listed here are excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> visibleValues;

  /**
   * A condition that must be true for values to be shown. (`visibleValues` does not override this
   * -- even if a value is listed there, it is still hidden if it does not meet the condition.)
   * Condition values that refer to ranges in A1-notation are evaluated relative to the pivot table
   * sheet. References are treated absolutely, so are not filled down the pivot table. For example,
   * a condition value of `=A1` on "Pivot Table 1" is treated as `'Pivot Table 1'!$A$1`. The source
   * data of the pivot table can be referenced by column header name. For example, if the source
   * data has columns named "Revenue" and "Cost" and a condition is applied to the "Revenue" column
   * with type `NUMBER_GREATER` and value `=Cost`, then only columns where "Revenue" > "Cost" are
   * included.
   * @return value or {@code null} for none
   */
  public BooleanCondition getCondition() {
    return condition;
  }

  /**
   * A condition that must be true for values to be shown. (`visibleValues` does not override this
   * -- even if a value is listed there, it is still hidden if it does not meet the condition.)
   * Condition values that refer to ranges in A1-notation are evaluated relative to the pivot table
   * sheet. References are treated absolutely, so are not filled down the pivot table. For example,
   * a condition value of `=A1` on "Pivot Table 1" is treated as `'Pivot Table 1'!$A$1`. The source
   * data of the pivot table can be referenced by column header name. For example, if the source
   * data has columns named "Revenue" and "Cost" and a condition is applied to the "Revenue" column
   * with type `NUMBER_GREATER` and value `=Cost`, then only columns where "Revenue" > "Cost" are
   * included.
   * @param condition condition or {@code null} for none
   */
  public PivotFilterCriteria setCondition(BooleanCondition condition) {
    this.condition = condition;
    return this;
  }

  /**
   * Whether values are visible by default. If true, the visible_values are ignored, all values that
   * meet condition (if specified) are shown. If false, values that are both in visible_values and
   * meet condition are shown.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVisibleByDefault() {
    return visibleByDefault;
  }

  /**
   * Whether values are visible by default. If true, the visible_values are ignored, all values that
   * meet condition (if specified) are shown. If false, values that are both in visible_values and
   * meet condition are shown.
   * @param visibleByDefault visibleByDefault or {@code null} for none
   */
  public PivotFilterCriteria setVisibleByDefault(java.lang.Boolean visibleByDefault) {
    this.visibleByDefault = visibleByDefault;
    return this;
  }

  /**
   * Values that should be included. Values not listed here are excluded.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getVisibleValues() {
    return visibleValues;
  }

  /**
   * Values that should be included. Values not listed here are excluded.
   * @param visibleValues visibleValues or {@code null} for none
   */
  public PivotFilterCriteria setVisibleValues(java.util.List<java.lang.String> visibleValues) {
    this.visibleValues = visibleValues;
    return this;
  }

  @Override
  public PivotFilterCriteria set(String fieldName, Object value) {
    return (PivotFilterCriteria) super.set(fieldName, value);
  }

  @Override
  public PivotFilterCriteria clone() {
    return (PivotFilterCriteria) super.clone();
  }

}
