/* 
 * File: xmms2ctrl.h
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GKrellM 2.0.0 or better and XMMS2 DR1 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef _XMMS2CTRL_H
#define _XMMS2CTRL_H

#include <xmmsclient/xmmsclient-glib.h>

enum { ERROR_NONE = 0, ERROR_CONNECTION = 1, ERROR_ADVANCE = 2 };

guint xmms2ctrl_get_error(void);
void  xmms2ctrl_set_error(guint error);
void  xmms2ctrl_play(xmmsc_connection_t *conn);
void  xmms2ctrl_pause(xmmsc_connection_t *conn);
void  xmms2ctrl_next(xmmsc_connection_t *conn);
void  xmms2ctrl_prev(xmmsc_connection_t *conn);
void  xmms2ctrl_stop(xmmsc_connection_t *conn);
void  xmms2ctrl_do_reljump(xmmsc_connection_t *conn, int where);
void  xmms2ctrl_toggle_pause(xmmsc_connection_t *conn, gboolean start_playback);
void  xmms2ctrl_volume_set(xmmsc_connection_t *conn, gint volume);
#endif
