/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import org.dbdoclet.jive.dialog.ExceptionBox;

public class ActionSetLookAndFeel extends AbstractAction {

    private static final long serialVersionUID = 1L;
    private ArrayList<Component> componentList;
    private LookAndFeelInfo info;
    private String lnfClassName;
    
    public ActionSetLookAndFeel(String label, LookAndFeelInfo info, ArrayList<Component> componentList) {
        
        super(label);
        
        if (componentList == null) {
            throw new IllegalArgumentException("The argument frame must not be null!");
        }

        this.componentList = componentList;
        this.info = info;
    }
    
    public ActionSetLookAndFeel(String label, String lnfClassName, ArrayList<Component> componentList) {
        
        super(label);
        
        if (componentList == null) {
            throw new IllegalArgumentException("The argument frame must not be null!");
        }

        this.componentList = componentList;
        this.lnfClassName = lnfClassName;
    }
    
    public void actionPerformed(ActionEvent event) {

        try {
            
            if (info != null) {
                lnfClassName = info.getClassName();
            }

            if (lnfClassName != null) {

                UIManager.setLookAndFeel(lnfClassName);
                
                for (Component component : componentList) {
                	
                	SwingUtilities.updateComponentTreeUI(component);
                	
                	if (component instanceof Window) {
                		((Window) component).pack();
                	}
                }
            }
            
        } catch (Throwable oops) {

            ExceptionBox ebox = new ExceptionBox(oops);
            ebox.setVisible(true);
            ebox.toFront();
            
        }
    }
}
