{- This module was generated from data in the Kate syntax
   highlighting file dockerfile.xml, version 1.1, by James Turnbull (james@lovedthanlost.net) -}

module Text.Highlighting.Kate.Syntax.Dockerfile
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Dockerfile"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "Dockerfile"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Dockerfile","normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Dockerfile","normal") -> return ()
      ("Dockerfile","Comment") -> (popContext) >> pEndLine
      ("Dockerfile","string\"") -> (popContext) >> pEndLine
      ("Dockerfile","string'") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "FROM MAINTAINER ENV RUN ONBUILD COPY ADD VOLUME EXPOSE ENTRYPOINT CMD WORKDIR USER"


parseRules ("Dockerfile","normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Dockerfile","Comment"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Dockerfile","string\""))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Dockerfile","string'"))
   <|>
   (currentContext >>= \x -> guard (x == ("Dockerfile","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Dockerfile","Comment") =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Dockerfile","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Dockerfile","string\"") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Dockerfile","string\"")) >> pDefault >>= withAttribute StringTok))

parseRules ("Dockerfile","string'") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Dockerfile","string'")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("Dockerfile","normal") <|> fail ("Unknown context" ++ show x)
