---
title: Emojis
description: Include emoji shortcodes in your markdown or templates.
categories: [quick reference]
keywords: [emoji]
menu:
  docs:
    parent: quick-reference
    weight: 20
weight: 20
toc: true
---

Configure Hugo to enable emoji processing in markdown:

{{< code-toggle file=hugo >}}
enableEmoji = true
{{< /code-toggle >}}

With emoji processing enabled, this markdown:

```md
Hello! :wave:
```

Is rendered to:

```html
Hello! &#x1f44b;
```

And in your browser... Hello! :wave:

To process an emoji shortcode from within a template, use the [`emojify`] function or pass the string through the [`RenderString`] method on a `Page` object:

```go-html-template
{{ "Hello! :wave:" | .RenderString }}
```

[`emojify`]: /functions/transform/emojify
[`RenderString`]: /methods/page/renderstring

## Introduction

This quick reference guide was automatically generated from [GitHub Emoji API] and [Unicode Full Emoji List]. Specials thanks to [@ikatyang] for making [this list] available to the open-source community.

GitHub [custom emoji] are not supported.

[custom emoji]: #github-custom-emoji
[@ikatyang]: https://github.com/ikatyang
[github emoji api]: https://api.github.com/emojis
[unicode full emoji list]: https://unicode.org/emoji/charts/full-emoji-list.html
[this list]: https://github.com/ikatyang/emoji-cheat-sheet/#readme

## Smileys & Emotion

- [Face Smiling](#face-smiling)
- [Face Affection](#face-affection)
- [Face Tongue](#face-tongue)
- [Face Hand](#face-hand)
- [Face Neutral Skeptical](#face-neutral-skeptical)
- [Face Sleepy](#face-sleepy)
- [Face Unwell](#face-unwell)
- [Face Hat](#face-hat)
- [Face Glasses](#face-glasses)
- [Face Concerned](#face-concerned)
- [Face Negative](#face-negative)
- [Face Costume](#face-costume)
- [Cat Face](#cat-face)
- [Monkey Face](#monkey-face)
- [Heart](#heart)
- [Emotion](#emotion)

### Face Smiling

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :grinning: | `:grinning:` | :smiley: | `:smiley:` | [top](#introduction) |
| [top](#introduction) | :smile: | `:smile:` | :grin: | `:grin:` | [top](#introduction) |
| [top](#introduction) | :laughing: | `:laughing:` `:satisfied:` | :sweat_smile: | `:sweat_smile:` | [top](#introduction) |
| [top](#introduction) | :rofl: | `:rofl:` | :joy: | `:joy:` | [top](#introduction) |
| [top](#introduction) | :slightly_smiling_face: | `:slightly_smiling_face:` | :upside_down_face: | `:upside_down_face:` | [top](#introduction) |
| [top](#introduction) | :wink: | `:wink:` | :blush: | `:blush:` | [top](#introduction) |
| [top](#introduction) | :innocent: | `:innocent:` | | | [top](#introduction) |

### Face Affection

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :smiling_face_with_three_hearts: | `:smiling_face_with_three_hearts:` | :heart_eyes: | `:heart_eyes:` | [top](#introduction) |
| [top](#introduction) | :star_struck: | `:star_struck:` | :kissing_heart: | `:kissing_heart:` | [top](#introduction) |
| [top](#introduction) | :kissing: | `:kissing:` | :relaxed: | `:relaxed:` | [top](#introduction) |
| [top](#introduction) | :kissing_closed_eyes: | `:kissing_closed_eyes:` | :kissing_smiling_eyes: | `:kissing_smiling_eyes:` | [top](#introduction) |
| [top](#introduction) | :smiling_face_with_tear: | `:smiling_face_with_tear:` | | | [top](#introduction) |

### Face Tongue

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :yum: | `:yum:` | :stuck_out_tongue: | `:stuck_out_tongue:` | [top](#introduction) |
| [top](#introduction) | :stuck_out_tongue_winking_eye: | `:stuck_out_tongue_winking_eye:` | :zany_face: | `:zany_face:` | [top](#introduction) |
| [top](#introduction) | :stuck_out_tongue_closed_eyes: | `:stuck_out_tongue_closed_eyes:` | :money_mouth_face: | `:money_mouth_face:` | [top](#introduction) |

### Face Hand

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :hugs: | `:hugs:` | :hand_over_mouth: | `:hand_over_mouth:` | [top](#introduction) |
| [top](#introduction) | :shushing_face: | `:shushing_face:` | :thinking: | `:thinking:` | [top](#introduction) |

### Face Neutral Skeptical

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :zipper_mouth_face: | `:zipper_mouth_face:` | :raised_eyebrow: | `:raised_eyebrow:` | [top](#introduction) |
| [top](#introduction) | :neutral_face: | `:neutral_face:` | :expressionless: | `:expressionless:` | [top](#introduction) |
| [top](#introduction) | :no_mouth: | `:no_mouth:` | :face_in_clouds: | `:face_in_clouds:` | [top](#introduction) |
| [top](#introduction) | :smirk: | `:smirk:` | :unamused: | `:unamused:` | [top](#introduction) |
| [top](#introduction) | :roll_eyes: | `:roll_eyes:` | :grimacing: | `:grimacing:` | [top](#introduction) |
| [top](#introduction) | :face_exhaling: | `:face_exhaling:` | :lying_face: | `:lying_face:` | [top](#introduction) |

### Face Sleepy

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :relieved: | `:relieved:` | :pensive: | `:pensive:` | [top](#introduction) |
| [top](#introduction) | :sleepy: | `:sleepy:` | :drooling_face: | `:drooling_face:` | [top](#introduction) |
| [top](#introduction) | :sleeping: | `:sleeping:` | | | [top](#introduction) |

### Face Unwell

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :mask: | `:mask:` | :face_with_thermometer: | `:face_with_thermometer:` | [top](#introduction) |
| [top](#introduction) | :face_with_head_bandage: | `:face_with_head_bandage:` | :nauseated_face: | `:nauseated_face:` | [top](#introduction) |
| [top](#introduction) | :vomiting_face: | `:vomiting_face:` | :sneezing_face: | `:sneezing_face:` | [top](#introduction) |
| [top](#introduction) | :hot_face: | `:hot_face:` | :cold_face: | `:cold_face:` | [top](#introduction) |
| [top](#introduction) | :woozy_face: | `:woozy_face:` | :dizzy_face: | `:dizzy_face:` | [top](#introduction) |
| [top](#introduction) | :face_with_spiral_eyes: | `:face_with_spiral_eyes:` | :exploding_head: | `:exploding_head:` | [top](#introduction) |

### Face Hat

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :cowboy_hat_face: | `:cowboy_hat_face:` | :partying_face: | `:partying_face:` | [top](#introduction) |
| [top](#introduction) | :disguised_face: | `:disguised_face:` | | | [top](#introduction) |

### Face Glasses

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :sunglasses: | `:sunglasses:` | :nerd_face: | `:nerd_face:` | [top](#introduction) |
| [top](#introduction) | :monocle_face: | `:monocle_face:` | | | [top](#introduction) |

### Face Concerned

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :confused: | `:confused:` | :worried: | `:worried:` | [top](#introduction) |
| [top](#introduction) | :slightly_frowning_face: | `:slightly_frowning_face:` | :frowning_face: | `:frowning_face:` | [top](#introduction) |
| [top](#introduction) | :open_mouth: | `:open_mouth:` | :hushed: | `:hushed:` | [top](#introduction) |
| [top](#introduction) | :astonished: | `:astonished:` | :flushed: | `:flushed:` | [top](#introduction) |
| [top](#introduction) | :pleading_face: | `:pleading_face:` | :frowning: | `:frowning:` | [top](#introduction) |
| [top](#introduction) | :anguished: | `:anguished:` | :fearful: | `:fearful:` | [top](#introduction) |
| [top](#introduction) | :cold_sweat: | `:cold_sweat:` | :disappointed_relieved: | `:disappointed_relieved:` | [top](#introduction) |
| [top](#introduction) | :cry: | `:cry:` | :sob: | `:sob:` | [top](#introduction) |
| [top](#introduction) | :scream: | `:scream:` | :confounded: | `:confounded:` | [top](#introduction) |
| [top](#introduction) | :persevere: | `:persevere:` | :disappointed: | `:disappointed:` | [top](#introduction) |
| [top](#introduction) | :sweat: | `:sweat:` | :weary: | `:weary:` | [top](#introduction) |
| [top](#introduction) | :tired_face: | `:tired_face:` | :yawning_face: | `:yawning_face:` | [top](#introduction) |

### Face Negative

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :triumph: | `:triumph:` | :pout: | `:pout:` `:rage:` | [top](#introduction) |
| [top](#introduction) | :angry: | `:angry:` | :cursing_face: | `:cursing_face:` | [top](#introduction) |
| [top](#introduction) | :smiling_imp: | `:smiling_imp:` | :imp: | `:imp:` | [top](#introduction) |
| [top](#introduction) | :skull: | `:skull:` | :skull_and_crossbones: | `:skull_and_crossbones:` | [top](#introduction) |

### Face Costume

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :hankey: | `:hankey:` `:poop:` `:shit:` | :clown_face: | `:clown_face:` | [top](#introduction) |
| [top](#introduction) | :japanese_ogre: | `:japanese_ogre:` | :japanese_goblin: | `:japanese_goblin:` | [top](#introduction) |
| [top](#introduction) | :ghost: | `:ghost:` | :alien: | `:alien:` | [top](#introduction) |
| [top](#introduction) | :space_invader: | `:space_invader:` | :robot: | `:robot:` | [top](#introduction) |

### Cat Face

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :smiley_cat: | `:smiley_cat:` | :smile_cat: | `:smile_cat:` | [top](#introduction) |
| [top](#introduction) | :joy_cat: | `:joy_cat:` | :heart_eyes_cat: | `:heart_eyes_cat:` | [top](#introduction) |
| [top](#introduction) | :smirk_cat: | `:smirk_cat:` | :kissing_cat: | `:kissing_cat:` | [top](#introduction) |
| [top](#introduction) | :scream_cat: | `:scream_cat:` | :crying_cat_face: | `:crying_cat_face:` | [top](#introduction) |
| [top](#introduction) | :pouting_cat: | `:pouting_cat:` | | | [top](#introduction) |

### Monkey Face

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :see_no_evil: | `:see_no_evil:` | :hear_no_evil: | `:hear_no_evil:` | [top](#introduction) |
| [top](#introduction) | :speak_no_evil: | `:speak_no_evil:` | | | [top](#introduction) |

### Heart

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :love_letter: | `:love_letter:` | :cupid: | `:cupid:` | [top](#introduction) |
| [top](#introduction) | :gift_heart: | `:gift_heart:` | :sparkling_heart: | `:sparkling_heart:` | [top](#introduction) |
| [top](#introduction) | :heartpulse: | `:heartpulse:` | :heartbeat: | `:heartbeat:` | [top](#introduction) |
| [top](#introduction) | :revolving_hearts: | `:revolving_hearts:` | :two_hearts: | `:two_hearts:` | [top](#introduction) |
| [top](#introduction) | :heart_decoration: | `:heart_decoration:` | :heavy_heart_exclamation: | `:heavy_heart_exclamation:` | [top](#introduction) |
| [top](#introduction) | :broken_heart: | `:broken_heart:` | :heart_on_fire: | `:heart_on_fire:` | [top](#introduction) |
| [top](#introduction) | :mending_heart: | `:mending_heart:` | :heart: | `:heart:` | [top](#introduction) |
| [top](#introduction) | :orange_heart: | `:orange_heart:` | :yellow_heart: | `:yellow_heart:` | [top](#introduction) |
| [top](#introduction) | :green_heart: | `:green_heart:` | :blue_heart: | `:blue_heart:` | [top](#introduction) |
| [top](#introduction) | :purple_heart: | `:purple_heart:` | :brown_heart: | `:brown_heart:` | [top](#introduction) |
| [top](#introduction) | :black_heart: | `:black_heart:` | :white_heart: | `:white_heart:` | [top](#introduction) |

### Emotion

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#introduction) | :kiss: | `:kiss:` | :100: | `:100:` | [top](#introduction) |
| [top](#introduction) | :anger: | `:anger:` | :boom: | `:boom:` `:collision:` | [top](#introduction) |
| [top](#introduction) | :dizzy: | `:dizzy:` | :sweat_drops: | `:sweat_drops:` | [top](#introduction) |
| [top](#introduction) | :dash: | `:dash:` | :hole: | `:hole:` | [top](#introduction) |
| [top](#introduction) | :speech_balloon: | `:speech_balloon:` | :eye_speech_bubble: | `:eye_speech_bubble:` | [top](#introduction) |
| [top](#introduction) | :left_speech_bubble: | `:left_speech_bubble:` | :right_anger_bubble: | `:right_anger_bubble:` | [top](#introduction) |
| [top](#introduction) | :thought_balloon: | `:thought_balloon:` | :zzz: | `:zzz:` | [top](#introduction) |

## People & Body

- [Hand Fingers Open](#hand-fingers-open)
- [Hand Fingers Partial](#hand-fingers-partial)
- [Hand Single Finger](#hand-single-finger)
- [Hand Fingers Closed](#hand-fingers-closed)
- [Hands](#hands)
- [Hand Prop](#hand-prop)
- [Body Parts](#body-parts)
- [Person](#person)
- [Person Gesture](#person-gesture)
- [Person Role](#person-role)
- [Person Fantasy](#person-fantasy)
- [Person Activity](#person-activity)
- [Person Sport](#person-sport)
- [Person Resting](#person-resting)
- [Family](#family)
- [Person Symbol](#person-symbol)

### Hand Fingers Open

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :wave: | `:wave:` | :raised_back_of_hand: | `:raised_back_of_hand:` | [top](#introduction) |
| [top](#people--body) | :raised_hand_with_fingers_splayed: | `:raised_hand_with_fingers_splayed:` | :hand: | `:hand:` `:raised_hand:` | [top](#introduction) |
| [top](#people--body) | :vulcan_salute: | `:vulcan_salute:` | | | [top](#introduction) |

### Hand Fingers Partial

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :ok_hand: | `:ok_hand:` | :pinched_fingers: | `:pinched_fingers:` | [top](#introduction) |
| [top](#people--body) | :pinching_hand: | `:pinching_hand:` | :v: | `:v:` | [top](#introduction) |
| [top](#people--body) | :crossed_fingers: | `:crossed_fingers:` | :love_you_gesture: | `:love_you_gesture:` | [top](#introduction) |
| [top](#people--body) | :metal: | `:metal:` | :call_me_hand: | `:call_me_hand:` | [top](#introduction) |

### Hand Single Finger

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :point_left: | `:point_left:` | :point_right: | `:point_right:` | [top](#introduction) |
| [top](#people--body) | :point_up_2: | `:point_up_2:` | :fu: | `:fu:` `:middle_finger:` | [top](#introduction) |
| [top](#people--body) | :point_down: | `:point_down:` | :point_up: | `:point_up:` | [top](#introduction) |

### Hand Fingers Closed

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :+1: | `:+1:` `:thumbsup:` | :-1: | `:-1:` `:thumbsdown:` | [top](#introduction) |
| [top](#people--body) | :fist: | `:fist:` `:fist_raised:` | :facepunch: | `:facepunch:` `:fist_oncoming:` `:punch:` | [top](#introduction) |
| [top](#people--body) | :fist_left: | `:fist_left:` | :fist_right: | `:fist_right:` | [top](#introduction) |

### Hands

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :clap: | `:clap:` | :raised_hands: | `:raised_hands:` | [top](#introduction) |
| [top](#people--body) | :open_hands: | `:open_hands:` | :palms_up_together: | `:palms_up_together:` | [top](#introduction) |
| [top](#people--body) | :handshake: | `:handshake:` | :pray: | `:pray:` | [top](#introduction) |

### Hand Prop

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :writing_hand: | `:writing_hand:` | :nail_care: | `:nail_care:` | [top](#introduction) |
| [top](#people--body) | :selfie: | `:selfie:` | | | [top](#introduction) |

### Body Parts

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :muscle: | `:muscle:` | :mechanical_arm: | `:mechanical_arm:` | [top](#introduction) |
| [top](#people--body) | :mechanical_leg: | `:mechanical_leg:` | :leg: | `:leg:` | [top](#introduction) |
| [top](#people--body) | :foot: | `:foot:` | :ear: | `:ear:` | [top](#introduction) |
| [top](#people--body) | :ear_with_hearing_aid: | `:ear_with_hearing_aid:` | :nose: | `:nose:` | [top](#introduction) |
| [top](#people--body) | :brain: | `:brain:` | :anatomical_heart: | `:anatomical_heart:` | [top](#introduction) |
| [top](#people--body) | :lungs: | `:lungs:` | :tooth: | `:tooth:` | [top](#introduction) |
| [top](#people--body) | :bone: | `:bone:` | :eyes: | `:eyes:` | [top](#introduction) |
| [top](#people--body) | :eye: | `:eye:` | :tongue: | `:tongue:` | [top](#introduction) |
| [top](#people--body) | :lips: | `:lips:` | | | [top](#introduction) |

### Person

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :baby: | `:baby:` | :child: | `:child:` | [top](#introduction) |
| [top](#people--body) | :boy: | `:boy:` | :girl: | `:girl:` | [top](#introduction) |
| [top](#people--body) | :adult: | `:adult:` | :blond_haired_person: | `:blond_haired_person:` | [top](#introduction) |
| [top](#people--body) | :man: | `:man:` | :bearded_person: | `:bearded_person:` | [top](#introduction) |
| [top](#people--body) | :man_beard: | `:man_beard:` | :woman_beard: | `:woman_beard:` | [top](#introduction) |
| [top](#people--body) | :red_haired_man: | `:red_haired_man:` | :curly_haired_man: | `:curly_haired_man:` | [top](#introduction) |
| [top](#people--body) | :white_haired_man: | `:white_haired_man:` | :bald_man: | `:bald_man:` | [top](#introduction) |
| [top](#people--body) | :woman: | `:woman:` | :red_haired_woman: | `:red_haired_woman:` | [top](#introduction) |
| [top](#people--body) | :person_red_hair: | `:person_red_hair:` | :curly_haired_woman: | `:curly_haired_woman:` | [top](#introduction) |
| [top](#people--body) | :person_curly_hair: | `:person_curly_hair:` | :white_haired_woman: | `:white_haired_woman:` | [top](#introduction) |
| [top](#people--body) | :person_white_hair: | `:person_white_hair:` | :bald_woman: | `:bald_woman:` | [top](#introduction) |
| [top](#people--body) | :person_bald: | `:person_bald:` | :blond_haired_woman: | `:blond_haired_woman:` `:blonde_woman:` | [top](#introduction) |
| [top](#people--body) | :blond_haired_man: | `:blond_haired_man:` | :older_adult: | `:older_adult:` | [top](#introduction) |
| [top](#people--body) | :older_man: | `:older_man:` | :older_woman: | `:older_woman:` | [top](#introduction) |

### Person Gesture

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :frowning_person: | `:frowning_person:` | :frowning_man: | `:frowning_man:` | [top](#introduction) |
| [top](#people--body) | :frowning_woman: | `:frowning_woman:` | :pouting_face: | `:pouting_face:` | [top](#introduction) |
| [top](#people--body) | :pouting_man: | `:pouting_man:` | :pouting_woman: | `:pouting_woman:` | [top](#introduction) |
| [top](#people--body) | :no_good: | `:no_good:` | :ng_man: | `:ng_man:` `:no_good_man:` | [top](#introduction) |
| [top](#people--body) | :ng_woman: | `:ng_woman:` `:no_good_woman:` | :ok_person: | `:ok_person:` | [top](#introduction) |
| [top](#people--body) | :ok_man: | `:ok_man:` | :ok_woman: | `:ok_woman:` | [top](#introduction) |
| [top](#people--body) | :information_desk_person: | `:information_desk_person:` `:tipping_hand_person:` | :sassy_man: | `:sassy_man:` `:tipping_hand_man:` | [top](#introduction) |
| [top](#people--body) | :sassy_woman: | `:sassy_woman:` `:tipping_hand_woman:` | :raising_hand: | `:raising_hand:` | [top](#introduction) |
| [top](#people--body) | :raising_hand_man: | `:raising_hand_man:` | :raising_hand_woman: | `:raising_hand_woman:` | [top](#introduction) |
| [top](#people--body) | :deaf_person: | `:deaf_person:` | :deaf_man: | `:deaf_man:` | [top](#introduction) |
| [top](#people--body) | :deaf_woman: | `:deaf_woman:` | :bow: | `:bow:` | [top](#introduction) |
| [top](#people--body) | :bowing_man: | `:bowing_man:` | :bowing_woman: | `:bowing_woman:` | [top](#introduction) |
| [top](#people--body) | :facepalm: | `:facepalm:` | :man_facepalming: | `:man_facepalming:` | [top](#introduction) |
| [top](#people--body) | :woman_facepalming: | `:woman_facepalming:` | :shrug: | `:shrug:` | [top](#introduction) |
| [top](#people--body) | :man_shrugging: | `:man_shrugging:` | :woman_shrugging: | `:woman_shrugging:` | [top](#introduction) |

### Person Role

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :health_worker: | `:health_worker:` | :man_health_worker: | `:man_health_worker:` | [top](#introduction) |
| [top](#people--body) | :woman_health_worker: | `:woman_health_worker:` | :student: | `:student:` | [top](#introduction) |
| [top](#people--body) | :man_student: | `:man_student:` | :woman_student: | `:woman_student:` | [top](#introduction) |
| [top](#people--body) | :teacher: | `:teacher:` | :man_teacher: | `:man_teacher:` | [top](#introduction) |
| [top](#people--body) | :woman_teacher: | `:woman_teacher:` | :judge: | `:judge:` | [top](#introduction) |
| [top](#people--body) | :man_judge: | `:man_judge:` | :woman_judge: | `:woman_judge:` | [top](#introduction) |
| [top](#people--body) | :farmer: | `:farmer:` | :man_farmer: | `:man_farmer:` | [top](#introduction) |
| [top](#people--body) | :woman_farmer: | `:woman_farmer:` | :cook: | `:cook:` | [top](#introduction) |
| [top](#people--body) | :man_cook: | `:man_cook:` | :woman_cook: | `:woman_cook:` | [top](#introduction) |
| [top](#people--body) | :mechanic: | `:mechanic:` | :man_mechanic: | `:man_mechanic:` | [top](#introduction) |
| [top](#people--body) | :woman_mechanic: | `:woman_mechanic:` | :factory_worker: | `:factory_worker:` | [top](#introduction) |
| [top](#people--body) | :man_factory_worker: | `:man_factory_worker:` | :woman_factory_worker: | `:woman_factory_worker:` | [top](#introduction) |
| [top](#people--body) | :office_worker: | `:office_worker:` | :man_office_worker: | `:man_office_worker:` | [top](#introduction) |
| [top](#people--body) | :woman_office_worker: | `:woman_office_worker:` | :scientist: | `:scientist:` | [top](#introduction) |
| [top](#people--body) | :man_scientist: | `:man_scientist:` | :woman_scientist: | `:woman_scientist:` | [top](#introduction) |
| [top](#people--body) | :technologist: | `:technologist:` | :man_technologist: | `:man_technologist:` | [top](#introduction) |
| [top](#people--body) | :woman_technologist: | `:woman_technologist:` | :singer: | `:singer:` | [top](#introduction) |
| [top](#people--body) | :man_singer: | `:man_singer:` | :woman_singer: | `:woman_singer:` | [top](#introduction) |
| [top](#people--body) | :artist: | `:artist:` | :man_artist: | `:man_artist:` | [top](#introduction) |
| [top](#people--body) | :woman_artist: | `:woman_artist:` | :pilot: | `:pilot:` | [top](#introduction) |
| [top](#people--body) | :man_pilot: | `:man_pilot:` | :woman_pilot: | `:woman_pilot:` | [top](#introduction) |
| [top](#people--body) | :astronaut: | `:astronaut:` | :man_astronaut: | `:man_astronaut:` | [top](#introduction) |
| [top](#people--body) | :woman_astronaut: | `:woman_astronaut:` | :firefighter: | `:firefighter:` | [top](#introduction) |
| [top](#people--body) | :man_firefighter: | `:man_firefighter:` | :woman_firefighter: | `:woman_firefighter:` | [top](#introduction) |
| [top](#people--body) | :cop: | `:cop:` `:police_officer:` | :policeman: | `:policeman:` | [top](#introduction) |
| [top](#people--body) | :policewoman: | `:policewoman:` | :detective: | `:detective:` | [top](#introduction) |
| [top](#people--body) | :male_detective: | `:male_detective:` | :female_detective: | `:female_detective:` | [top](#introduction) |
| [top](#people--body) | :guard: | `:guard:` | :guardsman: | `:guardsman:` | [top](#introduction) |
| [top](#people--body) | :guardswoman: | `:guardswoman:` | :ninja: | `:ninja:` | [top](#introduction) |
| [top](#people--body) | :construction_worker: | `:construction_worker:` | :construction_worker_man: | `:construction_worker_man:` | [top](#introduction) |
| [top](#people--body) | :construction_worker_woman: | `:construction_worker_woman:` | :prince: | `:prince:` | [top](#introduction) |
| [top](#people--body) | :princess: | `:princess:` | :person_with_turban: | `:person_with_turban:` | [top](#introduction) |
| [top](#people--body) | :man_with_turban: | `:man_with_turban:` | :woman_with_turban: | `:woman_with_turban:` | [top](#introduction) |
| [top](#people--body) | :man_with_gua_pi_mao: | `:man_with_gua_pi_mao:` | :woman_with_headscarf: | `:woman_with_headscarf:` | [top](#introduction) |
| [top](#people--body) | :person_in_tuxedo: | `:person_in_tuxedo:` | :man_in_tuxedo: | `:man_in_tuxedo:` | [top](#introduction) |
| [top](#people--body) | :woman_in_tuxedo: | `:woman_in_tuxedo:` | :person_with_veil: | `:person_with_veil:` | [top](#introduction) |
| [top](#people--body) | :man_with_veil: | `:man_with_veil:` | :bride_with_veil: | `:bride_with_veil:` `:woman_with_veil:` | [top](#introduction) |
| [top](#people--body) | :pregnant_woman: | `:pregnant_woman:` | :breast_feeding: | `:breast_feeding:` | [top](#introduction) |
| [top](#people--body) | :woman_feeding_baby: | `:woman_feeding_baby:` | :man_feeding_baby: | `:man_feeding_baby:` | [top](#introduction) |
| [top](#people--body) | :person_feeding_baby: | `:person_feeding_baby:` | | | [top](#introduction) |

### Person Fantasy

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :angel: | `:angel:` | :santa: | `:santa:` | [top](#introduction) |
| [top](#people--body) | :mrs_claus: | `:mrs_claus:` | :mx_claus: | `:mx_claus:` | [top](#introduction) |
| [top](#people--body) | :superhero: | `:superhero:` | :superhero_man: | `:superhero_man:` | [top](#introduction) |
| [top](#people--body) | :superhero_woman: | `:superhero_woman:` | :supervillain: | `:supervillain:` | [top](#introduction) |
| [top](#people--body) | :supervillain_man: | `:supervillain_man:` | :supervillain_woman: | `:supervillain_woman:` | [top](#introduction) |
| [top](#people--body) | :mage: | `:mage:` | :mage_man: | `:mage_man:` | [top](#introduction) |
| [top](#people--body) | :mage_woman: | `:mage_woman:` | :fairy: | `:fairy:` | [top](#introduction) |
| [top](#people--body) | :fairy_man: | `:fairy_man:` | :fairy_woman: | `:fairy_woman:` | [top](#introduction) |
| [top](#people--body) | :vampire: | `:vampire:` | :vampire_man: | `:vampire_man:` | [top](#introduction) |
| [top](#people--body) | :vampire_woman: | `:vampire_woman:` | :merperson: | `:merperson:` | [top](#introduction) |
| [top](#people--body) | :merman: | `:merman:` | :mermaid: | `:mermaid:` | [top](#introduction) |
| [top](#people--body) | :elf: | `:elf:` | :elf_man: | `:elf_man:` | [top](#introduction) |
| [top](#people--body) | :elf_woman: | `:elf_woman:` | :genie: | `:genie:` | [top](#introduction) |
| [top](#people--body) | :genie_man: | `:genie_man:` | :genie_woman: | `:genie_woman:` | [top](#introduction) |
| [top](#people--body) | :zombie: | `:zombie:` | :zombie_man: | `:zombie_man:` | [top](#introduction) |
| [top](#people--body) | :zombie_woman: | `:zombie_woman:` | | | [top](#introduction) |

### Person Activity

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :massage: | `:massage:` | :massage_man: | `:massage_man:` | [top](#introduction) |
| [top](#people--body) | :massage_woman: | `:massage_woman:` | :haircut: | `:haircut:` | [top](#introduction) |
| [top](#people--body) | :haircut_man: | `:haircut_man:` | :haircut_woman: | `:haircut_woman:` | [top](#introduction) |
| [top](#people--body) | :walking: | `:walking:` | :walking_man: | `:walking_man:` | [top](#introduction) |
| [top](#people--body) | :walking_woman: | `:walking_woman:` | :standing_person: | `:standing_person:` | [top](#introduction) |
| [top](#people--body) | :standing_man: | `:standing_man:` | :standing_woman: | `:standing_woman:` | [top](#introduction) |
| [top](#people--body) | :kneeling_person: | `:kneeling_person:` | :kneeling_man: | `:kneeling_man:` | [top](#introduction) |
| [top](#people--body) | :kneeling_woman: | `:kneeling_woman:` | :person_with_probing_cane: | `:person_with_probing_cane:` | [top](#introduction) |
| [top](#people--body) | :man_with_probing_cane: | `:man_with_probing_cane:` | :woman_with_probing_cane: | `:woman_with_probing_cane:` | [top](#introduction) |
| [top](#people--body) | :person_in_motorized_wheelchair: | `:person_in_motorized_wheelchair:` | :man_in_motorized_wheelchair: | `:man_in_motorized_wheelchair:` | [top](#introduction) |
| [top](#people--body) | :woman_in_motorized_wheelchair: | `:woman_in_motorized_wheelchair:` | :person_in_manual_wheelchair: | `:person_in_manual_wheelchair:` | [top](#introduction) |
| [top](#people--body) | :man_in_manual_wheelchair: | `:man_in_manual_wheelchair:` | :woman_in_manual_wheelchair: | `:woman_in_manual_wheelchair:` | [top](#introduction) |
| [top](#people--body) | :runner: | `:runner:` `:running:` | :running_man: | `:running_man:` | [top](#introduction) |
| [top](#people--body) | :running_woman: | `:running_woman:` | :dancer: | `:dancer:` `:woman_dancing:` | [top](#introduction) |
| [top](#people--body) | :man_dancing: | `:man_dancing:` | :business_suit_levitating: | `:business_suit_levitating:` | [top](#introduction) |
| [top](#people--body) | :dancers: | `:dancers:` | :dancing_men: | `:dancing_men:` | [top](#introduction) |
| [top](#people--body) | :dancing_women: | `:dancing_women:` | :sauna_person: | `:sauna_person:` | [top](#introduction) |
| [top](#people--body) | :sauna_man: | `:sauna_man:` | :sauna_woman: | `:sauna_woman:` | [top](#introduction) |
| [top](#people--body) | :climbing: | `:climbing:` | :climbing_man: | `:climbing_man:` | [top](#introduction) |
| [top](#people--body) | :climbing_woman: | `:climbing_woman:` | | | [top](#introduction) |

### Person Sport

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :person_fencing: | `:person_fencing:` | :horse_racing: | `:horse_racing:` | [top](#introduction) |
| [top](#people--body) | :skier: | `:skier:` | :snowboarder: | `:snowboarder:` | [top](#introduction) |
| [top](#people--body) | :golfing: | `:golfing:` | :golfing_man: | `:golfing_man:` | [top](#introduction) |
| [top](#people--body) | :golfing_woman: | `:golfing_woman:` | :surfer: | `:surfer:` | [top](#introduction) |
| [top](#people--body) | :surfing_man: | `:surfing_man:` | :surfing_woman: | `:surfing_woman:` | [top](#introduction) |
| [top](#people--body) | :rowboat: | `:rowboat:` | :rowing_man: | `:rowing_man:` | [top](#introduction) |
| [top](#people--body) | :rowing_woman: | `:rowing_woman:` | :swimmer: | `:swimmer:` | [top](#introduction) |
| [top](#people--body) | :swimming_man: | `:swimming_man:` | :swimming_woman: | `:swimming_woman:` | [top](#introduction) |
| [top](#people--body) | :bouncing_ball_person: | `:bouncing_ball_person:` | :basketball_man: | `:basketball_man:` `:bouncing_ball_man:` | [top](#introduction) |
| [top](#people--body) | :basketball_woman: | `:basketball_woman:` `:bouncing_ball_woman:` | :weight_lifting: | `:weight_lifting:` | [top](#introduction) |
| [top](#people--body) | :weight_lifting_man: | `:weight_lifting_man:` | :weight_lifting_woman: | `:weight_lifting_woman:` | [top](#introduction) |
| [top](#people--body) | :bicyclist: | `:bicyclist:` | :biking_man: | `:biking_man:` | [top](#introduction) |
| [top](#people--body) | :biking_woman: | `:biking_woman:` | :mountain_bicyclist: | `:mountain_bicyclist:` | [top](#introduction) |
| [top](#people--body) | :mountain_biking_man: | `:mountain_biking_man:` | :mountain_biking_woman: | `:mountain_biking_woman:` | [top](#introduction) |
| [top](#people--body) | :cartwheeling: | `:cartwheeling:` | :man_cartwheeling: | `:man_cartwheeling:` | [top](#introduction) |
| [top](#people--body) | :woman_cartwheeling: | `:woman_cartwheeling:` | :wrestling: | `:wrestling:` | [top](#introduction) |
| [top](#people--body) | :men_wrestling: | `:men_wrestling:` | :women_wrestling: | `:women_wrestling:` | [top](#introduction) |
| [top](#people--body) | :water_polo: | `:water_polo:` | :man_playing_water_polo: | `:man_playing_water_polo:` | [top](#introduction) |
| [top](#people--body) | :woman_playing_water_polo: | `:woman_playing_water_polo:` | :handball_person: | `:handball_person:` | [top](#introduction) |
| [top](#people--body) | :man_playing_handball: | `:man_playing_handball:` | :woman_playing_handball: | `:woman_playing_handball:` | [top](#introduction) |
| [top](#people--body) | :juggling_person: | `:juggling_person:` | :man_juggling: | `:man_juggling:` | [top](#introduction) |
| [top](#people--body) | :woman_juggling: | `:woman_juggling:` | | | [top](#introduction) |

### Person Resting

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :lotus_position: | `:lotus_position:` | :lotus_position_man: | `:lotus_position_man:` | [top](#introduction) |
| [top](#people--body) | :lotus_position_woman: | `:lotus_position_woman:` | :bath: | `:bath:` | [top](#introduction) |
| [top](#people--body) | :sleeping_bed: | `:sleeping_bed:` | | | [top](#introduction) |

### Family

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :people_holding_hands: | `:people_holding_hands:` | :two_women_holding_hands: | `:two_women_holding_hands:` | [top](#introduction) |
| [top](#people--body) | :couple: | `:couple:` | :two_men_holding_hands: | `:two_men_holding_hands:` | [top](#introduction) |
| [top](#people--body) | :couplekiss: | `:couplekiss:` | :couplekiss_man_woman: | `:couplekiss_man_woman:` | [top](#introduction) |
| [top](#people--body) | :couplekiss_man_man: | `:couplekiss_man_man:` | :couplekiss_woman_woman: | `:couplekiss_woman_woman:` | [top](#introduction) |
| [top](#people--body) | :couple_with_heart: | `:couple_with_heart:` | :couple_with_heart_woman_man: | `:couple_with_heart_woman_man:` | [top](#introduction) |
| [top](#people--body) | :couple_with_heart_man_man: | `:couple_with_heart_man_man:` | :couple_with_heart_woman_woman: | `:couple_with_heart_woman_woman:` | [top](#introduction) |
| [top](#people--body) | :family_man_woman_boy: | `:family_man_woman_boy:` | :family_man_woman_girl: | `:family_man_woman_girl:` | [top](#introduction) |
| [top](#people--body) | :family_man_woman_girl_boy: | `:family_man_woman_girl_boy:` | :family_man_woman_boy_boy: | `:family_man_woman_boy_boy:` | [top](#introduction) |
| [top](#people--body) | :family_man_woman_girl_girl: | `:family_man_woman_girl_girl:` | :family_man_man_boy: | `:family_man_man_boy:` | [top](#introduction) |
| [top](#people--body) | :family_man_man_girl: | `:family_man_man_girl:` | :family_man_man_girl_boy: | `:family_man_man_girl_boy:` | [top](#introduction) |
| [top](#people--body) | :family_man_man_boy_boy: | `:family_man_man_boy_boy:` | :family_man_man_girl_girl: | `:family_man_man_girl_girl:` | [top](#introduction) |
| [top](#people--body) | :family_woman_woman_boy: | `:family_woman_woman_boy:` | :family_woman_woman_girl: | `:family_woman_woman_girl:` | [top](#introduction) |
| [top](#people--body) | :family_woman_woman_girl_boy: | `:family_woman_woman_girl_boy:` | :family_woman_woman_boy_boy: | `:family_woman_woman_boy_boy:` | [top](#introduction) |
| [top](#people--body) | :family_woman_woman_girl_girl: | `:family_woman_woman_girl_girl:` | :family_man_boy: | `:family_man_boy:` | [top](#introduction) |
| [top](#people--body) | :family_man_boy_boy: | `:family_man_boy_boy:` | :family_man_girl: | `:family_man_girl:` | [top](#introduction) |
| [top](#people--body) | :family_man_girl_boy: | `:family_man_girl_boy:` | :family_man_girl_girl: | `:family_man_girl_girl:` | [top](#introduction) |
| [top](#people--body) | :family_woman_boy: | `:family_woman_boy:` | :family_woman_boy_boy: | `:family_woman_boy_boy:` | [top](#introduction) |
| [top](#people--body) | :family_woman_girl: | `:family_woman_girl:` | :family_woman_girl_boy: | `:family_woman_girl_boy:` | [top](#introduction) |
| [top](#people--body) | :family_woman_girl_girl: | `:family_woman_girl_girl:` | | | [top](#introduction) |

### Person Symbol

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#people--body) | :speaking_head: | `:speaking_head:` | :bust_in_silhouette: | `:bust_in_silhouette:` | [top](#introduction) |
| [top](#people--body) | :busts_in_silhouette: | `:busts_in_silhouette:` | :people_hugging: | `:people_hugging:` | [top](#introduction) |
| [top](#people--body) | :family: | `:family:` | :footprints: | `:footprints:` | [top](#introduction) |

## Animals & Nature

- [Animal Mammal](#animal-mammal)
- [Animal Bird](#animal-bird)
- [Animal Amphibian](#animal-amphibian)
- [Animal Reptile](#animal-reptile)
- [Animal Marine](#animal-marine)
- [Animal Bug](#animal-bug)
- [Plant Flower](#plant-flower)
- [Plant Other](#plant-other)

### Animal Mammal

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :monkey_face: | `:monkey_face:` | :monkey: | `:monkey:` | [top](#introduction) |
| [top](#animals--nature) | :gorilla: | `:gorilla:` | :orangutan: | `:orangutan:` | [top](#introduction) |
| [top](#animals--nature) | :dog: | `:dog:` | :dog2: | `:dog2:` | [top](#introduction) |
| [top](#animals--nature) | :guide_dog: | `:guide_dog:` | :service_dog: | `:service_dog:` | [top](#introduction) |
| [top](#animals--nature) | :poodle: | `:poodle:` | :wolf: | `:wolf:` | [top](#introduction) |
| [top](#animals--nature) | :fox_face: | `:fox_face:` | :raccoon: | `:raccoon:` | [top](#introduction) |
| [top](#animals--nature) | :cat: | `:cat:` | :cat2: | `:cat2:` | [top](#introduction) |
| [top](#animals--nature) | :black_cat: | `:black_cat:` | :lion: | `:lion:` | [top](#introduction) |
| [top](#animals--nature) | :tiger: | `:tiger:` | :tiger2: | `:tiger2:` | [top](#introduction) |
| [top](#animals--nature) | :leopard: | `:leopard:` | :horse: | `:horse:` | [top](#introduction) |
| [top](#animals--nature) | :racehorse: | `:racehorse:` | :unicorn: | `:unicorn:` | [top](#introduction) |
| [top](#animals--nature) | :zebra: | `:zebra:` | :deer: | `:deer:` | [top](#introduction) |
| [top](#animals--nature) | :bison: | `:bison:` | :cow: | `:cow:` | [top](#introduction) |
| [top](#animals--nature) | :ox: | `:ox:` | :water_buffalo: | `:water_buffalo:` | [top](#introduction) |
| [top](#animals--nature) | :cow2: | `:cow2:` | :pig: | `:pig:` | [top](#introduction) |
| [top](#animals--nature) | :pig2: | `:pig2:` | :boar: | `:boar:` | [top](#introduction) |
| [top](#animals--nature) | :pig_nose: | `:pig_nose:` | :ram: | `:ram:` | [top](#introduction) |
| [top](#animals--nature) | :sheep: | `:sheep:` | :goat: | `:goat:` | [top](#introduction) |
| [top](#animals--nature) | :dromedary_camel: | `:dromedary_camel:` | :camel: | `:camel:` | [top](#introduction) |
| [top](#animals--nature) | :llama: | `:llama:` | :giraffe: | `:giraffe:` | [top](#introduction) |
| [top](#animals--nature) | :elephant: | `:elephant:` | :mammoth: | `:mammoth:` | [top](#introduction) |
| [top](#animals--nature) | :rhinoceros: | `:rhinoceros:` | :hippopotamus: | `:hippopotamus:` | [top](#introduction) |
| [top](#animals--nature) | :mouse: | `:mouse:` | :mouse2: | `:mouse2:` | [top](#introduction) |
| [top](#animals--nature) | :rat: | `:rat:` | :hamster: | `:hamster:` | [top](#introduction) |
| [top](#animals--nature) | :rabbit: | `:rabbit:` | :rabbit2: | `:rabbit2:` | [top](#introduction) |
| [top](#animals--nature) | :chipmunk: | `:chipmunk:` | :beaver: | `:beaver:` | [top](#introduction) |
| [top](#animals--nature) | :hedgehog: | `:hedgehog:` | :bat: | `:bat:` | [top](#introduction) |
| [top](#animals--nature) | :bear: | `:bear:` | :polar_bear: | `:polar_bear:` | [top](#introduction) |
| [top](#animals--nature) | :koala: | `:koala:` | :panda_face: | `:panda_face:` | [top](#introduction) |
| [top](#animals--nature) | :sloth: | `:sloth:` | :otter: | `:otter:` | [top](#introduction) |
| [top](#animals--nature) | :skunk: | `:skunk:` | :kangaroo: | `:kangaroo:` | [top](#introduction) |
| [top](#animals--nature) | :badger: | `:badger:` | :feet: | `:feet:` `:paw_prints:` | [top](#introduction) |

### Animal Bird

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :turkey: | `:turkey:` | :chicken: | `:chicken:` | [top](#introduction) |
| [top](#animals--nature) | :rooster: | `:rooster:` | :hatching_chick: | `:hatching_chick:` | [top](#introduction) |
| [top](#animals--nature) | :baby_chick: | `:baby_chick:` | :hatched_chick: | `:hatched_chick:` | [top](#introduction) |
| [top](#animals--nature) | :bird: | `:bird:` | :penguin: | `:penguin:` | [top](#introduction) |
| [top](#animals--nature) | :dove: | `:dove:` | :eagle: | `:eagle:` | [top](#introduction) |
| [top](#animals--nature) | :duck: | `:duck:` | :swan: | `:swan:` | [top](#introduction) |
| [top](#animals--nature) | :owl: | `:owl:` | :dodo: | `:dodo:` | [top](#introduction) |
| [top](#animals--nature) | :feather: | `:feather:` | :flamingo: | `:flamingo:` | [top](#introduction) |
| [top](#animals--nature) | :peacock: | `:peacock:` | :parrot: | `:parrot:` | [top](#introduction) |

### Animal Amphibian

| | ico | shortcode | |
| - | :-: | - | - |
| [top](#animals--nature) | :frog: | `:frog:` | [top](#introduction) |

### Animal Reptile

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :crocodile: | `:crocodile:` | :turtle: | `:turtle:` | [top](#introduction) |
| [top](#animals--nature) | :lizard: | `:lizard:` | :snake: | `:snake:` | [top](#introduction) |
| [top](#animals--nature) | :dragon_face: | `:dragon_face:` | :dragon: | `:dragon:` | [top](#introduction) |
| [top](#animals--nature) | :sauropod: | `:sauropod:` | :t-rex: | `:t-rex:` | [top](#introduction) |

### Animal Marine

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :whale: | `:whale:` | :whale2: | `:whale2:` | [top](#introduction) |
| [top](#animals--nature) | :dolphin: | `:dolphin:` `:flipper:` | :seal: | `:seal:` | [top](#introduction) |
| [top](#animals--nature) | :fish: | `:fish:` | :tropical_fish: | `:tropical_fish:` | [top](#introduction) |
| [top](#animals--nature) | :blowfish: | `:blowfish:` | :shark: | `:shark:` | [top](#introduction) |
| [top](#animals--nature) | :octopus: | `:octopus:` | :shell: | `:shell:` | [top](#introduction) |

### Animal Bug

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :snail: | `:snail:` | :butterfly: | `:butterfly:` | [top](#introduction) |
| [top](#animals--nature) | :bug: | `:bug:` | :ant: | `:ant:` | [top](#introduction) |
| [top](#animals--nature) | :bee: | `:bee:` `:honeybee:` | :beetle: | `:beetle:` | [top](#introduction) |
| [top](#animals--nature) | :lady_beetle: | `:lady_beetle:` | :cricket: | `:cricket:` | [top](#introduction) |
| [top](#animals--nature) | :cockroach: | `:cockroach:` | :spider: | `:spider:` | [top](#introduction) |
| [top](#animals--nature) | :spider_web: | `:spider_web:` | :scorpion: | `:scorpion:` | [top](#introduction) |
| [top](#animals--nature) | :mosquito: | `:mosquito:` | :fly: | `:fly:` | [top](#introduction) |
| [top](#animals--nature) | :worm: | `:worm:` | :microbe: | `:microbe:` | [top](#introduction) |

### Plant Flower

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :bouquet: | `:bouquet:` | :cherry_blossom: | `:cherry_blossom:` | [top](#introduction) |
| [top](#animals--nature) | :white_flower: | `:white_flower:` | :rosette: | `:rosette:` | [top](#introduction) |
| [top](#animals--nature) | :rose: | `:rose:` | :wilted_flower: | `:wilted_flower:` | [top](#introduction) |
| [top](#animals--nature) | :hibiscus: | `:hibiscus:` | :sunflower: | `:sunflower:` | [top](#introduction) |
| [top](#animals--nature) | :blossom: | `:blossom:` | :tulip: | `:tulip:` | [top](#introduction) |

### Plant Other

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#animals--nature) | :seedling: | `:seedling:` | :potted_plant: | `:potted_plant:` | [top](#introduction) |
| [top](#animals--nature) | :evergreen_tree: | `:evergreen_tree:` | :deciduous_tree: | `:deciduous_tree:` | [top](#introduction) |
| [top](#animals--nature) | :palm_tree: | `:palm_tree:` | :cactus: | `:cactus:` | [top](#introduction) |
| [top](#animals--nature) | :ear_of_rice: | `:ear_of_rice:` | :herb: | `:herb:` | [top](#introduction) |
| [top](#animals--nature) | :shamrock: | `:shamrock:` | :four_leaf_clover: | `:four_leaf_clover:` | [top](#introduction) |
| [top](#animals--nature) | :maple_leaf: | `:maple_leaf:` | :fallen_leaf: | `:fallen_leaf:` | [top](#introduction) |
| [top](#animals--nature) | :leaves: | `:leaves:` | :mushroom: | `:mushroom:` | [top](#introduction) |

## Food & Drink

- [Food Fruit](#food-fruit)
- [Food Vegetable](#food-vegetable)
- [Food Prepared](#food-prepared)
- [Food Asian](#food-asian)
- [Food Marine](#food-marine)
- [Food Sweet](#food-sweet)
- [Drink](#drink)
- [Dishware](#dishware)

### Food Fruit

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :grapes: | `:grapes:` | :melon: | `:melon:` | [top](#introduction) |
| [top](#food--drink) | :watermelon: | `:watermelon:` | :mandarin: | `:mandarin:` `:orange:` `:tangerine:` | [top](#introduction) |
| [top](#food--drink) | :lemon: | `:lemon:` | :banana: | `:banana:` | [top](#introduction) |
| [top](#food--drink) | :pineapple: | `:pineapple:` | :mango: | `:mango:` | [top](#introduction) |
| [top](#food--drink) | :apple: | `:apple:` | :green_apple: | `:green_apple:` | [top](#introduction) |
| [top](#food--drink) | :pear: | `:pear:` | :peach: | `:peach:` | [top](#introduction) |
| [top](#food--drink) | :cherries: | `:cherries:` | :strawberry: | `:strawberry:` | [top](#introduction) |
| [top](#food--drink) | :blueberries: | `:blueberries:` | :kiwi_fruit: | `:kiwi_fruit:` | [top](#introduction) |
| [top](#food--drink) | :tomato: | `:tomato:` | :olive: | `:olive:` | [top](#introduction) |
| [top](#food--drink) | :coconut: | `:coconut:` | | | [top](#introduction) |

### Food Vegetable

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :avocado: | `:avocado:` | :eggplant: | `:eggplant:` | [top](#introduction) |
| [top](#food--drink) | :potato: | `:potato:` | :carrot: | `:carrot:` | [top](#introduction) |
| [top](#food--drink) | :corn: | `:corn:` | :hot_pepper: | `:hot_pepper:` | [top](#introduction) |
| [top](#food--drink) | :bell_pepper: | `:bell_pepper:` | :cucumber: | `:cucumber:` | [top](#introduction) |
| [top](#food--drink) | :leafy_green: | `:leafy_green:` | :broccoli: | `:broccoli:` | [top](#introduction) |
| [top](#food--drink) | :garlic: | `:garlic:` | :onion: | `:onion:` | [top](#introduction) |
| [top](#food--drink) | :peanuts: | `:peanuts:` | :chestnut: | `:chestnut:` | [top](#introduction) |

### Food Prepared

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :bread: | `:bread:` | :croissant: | `:croissant:` | [top](#introduction) |
| [top](#food--drink) | :baguette_bread: | `:baguette_bread:` | :flatbread: | `:flatbread:` | [top](#introduction) |
| [top](#food--drink) | :pretzel: | `:pretzel:` | :bagel: | `:bagel:` | [top](#introduction) |
| [top](#food--drink) | :pancakes: | `:pancakes:` | :waffle: | `:waffle:` | [top](#introduction) |
| [top](#food--drink) | :cheese: | `:cheese:` | :meat_on_bone: | `:meat_on_bone:` | [top](#introduction) |
| [top](#food--drink) | :poultry_leg: | `:poultry_leg:` | :cut_of_meat: | `:cut_of_meat:` | [top](#introduction) |
| [top](#food--drink) | :bacon: | `:bacon:` | :hamburger: | `:hamburger:` | [top](#introduction) |
| [top](#food--drink) | :fries: | `:fries:` | :pizza: | `:pizza:` | [top](#introduction) |
| [top](#food--drink) | :hotdog: | `:hotdog:` | :sandwich: | `:sandwich:` | [top](#introduction) |
| [top](#food--drink) | :taco: | `:taco:` | :burrito: | `:burrito:` | [top](#introduction) |
| [top](#food--drink) | :tamale: | `:tamale:` | :stuffed_flatbread: | `:stuffed_flatbread:` | [top](#introduction) |
| [top](#food--drink) | :falafel: | `:falafel:` | :egg: | `:egg:` | [top](#introduction) |
| [top](#food--drink) | :fried_egg: | `:fried_egg:` | :shallow_pan_of_food: | `:shallow_pan_of_food:` | [top](#introduction) |
| [top](#food--drink) | :stew: | `:stew:` | :fondue: | `:fondue:` | [top](#introduction) |
| [top](#food--drink) | :bowl_with_spoon: | `:bowl_with_spoon:` | :green_salad: | `:green_salad:` | [top](#introduction) |
| [top](#food--drink) | :popcorn: | `:popcorn:` | :butter: | `:butter:` | [top](#introduction) |
| [top](#food--drink) | :salt: | `:salt:` | :canned_food: | `:canned_food:` | [top](#introduction) |

### Food Asian

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :bento: | `:bento:` | :rice_cracker: | `:rice_cracker:` | [top](#introduction) |
| [top](#food--drink) | :rice_ball: | `:rice_ball:` | :rice: | `:rice:` | [top](#introduction) |
| [top](#food--drink) | :curry: | `:curry:` | :ramen: | `:ramen:` | [top](#introduction) |
| [top](#food--drink) | :spaghetti: | `:spaghetti:` | :sweet_potato: | `:sweet_potato:` | [top](#introduction) |
| [top](#food--drink) | :oden: | `:oden:` | :sushi: | `:sushi:` | [top](#introduction) |
| [top](#food--drink) | :fried_shrimp: | `:fried_shrimp:` | :fish_cake: | `:fish_cake:` | [top](#introduction) |
| [top](#food--drink) | :moon_cake: | `:moon_cake:` | :dango: | `:dango:` | [top](#introduction) |
| [top](#food--drink) | :dumpling: | `:dumpling:` | :fortune_cookie: | `:fortune_cookie:` | [top](#introduction) |
| [top](#food--drink) | :takeout_box: | `:takeout_box:` | | | [top](#introduction) |

### Food Marine

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :crab: | `:crab:` | :lobster: | `:lobster:` | [top](#introduction) |
| [top](#food--drink) | :shrimp: | `:shrimp:` | :squid: | `:squid:` | [top](#introduction) |
| [top](#food--drink) | :oyster: | `:oyster:` | | | [top](#introduction) |

### Food Sweet

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :icecream: | `:icecream:` | :shaved_ice: | `:shaved_ice:` | [top](#introduction) |
| [top](#food--drink) | :ice_cream: | `:ice_cream:` | :doughnut: | `:doughnut:` | [top](#introduction) |
| [top](#food--drink) | :cookie: | `:cookie:` | :birthday: | `:birthday:` | [top](#introduction) |
| [top](#food--drink) | :cake: | `:cake:` | :cupcake: | `:cupcake:` | [top](#introduction) |
| [top](#food--drink) | :pie: | `:pie:` | :chocolate_bar: | `:chocolate_bar:` | [top](#introduction) |
| [top](#food--drink) | :candy: | `:candy:` | :lollipop: | `:lollipop:` | [top](#introduction) |
| [top](#food--drink) | :custard: | `:custard:` | :honey_pot: | `:honey_pot:` | [top](#introduction) |

### Drink

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :baby_bottle: | `:baby_bottle:` | :milk_glass: | `:milk_glass:` | [top](#introduction) |
| [top](#food--drink) | :coffee: | `:coffee:` | :teapot: | `:teapot:` | [top](#introduction) |
| [top](#food--drink) | :tea: | `:tea:` | :sake: | `:sake:` | [top](#introduction) |
| [top](#food--drink) | :champagne: | `:champagne:` | :wine_glass: | `:wine_glass:` | [top](#introduction) |
| [top](#food--drink) | :cocktail: | `:cocktail:` | :tropical_drink: | `:tropical_drink:` | [top](#introduction) |
| [top](#food--drink) | :beer: | `:beer:` | :beers: | `:beers:` | [top](#introduction) |
| [top](#food--drink) | :clinking_glasses: | `:clinking_glasses:` | :tumbler_glass: | `:tumbler_glass:` | [top](#introduction) |
| [top](#food--drink) | :cup_with_straw: | `:cup_with_straw:` | :bubble_tea: | `:bubble_tea:` | [top](#introduction) |
| [top](#food--drink) | :beverage_box: | `:beverage_box:` | :mate: | `:mate:` | [top](#introduction) |
| [top](#food--drink) | :ice_cube: | `:ice_cube:` | | | [top](#introduction) |

### Dishware

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#food--drink) | :chopsticks: | `:chopsticks:` | :plate_with_cutlery: | `:plate_with_cutlery:` | [top](#introduction) |
| [top](#food--drink) | :fork_and_knife: | `:fork_and_knife:` | :spoon: | `:spoon:` | [top](#introduction) |
| [top](#food--drink) | :hocho: | `:hocho:` `:knife:` | :amphora: | `:amphora:` | [top](#introduction) |

## Travel & Places

- [Place Map](#place-map)
- [Place Geographic](#place-geographic)
- [Place Building](#place-building)
- [Place Religious](#place-religious)
- [Place Other](#place-other)
- [Transport Ground](#transport-ground)
- [Transport Water](#transport-water)
- [Transport Air](#transport-air)
- [Hotel](#hotel)
- [Time](#time)
- [Sky & Weather](#sky--weather)

### Place Map

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :earth_africa: | `:earth_africa:` | :earth_americas: | `:earth_americas:` | [top](#introduction) |
| [top](#travel--places) | :earth_asia: | `:earth_asia:` | :globe_with_meridians: | `:globe_with_meridians:` | [top](#introduction) |
| [top](#travel--places) | :world_map: | `:world_map:` | :japan: | `:japan:` | [top](#introduction) |
| [top](#travel--places) | :compass: | `:compass:` | | | [top](#introduction) |

### Place Geographic

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :mountain_snow: | `:mountain_snow:` | :mountain: | `:mountain:` | [top](#introduction) |
| [top](#travel--places) | :volcano: | `:volcano:` | :mount_fuji: | `:mount_fuji:` | [top](#introduction) |
| [top](#travel--places) | :camping: | `:camping:` | :beach_umbrella: | `:beach_umbrella:` | [top](#introduction) |
| [top](#travel--places) | :desert: | `:desert:` | :desert_island: | `:desert_island:` | [top](#introduction) |
| [top](#travel--places) | :national_park: | `:national_park:` | | | [top](#introduction) |

### Place Building

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :stadium: | `:stadium:` | :classical_building: | `:classical_building:` | [top](#introduction) |
| [top](#travel--places) | :building_construction: | `:building_construction:` | :bricks: | `:bricks:` | [top](#introduction) |
| [top](#travel--places) | :rock: | `:rock:` | :wood: | `:wood:` | [top](#introduction) |
| [top](#travel--places) | :hut: | `:hut:` | :houses: | `:houses:` | [top](#introduction) |
| [top](#travel--places) | :derelict_house: | `:derelict_house:` | :house: | `:house:` | [top](#introduction) |
| [top](#travel--places) | :house_with_garden: | `:house_with_garden:` | :office: | `:office:` | [top](#introduction) |
| [top](#travel--places) | :post_office: | `:post_office:` | :european_post_office: | `:european_post_office:` | [top](#introduction) |
| [top](#travel--places) | :hospital: | `:hospital:` | :bank: | `:bank:` | [top](#introduction) |
| [top](#travel--places) | :hotel: | `:hotel:` | :love_hotel: | `:love_hotel:` | [top](#introduction) |
| [top](#travel--places) | :convenience_store: | `:convenience_store:` | :school: | `:school:` | [top](#introduction) |
| [top](#travel--places) | :department_store: | `:department_store:` | :factory: | `:factory:` | [top](#introduction) |
| [top](#travel--places) | :japanese_castle: | `:japanese_castle:` | :european_castle: | `:european_castle:` | [top](#introduction) |
| [top](#travel--places) | :wedding: | `:wedding:` | :tokyo_tower: | `:tokyo_tower:` | [top](#introduction) |
| [top](#travel--places) | :statue_of_liberty: | `:statue_of_liberty:` | | | [top](#introduction) |

### Place Religious

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :church: | `:church:` | :mosque: | `:mosque:` | [top](#introduction) |
| [top](#travel--places) | :hindu_temple: | `:hindu_temple:` | :synagogue: | `:synagogue:` | [top](#introduction) |
| [top](#travel--places) | :shinto_shrine: | `:shinto_shrine:` | :kaaba: | `:kaaba:` | [top](#introduction) |

### Place Other

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :fountain: | `:fountain:` | :tent: | `:tent:` | [top](#introduction) |
| [top](#travel--places) | :foggy: | `:foggy:` | :night_with_stars: | `:night_with_stars:` | [top](#introduction) |
| [top](#travel--places) | :cityscape: | `:cityscape:` | :sunrise_over_mountains: | `:sunrise_over_mountains:` | [top](#introduction) |
| [top](#travel--places) | :sunrise: | `:sunrise:` | :city_sunset: | `:city_sunset:` | [top](#introduction) |
| [top](#travel--places) | :city_sunrise: | `:city_sunrise:` | :bridge_at_night: | `:bridge_at_night:` | [top](#introduction) |
| [top](#travel--places) | :hotsprings: | `:hotsprings:` | :carousel_horse: | `:carousel_horse:` | [top](#introduction) |
| [top](#travel--places) | :ferris_wheel: | `:ferris_wheel:` | :roller_coaster: | `:roller_coaster:` | [top](#introduction) |
| [top](#travel--places) | :barber: | `:barber:` | :circus_tent: | `:circus_tent:` | [top](#introduction) |

### Transport Ground

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :steam_locomotive: | `:steam_locomotive:` | :railway_car: | `:railway_car:` | [top](#introduction) |
| [top](#travel--places) | :bullettrain_side: | `:bullettrain_side:` | :bullettrain_front: | `:bullettrain_front:` | [top](#introduction) |
| [top](#travel--places) | :train2: | `:train2:` | :metro: | `:metro:` | [top](#introduction) |
| [top](#travel--places) | :light_rail: | `:light_rail:` | :station: | `:station:` | [top](#introduction) |
| [top](#travel--places) | :tram: | `:tram:` | :monorail: | `:monorail:` | [top](#introduction) |
| [top](#travel--places) | :mountain_railway: | `:mountain_railway:` | :train: | `:train:` | [top](#introduction) |
| [top](#travel--places) | :bus: | `:bus:` | :oncoming_bus: | `:oncoming_bus:` | [top](#introduction) |
| [top](#travel--places) | :trolleybus: | `:trolleybus:` | :minibus: | `:minibus:` | [top](#introduction) |
| [top](#travel--places) | :ambulance: | `:ambulance:` | :fire_engine: | `:fire_engine:` | [top](#introduction) |
| [top](#travel--places) | :police_car: | `:police_car:` | :oncoming_police_car: | `:oncoming_police_car:` | [top](#introduction) |
| [top](#travel--places) | :taxi: | `:taxi:` | :oncoming_taxi: | `:oncoming_taxi:` | [top](#introduction) |
| [top](#travel--places) | :car: | `:car:` `:red_car:` | :oncoming_automobile: | `:oncoming_automobile:` | [top](#introduction) |
| [top](#travel--places) | :blue_car: | `:blue_car:` | :pickup_truck: | `:pickup_truck:` | [top](#introduction) |
| [top](#travel--places) | :truck: | `:truck:` | :articulated_lorry: | `:articulated_lorry:` | [top](#introduction) |
| [top](#travel--places) | :tractor: | `:tractor:` | :racing_car: | `:racing_car:` | [top](#introduction) |
| [top](#travel--places) | :motorcycle: | `:motorcycle:` | :motor_scooter: | `:motor_scooter:` | [top](#introduction) |
| [top](#travel--places) | :manual_wheelchair: | `:manual_wheelchair:` | :motorized_wheelchair: | `:motorized_wheelchair:` | [top](#introduction) |
| [top](#travel--places) | :auto_rickshaw: | `:auto_rickshaw:` | :bike: | `:bike:` | [top](#introduction) |
| [top](#travel--places) | :kick_scooter: | `:kick_scooter:` | :skateboard: | `:skateboard:` | [top](#introduction) |
| [top](#travel--places) | :roller_skate: | `:roller_skate:` | :busstop: | `:busstop:` | [top](#introduction) |
| [top](#travel--places) | :motorway: | `:motorway:` | :railway_track: | `:railway_track:` | [top](#introduction) |
| [top](#travel--places) | :oil_drum: | `:oil_drum:` | :fuelpump: | `:fuelpump:` | [top](#introduction) |
| [top](#travel--places) | :rotating_light: | `:rotating_light:` | :traffic_light: | `:traffic_light:` | [top](#introduction) |
| [top](#travel--places) | :vertical_traffic_light: | `:vertical_traffic_light:` | :stop_sign: | `:stop_sign:` | [top](#introduction) |
| [top](#travel--places) | :construction: | `:construction:` | | | [top](#introduction) |

### Transport Water

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :anchor: | `:anchor:` | :boat: | `:boat:` `:sailboat:` | [top](#introduction) |
| [top](#travel--places) | :canoe: | `:canoe:` | :speedboat: | `:speedboat:` | [top](#introduction) |
| [top](#travel--places) | :passenger_ship: | `:passenger_ship:` | :ferry: | `:ferry:` | [top](#introduction) |
| [top](#travel--places) | :motor_boat: | `:motor_boat:` | :ship: | `:ship:` | [top](#introduction) |

### Transport Air

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :airplane: | `:airplane:` | :small_airplane: | `:small_airplane:` | [top](#introduction) |
| [top](#travel--places) | :flight_departure: | `:flight_departure:` | :flight_arrival: | `:flight_arrival:` | [top](#introduction) |
| [top](#travel--places) | :parachute: | `:parachute:` | :seat: | `:seat:` | [top](#introduction) |
| [top](#travel--places) | :helicopter: | `:helicopter:` | :suspension_railway: | `:suspension_railway:` | [top](#introduction) |
| [top](#travel--places) | :mountain_cableway: | `:mountain_cableway:` | :aerial_tramway: | `:aerial_tramway:` | [top](#introduction) |
| [top](#travel--places) | :artificial_satellite: | `:artificial_satellite:` | :rocket: | `:rocket:` | [top](#introduction) |
| [top](#travel--places) | :flying_saucer: | `:flying_saucer:` | | | [top](#introduction) |

### Hotel

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :bellhop_bell: | `:bellhop_bell:` | :luggage: | `:luggage:` | [top](#introduction) |

### Time

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :hourglass: | `:hourglass:` | :hourglass_flowing_sand: | `:hourglass_flowing_sand:` | [top](#introduction) |
| [top](#travel--places) | :watch: | `:watch:` | :alarm_clock: | `:alarm_clock:` | [top](#introduction) |
| [top](#travel--places) | :stopwatch: | `:stopwatch:` | :timer_clock: | `:timer_clock:` | [top](#introduction) |
| [top](#travel--places) | :mantelpiece_clock: | `:mantelpiece_clock:` | :clock12: | `:clock12:` | [top](#introduction) |
| [top](#travel--places) | :clock1230: | `:clock1230:` | :clock1: | `:clock1:` | [top](#introduction) |
| [top](#travel--places) | :clock130: | `:clock130:` | :clock2: | `:clock2:` | [top](#introduction) |
| [top](#travel--places) | :clock230: | `:clock230:` | :clock3: | `:clock3:` | [top](#introduction) |
| [top](#travel--places) | :clock330: | `:clock330:` | :clock4: | `:clock4:` | [top](#introduction) |
| [top](#travel--places) | :clock430: | `:clock430:` | :clock5: | `:clock5:` | [top](#introduction) |
| [top](#travel--places) | :clock530: | `:clock530:` | :clock6: | `:clock6:` | [top](#introduction) |
| [top](#travel--places) | :clock630: | `:clock630:` | :clock7: | `:clock7:` | [top](#introduction) |
| [top](#travel--places) | :clock730: | `:clock730:` | :clock8: | `:clock8:` | [top](#introduction) |
| [top](#travel--places) | :clock830: | `:clock830:` | :clock9: | `:clock9:` | [top](#introduction) |
| [top](#travel--places) | :clock930: | `:clock930:` | :clock10: | `:clock10:` | [top](#introduction) |
| [top](#travel--places) | :clock1030: | `:clock1030:` | :clock11: | `:clock11:` | [top](#introduction) |
| [top](#travel--places) | :clock1130: | `:clock1130:` | | | [top](#introduction) |

### Sky & Weather

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#travel--places) | :new_moon: | `:new_moon:` | :waxing_crescent_moon: | `:waxing_crescent_moon:` | [top](#introduction) |
| [top](#travel--places) | :first_quarter_moon: | `:first_quarter_moon:` | :moon: | `:moon:` `:waxing_gibbous_moon:` | [top](#introduction) |
| [top](#travel--places) | :full_moon: | `:full_moon:` | :waning_gibbous_moon: | `:waning_gibbous_moon:` | [top](#introduction) |
| [top](#travel--places) | :last_quarter_moon: | `:last_quarter_moon:` | :waning_crescent_moon: | `:waning_crescent_moon:` | [top](#introduction) |
| [top](#travel--places) | :crescent_moon: | `:crescent_moon:` | :new_moon_with_face: | `:new_moon_with_face:` | [top](#introduction) |
| [top](#travel--places) | :first_quarter_moon_with_face: | `:first_quarter_moon_with_face:` | :last_quarter_moon_with_face: | `:last_quarter_moon_with_face:` | [top](#introduction) |
| [top](#travel--places) | :thermometer: | `:thermometer:` | :sunny: | `:sunny:` | [top](#introduction) |
| [top](#travel--places) | :full_moon_with_face: | `:full_moon_with_face:` | :sun_with_face: | `:sun_with_face:` | [top](#introduction) |
| [top](#travel--places) | :ringed_planet: | `:ringed_planet:` | :star: | `:star:` | [top](#introduction) |
| [top](#travel--places) | :star2: | `:star2:` | :stars: | `:stars:` | [top](#introduction) |
| [top](#travel--places) | :milky_way: | `:milky_way:` | :cloud: | `:cloud:` | [top](#introduction) |
| [top](#travel--places) | :partly_sunny: | `:partly_sunny:` | :cloud_with_lightning_and_rain: | `:cloud_with_lightning_and_rain:` | [top](#introduction) |
| [top](#travel--places) | :sun_behind_small_cloud: | `:sun_behind_small_cloud:` | :sun_behind_large_cloud: | `:sun_behind_large_cloud:` | [top](#introduction) |
| [top](#travel--places) | :sun_behind_rain_cloud: | `:sun_behind_rain_cloud:` | :cloud_with_rain: | `:cloud_with_rain:` | [top](#introduction) |
| [top](#travel--places) | :cloud_with_snow: | `:cloud_with_snow:` | :cloud_with_lightning: | `:cloud_with_lightning:` | [top](#introduction) |
| [top](#travel--places) | :tornado: | `:tornado:` | :fog: | `:fog:` | [top](#introduction) |
| [top](#travel--places) | :wind_face: | `:wind_face:` | :cyclone: | `:cyclone:` | [top](#introduction) |
| [top](#travel--places) | :rainbow: | `:rainbow:` | :closed_umbrella: | `:closed_umbrella:` | [top](#introduction) |
| [top](#travel--places) | :open_umbrella: | `:open_umbrella:` | :umbrella: | `:umbrella:` | [top](#introduction) |
| [top](#travel--places) | :parasol_on_ground: | `:parasol_on_ground:` | :zap: | `:zap:` | [top](#introduction) |
| [top](#travel--places) | :snowflake: | `:snowflake:` | :snowman_with_snow: | `:snowman_with_snow:` | [top](#introduction) |
| [top](#travel--places) | :snowman: | `:snowman:` | :comet: | `:comet:` | [top](#introduction) |
| [top](#travel--places) | :fire: | `:fire:` | :droplet: | `:droplet:` | [top](#introduction) |
| [top](#travel--places) | :ocean: | `:ocean:` | | | [top](#introduction) |

## Activities

- [Event](#event)
- [Award Medal](#award-medal)
- [Sport](#sport)
- [Game](#game)
- [Arts & Crafts](#arts--crafts)

### Event

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#activities) | :jack_o_lantern: | `:jack_o_lantern:` | :christmas_tree: | `:christmas_tree:` | [top](#introduction) |
| [top](#activities) | :fireworks: | `:fireworks:` | :sparkler: | `:sparkler:` | [top](#introduction) |
| [top](#activities) | :firecracker: | `:firecracker:` | :sparkles: | `:sparkles:` | [top](#introduction) |
| [top](#activities) | :balloon: | `:balloon:` | :tada: | `:tada:` | [top](#introduction) |
| [top](#activities) | :confetti_ball: | `:confetti_ball:` | :tanabata_tree: | `:tanabata_tree:` | [top](#introduction) |
| [top](#activities) | :bamboo: | `:bamboo:` | :dolls: | `:dolls:` | [top](#introduction) |
| [top](#activities) | :flags: | `:flags:` | :wind_chime: | `:wind_chime:` | [top](#introduction) |
| [top](#activities) | :rice_scene: | `:rice_scene:` | :red_envelope: | `:red_envelope:` | [top](#introduction) |
| [top](#activities) | :ribbon: | `:ribbon:` | :gift: | `:gift:` | [top](#introduction) |
| [top](#activities) | :reminder_ribbon: | `:reminder_ribbon:` | :tickets: | `:tickets:` | [top](#introduction) |
| [top](#activities) | :ticket: | `:ticket:` | | | [top](#introduction) |

### Award Medal

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#activities) | :medal_military: | `:medal_military:` | :trophy: | `:trophy:` | [top](#introduction) |
| [top](#activities) | :medal_sports: | `:medal_sports:` | :1st_place_medal: | `:1st_place_medal:` | [top](#introduction) |
| [top](#activities) | :2nd_place_medal: | `:2nd_place_medal:` | :3rd_place_medal: | `:3rd_place_medal:` | [top](#introduction) |

### Sport

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#activities) | :soccer: | `:soccer:` | :baseball: | `:baseball:` | [top](#introduction) |
| [top](#activities) | :softball: | `:softball:` | :basketball: | `:basketball:` | [top](#introduction) |
| [top](#activities) | :volleyball: | `:volleyball:` | :football: | `:football:` | [top](#introduction) |
| [top](#activities) | :rugby_football: | `:rugby_football:` | :tennis: | `:tennis:` | [top](#introduction) |
| [top](#activities) | :flying_disc: | `:flying_disc:` | :bowling: | `:bowling:` | [top](#introduction) |
| [top](#activities) | :cricket_game: | `:cricket_game:` | :field_hockey: | `:field_hockey:` | [top](#introduction) |
| [top](#activities) | :ice_hockey: | `:ice_hockey:` | :lacrosse: | `:lacrosse:` | [top](#introduction) |
| [top](#activities) | :ping_pong: | `:ping_pong:` | :badminton: | `:badminton:` | [top](#introduction) |
| [top](#activities) | :boxing_glove: | `:boxing_glove:` | :martial_arts_uniform: | `:martial_arts_uniform:` | [top](#introduction) |
| [top](#activities) | :goal_net: | `:goal_net:` | :golf: | `:golf:` | [top](#introduction) |
| [top](#activities) | :ice_skate: | `:ice_skate:` | :fishing_pole_and_fish: | `:fishing_pole_and_fish:` | [top](#introduction) |
| [top](#activities) | :diving_mask: | `:diving_mask:` | :running_shirt_with_sash: | `:running_shirt_with_sash:` | [top](#introduction) |
| [top](#activities) | :ski: | `:ski:` | :sled: | `:sled:` | [top](#introduction) |
| [top](#activities) | :curling_stone: | `:curling_stone:` | | | [top](#introduction) |

### Game

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#activities) | :dart: | `:dart:` | :yo_yo: | `:yo_yo:` | [top](#introduction) |
| [top](#activities) | :kite: | `:kite:` | :gun: | `:gun:` | [top](#introduction) |
| [top](#activities) | :8ball: | `:8ball:` | :crystal_ball: | `:crystal_ball:` | [top](#introduction) |
| [top](#activities) | :magic_wand: | `:magic_wand:` | :video_game: | `:video_game:` | [top](#introduction) |
| [top](#activities) | :joystick: | `:joystick:` | :slot_machine: | `:slot_machine:` | [top](#introduction) |
| [top](#activities) | :game_die: | `:game_die:` | :jigsaw: | `:jigsaw:` | [top](#introduction) |
| [top](#activities) | :teddy_bear: | `:teddy_bear:` | :pinata: | `:pinata:` | [top](#introduction) |
| [top](#activities) | :nesting_dolls: | `:nesting_dolls:` | :spades: | `:spades:` | [top](#introduction) |
| [top](#activities) | :hearts: | `:hearts:` | :diamonds: | `:diamonds:` | [top](#introduction) |
| [top](#activities) | :clubs: | `:clubs:` | :chess_pawn: | `:chess_pawn:` | [top](#introduction) |
| [top](#activities) | :black_joker: | `:black_joker:` | :mahjong: | `:mahjong:` | [top](#introduction) |
| [top](#activities) | :flower_playing_cards: | `:flower_playing_cards:` | | | [top](#introduction) |

### Arts & Crafts

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#activities) | :performing_arts: | `:performing_arts:` | :framed_picture: | `:framed_picture:` | [top](#introduction) |
| [top](#activities) | :art: | `:art:` | :thread: | `:thread:` | [top](#introduction) |
| [top](#activities) | :sewing_needle: | `:sewing_needle:` | :yarn: | `:yarn:` | [top](#introduction) |
| [top](#activities) | :knot: | `:knot:` | | | [top](#introduction) |

## Objects

- [Clothing](#clothing)
- [Sound](#sound)
- [Music](#music)
- [Musical Instrument](#musical-instrument)
- [Phone](#phone)
- [Computer](#computer)
- [Light & Video](#light--video)
- [Book Paper](#book-paper)
- [Money](#money)
- [Mail](#mail)
- [Writing](#writing)
- [Office](#office)
- [Lock](#lock)
- [Tool](#tool)
- [Science](#science)
- [Medical](#medical)
- [Household](#household)
- [Other Object](#other-object)

### Clothing

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :eyeglasses: | `:eyeglasses:` | :dark_sunglasses: | `:dark_sunglasses:` | [top](#introduction) |
| [top](#objects) | :goggles: | `:goggles:` | :lab_coat: | `:lab_coat:` | [top](#introduction) |
| [top](#objects) | :safety_vest: | `:safety_vest:` | :necktie: | `:necktie:` | [top](#introduction) |
| [top](#objects) | :shirt: | `:shirt:` `:tshirt:` | :jeans: | `:jeans:` | [top](#introduction) |
| [top](#objects) | :scarf: | `:scarf:` | :gloves: | `:gloves:` | [top](#introduction) |
| [top](#objects) | :coat: | `:coat:` | :socks: | `:socks:` | [top](#introduction) |
| [top](#objects) | :dress: | `:dress:` | :kimono: | `:kimono:` | [top](#introduction) |
| [top](#objects) | :sari: | `:sari:` | :one_piece_swimsuit: | `:one_piece_swimsuit:` | [top](#introduction) |
| [top](#objects) | :swim_brief: | `:swim_brief:` | :shorts: | `:shorts:` | [top](#introduction) |
| [top](#objects) | :bikini: | `:bikini:` | :womans_clothes: | `:womans_clothes:` | [top](#introduction) |
| [top](#objects) | :purse: | `:purse:` | :handbag: | `:handbag:` | [top](#introduction) |
| [top](#objects) | :pouch: | `:pouch:` | :shopping: | `:shopping:` | [top](#introduction) |
| [top](#objects) | :school_satchel: | `:school_satchel:` | :thong_sandal: | `:thong_sandal:` | [top](#introduction) |
| [top](#objects) | :mans_shoe: | `:mans_shoe:` `:shoe:` | :athletic_shoe: | `:athletic_shoe:` | [top](#introduction) |
| [top](#objects) | :hiking_boot: | `:hiking_boot:` | :flat_shoe: | `:flat_shoe:` | [top](#introduction) |
| [top](#objects) | :high_heel: | `:high_heel:` | :sandal: | `:sandal:` | [top](#introduction) |
| [top](#objects) | :ballet_shoes: | `:ballet_shoes:` | :boot: | `:boot:` | [top](#introduction) |
| [top](#objects) | :crown: | `:crown:` | :womans_hat: | `:womans_hat:` | [top](#introduction) |
| [top](#objects) | :tophat: | `:tophat:` | :mortar_board: | `:mortar_board:` | [top](#introduction) |
| [top](#objects) | :billed_cap: | `:billed_cap:` | :military_helmet: | `:military_helmet:` | [top](#introduction) |
| [top](#objects) | :rescue_worker_helmet: | `:rescue_worker_helmet:` | :prayer_beads: | `:prayer_beads:` | [top](#introduction) |
| [top](#objects) | :lipstick: | `:lipstick:` | :ring: | `:ring:` | [top](#introduction) |
| [top](#objects) | :gem: | `:gem:` | | | [top](#introduction) |

### Sound

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :mute: | `:mute:` | :speaker: | `:speaker:` | [top](#introduction) |
| [top](#objects) | :sound: | `:sound:` | :loud_sound: | `:loud_sound:` | [top](#introduction) |
| [top](#objects) | :loudspeaker: | `:loudspeaker:` | :mega: | `:mega:` | [top](#introduction) |
| [top](#objects) | :postal_horn: | `:postal_horn:` | :bell: | `:bell:` | [top](#introduction) |
| [top](#objects) | :no_bell: | `:no_bell:` | | | [top](#introduction) |

### Music

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :musical_score: | `:musical_score:` | :musical_note: | `:musical_note:` | [top](#introduction) |
| [top](#objects) | :notes: | `:notes:` | :studio_microphone: | `:studio_microphone:` | [top](#introduction) |
| [top](#objects) | :level_slider: | `:level_slider:` | :control_knobs: | `:control_knobs:` | [top](#introduction) |
| [top](#objects) | :microphone: | `:microphone:` | :headphones: | `:headphones:` | [top](#introduction) |
| [top](#objects) | :radio: | `:radio:` | | | [top](#introduction) |

### Musical Instrument

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :saxophone: | `:saxophone:` | :accordion: | `:accordion:` | [top](#introduction) |
| [top](#objects) | :guitar: | `:guitar:` | :musical_keyboard: | `:musical_keyboard:` | [top](#introduction) |
| [top](#objects) | :trumpet: | `:trumpet:` | :violin: | `:violin:` | [top](#introduction) |
| [top](#objects) | :banjo: | `:banjo:` | :drum: | `:drum:` | [top](#introduction) |
| [top](#objects) | :long_drum: | `:long_drum:` | | | [top](#introduction) |

### Phone

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :iphone: | `:iphone:` | :calling: | `:calling:` | [top](#introduction) |
| [top](#objects) | :phone: | `:phone:` `:telephone:` | :telephone_receiver: | `:telephone_receiver:` | [top](#introduction) |
| [top](#objects) | :pager: | `:pager:` | :fax: | `:fax:` | [top](#introduction) |

### Computer

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :battery: | `:battery:` | :electric_plug: | `:electric_plug:` | [top](#introduction) |
| [top](#objects) | :computer: | `:computer:` | :desktop_computer: | `:desktop_computer:` | [top](#introduction) |
| [top](#objects) | :printer: | `:printer:` | :keyboard: | `:keyboard:` | [top](#introduction) |
| [top](#objects) | :computer_mouse: | `:computer_mouse:` | :trackball: | `:trackball:` | [top](#introduction) |
| [top](#objects) | :minidisc: | `:minidisc:` | :floppy_disk: | `:floppy_disk:` | [top](#introduction) |
| [top](#objects) | :cd: | `:cd:` | :dvd: | `:dvd:` | [top](#introduction) |
| [top](#objects) | :abacus: | `:abacus:` | | | [top](#introduction) |

### Light & Video

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :movie_camera: | `:movie_camera:` | :film_strip: | `:film_strip:` | [top](#introduction) |
| [top](#objects) | :film_projector: | `:film_projector:` | :clapper: | `:clapper:` | [top](#introduction) |
| [top](#objects) | :tv: | `:tv:` | :camera: | `:camera:` | [top](#introduction) |
| [top](#objects) | :camera_flash: | `:camera_flash:` | :video_camera: | `:video_camera:` | [top](#introduction) |
| [top](#objects) | :vhs: | `:vhs:` | :mag: | `:mag:` | [top](#introduction) |
| [top](#objects) | :mag_right: | `:mag_right:` | :candle: | `:candle:` | [top](#introduction) |
| [top](#objects) | :bulb: | `:bulb:` | :flashlight: | `:flashlight:` | [top](#introduction) |
| [top](#objects) | :izakaya_lantern: | `:izakaya_lantern:` `:lantern:` | :diya_lamp: | `:diya_lamp:` | [top](#introduction) |

### Book Paper

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :notebook_with_decorative_cover: | `:notebook_with_decorative_cover:` | :closed_book: | `:closed_book:` | [top](#introduction) |
| [top](#objects) | :book: | `:book:` `:open_book:` | :green_book: | `:green_book:` | [top](#introduction) |
| [top](#objects) | :blue_book: | `:blue_book:` | :orange_book: | `:orange_book:` | [top](#introduction) |
| [top](#objects) | :books: | `:books:` | :notebook: | `:notebook:` | [top](#introduction) |
| [top](#objects) | :ledger: | `:ledger:` | :page_with_curl: | `:page_with_curl:` | [top](#introduction) |
| [top](#objects) | :scroll: | `:scroll:` | :page_facing_up: | `:page_facing_up:` | [top](#introduction) |
| [top](#objects) | :newspaper: | `:newspaper:` | :newspaper_roll: | `:newspaper_roll:` | [top](#introduction) |
| [top](#objects) | :bookmark_tabs: | `:bookmark_tabs:` | :bookmark: | `:bookmark:` | [top](#introduction) |
| [top](#objects) | :label: | `:label:` | | | [top](#introduction) |

### Money

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :moneybag: | `:moneybag:` | :coin: | `:coin:` | [top](#introduction) |
| [top](#objects) | :yen: | `:yen:` | :dollar: | `:dollar:` | [top](#introduction) |
| [top](#objects) | :euro: | `:euro:` | :pound: | `:pound:` | [top](#introduction) |
| [top](#objects) | :money_with_wings: | `:money_with_wings:` | :credit_card: | `:credit_card:` | [top](#introduction) |
| [top](#objects) | :receipt: | `:receipt:` | :chart: | `:chart:` | [top](#introduction) |

### Mail

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :envelope: | `:envelope:` | :e-mail: | `:e-mail:` `:email:` | [top](#introduction) |
| [top](#objects) | :incoming_envelope: | `:incoming_envelope:` | :envelope_with_arrow: | `:envelope_with_arrow:` | [top](#introduction) |
| [top](#objects) | :outbox_tray: | `:outbox_tray:` | :inbox_tray: | `:inbox_tray:` | [top](#introduction) |
| [top](#objects) | :package: | `:package:` | :mailbox: | `:mailbox:` | [top](#introduction) |
| [top](#objects) | :mailbox_closed: | `:mailbox_closed:` | :mailbox_with_mail: | `:mailbox_with_mail:` | [top](#introduction) |
| [top](#objects) | :mailbox_with_no_mail: | `:mailbox_with_no_mail:` | :postbox: | `:postbox:` | [top](#introduction) |
| [top](#objects) | :ballot_box: | `:ballot_box:` | | | [top](#introduction) |

### Writing

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :pencil2: | `:pencil2:` | :black_nib: | `:black_nib:` | [top](#introduction) |
| [top](#objects) | :fountain_pen: | `:fountain_pen:` | :pen: | `:pen:` | [top](#introduction) |
| [top](#objects) | :paintbrush: | `:paintbrush:` | :crayon: | `:crayon:` | [top](#introduction) |
| [top](#objects) | :memo: | `:memo:` `:pencil:` | | | [top](#introduction) |

### Office

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :briefcase: | `:briefcase:` | :file_folder: | `:file_folder:` | [top](#introduction) |
| [top](#objects) | :open_file_folder: | `:open_file_folder:` | :card_index_dividers: | `:card_index_dividers:` | [top](#introduction) |
| [top](#objects) | :date: | `:date:` | :calendar: | `:calendar:` | [top](#introduction) |
| [top](#objects) | :spiral_notepad: | `:spiral_notepad:` | :spiral_calendar: | `:spiral_calendar:` | [top](#introduction) |
| [top](#objects) | :card_index: | `:card_index:` | :chart_with_upwards_trend: | `:chart_with_upwards_trend:` | [top](#introduction) |
| [top](#objects) | :chart_with_downwards_trend: | `:chart_with_downwards_trend:` | :bar_chart: | `:bar_chart:` | [top](#introduction) |
| [top](#objects) | :clipboard: | `:clipboard:` | :pushpin: | `:pushpin:` | [top](#introduction) |
| [top](#objects) | :round_pushpin: | `:round_pushpin:` | :paperclip: | `:paperclip:` | [top](#introduction) |
| [top](#objects) | :paperclips: | `:paperclips:` | :straight_ruler: | `:straight_ruler:` | [top](#introduction) |
| [top](#objects) | :triangular_ruler: | `:triangular_ruler:` | :scissors: | `:scissors:` | [top](#introduction) |
| [top](#objects) | :card_file_box: | `:card_file_box:` | :file_cabinet: | `:file_cabinet:` | [top](#introduction) |
| [top](#objects) | :wastebasket: | `:wastebasket:` | | | [top](#introduction) |

### Lock

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :lock: | `:lock:` | :unlock: | `:unlock:` | [top](#introduction) |
| [top](#objects) | :lock_with_ink_pen: | `:lock_with_ink_pen:` | :closed_lock_with_key: | `:closed_lock_with_key:` | [top](#introduction) |
| [top](#objects) | :key: | `:key:` | :old_key: | `:old_key:` | [top](#introduction) |

### Tool

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :hammer: | `:hammer:` | :axe: | `:axe:` | [top](#introduction) |
| [top](#objects) | :pick: | `:pick:` | :hammer_and_pick: | `:hammer_and_pick:` | [top](#introduction) |
| [top](#objects) | :hammer_and_wrench: | `:hammer_and_wrench:` | :dagger: | `:dagger:` | [top](#introduction) |
| [top](#objects) | :crossed_swords: | `:crossed_swords:` | :bomb: | `:bomb:` | [top](#introduction) |
| [top](#objects) | :boomerang: | `:boomerang:` | :bow_and_arrow: | `:bow_and_arrow:` | [top](#introduction) |
| [top](#objects) | :shield: | `:shield:` | :carpentry_saw: | `:carpentry_saw:` | [top](#introduction) |
| [top](#objects) | :wrench: | `:wrench:` | :screwdriver: | `:screwdriver:` | [top](#introduction) |
| [top](#objects) | :nut_and_bolt: | `:nut_and_bolt:` | :gear: | `:gear:` | [top](#introduction) |
| [top](#objects) | :clamp: | `:clamp:` | :balance_scale: | `:balance_scale:` | [top](#introduction) |
| [top](#objects) | :probing_cane: | `:probing_cane:` | :link: | `:link:` | [top](#introduction) |
| [top](#objects) | :chains: | `:chains:` | :hook: | `:hook:` | [top](#introduction) |
| [top](#objects) | :toolbox: | `:toolbox:` | :magnet: | `:magnet:` | [top](#introduction) |
| [top](#objects) | :ladder: | `:ladder:` | | | [top](#introduction) |

### Science

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :alembic: | `:alembic:` | :test_tube: | `:test_tube:` | [top](#introduction) |
| [top](#objects) | :petri_dish: | `:petri_dish:` | :dna: | `:dna:` | [top](#introduction) |
| [top](#objects) | :microscope: | `:microscope:` | :telescope: | `:telescope:` | [top](#introduction) |
| [top](#objects) | :satellite: | `:satellite:` | | | [top](#introduction) |

### Medical

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :syringe: | `:syringe:` | :drop_of_blood: | `:drop_of_blood:` | [top](#introduction) |
| [top](#objects) | :pill: | `:pill:` | :adhesive_bandage: | `:adhesive_bandage:` | [top](#introduction) |
| [top](#objects) | :stethoscope: | `:stethoscope:` | | | [top](#introduction) |

### Household

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :door: | `:door:` | :elevator: | `:elevator:` | [top](#introduction) |
| [top](#objects) | :mirror: | `:mirror:` | :window: | `:window:` | [top](#introduction) |
| [top](#objects) | :bed: | `:bed:` | :couch_and_lamp: | `:couch_and_lamp:` | [top](#introduction) |
| [top](#objects) | :chair: | `:chair:` | :toilet: | `:toilet:` | [top](#introduction) |
| [top](#objects) | :plunger: | `:plunger:` | :shower: | `:shower:` | [top](#introduction) |
| [top](#objects) | :bathtub: | `:bathtub:` | :mouse_trap: | `:mouse_trap:` | [top](#introduction) |
| [top](#objects) | :razor: | `:razor:` | :lotion_bottle: | `:lotion_bottle:` | [top](#introduction) |
| [top](#objects) | :safety_pin: | `:safety_pin:` | :broom: | `:broom:` | [top](#introduction) |
| [top](#objects) | :basket: | `:basket:` | :roll_of_paper: | `:roll_of_paper:` | [top](#introduction) |
| [top](#objects) | :bucket: | `:bucket:` | :soap: | `:soap:` | [top](#introduction) |
| [top](#objects) | :toothbrush: | `:toothbrush:` | :sponge: | `:sponge:` | [top](#introduction) |
| [top](#objects) | :fire_extinguisher: | `:fire_extinguisher:` | :shopping_cart: | `:shopping_cart:` | [top](#introduction) |

### Other Object

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#objects) | :smoking: | `:smoking:` | :coffin: | `:coffin:` | [top](#introduction) |
| [top](#objects) | :headstone: | `:headstone:` | :funeral_urn: | `:funeral_urn:` | [top](#introduction) |
| [top](#objects) | :nazar_amulet: | `:nazar_amulet:` | :moyai: | `:moyai:` | [top](#introduction) |
| [top](#objects) | :placard: | `:placard:` | | | [top](#introduction) |

## Symbols

- [Transport Sign](#transport-sign)
- [Warning](#warning)
- [Arrow](#arrow)
- [Religion](#religion)
- [Zodiac](#zodiac)
- [Av Symbol](#av-symbol)
- [Gender](#gender)
- [Math](#math)
- [Punctuation](#punctuation)
- [Currency](#currency)
- [Other Symbol](#other-symbol)
- [Keycap](#keycap)
- [Alphanum](#alphanum)
- [Geometric](#geometric)

### Transport Sign

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :atm: | `:atm:` | :put_litter_in_its_place: | `:put_litter_in_its_place:` | [top](#introduction) |
| [top](#symbols) | :potable_water: | `:potable_water:` | :wheelchair: | `:wheelchair:` | [top](#introduction) |
| [top](#symbols) | :mens: | `:mens:` | :womens: | `:womens:` | [top](#introduction) |
| [top](#symbols) | :restroom: | `:restroom:` | :baby_symbol: | `:baby_symbol:` | [top](#introduction) |
| [top](#symbols) | :wc: | `:wc:` | :passport_control: | `:passport_control:` | [top](#introduction) |
| [top](#symbols) | :customs: | `:customs:` | :baggage_claim: | `:baggage_claim:` | [top](#introduction) |
| [top](#symbols) | :left_luggage: | `:left_luggage:` | | | [top](#introduction) |

### Warning

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :warning: | `:warning:` | :children_crossing: | `:children_crossing:` | [top](#introduction) |
| [top](#symbols) | :no_entry: | `:no_entry:` | :no_entry_sign: | `:no_entry_sign:` | [top](#introduction) |
| [top](#symbols) | :no_bicycles: | `:no_bicycles:` | :no_smoking: | `:no_smoking:` | [top](#introduction) |
| [top](#symbols) | :do_not_litter: | `:do_not_litter:` | :non-potable_water: | `:non-potable_water:` | [top](#introduction) |
| [top](#symbols) | :no_pedestrians: | `:no_pedestrians:` | :no_mobile_phones: | `:no_mobile_phones:` | [top](#introduction) |
| [top](#symbols) | :underage: | `:underage:` | :radioactive: | `:radioactive:` | [top](#introduction) |
| [top](#symbols) | :biohazard: | `:biohazard:` | | | [top](#introduction) |

### Arrow

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :arrow_up: | `:arrow_up:` | :arrow_upper_right: | `:arrow_upper_right:` | [top](#introduction) |
| [top](#symbols) | :arrow_right: | `:arrow_right:` | :arrow_lower_right: | `:arrow_lower_right:` | [top](#introduction) |
| [top](#symbols) | :arrow_down: | `:arrow_down:` | :arrow_lower_left: | `:arrow_lower_left:` | [top](#introduction) |
| [top](#symbols) | :arrow_left: | `:arrow_left:` | :arrow_upper_left: | `:arrow_upper_left:` | [top](#introduction) |
| [top](#symbols) | :arrow_up_down: | `:arrow_up_down:` | :left_right_arrow: | `:left_right_arrow:` | [top](#introduction) |
| [top](#symbols) | :leftwards_arrow_with_hook: | `:leftwards_arrow_with_hook:` | :arrow_right_hook: | `:arrow_right_hook:` | [top](#introduction) |
| [top](#symbols) | :arrow_heading_up: | `:arrow_heading_up:` | :arrow_heading_down: | `:arrow_heading_down:` | [top](#introduction) |
| [top](#symbols) | :arrows_clockwise: | `:arrows_clockwise:` | :arrows_counterclockwise: | `:arrows_counterclockwise:` | [top](#introduction) |
| [top](#symbols) | :back: | `:back:` | :end: | `:end:` | [top](#introduction) |
| [top](#symbols) | :on: | `:on:` | :soon: | `:soon:` | [top](#introduction) |
| [top](#symbols) | :top: | `:top:` | | | [top](#introduction) |

### Religion

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :place_of_worship: | `:place_of_worship:` | :atom_symbol: | `:atom_symbol:` | [top](#introduction) |
| [top](#symbols) | :om: | `:om:` | :star_of_david: | `:star_of_david:` | [top](#introduction) |
| [top](#symbols) | :wheel_of_dharma: | `:wheel_of_dharma:` | :yin_yang: | `:yin_yang:` | [top](#introduction) |
| [top](#symbols) | :latin_cross: | `:latin_cross:` | :orthodox_cross: | `:orthodox_cross:` | [top](#introduction) |
| [top](#symbols) | :star_and_crescent: | `:star_and_crescent:` | :peace_symbol: | `:peace_symbol:` | [top](#introduction) |
| [top](#symbols) | :menorah: | `:menorah:` | :six_pointed_star: | `:six_pointed_star:` | [top](#introduction) |

### Zodiac

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :aries: | `:aries:` | :taurus: | `:taurus:` | [top](#introduction) |
| [top](#symbols) | :gemini: | `:gemini:` | :cancer: | `:cancer:` | [top](#introduction) |
| [top](#symbols) | :leo: | `:leo:` | :virgo: | `:virgo:` | [top](#introduction) |
| [top](#symbols) | :libra: | `:libra:` | :scorpius: | `:scorpius:` | [top](#introduction) |
| [top](#symbols) | :sagittarius: | `:sagittarius:` | :capricorn: | `:capricorn:` | [top](#introduction) |
| [top](#symbols) | :aquarius: | `:aquarius:` | :pisces: | `:pisces:` | [top](#introduction) |
| [top](#symbols) | :ophiuchus: | `:ophiuchus:` | | | [top](#introduction) |

### Av Symbol

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :twisted_rightwards_arrows: | `:twisted_rightwards_arrows:` | :repeat: | `:repeat:` | [top](#introduction) |
| [top](#symbols) | :repeat_one: | `:repeat_one:` | :arrow_forward: | `:arrow_forward:` | [top](#introduction) |
| [top](#symbols) | :fast_forward: | `:fast_forward:` | :next_track_button: | `:next_track_button:` | [top](#introduction) |
| [top](#symbols) | :play_or_pause_button: | `:play_or_pause_button:` | :arrow_backward: | `:arrow_backward:` | [top](#introduction) |
| [top](#symbols) | :rewind: | `:rewind:` | :previous_track_button: | `:previous_track_button:` | [top](#introduction) |
| [top](#symbols) | :arrow_up_small: | `:arrow_up_small:` | :arrow_double_up: | `:arrow_double_up:` | [top](#introduction) |
| [top](#symbols) | :arrow_down_small: | `:arrow_down_small:` | :arrow_double_down: | `:arrow_double_down:` | [top](#introduction) |
| [top](#symbols) | :pause_button: | `:pause_button:` | :stop_button: | `:stop_button:` | [top](#introduction) |
| [top](#symbols) | :record_button: | `:record_button:` | :eject_button: | `:eject_button:` | [top](#introduction) |
| [top](#symbols) | :cinema: | `:cinema:` | :low_brightness: | `:low_brightness:` | [top](#introduction) |
| [top](#symbols) | :high_brightness: | `:high_brightness:` | :signal_strength: | `:signal_strength:` | [top](#introduction) |
| [top](#symbols) | :vibration_mode: | `:vibration_mode:` | :mobile_phone_off: | `:mobile_phone_off:` | [top](#introduction) |

### Gender

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :female_sign: | `:female_sign:` | :male_sign: | `:male_sign:` | [top](#introduction) |
| [top](#symbols) | :transgender_symbol: | `:transgender_symbol:` | | | [top](#introduction) |

### Math

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :heavy_multiplication_x: | `:heavy_multiplication_x:` | :heavy_plus_sign: | `:heavy_plus_sign:` | [top](#introduction) |
| [top](#symbols) | :heavy_minus_sign: | `:heavy_minus_sign:` | :heavy_division_sign: | `:heavy_division_sign:` | [top](#introduction) |
| [top](#symbols) | :infinity: | `:infinity:` | | | [top](#introduction) |

### Punctuation

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :bangbang: | `:bangbang:` | :interrobang: | `:interrobang:` | [top](#introduction) |
| [top](#symbols) | :question: | `:question:` | :grey_question: | `:grey_question:` | [top](#introduction) |
| [top](#symbols) | :grey_exclamation: | `:grey_exclamation:` | :exclamation: | `:exclamation:` `:heavy_exclamation_mark:` | [top](#introduction) |
| [top](#symbols) | :wavy_dash: | `:wavy_dash:` | | | [top](#introduction) |

### Currency

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :currency_exchange: | `:currency_exchange:` | :heavy_dollar_sign: | `:heavy_dollar_sign:` | [top](#introduction) |

### Other Symbol

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :medical_symbol: | `:medical_symbol:` | :recycle: | `:recycle:` | [top](#introduction) |
| [top](#symbols) | :fleur_de_lis: | `:fleur_de_lis:` | :trident: | `:trident:` | [top](#introduction) |
| [top](#symbols) | :name_badge: | `:name_badge:` | :beginner: | `:beginner:` | [top](#introduction) |
| [top](#symbols) | :o: | `:o:` | :white_check_mark: | `:white_check_mark:` | [top](#introduction) |
| [top](#symbols) | :ballot_box_with_check: | `:ballot_box_with_check:` | :heavy_check_mark: | `:heavy_check_mark:` | [top](#introduction) |
| [top](#symbols) | :x: | `:x:` | :negative_squared_cross_mark: | `:negative_squared_cross_mark:` | [top](#introduction) |
| [top](#symbols) | :curly_loop: | `:curly_loop:` | :loop: | `:loop:` | [top](#introduction) |
| [top](#symbols) | :part_alternation_mark: | `:part_alternation_mark:` | :eight_spoked_asterisk: | `:eight_spoked_asterisk:` | [top](#introduction) |
| [top](#symbols) | :eight_pointed_black_star: | `:eight_pointed_black_star:` | :sparkle: | `:sparkle:` | [top](#introduction) |
| [top](#symbols) | :copyright: | `:copyright:` | :registered: | `:registered:` | [top](#introduction) |
| [top](#symbols) | :tm: | `:tm:` | | | [top](#introduction) |

### Keycap

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :hash: | `:hash:` | :asterisk: | `:asterisk:` | [top](#introduction) |
| [top](#symbols) | :zero: | `:zero:` | :one: | `:one:` | [top](#introduction) |
| [top](#symbols) | :two: | `:two:` | :three: | `:three:` | [top](#introduction) |
| [top](#symbols) | :four: | `:four:` | :five: | `:five:` | [top](#introduction) |
| [top](#symbols) | :six: | `:six:` | :seven: | `:seven:` | [top](#introduction) |
| [top](#symbols) | :eight: | `:eight:` | :nine: | `:nine:` | [top](#introduction) |
| [top](#symbols) | :keycap_ten: | `:keycap_ten:` | | | [top](#introduction) |

### Alphanum

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :capital_abcd: | `:capital_abcd:` | :abcd: | `:abcd:` | [top](#introduction) |
| [top](#symbols) | :1234: | `:1234:` | :symbols: | `:symbols:` | [top](#introduction) |
| [top](#symbols) | :abc: | `:abc:` | :a: | `:a:` | [top](#introduction) |
| [top](#symbols) | :ab: | `:ab:` | :b: | `:b:` | [top](#introduction) |
| [top](#symbols) | :cl: | `:cl:` | :cool: | `:cool:` | [top](#introduction) |
| [top](#symbols) | :free: | `:free:` | :information_source: | `:information_source:` | [top](#introduction) |
| [top](#symbols) | :id: | `:id:` | :m: | `:m:` | [top](#introduction) |
| [top](#symbols) | :new: | `:new:` | :ng: | `:ng:` | [top](#introduction) |
| [top](#symbols) | :o2: | `:o2:` | :ok: | `:ok:` | [top](#introduction) |
| [top](#symbols) | :parking: | `:parking:` | :sos: | `:sos:` | [top](#introduction) |
| [top](#symbols) | :up: | `:up:` | :vs: | `:vs:` | [top](#introduction) |
| [top](#symbols) | :koko: | `:koko:` | :sa: | `:sa:` | [top](#introduction) |
| [top](#symbols) | :u6708: | `:u6708:` | :u6709: | `:u6709:` | [top](#introduction) |
| [top](#symbols) | :u6307: | `:u6307:` | :ideograph_advantage: | `:ideograph_advantage:` | [top](#introduction) |
| [top](#symbols) | :u5272: | `:u5272:` | :u7121: | `:u7121:` | [top](#introduction) |
| [top](#symbols) | :u7981: | `:u7981:` | :accept: | `:accept:` | [top](#introduction) |
| [top](#symbols) | :u7533: | `:u7533:` | :u5408: | `:u5408:` | [top](#introduction) |
| [top](#symbols) | :u7a7a: | `:u7a7a:` | :congratulations: | `:congratulations:` | [top](#introduction) |
| [top](#symbols) | :secret: | `:secret:` | :u55b6: | `:u55b6:` | [top](#introduction) |
| [top](#symbols) | :u6e80: | `:u6e80:` | | | [top](#introduction) |

### Geometric

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#symbols) | :red_circle: | `:red_circle:` | :orange_circle: | `:orange_circle:` | [top](#introduction) |
| [top](#symbols) | :yellow_circle: | `:yellow_circle:` | :green_circle: | `:green_circle:` | [top](#introduction) |
| [top](#symbols) | :large_blue_circle: | `:large_blue_circle:` | :purple_circle: | `:purple_circle:` | [top](#introduction) |
| [top](#symbols) | :brown_circle: | `:brown_circle:` | :black_circle: | `:black_circle:` | [top](#introduction) |
| [top](#symbols) | :white_circle: | `:white_circle:` | :red_square: | `:red_square:` | [top](#introduction) |
| [top](#symbols) | :orange_square: | `:orange_square:` | :yellow_square: | `:yellow_square:` | [top](#introduction) |
| [top](#symbols) | :green_square: | `:green_square:` | :blue_square: | `:blue_square:` | [top](#introduction) |
| [top](#symbols) | :purple_square: | `:purple_square:` | :brown_square: | `:brown_square:` | [top](#introduction) |
| [top](#symbols) | :black_large_square: | `:black_large_square:` | :white_large_square: | `:white_large_square:` | [top](#introduction) |
| [top](#symbols) | :black_medium_square: | `:black_medium_square:` | :white_medium_square: | `:white_medium_square:` | [top](#introduction) |
| [top](#symbols) | :black_medium_small_square: | `:black_medium_small_square:` | :white_medium_small_square: | `:white_medium_small_square:` | [top](#introduction) |
| [top](#symbols) | :black_small_square: | `:black_small_square:` | :white_small_square: | `:white_small_square:` | [top](#introduction) |
| [top](#symbols) | :large_orange_diamond: | `:large_orange_diamond:` | :large_blue_diamond: | `:large_blue_diamond:` | [top](#introduction) |
| [top](#symbols) | :small_orange_diamond: | `:small_orange_diamond:` | :small_blue_diamond: | `:small_blue_diamond:` | [top](#introduction) |
| [top](#symbols) | :small_red_triangle: | `:small_red_triangle:` | :small_red_triangle_down: | `:small_red_triangle_down:` | [top](#introduction) |
| [top](#symbols) | :diamond_shape_with_a_dot_inside: | `:diamond_shape_with_a_dot_inside:` | :radio_button: | `:radio_button:` | [top](#introduction) |
| [top](#symbols) | :white_square_button: | `:white_square_button:` | :black_square_button: | `:black_square_button:` | [top](#introduction) |

## Flags

- [Flag](#flag)
- [Country Flag](#country-flag)
- [Subdivision Flag](#subdivision-flag)

### Flag

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#flags) | :checkered_flag: | `:checkered_flag:` | :triangular_flag_on_post: | `:triangular_flag_on_post:` | [top](#introduction) |
| [top](#flags) | :crossed_flags: | `:crossed_flags:` | :black_flag: | `:black_flag:` | [top](#introduction) |
| [top](#flags) | :white_flag: | `:white_flag:` | :rainbow_flag: | `:rainbow_flag:` | [top](#introduction) |
| [top](#flags) | :transgender_flag: | `:transgender_flag:` | :pirate_flag: | `:pirate_flag:` | [top](#introduction) |

### Country Flag

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#flags) | :ascension_island: | `:ascension_island:` | :andorra: | `:andorra:` | [top](#introduction) |
| [top](#flags) | :united_arab_emirates: | `:united_arab_emirates:` | :afghanistan: | `:afghanistan:` | [top](#introduction) |
| [top](#flags) | :antigua_barbuda: | `:antigua_barbuda:` | :anguilla: | `:anguilla:` | [top](#introduction) |
| [top](#flags) | :albania: | `:albania:` | :armenia: | `:armenia:` | [top](#introduction) |
| [top](#flags) | :angola: | `:angola:` | :antarctica: | `:antarctica:` | [top](#introduction) |
| [top](#flags) | :argentina: | `:argentina:` | :american_samoa: | `:american_samoa:` | [top](#introduction) |
| [top](#flags) | :austria: | `:austria:` | :australia: | `:australia:` | [top](#introduction) |
| [top](#flags) | :aruba: | `:aruba:` | :aland_islands: | `:aland_islands:` | [top](#introduction) |
| [top](#flags) | :azerbaijan: | `:azerbaijan:` | :bosnia_herzegovina: | `:bosnia_herzegovina:` | [top](#introduction) |
| [top](#flags) | :barbados: | `:barbados:` | :bangladesh: | `:bangladesh:` | [top](#introduction) |
| [top](#flags) | :belgium: | `:belgium:` | :burkina_faso: | `:burkina_faso:` | [top](#introduction) |
| [top](#flags) | :bulgaria: | `:bulgaria:` | :bahrain: | `:bahrain:` | [top](#introduction) |
| [top](#flags) | :burundi: | `:burundi:` | :benin: | `:benin:` | [top](#introduction) |
| [top](#flags) | :st_barthelemy: | `:st_barthelemy:` | :bermuda: | `:bermuda:` | [top](#introduction) |
| [top](#flags) | :brunei: | `:brunei:` | :bolivia: | `:bolivia:` | [top](#introduction) |
| [top](#flags) | :caribbean_netherlands: | `:caribbean_netherlands:` | :brazil: | `:brazil:` | [top](#introduction) |
| [top](#flags) | :bahamas: | `:bahamas:` | :bhutan: | `:bhutan:` | [top](#introduction) |
| [top](#flags) | :bouvet_island: | `:bouvet_island:` | :botswana: | `:botswana:` | [top](#introduction) |
| [top](#flags) | :belarus: | `:belarus:` | :belize: | `:belize:` | [top](#introduction) |
| [top](#flags) | :canada: | `:canada:` | :cocos_islands: | `:cocos_islands:` | [top](#introduction) |
| [top](#flags) | :congo_kinshasa: | `:congo_kinshasa:` | :central_african_republic: | `:central_african_republic:` | [top](#introduction) |
| [top](#flags) | :congo_brazzaville: | `:congo_brazzaville:` | :switzerland: | `:switzerland:` | [top](#introduction) |
| [top](#flags) | :cote_divoire: | `:cote_divoire:` | :cook_islands: | `:cook_islands:` | [top](#introduction) |
| [top](#flags) | :chile: | `:chile:` | :cameroon: | `:cameroon:` | [top](#introduction) |
| [top](#flags) | :cn: | `:cn:` | :colombia: | `:colombia:` | [top](#introduction) |
| [top](#flags) | :clipperton_island: | `:clipperton_island:` | :costa_rica: | `:costa_rica:` | [top](#introduction) |
| [top](#flags) | :cuba: | `:cuba:` | :cape_verde: | `:cape_verde:` | [top](#introduction) |
| [top](#flags) | :curacao: | `:curacao:` | :christmas_island: | `:christmas_island:` | [top](#introduction) |
| [top](#flags) | :cyprus: | `:cyprus:` | :czech_republic: | `:czech_republic:` | [top](#introduction) |
| [top](#flags) | :de: | `:de:` | :diego_garcia: | `:diego_garcia:` | [top](#introduction) |
| [top](#flags) | :djibouti: | `:djibouti:` | :denmark: | `:denmark:` | [top](#introduction) |
| [top](#flags) | :dominica: | `:dominica:` | :dominican_republic: | `:dominican_republic:` | [top](#introduction) |
| [top](#flags) | :algeria: | `:algeria:` | :ceuta_melilla: | `:ceuta_melilla:` | [top](#introduction) |
| [top](#flags) | :ecuador: | `:ecuador:` | :estonia: | `:estonia:` | [top](#introduction) |
| [top](#flags) | :egypt: | `:egypt:` | :western_sahara: | `:western_sahara:` | [top](#introduction) |
| [top](#flags) | :eritrea: | `:eritrea:` | :es: | `:es:` | [top](#introduction) |
| [top](#flags) | :ethiopia: | `:ethiopia:` | :eu: | `:eu:` `:european_union:` | [top](#introduction) |
| [top](#flags) | :finland: | `:finland:` | :fiji: | `:fiji:` | [top](#introduction) |
| [top](#flags) | :falkland_islands: | `:falkland_islands:` | :micronesia: | `:micronesia:` | [top](#introduction) |
| [top](#flags) | :faroe_islands: | `:faroe_islands:` | :fr: | `:fr:` | [top](#introduction) |
| [top](#flags) | :gabon: | `:gabon:` | :gb: | `:gb:` `:uk:` | [top](#introduction) |
| [top](#flags) | :grenada: | `:grenada:` | :georgia: | `:georgia:` | [top](#introduction) |
| [top](#flags) | :french_guiana: | `:french_guiana:` | :guernsey: | `:guernsey:` | [top](#introduction) |
| [top](#flags) | :ghana: | `:ghana:` | :gibraltar: | `:gibraltar:` | [top](#introduction) |
| [top](#flags) | :greenland: | `:greenland:` | :gambia: | `:gambia:` | [top](#introduction) |
| [top](#flags) | :guinea: | `:guinea:` | :guadeloupe: | `:guadeloupe:` | [top](#introduction) |
| [top](#flags) | :equatorial_guinea: | `:equatorial_guinea:` | :greece: | `:greece:` | [top](#introduction) |
| [top](#flags) | :south_georgia_south_sandwich_islands: | `:south_georgia_south_sandwich_islands:` | :guatemala: | `:guatemala:` | [top](#introduction) |
| [top](#flags) | :guam: | `:guam:` | :guinea_bissau: | `:guinea_bissau:` | [top](#introduction) |
| [top](#flags) | :guyana: | `:guyana:` | :hong_kong: | `:hong_kong:` | [top](#introduction) |
| [top](#flags) | :heard_mcdonald_islands: | `:heard_mcdonald_islands:` | :honduras: | `:honduras:` | [top](#introduction) |
| [top](#flags) | :croatia: | `:croatia:` | :haiti: | `:haiti:` | [top](#introduction) |
| [top](#flags) | :hungary: | `:hungary:` | :canary_islands: | `:canary_islands:` | [top](#introduction) |
| [top](#flags) | :indonesia: | `:indonesia:` | :ireland: | `:ireland:` | [top](#introduction) |
| [top](#flags) | :israel: | `:israel:` | :isle_of_man: | `:isle_of_man:` | [top](#introduction) |
| [top](#flags) | :india: | `:india:` | :british_indian_ocean_territory: | `:british_indian_ocean_territory:` | [top](#introduction) |
| [top](#flags) | :iraq: | `:iraq:` | :iran: | `:iran:` | [top](#introduction) |
| [top](#flags) | :iceland: | `:iceland:` | :it: | `:it:` | [top](#introduction) |
| [top](#flags) | :jersey: | `:jersey:` | :jamaica: | `:jamaica:` | [top](#introduction) |
| [top](#flags) | :jordan: | `:jordan:` | :jp: | `:jp:` | [top](#introduction) |
| [top](#flags) | :kenya: | `:kenya:` | :kyrgyzstan: | `:kyrgyzstan:` | [top](#introduction) |
| [top](#flags) | :cambodia: | `:cambodia:` | :kiribati: | `:kiribati:` | [top](#introduction) |
| [top](#flags) | :comoros: | `:comoros:` | :st_kitts_nevis: | `:st_kitts_nevis:` | [top](#introduction) |
| [top](#flags) | :north_korea: | `:north_korea:` | :kr: | `:kr:` | [top](#introduction) |
| [top](#flags) | :kuwait: | `:kuwait:` | :cayman_islands: | `:cayman_islands:` | [top](#introduction) |
| [top](#flags) | :kazakhstan: | `:kazakhstan:` | :laos: | `:laos:` | [top](#introduction) |
| [top](#flags) | :lebanon: | `:lebanon:` | :st_lucia: | `:st_lucia:` | [top](#introduction) |
| [top](#flags) | :liechtenstein: | `:liechtenstein:` | :sri_lanka: | `:sri_lanka:` | [top](#introduction) |
| [top](#flags) | :liberia: | `:liberia:` | :lesotho: | `:lesotho:` | [top](#introduction) |
| [top](#flags) | :lithuania: | `:lithuania:` | :luxembourg: | `:luxembourg:` | [top](#introduction) |
| [top](#flags) | :latvia: | `:latvia:` | :libya: | `:libya:` | [top](#introduction) |
| [top](#flags) | :morocco: | `:morocco:` | :monaco: | `:monaco:` | [top](#introduction) |
| [top](#flags) | :moldova: | `:moldova:` | :montenegro: | `:montenegro:` | [top](#introduction) |
| [top](#flags) | :st_martin: | `:st_martin:` | :madagascar: | `:madagascar:` | [top](#introduction) |
| [top](#flags) | :marshall_islands: | `:marshall_islands:` | :macedonia: | `:macedonia:` | [top](#introduction) |
| [top](#flags) | :mali: | `:mali:` | :myanmar: | `:myanmar:` | [top](#introduction) |
| [top](#flags) | :mongolia: | `:mongolia:` | :macau: | `:macau:` | [top](#introduction) |
| [top](#flags) | :northern_mariana_islands: | `:northern_mariana_islands:` | :martinique: | `:martinique:` | [top](#introduction) |
| [top](#flags) | :mauritania: | `:mauritania:` | :montserrat: | `:montserrat:` | [top](#introduction) |
| [top](#flags) | :malta: | `:malta:` | :mauritius: | `:mauritius:` | [top](#introduction) |
| [top](#flags) | :maldives: | `:maldives:` | :malawi: | `:malawi:` | [top](#introduction) |
| [top](#flags) | :mexico: | `:mexico:` | :malaysia: | `:malaysia:` | [top](#introduction) |
| [top](#flags) | :mozambique: | `:mozambique:` | :namibia: | `:namibia:` | [top](#introduction) |
| [top](#flags) | :new_caledonia: | `:new_caledonia:` | :niger: | `:niger:` | [top](#introduction) |
| [top](#flags) | :norfolk_island: | `:norfolk_island:` | :nigeria: | `:nigeria:` | [top](#introduction) |
| [top](#flags) | :nicaragua: | `:nicaragua:` | :netherlands: | `:netherlands:` | [top](#introduction) |
| [top](#flags) | :norway: | `:norway:` | :nepal: | `:nepal:` | [top](#introduction) |
| [top](#flags) | :nauru: | `:nauru:` | :niue: | `:niue:` | [top](#introduction) |
| [top](#flags) | :new_zealand: | `:new_zealand:` | :oman: | `:oman:` | [top](#introduction) |
| [top](#flags) | :panama: | `:panama:` | :peru: | `:peru:` | [top](#introduction) |
| [top](#flags) | :french_polynesia: | `:french_polynesia:` | :papua_new_guinea: | `:papua_new_guinea:` | [top](#introduction) |
| [top](#flags) | :philippines: | `:philippines:` | :pakistan: | `:pakistan:` | [top](#introduction) |
| [top](#flags) | :poland: | `:poland:` | :st_pierre_miquelon: | `:st_pierre_miquelon:` | [top](#introduction) |
| [top](#flags) | :pitcairn_islands: | `:pitcairn_islands:` | :puerto_rico: | `:puerto_rico:` | [top](#introduction) |
| [top](#flags) | :palestinian_territories: | `:palestinian_territories:` | :portugal: | `:portugal:` | [top](#introduction) |
| [top](#flags) | :palau: | `:palau:` | :paraguay: | `:paraguay:` | [top](#introduction) |
| [top](#flags) | :qatar: | `:qatar:` | :reunion: | `:reunion:` | [top](#introduction) |
| [top](#flags) | :romania: | `:romania:` | :serbia: | `:serbia:` | [top](#introduction) |
| [top](#flags) | :ru: | `:ru:` | :rwanda: | `:rwanda:` | [top](#introduction) |
| [top](#flags) | :saudi_arabia: | `:saudi_arabia:` | :solomon_islands: | `:solomon_islands:` | [top](#introduction) |
| [top](#flags) | :seychelles: | `:seychelles:` | :sudan: | `:sudan:` | [top](#introduction) |
| [top](#flags) | :sweden: | `:sweden:` | :singapore: | `:singapore:` | [top](#introduction) |
| [top](#flags) | :st_helena: | `:st_helena:` | :slovenia: | `:slovenia:` | [top](#introduction) |
| [top](#flags) | :svalbard_jan_mayen: | `:svalbard_jan_mayen:` | :slovakia: | `:slovakia:` | [top](#introduction) |
| [top](#flags) | :sierra_leone: | `:sierra_leone:` | :san_marino: | `:san_marino:` | [top](#introduction) |
| [top](#flags) | :senegal: | `:senegal:` | :somalia: | `:somalia:` | [top](#introduction) |
| [top](#flags) | :suriname: | `:suriname:` | :south_sudan: | `:south_sudan:` | [top](#introduction) |
| [top](#flags) | :sao_tome_principe: | `:sao_tome_principe:` | :el_salvador: | `:el_salvador:` | [top](#introduction) |
| [top](#flags) | :sint_maarten: | `:sint_maarten:` | :syria: | `:syria:` | [top](#introduction) |
| [top](#flags) | :swaziland: | `:swaziland:` | :tristan_da_cunha: | `:tristan_da_cunha:` | [top](#introduction) |
| [top](#flags) | :turks_caicos_islands: | `:turks_caicos_islands:` | :chad: | `:chad:` | [top](#introduction) |
| [top](#flags) | :french_southern_territories: | `:french_southern_territories:` | :togo: | `:togo:` | [top](#introduction) |
| [top](#flags) | :thailand: | `:thailand:` | :tajikistan: | `:tajikistan:` | [top](#introduction) |
| [top](#flags) | :tokelau: | `:tokelau:` | :timor_leste: | `:timor_leste:` | [top](#introduction) |
| [top](#flags) | :turkmenistan: | `:turkmenistan:` | :tunisia: | `:tunisia:` | [top](#introduction) |
| [top](#flags) | :tonga: | `:tonga:` | :tr: | `:tr:` | [top](#introduction) |
| [top](#flags) | :trinidad_tobago: | `:trinidad_tobago:` | :tuvalu: | `:tuvalu:` | [top](#introduction) |
| [top](#flags) | :taiwan: | `:taiwan:` | :tanzania: | `:tanzania:` | [top](#introduction) |
| [top](#flags) | :ukraine: | `:ukraine:` | :uganda: | `:uganda:` | [top](#introduction) |
| [top](#flags) | :us_outlying_islands: | `:us_outlying_islands:` | :united_nations: | `:united_nations:` | [top](#introduction) |
| [top](#flags) | :us: | `:us:` | :uruguay: | `:uruguay:` | [top](#introduction) |
| [top](#flags) | :uzbekistan: | `:uzbekistan:` | :vatican_city: | `:vatican_city:` | [top](#introduction) |
| [top](#flags) | :st_vincent_grenadines: | `:st_vincent_grenadines:` | :venezuela: | `:venezuela:` | [top](#introduction) |
| [top](#flags) | :british_virgin_islands: | `:british_virgin_islands:` | :us_virgin_islands: | `:us_virgin_islands:` | [top](#introduction) |
| [top](#flags) | :vietnam: | `:vietnam:` | :vanuatu: | `:vanuatu:` | [top](#introduction) |
| [top](#flags) | :wallis_futuna: | `:wallis_futuna:` | :samoa: | `:samoa:` | [top](#introduction) |
| [top](#flags) | :kosovo: | `:kosovo:` | :yemen: | `:yemen:` | [top](#introduction) |
| [top](#flags) | :mayotte: | `:mayotte:` | :south_africa: | `:south_africa:` | [top](#introduction) |
| [top](#flags) | :zambia: | `:zambia:` | :zimbabwe: | `:zimbabwe:` | [top](#introduction) |

### Subdivision Flag

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#flags) | :england: | `:england:` | :scotland: | `:scotland:` | [top](#introduction) |
| [top](#flags) | :wales: | `:wales:` | | | [top](#introduction) |

## GitHub Custom Emoji

| | ico | shortcode | ico | shortcode | |
| - | :-: | - | :-: | - | - |
| [top](#github-custom-emoji) | :accessibility: | `:accessibility:` | :atom: | `:atom:` | [top](#introduction) |
| [top](#github-custom-emoji) | :basecamp: | `:basecamp:` | :basecampy: | `:basecampy:` | [top](#introduction) |
| [top](#github-custom-emoji) | :bowtie: | `:bowtie:` | :dependabot: | `:dependabot:` | [top](#introduction) |
| [top](#github-custom-emoji) | :electron: | `:electron:` | :feelsgood: | `:feelsgood:` | [top](#introduction) |
| [top](#github-custom-emoji) | :finnadie: | `:finnadie:` | :fishsticks: | `:fishsticks:` | [top](#introduction) |
| [top](#github-custom-emoji) | :goberserk: | `:goberserk:` | :godmode: | `:godmode:` | [top](#introduction) |
| [top](#github-custom-emoji) | :hurtrealbad: | `:hurtrealbad:` | :neckbeard: | `:neckbeard:` | [top](#introduction) |
| [top](#github-custom-emoji) | :octocat: | `:octocat:` | :rage1: | `:rage1:` | [top](#introduction) |
| [top](#github-custom-emoji) | :rage2: | `:rage2:` | :rage3: | `:rage3:` | [top](#introduction) |
| [top](#github-custom-emoji) | :rage4: | `:rage4:` | :shipit: | `:shipit:` | [top](#introduction) |
| [top](#github-custom-emoji) | :suspect: | `:suspect:` | :trollface: | `:trollface:` | [top](#introduction) |
