/* This is an example HY-PHY Batch File.

	This file contains the shared part of "ReplicateConstraint" examples.
	
   Sergei L. Kosakovsky Pond and Spencer V. Muse 
   June 2001. 
*/


/* 1. Read in the data and store the result in a DataSet variable.*/

DataSet 		nucleotideSequences = ReadDataFile ("data/hiv.seq");

   
/* 2. Filter the data, specifying that all of the data is to be used
	  and that it is to be treated as nucleotides. */

	  
DataSetFilter	filteredData = CreateFilter (nucleotideSequences,1);



/* 3. Collect observed nucleotide frequencies from the filtered data. observedFreqs will
	  store the vector of frequencies. */

HarvestFrequencies (observedFreqs, filteredData, 1, 1, 1);



/* 4. Define the HKY substitution matrix. '*' is defined to be -(sum of off-diag row elements) */

HKY85RateMatrix  = 

		{{*,trvs,trst,trvs}
		 {trvs,*,trvs,trst}
		 {trst,trvs,*,trvs}
		 {trvs,trst,trvs,*}};

		 

/*5.  Define the HKY85 model, by combining the substitution matrix with the vector of observed (equilibrium)
	  frequencies. */

Model HKY85	 = (HKY85RateMatrix , observedFreqs);

/*6.  Use the tree from the data file:
 (((317,6767),((135,(529,105r))iNode1,(719,136))),6760,((113,9939),(256,(822,159))iNode2))
 */

Tree	hivTree = DATAFILE_TREE;

/*7.  Since all the likelihood function ingredients (data, tree, equilibrium frequencies)
	  have been defined we are ready to construct the likelihood function. */

LikelihoodFunction  hivLik = (filteredData, hivTree);
