#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 9;
	TAXLABELS
		'RecombStrain' 'D_CD_83_ELI_ACC_K03454' 'D_CD_83_NDK_ACC_M27323' 'D_UG_94_94UG114_ACC_U88824' 'D_CD_84_84ZR085_ACC_U88822' 'B_US_83_RF_ACC_M17451' 'B_FR_83_HXB2_ACC_K03455' 'B_US_86_JRFL_ACC_U63632' 'B_US_90_WEAU160_ACC_U21135' ;
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 2400;
	FORMAT
		DATATYPE = DNA
		GAP=-
		MISSING=?
	;

MATRIX
	'RecombStrain'                ACTGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGAACTTCTTGAGGAACCATAAGAGAAGATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTTTAGAGCGATTAAAAAAAAGACCCACAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAACATTAAGAAGAAACCAGTAAGAGGAGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAAAGTTCCAAAAACGTGAAATTTATAAATCTACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAACAAATTGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCGTCAAAGTGTCTCCGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGACAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTAGAGGCATAGAGTCAAAAGGGGAGATGTTGCGATATGATCTGCGTGACTAAGCAATTCGGGATCGTATGAATCAAGTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTATTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATGTTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTACTAACAAATAATAAGAGTTAGGTAGAACGAACCCGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGGAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAACAACATCCATTTGGCATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATTGAAATAACCGTATGGAAACCAGAAACTAAATTCAAAGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGAAGAAACCAGCGAAGATATTAGACTTAATTGATGATGAACCCCAAAATAAGAATACATCAGTAAAGGACCCTTAAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAATGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTGCCAGGAAACTCATGCTGAATTCAAATGTAGCAAATGAATCGAGAAAGGGTTCTCCCGGAGGAACACGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTCACTGAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGGTTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGTAAGCGTGAAGTCGAAAACAACATGCTTGCGGAAGCATAAAAAGTACTTATGACACGCGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAGTGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'D_CD_83_ELI_ACC_K03454'      AATGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAAAAAAAAAAGAACTTCTTGAGGAACCATAAGAGAAGATAACCGTACAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTTTAGAGCGATTGGAAAAAAAACCCGCAACCTTGGTTTACTACGGTACATAAAAGATAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAACATTAAGAAGAAATCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCATGTGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATCTACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAACAAATTGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACGAAGCAAGGGGTATGCGGCGTCAAAGTGTCTCCGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAGAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACTATAGAAGGCTCGGTAATCAATTGAGAAAAAGGAGTAACGGTAGAGGCATAGAGTCAAAAGGGGAGATGTTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTCGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCGCCGTATGATCTGCTAACAAATAATAAGAGTTAGGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCCTAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATCGAAATAACCGTATGGAAATCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGTAGATACCAGCGAGGATATTAGACCTAATTGATGATGAACCCTAAAATAAGAATATATCATTAAAGGACCCTTGAACAATCATGTTAGACGCTAAATTTTAAAGGGGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTAACAGGAAACTCATGCTGAATCCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACACGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATGCCGAAAGTAATATGAGTCACTGAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGTAAGCGTGAAGTCGAAAACAACATGCTTGCGGAAGCATAAAAAGTACTTATGACACGCGTGCGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAGTGGAGTAACTTACAATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'D_CD_83_NDK_ACC_M27323'      ACTGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGAACTTCTTGAGGAACCATAAGAGAAGATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTTTAGAGCGATTAGAAAAAAGACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAACATTAAGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCATGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATCTACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAACAAATTGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCGTCAAAGTGTCTCCGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAGAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTAGAGGCATAGAGTCAAAAGGGGAGATGTTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTGCTAACAAATAATAAGAGTTAGGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGACACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAACTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATCGAAATAACCGTATGGAAATCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTCAAAAAAGTAGATACCAGCGAGGATATTAGACCTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTGAACAATCATGTTAGACACTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTGAATCCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACACGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTCACTGAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGTAAGCGTGAAGTCGAAAACAACATGCTTGCGGAAGCATAAAAAGTACTTATGACACACGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAGTGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'D_UG_94_94UG114_ACC_U88824'  ACTGCAAACTTACATGAAGAATGAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAAGTTATACCTCGAGAAAAAAAAGTACTTCTTGAGGAACCATAAGAGAAAATAATCGTGCAAGTATGATATGAACAAAAATTTGAATTGAAAGGACTGTATAGAGCGATTAAAAAAAAGACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAACATTAAGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACACAGGCAGGCGTCCAAGTTAAGACCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATCAAAAGATACAAAGATGAGCACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAATCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACATGAAATCTATAAATATACGATAATGAGGGACCAACGGAAGAAAACGATATGGGAAGCGAAAGTAAATAGTTTTCGTAAACACAGACAAGTGACATCACCTCAAAATACGAGTTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCATCAAAGTGTCTCTGGTCCAAATCCGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTATTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTACCAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCGGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTGAAGGCATAGAGTCAAAAAGGGAGATGTTGCGATATGATCTGCGTGACTAAGCAATTCGGGATCGTATGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTATTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATGTTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTACTAACAAATAATAAGAGTTAAGTAGAACGAACCCGAAACTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGGAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAACAACATCCATTTGACATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAACGTGATGCGGATTGAAATAACCGTATGGAAACCAGATAATAATTTCAAAGATAAACATGTCTCGGGAAAAGTGTAATAAAAAAAGAAGAAACCAGCGAAGATATTAGACTTAATTGATGATGGACCCCAAAATAAGAATACATAATTAAAGGACCCTTAAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACAGAATGAAAAACCGTGTTTCATAATAGAAAAGCACAATGATGATATCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTGCCAGGAAACTCATGCTGAATTCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCTGGAGGAACACGCATAGGCAAAATAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTGTACCGAAAGTAATATGAGTCACTGAAAGATAAATAAAAATAAACTTTCAGCAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATAGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACATCCAAAAAATCTGAATTTACGCCGCATGAGTAAGCGTGAAGTCGAAGACAACGTGCTTGCGGAAGCATAAAAAGTACTTATGACACGCGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCTAGAGGAGTGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'D_CD_84_84ZR085_ACC_U88822'  ACTGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGAACTTCTTGAGGAACCATAAGAGAAAATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTATAGAGCGATTAAAAAAAAGACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCAACGTATTTAAGGAAAACATTAAGAAGAAATCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTTCCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCGAATGGAAGGTAAATAACGATGCCAGGTCCAGGCAGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACATGAAATTTATAAATATACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAATAAATAGTTTCCGTAAACACAGACGAGTGACATCACCTCAAAAAACGAGTTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCATCAAAGTGTCTCTGGTCCAAATCCGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCATAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGGAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTGAAGGCATAGAGTCAAAAAGGGAGATATTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGATCCAGACCTAAACTAGAAATTGAGAAACTATTCTGCAATCGAGGTCAATCTAGCAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTACTAACAAATAATAAGAGTTAGGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATTGAAATAACCGTATGGAAACCAGAAACTAAATTCAAAGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGAAGAAACCAGCGAAGATATTAGACTTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTAAACAATCATGTTAGACGCTATATTTTAAAGGAGACAAACAATCTTAATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTGAATCCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACACGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGTAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTCACTGAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGATTGACAATAATGACACAACGGTCTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAAAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGTAAGCGTGAAGTCGAAAACAACGTGCTTGCGGAAGCATAAAAAGTACTTATGGCACGCGTGAGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAGTGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'B_US_83_RF_ACC_M17451'       ACTGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGACCTTCTTGAGGAACCATAAGATAAAATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGCATAGAGCGATTAAAAAAAAGACCCGCACCCTTGGTTTACTACGGTACCTAAAAGCTAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAATATTAGGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGAATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAATGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATATACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAATAAATAGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCATCAAAGTGTCTCTGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAAACATAAAGATGACGAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCCATTGAGAAAAAGGAGTAACGGTGAAGGCATAGAGTCAAAAAGGGAGATGTTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACTACCGTATGATCTGCTAACAAATAATAAGAGTTAAGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGTAAGCAAATAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTGCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATTGAAATAACCGTATGGAAACCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGTAGAAACCAGCGAAGATATTAGACTTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTAAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAACAGAAAAGCACTATAAAGATAACCAGACGGTAAATTACGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTAAATCCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACGCGCATAGGCAAATTAAATGATGAGAGCTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTTACTGAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAATACGGTGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGCAAGCGTGAAGTCGAAAACAACGTGCTGGCGGAAGCATAAAAAGTACTTATGGCACGCGTATGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAAGAATGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'B_FR_83_HXB2_ACC_K03455'     ACTGCAAACTTACATGAAAAATAAAACGGAGCGATTGGTAGAGAAATTAGAAGACTACATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGACCTTCTTGAGGAACCATAAGAGAAAATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTATAGAGCGATTAAAAAAAACACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACCTATTTAAGGAAAACATTAGGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATATACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAATAAATAGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCATCAAAGTGTCTCTGGTCCACATCGGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTGGAGGCATAGAGTCAAAAAGGGAGATGTTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAATAAATCCAACGTTAGGTCACCACCACCGTATGATCTGCTAACAAATAATAAGAGTTAGGTAGATCGAAGCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGTTTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACAAATGTGATACGGATTGAAATAACCGTATGGAAACCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGTAGAAACCAGCGAAGATATTAGACTTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTGAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATTTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGCAAATTCCGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTGAATCCAAATGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACGCGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTTACTCAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGCAAGCGTGAAGTCGAAAACAACGTGCTGGCGGAAGCATAAAAAGTACTTATGGCACGCGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAATGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'B_US_86_JRFL_ACC_U63632'     ACTGCAAACTTACATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGACCTTCTTGAGGAACCATAAGAGAAAATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTATAGAGCGATTAAAAAAAAGACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACCTATTTAAGGAAAACATTAGGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATAAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAGTGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGGAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATCTACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAACAAATAGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTAAGCAAGGGGTATGCGGCGTCAAAGTGTCTCCGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATAAGATCAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTCGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTGGAGGCATAGAGTCAAAAGGGGAGATGTTGCGACATGATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAGAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAGCCCATTGCTTGATATATTCCTAAGTAACTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTGCTAACAAATAATAAGGGTTAGGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTAGAGACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGATTGTAGGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATCGAAATAACCGTATGGAAATCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGTAGATACCAGCGAGGATATTAGACTTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTGAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTGAATCCAAATGTAGCATATGAATCGAGAAAGAGTTCTCCCGGAGGAACGCGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACGTATACCGAAAGTAATATGAGTTACTCAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGATGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGCAAGCGTGAAGTCGAAAACAACGTGCTGGCGGAAGCATAAAAAGTACTTATGGCACGCGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAATGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA
	'B_US_90_WEAU160_ACC_U21135'  ACTGCAAACTTATATGAAAAATAAAACGGCGCGATTGGTAGAGAAATTAGAAGACTATATCATTGGACTAAAAAATGAAAAATAGACACTGCACCTCAGTAAAGCAGAGCAGTGACGGTATGTAAAGATCAAAGAAGGGTGTAGGTTATACCTCGAGAAAAAAAAGACCTTCTTGAGGAACCATAAGAGAAAATAACCGTGCAAGTATGATATAACCAAAAATTTGAATTGGAAGGACTGTATAGAGCGATTAAAAAAAAGACCCGCAACCTTGGTTTACTACGGTACATAAAAGCTAACAAATTGCAAAATACGCCCACGTATTTAAGGAAAACATTAGGAAGAAACCAGTAAGAGGGGCTTAGTAAAATCTATATAGAAAAGAAGCATCAAAGATCTACGGTGTAACACATTATACATAGGCAGGCGTCCAAGTTAAGGCCGGGTAATTACCAAAGTGAACGTCTACAGCAAAGACAATAGAATAAAAAGATTAAAAAATGAGAACCGGGGAGTGGGAGAGTCTAATGGAAGGTAAATAACGATGCCAGGTCCAGGCTGGTAGCAGGAGTCGCTAGAACTCATCGAATTTCCTTGAAATAGCAACCAGACCCAGAGTTCCAAAAACGTGAAATTTATAAATATACGATAATGAGGGACTAACGGAAGAAAACGATATGGGAAGCGAAAATAAATAGTTTCTGTAAACACAGACAAGTGACATCACCTCGAAATACGAATTAGCAAGTAAGGGTATACTGAGCAAGGGGTATGCGGCATCAAAGTGTCTCTGGTCCAAATCGGGCAAAGATGAAGCGTAGCCCTTGGATAAAACTATAAGGCTGGCTAAGAAGACCAAAACATTAGTTTATAGTGGGGAAAGTCAAAGAAAGTCTAAACACGATTAGTGTTCGTATGAGATGAGAACGAAATCCAAATAATCCGCCAAATGTGTGCGGTGGCTAACAAAATACGGTACGACATTCGAACAAAGACATAAAGATGACAAACATGCTGGGTAAATCCGTAGAAAATACGATAGAAGGCTCGGTGATCAATTGAGAAAAAGGAGTAACGGTGGAGGCATAGAGTCAAAAAGGGAGATGTTGCGACATAATCTGCGTGACTAAGCAATTCGGGATCGTACGAATCAACTGCAAGGTCCAGACCTAAACTAGAAATTGAAAAACTACTCTGCAATCGAGGTCAATCTAACAGGCAGGAGATTTAGCGTAACCCATTGCTTGATATATTCCTAAGTAATTAGCAACAAATCCAACGTTAGGTCACCACCACCGTATGATCTGCTAACAAATAATAAGAGTTAGGTAGAACGAACCGGAAGCTGTTGTTATTAAAAGGATGCTAATATGGAACGGTGGAGACAAGTAAGCAAGTAGCATTCCTTACAGATACCTTTAATTGTGAGCTCTCCACTAAAACTATGGTACGGGGTAGCAACATCCATTTGGCATAGAGATTATAGTTTGTAAGAAAGGTGAGGATAGATGCTGTGGGATAAGAGCTGGAATCTCAAACAGATTACGAATGTGATGCGGATTGAAATAACCGTATGGAAACCAGAAACTAAATTCAATGATAAACATGTCTCGGGAAAAGTGTAGTAAAAAAAGTAGAAACCAGCGAAGATATTAGACTTAATTGATGATGAACCCTAAAATAAGAATACATCATTAAAGGACCCTTGAACAATCATGTTAGACGCTAAATTTTAAAGGAGACAAACAATCTTGATACGAGGCTCACAAGACGGAATGAAAAACCGTGTTTCATAATAGAAAAGCACTATAAAGATACCCAGACGGTAAATTCCGGGAAGGCTGTAAGGATGAATGCTACCAGGAAACTCATGCTGAATCCAATTGTAGCAAATGAATCGAGAAAGAGTTCTCCCGGAGGAACGCGCATAGGCAAATTAAATGATGAGAACTAAGGTAGCAAAAAAAGAGAAAAAAGATCCTTGGCCGAACCTATACCGAAAGTAATATGAGTTACTCAAAGGTAAATAAAAATAAACTTTCAACAGGGAAGTAATCACAGACAAGTTACTCACAAATACATTAACACGGTGATCGGATTGACAATAATGACACAACGGTTTGACCTGGTATGTCCACTGATATTAGGTAACAAAACAAAATAATAGAACTTTACGTGATAGAAAGAACTTCCAAAAAATCTGAATTTACGCCGCATGAGCAAGCGTGAAGTCGAAAACAACGTGCTGGCGGAAGCATAAAAAGTACTTATGGCACGCGTGTGAGTTGGTACGTAAGAGCTAAATAGTATGATAGACCAGGTGCCTCCAGAGGAATGGAGTAACTTACGATGTGGTAGCGTAAGAGCAGTTAAAAGAATCAGATTAATAAGAACCCCGAA;
END;

BEGIN HYPHY;

/* test preamble */

	_testDescription 		= " fit the HKY+gamma model to an HIV-1 alignment with 9 sequences and 2400 nucleotides with 4 partitions and different rate class counts";
	_expectedLL 			= -4490.24;
	ExecuteAFile 			("../Shared/TestInstrumentation.bf");
	startTestTimer 			(_testDescription);

/* end test preamble */


global CT=1.22367;
global AT=0.284002;
global CG=0.390749;
global AC=0.369337;
global GT=0.142059;

global alpha=0.197532;
alpha:>0.01;
alpha:<100;


category pc=(3,pc.weights,MEAN,_x_^(betaP-1)*(1-_x_)^(betaQ-1)/Beta(betaP,betaQ),IBeta(_x_,betaP,betaQ),0,1,IBeta(_x_,betaP+1,betaQ)*betaP/(betaP+betaQ));
category c=(4,EQUAL,MEAN,GammaDist(_x_,alpha,alpha),CGammaDist(_x_,alpha,alpha),0,1e+25,CGammaDist(_x_,alpha+1,alpha));
category d=(5,EQUAL,MEAN,GammaDist(_x_,alpha,alpha),CGammaDist(_x_,alpha,alpha),0,1e+25,CGammaDist(_x_,alpha+1,alpha));
category e=(3,EQUAL,MEAN,GammaDist(_x_,alpha,alpha),CGammaDist(_x_,alpha,alpha),0,1e+25,CGammaDist(_x_,alpha+1,alpha));

GTR_Matrix={4,4};
GTR_Matrix[0][1]:=AC*t*c;
GTR_Matrix[0][2]:=t*c;
GTR_Matrix[0][3]:=AT*t*c;
GTR_Matrix[1][0]:=AC*t*c;
GTR_Matrix[1][2]:=CG*t*c;
GTR_Matrix[1][3]:=CT*t*c;
GTR_Matrix[2][0]:=t*c;
GTR_Matrix[2][1]:=CG*t*c;
GTR_Matrix[2][3]:=GT*t*c;
GTR_Matrix[3][0]:=AT*t*c;
GTR_Matrix[3][1]:=CT*t*c;
GTR_Matrix[3][2]:=GT*t*c;

GTR_Matrix2={4,4};
GTR_Matrix2[0][1]:=AC*t*d;
GTR_Matrix2[0][2]:=t*d;
GTR_Matrix2[0][3]:=AT*t*d;
GTR_Matrix2[1][0]:=AC*t*d;
GTR_Matrix2[1][2]:=CG*t*d;
GTR_Matrix2[1][3]:=CT*t*d;
GTR_Matrix2[2][0]:=t*d;
GTR_Matrix2[2][1]:=CG*t*d;
GTR_Matrix2[2][3]:=GT*t*d;
GTR_Matrix2[3][0]:=AT*t*d;
GTR_Matrix2[3][1]:=CT*t*d;
GTR_Matrix2[3][2]:=GT*t*d;

GTR_Matrix3={4,4};
GTR_Matrix3[0][1]:=AC*t*e;
GTR_Matrix3[0][2]:=t*e;
GTR_Matrix3[0][3]:=AT*t*e;
GTR_Matrix3[1][0]:=AC*t*e;
GTR_Matrix3[1][2]:=CG*t*e;
GTR_Matrix3[1][3]:=CT*t*e;
GTR_Matrix3[2][0]:=t*e;
GTR_Matrix3[2][1]:=CG*t*e;
GTR_Matrix3[2][3]:=GT*t*e;
GTR_Matrix3[3][0]:=AT*t*e;
GTR_Matrix3[3][1]:=CT*t*e;
GTR_Matrix3[3][2]:=GT*t*e;

baseFreqs={
{    0.399398148148}
{    0.163842592593}
{    0.223981481481}
{    0.212777777778}
}
;
Model GTR_Model=(GTR_Matrix,baseFreqs);
UseModel (GTR_Model);
Tree tree_0=((((RecombStrain,(D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323)Node5)Node3,D_CD_84_84ZR085_ACC_U88822)Node2,D_UG_94_94UG114_ACC_U88824)Node1,(B_US_83_RF_ACC_M17451,B_US_90_WEAU160_ACC_U21135)Node10,(B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632)Node13);

UseModel (GTR_Model);
Tree tree_1=((((RecombStrain,(D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323)Node5)Node3,B_US_86_JRFL_ACC_U63632)Node2,B_US_90_WEAU160_ACC_U21135)Node1,((D_UG_94_94UG114_ACC_U88824,D_CD_84_84ZR085_ACC_U88822)Node11,B_US_83_RF_ACC_M17451)Node10,B_FR_83_HXB2_ACC_K03455);

Model GTR_Model2=(GTR_Matrix2,baseFreqs);
Tree tree_2=(((((RecombStrain,D_UG_94_94UG114_ACC_U88824)Node4,D_CD_84_84ZR085_ACC_U88822)Node3,B_US_83_RF_ACC_M17451)Node2,B_FR_83_HXB2_ACC_K03455)Node1,((D_CD_83_ELI_ACC_K03454,D_CD_83_NDK_ACC_M27323)Node11,B_US_86_JRFL_ACC_U63632)Node10,B_US_90_WEAU160_ACC_U21135);

Model GTR_Model3=(GTR_Matrix3,baseFreqs);
Tree tree_3=(RecombStrain,(D_CD_83_ELI_ACC_K03454,(D_UG_94_94UG114_ACC_U88824,(D_CD_84_84ZR085_ACC_U88822,(B_US_83_RF_ACC_M17451,((B_FR_83_HXB2_ACC_K03455,B_US_86_JRFL_ACC_U63632)Node11,B_US_90_WEAU160_ACC_U21135)Node10)Node8)Node6)Node4)Node2,D_CD_83_NDK_ACC_M27323);

tree_2.B_US_83_RF_ACC_M17451.t=0.02755683682993398;
tree_2.Node1.t=0;
tree_2.B_US_86_JRFL_ACC_U63632.t=0.01326059287271811;
tree_2.Node10.t=0.01326143467048369;
tree_2.B_US_90_WEAU160_ACC_U21135.t=0.01987764324853837;
tree_2.Node11.t=0.003026459698870693;
tree_2.B_FR_83_HXB2_ACC_K03455.t=0.02329267821605396;
tree_2.Node2.t=0.002800333307564091;
tree_2.Node4.t=0.03500361914558993;
tree_2.D_UG_94_94UG114_ACC_U88824.t=0.04889981365158647;
tree_2.RecombStrain.t=0.006715808089228459;
tree_2.D_CD_84_84ZR085_ACC_U88822.t=0.01332295638171858;
tree_2.D_CD_83_NDK_ACC_M27323.t=0.01328712408506268;
tree_2.D_CD_83_ELI_ACC_K03454.t=0.01996826383490629;
tree_2.Node3.t=0.01383818615750967;
tree_3.RecombStrain.t=0.009992697906091448;
tree_3.B_US_86_JRFL_ACC_U63632.t=0.0099749493969674;
tree_3.Node2.t=0;
tree_3.Node8.t=0.02636648254239594;
tree_3.Node6.t=0.004563116148969946;
tree_3.B_US_90_WEAU160_ACC_U21135.t=0;
tree_3.B_FR_83_HXB2_ACC_K03455.t=0;
tree_3.B_US_83_RF_ACC_M17451.t=0.02027530226140629;
tree_3.D_CD_83_NDK_ACC_M27323.t=0.004993954698447391;
tree_3.Node4.t=0.005135340264405711;
tree_3.D_UG_94_94UG114_ACC_U88824.t=0.04793012238098922;
tree_3.Node11.t=0;
tree_3.D_CD_84_84ZR085_ACC_U88822.t=0.02087877906855073;
tree_3.D_CD_83_ELI_ACC_K03454.t=0.01507507532185939;
tree_3.Node10.t=0.005001849275258297;
tree_1.B_US_90_WEAU160_ACC_U21135.t=0.02321828136492775;
tree_0.Node10.t=0;
tree_0.Node2.t=0;
tree_0.Node5.t=0.01210808669935977;
tree_0.B_US_86_JRFL_ACC_U63632.t=0;
tree_0.B_FR_83_HXB2_ACC_K03455.t=0.01816066369929858;
tree_0.B_US_83_RF_ACC_M17451.t=0.03742153847361689;
tree_0.Node1.t=0.01195896810357335;
tree_0.D_CD_83_NDK_ACC_M27323.t=0;
tree_1.Node10.t=0.003353456605947262;
tree_0.D_UG_94_94UG114_ACC_U88824.t=0.05673213356293653;
tree_0.RecombStrain.t=0.01200894050847036;
tree_0.D_CD_84_84ZR085_ACC_U88822.t=0.01206640617488343;
tree_0.D_CD_83_ELI_ACC_K03454.t=0.05053803232401123;
tree_0.Node3.t=0.01211693401151765;
tree_0.B_US_90_WEAU160_ACC_U21135.t=0.005897424801452161;
tree_1.Node11.t=0.01943622215056805;
tree_1.Node2.t=0.01930639918536271;
tree_1.Node5.t=0.00367221191230085;
tree_1.B_US_86_JRFL_ACC_U63632.t=0.003556907631311533;
tree_1.B_FR_83_HXB2_ACC_K03455.t=0.003761914794499745;
tree_1.B_US_83_RF_ACC_M17451.t=0.01579657810015503;
tree_1.Node1.t=0;
tree_1.D_CD_83_NDK_ACC_M27323.t=0;
tree_1.D_UG_94_94UG114_ACC_U88824.t=0.05405801345442108;
tree_1.RecombStrain.t=0.007591494164654542;
tree_0.Node13.t=0.005916039435863761;
tree_1.D_CD_84_84ZR085_ACC_U88822.t=0.03313660975482054;
tree_1.D_CD_83_ELI_ACC_K03454.t=0.01143840296527942;
tree_1.Node3.t=0.007767398822293749;
DataSet ds = ReadDataFile(USE_NEXUS_FILE_DATA);
DataSetFilter part_0 = CreateFilter(ds,1,"0-427","0-2,4,3,5,8,6,7");
DataSetFilter part_1 = CreateFilter(ds,1,"428-1105","0-2,7,8,3-6");
DataSetFilter part_2 = CreateFilter(ds,1,"1106-1891","0,3-6,1,2,7,8");
DataSetFilter part_3 = CreateFilter(ds,1,"1892-2399","0,1,3-8,2");

exepectedRateClassAssignments = 
{
{                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 3,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 4,                 0,                 4,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 4,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 2,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 2,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 2,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0}
};
expectedConditionalProbabilities = 

{
{    0.373102612625,  0.00100640393898,    0.198909372471,    0.203294686753,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.148615761204,    0.198909372471,    0.198909372471,    0.373102612625, 0.000189131144695,    0.373102612625,    0.198909372471,    0.203294686753,    0.373102612625,    0.373102612625,  0.00384825332164,    0.373102612625,    0.373102612625,    0.198909372471,  0.00384825332164,    0.373102612625,    0.373102612625,    0.373102612625,    0.148615761204,    0.203294686753,    0.203294686753, 0.000370550318873,    0.203294686753,    0.148615761204,    0.203294686753,    0.373102612625,    0.198909372471,    0.198909372471,    0.203294686753,    0.203294686753,    0.198909372471,    0.373102612625,    0.203294686753,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.198909372471,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.148615761204,    0.198909372471,    0.373102612625, 0.000587041037737,    0.373102612625,    0.198909372471,    0.148615761204,    0.373102612625,    0.198909372471,    0.198909372471,    0.203294686753,    0.203294686753,    0.373102612625,    0.148615761204,    0.198909372471,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.203294686753,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.373102612625,    0.203294686753,    0.373102612625,    0.148615761204,    0.373102612625,    0.148615761204,    0.198909372471,    0.203294686753,    0.148615761204,    0.373102612625,    0.148615761204,    0.148615761204,    0.198909372471,    0.148615761204,    0.373102612625,    0.203294686753,    0.198909372471,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,    0.148615761204,    0.373102612625,    0.203294686753,    0.373102612625,    0.203294686753,    0.148615761204,    0.373102612625,    0.203294686753,    0.198909372471,    0.203294686753,    0.373102612625,    0.148615761204,    0.203294686753,    0.203294686753,    0.198909372471,    0.373102612625,    0.198909372471,    0.203294686753,    0.198909372471,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.198909372471,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.203294686753,    0.203294686753,    0.203294686753,    0.198909372471,    0.203294686753,    0.198909372471,    0.373102612625,  0.00376471440265,    0.203294686753,    0.198909372471,    0.198909372471,    0.373102612625,    0.198909372471,    0.373102612625,    0.148615761204,    0.148615761204,    0.198909372471,    0.148615761204,    0.203294686753,    0.373102612625,  0.00334654493753,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,  0.00107121503335, 0.000250784108412,    0.148615761204,    0.198909372471,    0.198909372471,    0.148615761204,    0.198909372471,    0.198909372471,    0.203294686753,    0.373102612625,    0.203294686753,    0.203294686753,    0.373102612625,    0.373102612625,    0.148615761204,    0.148615761204,    0.373102612625,    0.198909372471,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,  0.00023297842818,    0.373102612625,    0.373102612625, 0.000844355211295,    0.373102612625,    0.198909372471,    0.373102612625,    0.373102612625,  0.00173698541849,    0.148615761204,    0.203294686753,    0.198909372471,  0.00334654493753,    0.148615761204,    0.373102612625,    0.373102612625,    0.203294686753,    0.198909372471,    0.373102612625,    0.198909372471,    0.203294686753,    0.373102612625,    0.198909372471,    0.373102612625,    0.198909372471,  0.00384825332164,    0.373102612625,  0.00113320760951,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.198909372471,    0.198909372471,    0.203294686753,    0.373102612625,    0.373102612625,    0.198909372471,    0.198909372471,    0.203294686753,  0.00376471440265,    0.373102612625,    0.373102612625,    0.203294686753,    0.203294686753,    0.373102612625,    0.148615761204,    0.198909372471,    0.203294686753,  0.00118398056029, 0.000234629159087,    0.198909372471,    0.373102612625,    0.203294686753,    0.373102612625,    0.203294686753,    0.148615761204,    0.203294686753,    0.373102612625,    0.198909372471,    0.198909372471,  0.00342339654122, 0.000848335770335,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625, 3.31353992055e-06,    0.373102612625,    0.148615761204,    0.148615761204,    0.148615761204, 0.000826932607081,    0.148615761204,    0.373102612625, 0.000769956745646,    0.148615761204,    0.148615761204,    0.198909372471,    0.198909372471,    0.203294686753,    0.203294686753,    0.198909372471,    0.198909372471,    0.198909372471,    0.373102612625,    0.148615761204,    0.198909372471,    0.373102612625,    0.148615761204,    0.203294686753,    0.203294686753,    0.198909372471,    0.373102612625,    0.148615761204, 0.000769956745646,    0.198909372471,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,  0.00100640393898,    0.198909372471,    0.373102612625,    0.373102612625,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.198909372471,    0.203294686753,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.373102612625,    0.148615761204,    0.203294686753,    0.148615761204,    0.148615761204, 0.000246730478226,    0.373102612625,    0.148615761204,  6.6510626881e-05,    0.198909372471,    0.373102612625,    0.198909372471,    0.198909372471,    0.198909372471,    0.373102612625,    0.373102612625,    0.203294686753,    0.203294686753,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,  0.00115432085051,    0.373102612625,    0.198909372471,    0.198909372471,    0.373102612625, 0.000838300367513,    0.203294686753,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.373102612625, 3.95301708586e-06,    0.148615761204,    0.373102612625,    0.203294686753,    0.198909372471,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.203294686753,    0.203294686753, 0.000826932607081,    0.203294686753,    0.148615761204,    0.198909372471,    0.198909372471,    0.373102612625,    0.203294686753,    0.198909372471,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.198909372471,    0.148615761204,    0.198909372471,    0.373102612625,    0.198909372471,    0.373102612625,    0.198909372471,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.373102612625,    0.203294686753, 0.000751116253949,    0.373102612625,    0.198909372471,    0.148615761204,    0.373102612625,    0.373102612625,    0.373102612625,    0.203294686753,    0.373102612625,    0.198909372471,    0.148615761204,    0.198909372471,    0.373102612625,    0.148615761204,    0.203294686753,    0.203294686753,    0.198909372471,    0.203294686753,    0.198909372471,    0.373102612625,    0.373102612625,    0.148615761204,    0.373102612625,    0.148615761204,    0.373102612625,    0.198909372471,    0.198909372471,    0.373102612625,    0.198909372471,    0.373102612625,    0.148615761204,    0.373102612625,  0.00177735535728,    0.373102612625,    0.203294686753,    0.203294686753,    0.148615761204,    0.373102612625, 7.66762193866e-05,    0.203294686753,  0.00154395111435,     0.20627235913,    0.200932311273,    0.150809553136,    0.150809553136,    0.376926911162,    0.376926911162,     0.20627235913,    0.200932311273,    0.200932311273,    0.376926911162,    0.376926911162,     0.20627235913,  0.00345068532669,    0.150809553136,    0.150809553136,     0.20627235913,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,    0.200932311273,    0.200932311273, 0.000599796608564,    0.150809553136,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.200932311273,     0.20627235913,    0.376926911162,    0.376926911162,    0.150809553136,     0.20627235913,    0.200932311273,    0.150809553136,    0.200932311273,    0.376926911162,    0.150809553136,    0.376926911162,     0.20627235913,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.150809553136,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.200932311273,    0.001056886428,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.200932311273, 0.000441345798324,    0.001056886428,    0.376926911162,    0.376926911162,    0.376926911162,  0.00352017761046,    0.376926911162,    0.200932311273,     0.20627235913,    0.376926911162,     0.20627235913,    0.001056886428,    0.376926911162,    0.150809553136,    0.150809553136,     0.20627235913,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162,     0.20627235913,    0.200932311273,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162,     0.20627235913,    0.376926911162,     0.20627235913,    0.200932311273,    0.150809553136, 0.000200842158576,    0.376926911162, 0.000264400676055,    0.200932311273,     0.20627235913,     0.20627235913,    0.376926911162,    0.376926911162,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162, 0.000482907023759,     0.20627235913,    0.376926911162,    0.200932311273,     0.20627235913,    0.150809553136,    0.150809553136,    0.376926911162,     0.20627235913,     0.20627235913,    0.200932311273,    0.150809553136,    0.150809553136,    0.376926911162,     0.20627235913,     0.20627235913,    0.150809553136, 0.000599272500992,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,     0.20627235913, 0.000254229726937,    0.376926911162,     0.20627235913,     0.20627235913,    0.376926911162,  0.00345068532669,    0.200932311273,    0.150809553136,     0.20627235913,    0.150809553136,    0.200932311273,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.150809553136,    0.200932311273,    0.150809553136,    0.376926911162,    0.200932311273,    0.150809553136,     0.20627235913,    0.376926911162,    0.376926911162,    0.200932311273,    0.200932311273,    0.200932311273,    0.150809553136,    0.150809553136,    0.200932311273,    0.200932311273,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,     0.20627235913,    0.150809553136,    0.376926911162,    0.376926911162,    0.150809553136,    0.150809553136,    0.376926911162,     0.20627235913,    0.376926911162,    0.150809553136,    0.150809553136,    0.150809553136,    0.376926911162, 0.000518801453353,    0.376926911162,     0.20627235913,    0.200932311273,    0.200932311273,    0.150809553136,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.150809553136,  0.00134923883292,    0.200932311273,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,  0.00162335388311,    0.200932311273,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273, 0.000396480480001,    0.200932311273,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162,    0.200932311273,     0.20627235913,    0.376926911162,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162,    0.150809553136,  0.00162335388311,    0.376926911162,    0.376926911162,    0.150809553136,     0.20627235913,     0.20627235913,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,    0.200932311273,    0.376926911162,    0.200932311273,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162,    0.376926911162,     0.20627235913,    0.150809553136,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,  0.00352017761046, 0.000611227065496,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273, 0.000146633338671,     0.20627235913,    0.200932311273,    0.200932311273,    0.200932311273,  0.00159172407339, 0.000615806833539,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,    0.150809553136,    0.376926911162,    0.150809553136,    0.376926911162,     0.20627235913,    0.376926911162,    0.150809553136,   0.0021816764981,    0.376926911162,     0.20627235913,    0.200932311273,     0.20627235913,    0.376926911162,    0.150809553136,    0.376926911162,    0.200932311273,    0.150809553136,    0.376926911162,    0.150809553136,    0.150809553136,    0.200932311273,    0.150809553136,  0.00134923883292,    0.376926911162,    0.376926911162,    0.376926911162, 0.000599272500992,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,  0.00133741027525,    0.200932311273,    0.200932311273,    0.376926911162,     0.20627235913,    0.150809553136,    0.376926911162,    0.376926911162,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,     0.20627235913,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.200932311273,    0.376926911162,    0.150809553136, 7.33763427876e-05,    0.001596767597,    0.376926911162,     0.20627235913,    0.150809553136,    0.376926911162,    0.376926911162,     0.20627235913,     0.20627235913,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.200932311273,     0.20627235913,    0.150809553136,     0.20627235913,     0.20627235913,    0.150809553136,   0.0013240416966,    0.200932311273,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.200932311273,     0.20627235913,    0.200932311273,    0.150809553136,    0.200932311273,    0.150809553136, 0.000611227065496,     0.20627235913,     0.20627235913,    0.200932311273,    0.150809553136,    0.150809553136,    0.376926911162,  7.9327379033e-05,    0.376926911162,    0.200932311273,    0.150809553136, 0.000212371061842,     0.20627235913,     0.20627235913,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.200932311273,     0.20627235913,    0.376926911162,    0.376926911162,     0.20627235913,    0.150809553136,     0.20627235913,    0.200932311273,    0.376926911162,     0.20627235913,    0.150809553136,    0.150809553136,    0.150809553136,    0.200932311273,    0.200932311273,     0.20627235913,     0.20627235913,    0.376926911162,    0.200932311273,    0.376926911162, 0.000264258485169,    0.376926911162,    0.376926911162,    0.150809553136,    0.200932311273,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162,     0.20627235913,     0.20627235913,    0.150809553136,    0.200932311273,     0.20627235913,     0.20627235913,    0.150809553136,    0.200932311273,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.150809553136,    0.150809553136,    0.376926911162, 0.000599796608564,    0.376926911162,    0.376926911162,    0.150809553136,    0.376926911162,    0.200932311273,    0.200932311273,    0.376926911162,     0.20627235913,    0.200932311273,    0.200932311273,    0.200932311273,    0.376926911162,    0.200932311273,    0.376926911162,     0.20627235913,    0.200932311273,     0.20627235913,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162, 0.000158798484763,    0.376926911162,     0.20627235913,    0.200932311273,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.200932311273,    0.150809553136,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,    0.150809553136,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,    0.200932311273,    0.200932311273,    0.376926911162,     0.20627235913,    0.200932311273,  0.00345068532669,    0.200932311273,    0.200932311273,    0.150809553136,     0.20627235913,    0.200932311273,    0.376926911162,    0.200932311273,    0.001596767597,    0.376926911162,     0.20627235913,    0.376926911162,    0.200932311273, 0.000254111959731,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.150809553136,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162,    0.200932311273,    0.150809553136,    0.150809553136,     0.20627235913,    0.150809553136,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,     0.20627235913,    0.200932311273,     0.20627235913,    0.200932311273,     0.20627235913,    0.150809553136,     0.20627235913,     0.20627235913,    0.200932311273, 0.000254111959731,     0.20627235913,    0.150809553136,    0.200932311273,    0.376926911162,    0.001056886428,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,    0.150809553136,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.150809553136,     0.20627235913,    0.376926911162,    0.150809553136,    0.376926911162,    0.200932311273,    0.200932311273,    0.150809553136,     0.20627235913,    0.376926911162,    0.376926911162,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,  0.00104707165931,    0.376926911162,    0.150809553136,    0.376926911162,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,    0.376926911162,    0.200932311273,     0.20627235913,    0.376926911162,    0.150809553136,   0.0010717182581,    0.376926911162,    0.376926911162,    0.150809553136,    0.376926911162,    0.200932311273,     0.20627235913,    0.150809553136,    0.200932311273,     0.20627235913,     0.20627235913,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.150809553136,  0.00056247779008,     0.20627235913,    0.200932311273,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.200932311273,    0.376926911162,    0.150809553136, 7.16616084779e-05,    0.376926911162,    0.200932311273,    0.376926911162,     0.20627235913,   0.0021816764981,    0.376926911162,     0.20627235913,     0.20627235913,    0.150809553136,    0.200932311273,    0.150809553136,     0.20627235913,     0.20627235913,    0.200932311273,  0.00077856397444,    0.376926911162,    0.200932311273,    0.150809553136, 0.000320540716695,    0.376926911162,    0.200932311273,    0.200932311273,     0.20627235913,    0.376926911162,     0.20627235913,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,     0.20627235913,     0.20627235913,    0.376926911162,     0.20627235913,    0.200932311273,    0.376926911162,    0.376926911162,    0.150809553136,     0.20627235913,     0.20627235913,    0.200932311273, 0.000522282424334, 0.000262711135727,    0.376926911162,     0.20627235913,     0.20627235913,    0.150809553136,    0.376926911162,    0.200932311273,    0.376926911162,     0.20627235913,    0.376926911162,     0.20627235913,    0.200932311273,    0.150809553136,    0.376926911162,    0.376926911162,    0.376926911162,    0.376926911162,   0.0013240416966,     0.20627235913,     0.20627235913,     0.20627235913,    0.376926911162,     0.20627235913,    0.376926911162,    0.200932311273,  0.00212775353407,    0.198259521204,    0.198259521204,    0.202338007603,    0.147915646674,    0.202338007603,    0.371855979636,  0.00103097081993,    0.371855979636,    0.198259521204,  0.00131144910088,    0.371855979636,    0.198259521204,    0.147915646674,    0.198259521204,    0.202338007603,    0.147915646674,    0.202338007603,    0.198259521204,    0.202338007603,    0.371855979636,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636,    0.371855979636,    0.198259521204,    0.198259521204,    0.147915646674,    0.202338007603,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204,    0.147915646674,    0.202338007603,    0.198259521204,    0.371855979636,  0.00103097081993,    0.202338007603,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.371855979636,    0.371855979636,   7.195161161e-05,    0.198259521204,    0.202338007603,    0.147915646674,    0.371855979636,    0.371855979636,    0.202338007603, 0.000877782717351,    0.198259521204,    0.147915646674,    0.147915646674,    0.371855979636,    0.202338007603,    0.371855979636,    0.147915646674,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.198259521204,    0.202338007603,    0.371855979636,  0.00131144910088,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.198259521204,    0.371855979636, 0.000416426863533,    0.198259521204,    0.147915646674,    0.198259521204,    0.202338007603,    0.147915646674,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.202338007603,    0.371855979636,    0.202338007603,    0.202338007603,    0.198259521204,    0.147915646674,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.198259521204,    0.371855979636, 0.000907568630791,    0.147915646674,    0.371855979636,    0.202338007603,    0.202338007603,    0.147915646674,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.202338007603,    0.371855979636,    0.198259521204,    0.198259521204,    0.198259521204, 0.000404100682603,    0.202338007603,    0.147915646674,    0.202338007603,    0.198259521204,    0.371855979636,  0.00131144910088,    0.147915646674,    0.147915646674,    0.147915646674,    0.371855979636,    0.198259521204,    0.198259521204,    0.202338007603,    0.147915646674,    0.198259521204,    0.198259521204,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.198259521204,   0.0022655052843,    0.198259521204,    0.198259521204,    0.147915646674,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603,    0.198259521204,    0.371855979636,    0.371855979636, 0.000604861713212,    0.198259521204,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636,    0.371855979636, 0.000705349489885,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.147915646674,    0.371855979636,    0.371855979636,    0.147915646674,    0.202338007603,    0.198259521204,    0.198259521204,    0.371855979636,    0.202338007603,    0.202338007603,    0.198259521204,    0.147915646674,    0.371855979636,    0.147915646674,    0.147915646674,    0.371855979636,    0.147915646674, 0.000812949421817,  0.00134957693151,    0.147915646674,    0.147915646674,    0.202338007603,    0.198259521204,    0.371855979636,    0.198259521204,    0.202338007603,    0.371855979636,    0.198259521204,    0.147915646674,    0.198259521204, 0.000906136616391,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603, 0.000898585885936,    0.202338007603,    0.198259521204,    0.198259521204,    0.371855979636, 2.70362440073e-05,    0.202338007603,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636, 0.000434414794043,    0.147915646674,    0.202338007603,    0.371855979636,    0.371855979636, 0.000248666453095,    0.147915646674, 0.000360970326739,    0.202338007603,    0.371855979636,    0.371855979636,  0.00310360584614,    0.147915646674,    0.198259521204,    0.202338007603,    0.198259521204,    0.198259521204,    0.202338007603,    0.198259521204,    0.198259521204,    0.371855979636,    0.198259521204,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204,    0.202338007603,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636,    0.198259521204,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.147915646674,    0.202338007603,    0.202338007603,    0.198259521204, 0.000872855496694,    0.202338007603,    0.371855979636, 0.000141859416056,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.202338007603, 0.000210042457866,    0.371855979636,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636,    0.371855979636,  0.00176257364911,    0.198259521204,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636,    0.198259521204,    0.198259521204,    0.147915646674,    0.147915646674,    0.198259521204,    0.198259521204,    0.371855979636,    0.147915646674,    0.371855979636,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.147915646674,    0.147915646674,    0.198259521204,    0.198259521204,    0.198259521204,    0.371855979636,    0.371855979636,    0.198259521204,    0.198259521204,    0.202338007603,    0.198259521204,    0.202338007603,    0.371855979636,  0.00087356816053,    0.147915646674,    0.198259521204,    0.147915646674,    0.198259521204, 0.000286682371544,    0.147915646674,    0.371855979636,    0.147915646674,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.198259521204,    0.371855979636,    0.198259521204,    0.202338007603,    0.202338007603,    0.198259521204,    0.371855979636,    0.147915646674,    0.202338007603,    0.202338007603,    0.202338007603,    0.202338007603,    0.198259521204,    0.371855979636,   0.0022371335901,    0.147915646674,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.198259521204,    0.147915646674,    0.147915646674,    0.371855979636,    0.198259521204,    0.198259521204,    0.198259521204,    0.202338007603,  0.00310360584614,    0.147915646674, 0.000404100682603,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636,    0.202338007603,    0.371855979636,    0.198259521204,    0.198259521204,    0.371855979636,    0.198259521204,    0.371855979636,    0.202338007603, 0.000247797327543,    0.198259521204,    0.198259521204,    0.202338007603,    0.198259521204,    0.371855979636,  0.00131144910088,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,    0.198259521204,    0.202338007603,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636,    0.198259521204,    0.202338007603,    0.147915646674,    0.198259521204,    0.202338007603,    0.198259521204,    0.202338007603,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603,    0.371855979636,    0.202338007603,    0.147915646674,    0.198259521204,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.198259521204,    0.147915646674,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.202338007603,    0.371855979636,    0.198259521204,    0.198259521204,    0.371855979636,    0.147915646674,  0.00152927603994,    0.371855979636,    0.371855979636,  0.00146916551147,    0.202338007603,    0.198259521204,    0.202338007603,    0.371855979636,    0.198259521204,  0.00152927603994,    0.147915646674,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204, 0.000412145552187,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.147915646674,    0.147915646674,    0.202338007603,    0.198259521204,    0.371855979636,    0.198259521204,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636, 0.000405117717422,    0.147915646674,    0.371855979636,    0.202338007603,    0.371855979636, 0.000883172257984,    0.371855979636, 0.000932298626964,    0.198259521204,    0.371855979636,    0.371855979636, 0.000883172257984,    0.198259521204,    0.198259521204,    0.147915646674,    0.371855979636,    0.371855979636, 0.000252064797928,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.198259521204,    0.202338007603,    0.198259521204,    0.147915646674,    0.198259521204,    0.147915646674,    0.202338007603,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.198259521204,    0.202338007603,    0.198259521204,    0.371855979636,  0.00310360584614,    0.198259521204, 0.000268940918112,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603, 0.000252064797928,    0.371855979636,    0.202338007603,    0.371855979636, 0.000247655602017,    0.371855979636,    0.147915646674,    0.147915646674,    0.371855979636,    0.202338007603,    0.147915646674,    0.202338007603,    0.371855979636, 0.000892795705185,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636,    0.198259521204,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636,    0.147915646674, 0.000103799899633,    0.198259521204,    0.371855979636,    0.371855979636,    0.198259521204,    0.198259521204,    0.202338007603,    0.371855979636,    0.198259521204,    0.202338007603,    0.371855979636,    0.198259521204,    0.202338007603,  0.00318269060858,    0.371855979636,    0.147915646674,    0.147915646674,    0.147915646674,   0.0010451003146,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603,    0.371855979636,    0.371855979636,    0.198259521204,    0.371855979636, 0.000605177949608,    0.371855979636,    0.198259521204, 0.000932298626964,    0.371855979636, 4.17580856902e-05,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.147915646674,    0.147915646674,    0.147915646674,    0.198259521204,    0.198259521204, 0.000220418054992,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.198259521204,    0.147915646674,    0.371855979636,    0.198259521204,    0.202338007603,    0.198259521204,    0.198259521204,    0.371855979636,    0.202338007603,    0.371855979636,    0.147915646674,  0.00087356816053,    0.147915646674,    0.198259521204,    0.371855979636, 0.000248380038377,    0.371855979636,    0.198259521204,    0.198259521204,    0.198259521204,    0.198259521204,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,  0.00134957693151,    0.202338007603,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.198259521204, 0.000705349489885,    0.198259521204,    0.198259521204, 0.000877782717351,    0.371855979636,    0.198259521204,    0.371855979636,    0.147915646674,    0.202338007603,    0.371855979636,    0.202338007603,    0.202338007603,    0.147915646674,    0.198259521204,    0.147915646674,    0.371855979636,    0.147915646674,    0.371855979636,    0.371855979636,    0.202338007603,    0.371855979636,    0.147915646674,  0.00310360584614,    0.202338007603,    0.371855979636,    0.371855979636,    0.198259521204,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.147915646674,    0.202338007603,    0.198259521204,    0.202338007603,    0.198259521204,    0.198259521204,    0.198259521204,    0.147915646674,    0.371855979636,    0.198259521204,    0.371855979636,    0.371855979636, 0.000836273211867,    0.371855979636,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636,    0.147915646674, 0.000883559304543,    0.371855979636,    0.198259521204,  0.00318269060858,    0.371855979636, 0.000630198501587,    0.202338007603,    0.371855979636,    0.198259521204,    0.371855979636, 5.11134690091e-06,    0.147915646674,    0.147915646674,    0.371855979636,    0.202338007603,    0.371855979636,    0.147915646674,    0.202338007603,    0.202338007603, 0.000725855962719,    0.371855979636,    0.371855979636,    0.371855979636,    0.198259521204,    0.198259521204, 0.000528097088634,    0.147915646674,    0.202338007603,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,    0.147915646674,    0.198259521204,    0.202338007603,    0.198259521204,    0.371855979636,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.198259521204,    0.202338007603,    0.371855979636,    0.371855979636,    0.198259521204,    0.202338007603,    0.147915646674,    0.198259521204,   0.0022655052843,  0.00039273477404,    0.147915646674,    0.371855979636,    0.202338007603,    0.202338007603,    0.371855979636,    0.371855979636,    0.371855979636,    0.147915646674,    0.198259521204,    0.147915646674,    0.371855979636,    0.198259521204,    0.202338007603,    0.147915646674,    0.198259521204,  0.00176257364911,    0.371855979636,    0.371855979636,    0.198259521204,  0.00103097081993,    0.147915646674,    0.371855979636,    0.371855979636, 0.000372425336687,    0.198259521204,    0.202338007603,    0.198259521204,    0.371855979636,    0.202338007603,    0.147915646674,    0.371855979636, 0.000247650881614,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.379820022921,    0.202458484825,    0.152470111416,    0.208528784498,    0.379820022921,    0.208528784498,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498, 0.000732432983637,    0.208528784498,    0.202458484825,    0.202458484825,    0.152470111416,    0.202458484825,    0.152470111416,    0.152470111416,  0.00151601799371,    0.208528784498,    0.208528784498,    0.379820022921,    0.208528784498,    0.208528784498,    0.379820022921,    0.379820022921,    0.152470111416,  0.00184649181942,    0.152470111416,    0.208528784498,    0.152470111416,    0.379820022921,    0.202458484825,    0.379820022921,    0.208528784498,    0.208528784498,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921, 0.000927414149367,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.208528784498,    0.379820022921,    0.001472391245,    0.152470111416,    0.202458484825,    0.379820022921,    0.379820022921,    0.208528784498,    0.208528784498,    0.202458484825,    0.379820022921,    0.208528784498,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.208528784498, 0.000408474655741,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.202458484825,    0.152470111416,    0.152470111416,    0.202458484825,    0.202458484825,    0.208528784498,    0.208528784498,    0.152470111416,    0.152470111416,    0.208528784498,    0.379820022921,    0.379820022921,    0.152470111416,  0.00011656210147,    0.202458484825,  0.00333674981264,    0.202458484825,  0.00109890492347,    0.152470111416,    0.152470111416,    0.208528784498,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.208528784498,    0.202458484825, 0.000843861925105,    0.379820022921,    0.152470111416,    0.202458484825, 5.88754363031e-05,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,  0.00328551335829,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.152470111416,    0.202458484825,    0.202458484825,    0.202458484825,    0.152470111416,    0.379820022921,  0.00333674981264,    0.152470111416,    0.379820022921,    0.208528784498,    0.208528784498,    0.208528784498,    0.379820022921,    0.379820022921,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.202458484825,    0.152470111416,    0.379820022921,    0.152470111416,    0.379820022921,    0.208528784498,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.208528784498,    0.202458484825,    0.202458484825,    0.379820022921,    0.152470111416,    0.202458484825,    0.152470111416,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.152470111416,    0.379820022921,    0.202458484825,    0.202458484825,    0.379820022921,    0.379820022921, 0.000665932521018,    0.379820022921,    0.152470111416,    0.208528784498,  0.00071796426467,    0.202458484825,    0.208528784498,    0.379820022921,    0.202458484825, 0.000987843621483,    0.208528784498,    0.208528784498, 0.000732432983637,    0.202458484825,    0.202458484825,    0.208528784498,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.152470111416,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.152470111416,    0.208528784498,    0.208528784498,    0.202458484825, 0.000683103578456,    0.202458484825,    0.208528784498,    0.379820022921,    0.152470111416,    0.152470111416,    0.202458484825,    0.208528784498,    0.208528784498,    0.202458484825,    0.379820022921,    0.202458484825,    0.208528784498,    0.202458484825,    0.152470111416,    0.152470111416,    0.379820022921,    0.152470111416,    0.202458484825,    0.208528784498,    0.379820022921,    0.202458484825,    0.379820022921,    0.202458484825,    0.202458484825,    0.379820022921,    0.208528784498,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,   0.0014519556318,    0.379820022921,    0.379820022921,    0.152470111416,    0.202458484825,    0.202458484825,    0.202458484825,    0.379820022921,    0.152470111416,    0.208528784498,    0.202458484825,    0.208528784498,    0.379820022921,    0.202458484825,    0.379820022921,    0.208528784498,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.379820022921,    0.152470111416, 0.000927414149367,    0.202458484825,    0.152470111416,    0.152470111416,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.152470111416,    0.202458484825,    0.208528784498,    0.379820022921,    0.379820022921,    0.202458484825,    0.202458484825,    0.202458484825,    0.379820022921,    0.152470111416,    0.208528784498,    0.152470111416,    0.152470111416,    0.208528784498,    0.152470111416,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.208528784498, 0.000851871689786,    0.379820022921,    0.379820022921,    0.208528784498,    0.152470111416,    0.208528784498,    0.202458484825,    0.208528784498,    0.379820022921,    0.379820022921,    0.208528784498,    0.202458484825,    0.152470111416,    0.208528784498,    0.379820022921,    0.379820022921,  0.00333674981264,    0.379820022921,    0.152470111416,    0.379820022921,    0.379820022921,    0.152470111416, 0.000364933843428,    0.202458484825,    0.208528784498,    0.152470111416,    0.202458484825, 0.000170835908018,    0.208528784498,    0.152470111416,    0.208528784498,    0.208528784498,    0.379820022921,    0.379820022921,    0.208528784498,    0.152470111416,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.202458484825,    0.379820022921,    0.152470111416,    0.202458484825,    0.202458484825,    0.379820022921,    0.202458484825,    0.208528784498, 0.000366489111342,    0.152470111416,    0.379820022921,    0.152470111416, 0.000357692613189,    0.152470111416,    0.208528784498,    0.202458484825,  0.00144380583684,  1.0238488898e-06,    0.208528784498,    0.379820022921,    0.208528784498,    0.202458484825,    0.202458484825,    0.208528784498,    0.208528784498,    0.202458484825,    0.379820022921,    0.152470111416,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.208528784498,    0.152470111416,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.208528784498,    0.202458484825,    0.379820022921,    0.202458484825,    0.208528784498,    0.379820022921,    0.202458484825,    0.379820022921,    0.208528784498,    0.379820022921,    0.152470111416,    0.152470111416,    0.379820022921,    0.208528784498,    0.208528784498,    0.202458484825,    0.208528784498,    0.152470111416,    0.152470111416,    0.202458484825,    0.152470111416,  0.00151601799371,    0.379820022921,    0.208528784498,    0.379820022921,  0.00144380583684,    0.208528784498,    0.379820022921,   0.0018298948576,    0.202458484825,    0.208528784498,    0.208528784498,    0.379820022921,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.152470111416,    0.202458484825,    0.202458484825,    0.379820022921,    0.152470111416,  0.00107788975278,    0.379820022921,    0.202458484825,    0.208528784498,    0.202458484825,    0.208528784498,    0.208528784498,    0.202458484825,    0.379820022921,    0.208528784498,    0.152470111416,    0.208528784498,    0.202458484825,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.208528784498,    0.152470111416,    0.379820022921,    0.208528784498,    0.202458484825,    0.202458484825,    0.379820022921,    0.379820022921,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.379820022921,    0.202458484825,    0.152470111416,    0.379820022921,    0.208528784498,    0.379820022921,    0.202458484825,    0.202458484825,    0.379820022921,    0.379820022921,    0.202458484825,    0.379820022921,    0.379820022921,    0.208528784498,    0.379820022921,    0.379820022921,    0.152470111416,    0.152470111416,    0.152470111416,    0.152470111416,    0.208528784498,    0.379820022921,    0.379820022921}
{    0.370546777204,  0.00109882478718,    0.197557881821,    0.201312536128,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.147155834141,    0.197557881821,    0.197557881821,    0.370546777204,  0.00020627770484,    0.370546777204,    0.197557881821,    0.201312536128,    0.370546777204,    0.370546777204,  0.00420834766579,    0.370546777204,    0.370546777204,    0.197557881821,  0.00420834766579,    0.370546777204,    0.370546777204,    0.370546777204,    0.147155834141,    0.201312536128,    0.201312536128, 0.000404291926999,    0.201312536128,    0.147155834141,    0.201312536128,    0.370546777204,    0.197557881821,    0.197557881821,    0.201312536128,    0.201312536128,    0.197557881821,    0.370546777204,    0.201312536128,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.197557881821,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.147155834141,    0.197557881821,    0.370546777204, 0.000642133436036,    0.370546777204,    0.197557881821,    0.147155834141,    0.370546777204,    0.197557881821,    0.197557881821,    0.201312536128,    0.201312536128,    0.370546777204,    0.147155834141,    0.197557881821,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.201312536128,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.370546777204,    0.201312536128,    0.370546777204,    0.147155834141,    0.370546777204,    0.147155834141,    0.197557881821,    0.201312536128,    0.147155834141,    0.370546777204,    0.147155834141,    0.147155834141,    0.197557881821,    0.147155834141,    0.370546777204,    0.201312536128,    0.197557881821,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,    0.147155834141,    0.370546777204,    0.201312536128,    0.370546777204,    0.201312536128,    0.147155834141,    0.370546777204,    0.201312536128,    0.197557881821,    0.201312536128,    0.370546777204,    0.147155834141,    0.201312536128,    0.201312536128,    0.197557881821,    0.370546777204,    0.197557881821,    0.201312536128,    0.197557881821,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.197557881821,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.201312536128,    0.201312536128,    0.201312536128,    0.197557881821,    0.201312536128,    0.197557881821,    0.370546777204,  0.00410782875567,    0.201312536128,    0.197557881821,    0.197557881821,    0.370546777204,    0.197557881821,    0.370546777204,    0.147155834141,    0.147155834141,    0.197557881821,    0.147155834141,    0.201312536128,    0.370546777204,  0.00365138091875,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,  0.00117287642082,   0.0002741240487,    0.147155834141,    0.197557881821,    0.197557881821,    0.147155834141,    0.197557881821,    0.197557881821,    0.201312536128,    0.370546777204,    0.201312536128,    0.201312536128,    0.370546777204,    0.370546777204,    0.147155834141,    0.147155834141,    0.370546777204,    0.197557881821,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204, 0.000254601625325,    0.370546777204,    0.370546777204,  0.00092293806835,    0.370546777204,    0.197557881821,    0.370546777204,    0.370546777204,  0.00189526332842,    0.147155834141,    0.201312536128,    0.197557881821,  0.00365138091875,    0.147155834141,    0.370546777204,    0.370546777204,    0.201312536128,    0.197557881821,    0.370546777204,    0.197557881821,    0.201312536128,    0.370546777204,    0.197557881821,    0.370546777204,    0.197557881821,  0.00420834766579,    0.370546777204,  0.00123744603138,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.197557881821,    0.197557881821,    0.201312536128,    0.370546777204,    0.370546777204,    0.197557881821,    0.197557881821,    0.201312536128,  0.00410782875567,    0.370546777204,    0.370546777204,    0.201312536128,    0.201312536128,    0.370546777204,    0.147155834141,    0.197557881821,    0.201312536128,  0.00129498729595,  0.00025673031954,    0.197557881821,    0.370546777204,    0.201312536128,    0.370546777204,    0.201312536128,    0.147155834141,    0.201312536128,    0.370546777204,    0.197557881821,    0.197557881821,  0.00374385221513, 0.000927722108682,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,  3.9836259667e-06,    0.370546777204,    0.147155834141,    0.147155834141,    0.147155834141, 0.000902213836027,    0.147155834141,    0.370546777204, 0.000842549338391,    0.147155834141,    0.147155834141,    0.197557881821,    0.197557881821,    0.201312536128,    0.201312536128,    0.197557881821,    0.197557881821,    0.197557881821,    0.370546777204,    0.147155834141,    0.197557881821,    0.370546777204,    0.147155834141,    0.201312536128,    0.201312536128,    0.197557881821,    0.370546777204,    0.147155834141, 0.000842549338391,    0.197557881821,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,  0.00109882478718,    0.197557881821,    0.370546777204,    0.370546777204,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.197557881821,    0.201312536128,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.370546777204,    0.147155834141,    0.201312536128,    0.147155834141,    0.147155834141, 0.000269159711548,    0.370546777204,    0.147155834141, 7.25510783703e-05,    0.197557881821,    0.370546777204,    0.197557881821,    0.197557881821,    0.197557881821,    0.370546777204,    0.370546777204,    0.201312536128,    0.201312536128,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,  0.00125930521218,    0.370546777204,    0.197557881821,    0.197557881821,    0.370546777204, 0.000916183421099,    0.201312536128,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.370546777204, 4.75094226837e-06,    0.147155834141,    0.370546777204,    0.201312536128,    0.197557881821,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.201312536128,    0.201312536128, 0.000902213836027,    0.201312536128,    0.147155834141,    0.197557881821,    0.197557881821,    0.370546777204,    0.201312536128,    0.197557881821,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.197557881821,    0.147155834141,    0.197557881821,    0.370546777204,    0.197557881821,    0.370546777204,    0.197557881821,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.370546777204,    0.201312536128, 0.000819861235576,    0.370546777204,    0.197557881821,    0.147155834141,    0.370546777204,    0.370546777204,    0.370546777204,    0.201312536128,    0.370546777204,    0.197557881821,    0.147155834141,    0.197557881821,    0.370546777204,    0.147155834141,    0.201312536128,    0.201312536128,    0.197557881821,    0.201312536128,    0.197557881821,    0.370546777204,    0.370546777204,    0.147155834141,    0.370546777204,    0.147155834141,    0.370546777204,    0.197557881821,    0.197557881821,    0.370546777204,    0.197557881821,    0.370546777204,    0.147155834141,    0.370546777204,  0.00194383293108,    0.370546777204,    0.201312536128,    0.201312536128,    0.147155834141,    0.370546777204, 8.37401635764e-05,    0.201312536128,  0.00168455092352,    0.204560474739,    0.199770746293,    0.149549093428,    0.149549093428,    0.374727925177,    0.374727925177,    0.204560474739,    0.199770746293,    0.199770746293,    0.374727925177,    0.374727925177,    0.204560474739,  0.00377138445399,    0.149549093428,    0.149549093428,    0.204560474739,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.199770746293,    0.199770746293, 0.000657327832612,    0.149549093428,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.199770746293,    0.204560474739,    0.374727925177,    0.374727925177,    0.149549093428,    0.204560474739,    0.199770746293,    0.149549093428,    0.199770746293,    0.374727925177,    0.149549093428,    0.374727925177,    0.204560474739,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.149549093428,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.199770746293,  0.00115805643871,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.199770746293, 0.000483459509408,  0.00115805643871,    0.374727925177,    0.374727925177,    0.374727925177,  0.00385511071059,    0.374727925177,    0.199770746293,    0.204560474739,    0.374727925177,    0.204560474739,  0.00115805643871,    0.374727925177,    0.149549093428,    0.149549093428,    0.204560474739,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177,    0.204560474739,    0.199770746293,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177,    0.204560474739,    0.374727925177,    0.204560474739,    0.199770746293,    0.149549093428, 0.000220231061372,    0.374727925177, 0.000289883280599,    0.199770746293,    0.204560474739,    0.204560474739,    0.374727925177,    0.374727925177,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177, 0.000527548452817,    0.204560474739,    0.374727925177,    0.199770746293,    0.204560474739,    0.149549093428,    0.149549093428,    0.374727925177,    0.204560474739,    0.204560474739,    0.199770746293,    0.149549093428,    0.149549093428,    0.374727925177,    0.204560474739,    0.204560474739,    0.149549093428, 0.000656688120464,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.204560474739, 0.000277827313574,    0.374727925177,    0.204560474739,    0.204560474739,    0.374727925177,  0.00377138445399,    0.199770746293,    0.149549093428,    0.204560474739,    0.149549093428,    0.199770746293,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.149549093428,    0.199770746293,    0.149549093428,    0.374727925177,    0.199770746293,    0.149549093428,    0.204560474739,    0.374727925177,    0.374727925177,    0.199770746293,    0.199770746293,    0.199770746293,    0.149549093428,    0.149549093428,    0.199770746293,    0.199770746293,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.204560474739,    0.149549093428,    0.374727925177,    0.374727925177,    0.149549093428,    0.149549093428,    0.374727925177,    0.204560474739,    0.374727925177,    0.149549093428,    0.149549093428,    0.149549093428,    0.374727925177,   0.0005667491272,    0.374727925177,    0.204560474739,    0.199770746293,    0.199770746293,    0.149549093428,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.149549093428,  0.00147943076895,    0.199770746293,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,  0.00177769633641,    0.199770746293,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293, 0.000434042720061,    0.199770746293,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177,    0.199770746293,    0.204560474739,    0.374727925177,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177,    0.149549093428,  0.00177769633641,    0.374727925177,    0.374727925177,    0.149549093428,    0.204560474739,    0.204560474739,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,    0.199770746293,    0.374727925177,    0.199770746293,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177,    0.374727925177,    0.204560474739,    0.149549093428,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,  0.00385511071059, 0.000668988360994,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293, 0.000160602680772,    0.204560474739,    0.199770746293,    0.199770746293,    0.199770746293,  0.00173959143743, 0.000674512649413,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.149549093428,    0.374727925177,    0.149549093428,    0.374727925177,    0.204560474739,    0.374727925177,    0.149549093428,  0.00239099471728,    0.374727925177,    0.204560474739,    0.199770746293,    0.204560474739,    0.374727925177,    0.149549093428,    0.374727925177,    0.199770746293,    0.149549093428,    0.374727925177,    0.149549093428,    0.149549093428,    0.199770746293,    0.149549093428,  0.00147943076895,    0.374727925177,    0.374727925177,    0.374727925177, 0.000656688120464,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,  0.00146522789451,    0.199770746293,    0.199770746293,    0.374727925177,    0.204560474739,    0.149549093428,    0.374727925177,    0.374727925177,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.204560474739,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.199770746293,    0.374727925177,    0.149549093428, 8.03878710448e-05,  0.00174825874574,    0.374727925177,    0.204560474739,    0.149549093428,    0.374727925177,    0.374727925177,    0.204560474739,    0.204560474739,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.199770746293,    0.204560474739,    0.149549093428,    0.204560474739,    0.204560474739,    0.149549093428,  0.00144911068505,    0.199770746293,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.199770746293,    0.204560474739,    0.199770746293,    0.149549093428,    0.199770746293,    0.149549093428, 0.000668988360994,    0.204560474739,    0.204560474739,    0.199770746293,    0.149549093428,    0.149549093428,    0.374727925177, 8.68664495744e-05,    0.374727925177,    0.199770746293,    0.149549093428, 0.000232171319158,    0.204560474739,    0.204560474739,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.199770746293,    0.204560474739,    0.374727925177,    0.374727925177,    0.204560474739,    0.149549093428,    0.204560474739,    0.199770746293,    0.374727925177,    0.204560474739,    0.149549093428,    0.149549093428,    0.149549093428,    0.199770746293,    0.199770746293,    0.204560474739,    0.204560474739,    0.374727925177,    0.199770746293,    0.374727925177, 0.000289463730847,    0.374727925177,    0.374727925177,    0.149549093428,    0.199770746293,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177,    0.204560474739,    0.204560474739,    0.149549093428,    0.199770746293,    0.204560474739,    0.204560474739,    0.149549093428,    0.199770746293,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.149549093428,    0.149549093428,    0.374727925177, 0.000657327832612,    0.374727925177,    0.374727925177,    0.149549093428,    0.374727925177,    0.199770746293,    0.199770746293,    0.374727925177,    0.204560474739,    0.199770746293,    0.199770746293,    0.199770746293,    0.374727925177,    0.199770746293,    0.374727925177,    0.204560474739,    0.199770746293,    0.204560474739,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177, 0.000173905795104,    0.374727925177,    0.204560474739,    0.199770746293,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.199770746293,    0.149549093428,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.149549093428,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,    0.199770746293,    0.199770746293,    0.374727925177,    0.204560474739,    0.199770746293,  0.00377138445399,    0.199770746293,    0.199770746293,    0.149549093428,    0.204560474739,    0.199770746293,    0.374727925177,    0.199770746293,  0.00174825874574,    0.374727925177,    0.204560474739,    0.374727925177,    0.199770746293, 0.000277683982419,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.149549093428,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177,    0.199770746293,    0.149549093428,    0.149549093428,    0.204560474739,    0.149549093428,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.204560474739,    0.199770746293,    0.204560474739,    0.199770746293,    0.204560474739,    0.149549093428,    0.204560474739,    0.204560474739,    0.199770746293, 0.000277683982419,    0.204560474739,    0.149549093428,    0.199770746293,    0.374727925177,  0.00115805643871,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.149549093428,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.149549093428,    0.204560474739,    0.374727925177,    0.149549093428,    0.374727925177,    0.199770746293,    0.199770746293,    0.149549093428,    0.204560474739,    0.374727925177,    0.374727925177,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,   0.0011439308582,    0.374727925177,    0.149549093428,    0.374727925177,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.374727925177,    0.199770746293,    0.204560474739,    0.374727925177,    0.149549093428,  0.00117362858969,    0.374727925177,    0.374727925177,    0.149549093428,    0.374727925177,    0.199770746293,    0.204560474739,    0.149549093428,    0.199770746293,    0.204560474739,    0.204560474739,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.149549093428, 0.000615065097061,    0.204560474739,    0.199770746293,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.199770746293,    0.374727925177,    0.149549093428, 7.83218436134e-05,    0.374727925177,    0.199770746293,    0.374727925177,    0.204560474739,  0.00239099471728,    0.374727925177,    0.204560474739,    0.204560474739,    0.149549093428,    0.199770746293,    0.149549093428,    0.204560474739,    0.204560474739,    0.199770746293, 0.000850483172218,    0.374727925177,    0.199770746293,    0.149549093428, 0.000351067457516,    0.374727925177,    0.199770746293,    0.199770746293,    0.204560474739,    0.374727925177,    0.204560474739,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,    0.204560474739,    0.204560474739,    0.374727925177,    0.204560474739,    0.199770746293,    0.374727925177,    0.374727925177,    0.149549093428,    0.204560474739,    0.204560474739,    0.199770746293, 0.000570845036676, 0.000288155847521,    0.374727925177,    0.204560474739,    0.204560474739,    0.149549093428,    0.374727925177,    0.199770746293,    0.374727925177,    0.204560474739,    0.374727925177,    0.204560474739,    0.199770746293,    0.149549093428,    0.374727925177,    0.374727925177,    0.374727925177,    0.374727925177,  0.00144911068505,    0.204560474739,    0.204560474739,    0.204560474739,    0.374727925177,    0.204560474739,    0.374727925177,    0.199770746293,  0.00232601444855,    0.196960887815,    0.196960887815,     0.20043554663,    0.146515170005,     0.20043554663,    0.369397356417,  0.00111763081028,    0.369397356417,    0.196960887815,  0.00142034581272,    0.369397356417,    0.196960887815,    0.146515170005,    0.196960887815,     0.20043554663,    0.146515170005,     0.20043554663,    0.196960887815,     0.20043554663,    0.369397356417,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417,    0.369397356417,    0.196960887815,    0.196960887815,    0.146515170005,     0.20043554663,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815,    0.146515170005,     0.20043554663,    0.196960887815,    0.369397356417,  0.00111763081028,     0.20043554663,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,    0.369397356417,    0.369397356417, 7.80138718093e-05,    0.196960887815,     0.20043554663,    0.146515170005,    0.369397356417,    0.369397356417,     0.20043554663, 0.000951180176932,    0.196960887815,    0.146515170005,    0.146515170005,    0.369397356417,     0.20043554663,    0.369397356417,    0.146515170005,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.196960887815,     0.20043554663,    0.369397356417,  0.00142034581272,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.196960887815,    0.369397356417, 0.000451818232423,    0.196960887815,    0.146515170005,    0.196960887815,     0.20043554663,    0.146515170005,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,     0.20043554663,    0.369397356417,     0.20043554663,     0.20043554663,    0.196960887815,    0.146515170005,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,    0.196960887815,    0.369397356417, 0.000986514682932,    0.146515170005,    0.369397356417,     0.20043554663,     0.20043554663,    0.146515170005,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,     0.20043554663,    0.369397356417,    0.196960887815,    0.196960887815,    0.196960887815, 0.000438919537606,     0.20043554663,    0.146515170005,     0.20043554663,    0.196960887815,    0.369397356417,  0.00142034581272,    0.146515170005,    0.146515170005,    0.146515170005,    0.369397356417,    0.196960887815,    0.196960887815,     0.20043554663,    0.146515170005,    0.196960887815,    0.196960887815,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,    0.196960887815,  0.00245913096802,    0.196960887815,    0.196960887815,    0.146515170005,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663,    0.196960887815,    0.369397356417,    0.369397356417, 0.000655054815937,    0.196960887815,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417,    0.369397356417, 0.000763900958063,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,    0.146515170005,    0.369397356417,    0.369397356417,    0.146515170005,     0.20043554663,    0.196960887815,    0.196960887815,    0.369397356417,     0.20043554663,     0.20043554663,    0.196960887815,    0.146515170005,    0.369397356417,    0.146515170005,    0.146515170005,    0.369397356417,    0.146515170005, 0.000880477843461,  0.00146552739782,    0.146515170005,    0.146515170005,     0.20043554663,    0.196960887815,    0.369397356417,    0.196960887815,     0.20043554663,    0.369397356417,    0.196960887815,    0.146515170005,    0.196960887815, 0.000983523367092,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663, 0.000975852227479,     0.20043554663,    0.196960887815,    0.196960887815,    0.369397356417, 3.20245241787e-05,     0.20043554663,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417, 0.000471915616619,    0.146515170005,     0.20043554663,    0.369397356417,    0.369397356417, 0.000269383457705,    0.146515170005, 0.000391173367754,     0.20043554663,    0.369397356417,    0.369397356417,  0.00336220652311,    0.146515170005,    0.196960887815,     0.20043554663,    0.196960887815,    0.196960887815,     0.20043554663,    0.196960887815,    0.196960887815,    0.369397356417,    0.196960887815,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815,     0.20043554663,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417,    0.196960887815,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,    0.146515170005,     0.20043554663,     0.20043554663,    0.196960887815, 0.000945343639426,     0.20043554663,    0.369397356417, 0.000153662661573,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,     0.20043554663, 0.000228255286105,    0.369397356417,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417,    0.369397356417,  0.00190907113581,    0.196960887815,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417,    0.196960887815,    0.196960887815,    0.146515170005,    0.146515170005,    0.196960887815,    0.196960887815,    0.369397356417,    0.146515170005,    0.369397356417,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,    0.146515170005,    0.146515170005,    0.196960887815,    0.196960887815,    0.196960887815,    0.369397356417,    0.369397356417,    0.196960887815,    0.196960887815,     0.20043554663,    0.196960887815,     0.20043554663,    0.369397356417, 0.000946141921462,    0.146515170005,    0.196960887815,    0.146515170005,    0.196960887815, 0.000310590771091,    0.146515170005,    0.369397356417,    0.146515170005,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.196960887815,    0.369397356417,    0.196960887815,     0.20043554663,     0.20043554663,    0.196960887815,    0.369397356417,    0.146515170005,     0.20043554663,     0.20043554663,     0.20043554663,     0.20043554663,    0.196960887815,    0.369397356417,   0.0024254797004,    0.146515170005,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,    0.196960887815,    0.146515170005,    0.146515170005,    0.369397356417,    0.196960887815,    0.196960887815,    0.196960887815,     0.20043554663,  0.00336220652311,    0.146515170005, 0.000438919537606,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417,     0.20043554663,    0.369397356417,    0.196960887815,    0.196960887815,    0.369397356417,    0.196960887815,    0.369397356417,     0.20043554663, 0.000269167131806,    0.196960887815,    0.196960887815,     0.20043554663,    0.196960887815,    0.369397356417,  0.00142034581272,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,    0.196960887815,     0.20043554663,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417,    0.196960887815,     0.20043554663,    0.146515170005,    0.196960887815,     0.20043554663,    0.196960887815,     0.20043554663,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663,    0.369397356417,     0.20043554663,    0.146515170005,    0.196960887815,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,    0.196960887815,    0.146515170005,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,     0.20043554663,    0.369397356417,    0.196960887815,    0.196960887815,    0.369397356417,    0.146515170005,  0.00165629752919,    0.369397356417,    0.369397356417,  0.00159536394881,     0.20043554663,    0.196960887815,     0.20043554663,    0.369397356417,    0.196960887815,  0.00165629752919,    0.146515170005,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815, 0.000447328807881,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,    0.146515170005,    0.146515170005,     0.20043554663,    0.196960887815,    0.369397356417,    0.196960887815,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417, 0.000438997650694,    0.146515170005,    0.369397356417,     0.20043554663,    0.369397356417, 0.000959800038559,    0.369397356417,  0.00101050876833,    0.196960887815,    0.369397356417,    0.369397356417, 0.000959800038559,    0.196960887815,    0.196960887815,    0.146515170005,    0.369397356417,    0.369397356417, 0.000273883296089,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,    0.196960887815,     0.20043554663,    0.196960887815,    0.146515170005,    0.196960887815,    0.146515170005,     0.20043554663,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,    0.196960887815,     0.20043554663,    0.196960887815,    0.369397356417,  0.00336220652311,    0.196960887815, 0.000292106295186,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663, 0.000273883296089,    0.369397356417,     0.20043554663,    0.369397356417, 0.000269001337334,    0.369397356417,    0.146515170005,    0.146515170005,    0.369397356417,     0.20043554663,    0.146515170005,     0.20043554663,    0.369397356417, 0.000968979851731,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417,    0.196960887815,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417,    0.146515170005, 0.000112926898075,    0.196960887815,    0.369397356417,    0.369397356417,    0.196960887815,    0.196960887815,     0.20043554663,    0.369397356417,    0.196960887815,     0.20043554663,    0.369397356417,    0.196960887815,     0.20043554663,  0.00345597400857,    0.369397356417,    0.146515170005,    0.146515170005,    0.146515170005,  0.00113438683269,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663,    0.369397356417,    0.369397356417,    0.196960887815,    0.369397356417, 0.000655418503224,    0.369397356417,    0.196960887815,  0.00101050876833,    0.369397356417, 4.53932144164e-05,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,    0.146515170005,    0.146515170005,    0.146515170005,    0.196960887815,    0.196960887815, 0.000239878010534,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,    0.196960887815,    0.146515170005,    0.369397356417,    0.196960887815,     0.20043554663,    0.196960887815,    0.196960887815,    0.369397356417,     0.20043554663,    0.369397356417,    0.146515170005, 0.000946141921462,    0.146515170005,    0.196960887815,    0.369397356417, 0.000269863164366,    0.369397356417,    0.196960887815,    0.196960887815,    0.196960887815,    0.196960887815,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,  0.00146552739782,     0.20043554663,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,    0.196960887815, 0.000763900958063,    0.196960887815,    0.196960887815, 0.000951180176932,    0.369397356417,    0.196960887815,    0.369397356417,    0.146515170005,     0.20043554663,    0.369397356417,     0.20043554663,     0.20043554663,    0.146515170005,    0.196960887815,    0.146515170005,    0.369397356417,    0.146515170005,    0.369397356417,    0.369397356417,     0.20043554663,    0.369397356417,    0.146515170005,  0.00336220652311,     0.20043554663,    0.369397356417,    0.369397356417,    0.196960887815,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.146515170005,     0.20043554663,    0.196960887815,     0.20043554663,    0.196960887815,    0.196960887815,    0.196960887815,    0.146515170005,    0.369397356417,    0.196960887815,    0.369397356417,    0.369397356417, 0.000908127532844,    0.369397356417,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417,    0.146515170005, 0.000960252802777,    0.369397356417,    0.196960887815,  0.00345597400857,    0.369397356417, 0.000684780729379,     0.20043554663,    0.369397356417,    0.196960887815,    0.369397356417, 6.05629748476e-06,    0.146515170005,    0.146515170005,    0.369397356417,     0.20043554663,    0.369397356417,    0.146515170005,     0.20043554663,     0.20043554663, 0.000788210068944,    0.369397356417,    0.369397356417,    0.369397356417,    0.196960887815,    0.196960887815, 0.000572151195539,    0.146515170005,     0.20043554663,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,    0.146515170005,    0.196960887815,     0.20043554663,    0.196960887815,    0.369397356417,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,    0.196960887815,     0.20043554663,    0.369397356417,    0.369397356417,    0.196960887815,     0.20043554663,    0.146515170005,    0.196960887815,  0.00245913096802, 0.000425438343099,    0.146515170005,    0.369397356417,     0.20043554663,     0.20043554663,    0.369397356417,    0.369397356417,    0.369397356417,    0.146515170005,    0.196960887815,    0.146515170005,    0.369397356417,    0.196960887815,     0.20043554663,    0.146515170005,    0.196960887815,  0.00190907113581,    0.369397356417,    0.369397356417,    0.196960887815,  0.00111763081028,    0.146515170005,    0.369397356417,    0.369397356417, 0.000404554483562,    0.196960887815,     0.20043554663,    0.196960887815,    0.369397356417,     0.20043554663,    0.146515170005,    0.369397356417, 0.000268996116871,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,     0.37760522834,     0.20128881053,    0.151196586311,    0.206799185652,     0.37760522834,    0.206799185652,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652, 0.000813149442564,    0.206799185652,     0.20128881053,     0.20128881053,    0.151196586311,     0.20128881053,    0.151196586311,    0.151196586311,  0.00167972191435,    0.206799185652,    0.206799185652,     0.37760522834,    0.206799185652,    0.206799185652,     0.37760522834,     0.37760522834,    0.151196586311,  0.00204923669359,    0.151196586311,    0.206799185652,    0.151196586311,     0.37760522834,     0.20128881053,     0.37760522834,    0.206799185652,    0.206799185652,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,  0.00103067661249,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,    0.206799185652,     0.37760522834,  0.00163496937781,    0.151196586311,     0.20128881053,     0.37760522834,     0.37760522834,    0.206799185652,    0.206799185652,     0.20128881053,     0.37760522834,    0.206799185652,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,    0.206799185652, 0.000453736308576,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,     0.20128881053,    0.151196586311,    0.151196586311,     0.20128881053,     0.20128881053,    0.206799185652,    0.206799185652,    0.151196586311,    0.151196586311,    0.206799185652,     0.37760522834,     0.37760522834,    0.151196586311, 0.000129120607077,     0.20128881053,   0.0037037690929,     0.20128881053,  0.00121997191133,    0.151196586311,    0.151196586311,    0.206799185652,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,    0.206799185652,     0.20128881053,  0.00093545830187,     0.37760522834,    0.151196586311,     0.20128881053, 6.52737606634e-05,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,  0.00364030747553,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,    0.151196586311,     0.20128881053,     0.20128881053,     0.20128881053,    0.151196586311,     0.37760522834,   0.0037037690929,    0.151196586311,     0.37760522834,    0.206799185652,    0.206799185652,    0.206799185652,     0.37760522834,     0.37760522834,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,     0.20128881053,    0.151196586311,     0.37760522834,    0.151196586311,     0.37760522834,    0.206799185652,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,    0.206799185652,     0.20128881053,     0.20128881053,     0.37760522834,    0.151196586311,     0.20128881053,    0.151196586311,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,    0.151196586311,     0.37760522834,     0.20128881053,     0.20128881053,     0.37760522834,     0.37760522834, 0.000737731981517,     0.37760522834,    0.151196586311,    0.206799185652, 0.000795229157891,     0.20128881053,    0.206799185652,     0.37760522834,     0.20128881053,   0.0010953550057,    0.206799185652,    0.206799185652, 0.000813149442564,     0.20128881053,     0.20128881053,    0.206799185652,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,    0.151196586311,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,    0.151196586311,    0.206799185652,    0.206799185652,     0.20128881053, 0.000758506317491,     0.20128881053,    0.206799185652,     0.37760522834,    0.151196586311,    0.151196586311,     0.20128881053,    0.206799185652,    0.206799185652,     0.20128881053,     0.37760522834,     0.20128881053,    0.206799185652,     0.20128881053,    0.151196586311,    0.151196586311,     0.37760522834,    0.151196586311,     0.20128881053,    0.206799185652,     0.37760522834,     0.20128881053,     0.37760522834,     0.20128881053,     0.20128881053,     0.37760522834,    0.206799185652,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,   0.0016085878139,     0.37760522834,     0.37760522834,    0.151196586311,     0.20128881053,     0.20128881053,     0.20128881053,     0.37760522834,    0.151196586311,    0.206799185652,     0.20128881053,    0.206799185652,     0.37760522834,     0.20128881053,     0.37760522834,    0.206799185652,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,     0.37760522834,    0.151196586311,  0.00103067661249,     0.20128881053,    0.151196586311,    0.151196586311,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,    0.151196586311,     0.20128881053,    0.206799185652,     0.37760522834,     0.37760522834,     0.20128881053,     0.20128881053,     0.20128881053,     0.37760522834,    0.151196586311,    0.206799185652,    0.151196586311,    0.151196586311,    0.206799185652,    0.151196586311,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,    0.206799185652, 0.000945379334404,     0.37760522834,     0.37760522834,    0.206799185652,    0.151196586311,    0.206799185652,     0.20128881053,    0.206799185652,     0.37760522834,     0.37760522834,    0.206799185652,     0.20128881053,    0.151196586311,    0.206799185652,     0.37760522834,     0.37760522834,   0.0037037690929,     0.37760522834,    0.151196586311,     0.37760522834,     0.37760522834,    0.151196586311, 0.000404792059834,     0.20128881053,    0.206799185652,    0.151196586311,     0.20128881053, 0.000189818841227,    0.206799185652,    0.151196586311,    0.206799185652,    0.206799185652,     0.37760522834,     0.37760522834,    0.206799185652,    0.151196586311,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.20128881053,     0.37760522834,    0.151196586311,     0.20128881053,     0.20128881053,     0.37760522834,     0.20128881053,    0.206799185652, 0.000408069092246,    0.151196586311,     0.37760522834,    0.151196586311, 0.000396168477198,    0.151196586311,    0.206799185652,     0.20128881053,   0.0015995605044,  1.2700253843e-06,    0.206799185652,     0.37760522834,    0.206799185652,     0.20128881053,     0.20128881053,    0.206799185652,    0.206799185652,     0.20128881053,     0.37760522834,    0.151196586311,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,    0.206799185652,    0.151196586311,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,    0.206799185652,     0.20128881053,     0.37760522834,     0.20128881053,    0.206799185652,     0.37760522834,     0.20128881053,     0.37760522834,    0.206799185652,     0.37760522834,    0.151196586311,    0.151196586311,     0.37760522834,    0.206799185652,    0.206799185652,     0.20128881053,    0.206799185652,    0.151196586311,    0.151196586311,     0.20128881053,    0.151196586311,  0.00167972191435,     0.37760522834,    0.206799185652,     0.37760522834,   0.0015995605044,    0.206799185652,     0.37760522834,  0.00202867102819,     0.20128881053,    0.206799185652,    0.206799185652,     0.37760522834,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,    0.151196586311,     0.20128881053,     0.20128881053,     0.37760522834,    0.151196586311,  0.00119394376008,     0.37760522834,     0.20128881053,    0.206799185652,     0.20128881053,    0.206799185652,    0.206799185652,     0.20128881053,     0.37760522834,    0.206799185652,    0.151196586311,    0.206799185652,     0.20128881053,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,    0.206799185652,    0.151196586311,     0.37760522834,    0.206799185652,     0.20128881053,     0.20128881053,     0.37760522834,     0.37760522834,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,     0.37760522834,     0.20128881053,    0.151196586311,     0.37760522834,    0.206799185652,     0.37760522834,     0.20128881053,     0.20128881053,     0.37760522834,     0.37760522834,     0.20128881053,     0.37760522834,     0.37760522834,    0.206799185652,     0.37760522834,     0.37760522834,    0.151196586311,    0.151196586311,    0.151196586311,    0.151196586311,    0.206799185652,     0.37760522834,     0.37760522834}
{    0.368694592794,  0.00116519035075,    0.196578076453,    0.199879321967,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.146100118453,    0.196578076453,    0.196578076453,    0.368694592794, 0.000218564871153,    0.368694592794,    0.196578076453,    0.199879321967,    0.368694592794,    0.368694592794,  0.00446771289936,    0.368694592794,    0.368694592794,    0.196578076453,  0.00446771289936,    0.368694592794,    0.368694592794,    0.368694592794,    0.146100118453,    0.199879321967,    0.199879321967, 0.000428488121483,    0.199879321967,    0.146100118453,    0.199879321967,    0.368694592794,    0.196578076453,    0.196578076453,    0.199879321967,    0.199879321967,    0.196578076453,    0.368694592794,    0.199879321967,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.196578076453,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.146100118453,    0.196578076453,    0.368694592794, 0.000681832858004,    0.368694592794,    0.196578076453,    0.146100118453,    0.368694592794,    0.196578076453,    0.196578076453,    0.199879321967,    0.199879321967,    0.368694592794,    0.146100118453,    0.196578076453,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.199879321967,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.368694592794,    0.199879321967,    0.368694592794,    0.146100118453,    0.368694592794,    0.146100118453,    0.196578076453,    0.199879321967,    0.146100118453,    0.368694592794,    0.146100118453,    0.146100118453,    0.196578076453,    0.146100118453,    0.368694592794,    0.199879321967,    0.196578076453,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,    0.146100118453,    0.368694592794,    0.199879321967,    0.368694592794,    0.199879321967,    0.146100118453,    0.368694592794,    0.199879321967,    0.196578076453,    0.199879321967,    0.368694592794,    0.146100118453,    0.199879321967,    0.199879321967,    0.196578076453,    0.368694592794,    0.196578076453,    0.199879321967,    0.196578076453,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.196578076453,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.199879321967,    0.199879321967,    0.199879321967,    0.196578076453,    0.199879321967,    0.196578076453,    0.368694592794,  0.00435391439799,    0.199879321967,    0.196578076453,    0.196578076453,    0.368694592794,    0.196578076453,    0.368694592794,    0.146100118453,    0.146100118453,    0.196578076453,    0.146100118453,    0.199879321967,    0.368694592794,  0.00386999411721,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,  0.00124626572069, 0.000290920646526,    0.146100118453,    0.196578076453,    0.196578076453,    0.146100118453,    0.196578076453,    0.196578076453,    0.199879321967,    0.368694592794,    0.199879321967,    0.199879321967,    0.368694592794,    0.368694592794,    0.146100118453,    0.146100118453,    0.368694592794,    0.196578076453,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794, 0.000270155365675,    0.368694592794,    0.368694592794,  0.00097949131734,    0.368694592794,    0.196578076453,    0.368694592794,    0.368694592794,   0.0020087769148,    0.146100118453,    0.199879321967,    0.196578076453,  0.00386999411721,    0.146100118453,    0.368694592794,    0.368694592794,    0.199879321967,    0.196578076453,    0.368694592794,    0.196578076453,    0.199879321967,    0.368694592794,    0.196578076453,    0.368694592794,    0.196578076453,  0.00446771289936,    0.368694592794,  0.00131231745879,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.196578076453,    0.196578076453,    0.199879321967,    0.368694592794,    0.368694592794,    0.196578076453,    0.196578076453,    0.199879321967,  0.00435391439799,    0.368694592794,    0.368694592794,    0.199879321967,    0.199879321967,    0.368694592794,    0.146100118453,    0.196578076453,    0.199879321967,  0.00137496587409, 0.000272666218918,    0.196578076453,    0.368694592794,    0.199879321967,    0.368694592794,    0.199879321967,    0.146100118453,    0.199879321967,    0.368694592794,    0.196578076453,    0.196578076453,  0.00397468097978, 0.000984902764204,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,  4.5070822492e-06,    0.368694592794,    0.146100118453,    0.146100118453,    0.146100118453, 0.000956197290329,    0.146100118453,    0.368694592794, 0.000894899348897,    0.146100118453,    0.146100118453,    0.196578076453,    0.196578076453,    0.199879321967,    0.199879321967,    0.196578076453,    0.196578076453,    0.196578076453,    0.368694592794,    0.146100118453,    0.196578076453,    0.368694592794,    0.146100118453,    0.199879321967,    0.199879321967,    0.196578076453,    0.368694592794,    0.146100118453, 0.000894899348897,    0.196578076453,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,  0.00116519035075,    0.196578076453,    0.368694592794,    0.368694592794,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.196578076453,    0.199879321967,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.368694592794,    0.146100118453,    0.199879321967,    0.146100118453,    0.146100118453, 0.000285239436689,    0.368694592794,    0.146100118453, 7.68809517897e-05,    0.196578076453,    0.368694592794,    0.196578076453,    0.196578076453,    0.196578076453,    0.368694592794,    0.368694592794,    0.199879321967,    0.199879321967,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,  0.00133457497888,    0.368694592794,    0.196578076453,    0.196578076453,    0.368694592794,  0.00097221734564,    0.199879321967,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.368694592794, 5.37400075563e-06,    0.146100118453,    0.368694592794,    0.199879321967,    0.196578076453,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.199879321967,    0.199879321967, 0.000956197290329,    0.199879321967,    0.146100118453,    0.196578076453,    0.196578076453,    0.368694592794,    0.199879321967,    0.196578076453,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.196578076453,    0.146100118453,    0.196578076453,    0.368694592794,    0.196578076453,    0.368694592794,    0.196578076453,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.368694592794,    0.199879321967, 0.000869198939807,    0.368694592794,    0.196578076453,    0.146100118453,    0.368694592794,    0.368694592794,    0.368694592794,    0.199879321967,    0.368694592794,    0.196578076453,    0.146100118453,    0.196578076453,    0.368694592794,    0.146100118453,    0.199879321967,    0.199879321967,    0.196578076453,    0.199879321967,    0.196578076453,    0.368694592794,    0.368694592794,    0.146100118453,    0.368694592794,    0.146100118453,    0.368694592794,    0.196578076453,    0.196578076453,    0.368694592794,    0.196578076453,    0.368694592794,    0.146100118453,    0.368694592794,   0.0020637581669,    0.368694592794,    0.199879321967,    0.199879321967,    0.146100118453,    0.368694592794, 8.88153703912e-05,    0.199879321967,  0.00178537606157,    0.203320969338,    0.198927809425,    0.148636380864,    0.148636380864,    0.373132654875,    0.373132654875,    0.203320969338,    0.198927809425,    0.198927809425,    0.373132654875,    0.373132654875,    0.203320969338,   0.0040021163941,    0.148636380864,    0.148636380864,    0.203320969338,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.198927809425,    0.198927809425,  0.00069893093925,    0.148636380864,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.198927809425,    0.203320969338,    0.373132654875,    0.373132654875,    0.148636380864,    0.203320969338,    0.198927809425,    0.148636380864,    0.198927809425,    0.373132654875,    0.148636380864,    0.373132654875,    0.203320969338,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.148636380864,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.198927809425,  0.00123119143588,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.198927809425, 0.000513887837691,  0.00123119143588,    0.373132654875,    0.373132654875,    0.373132654875,  0.00409699385637,    0.373132654875,    0.198927809425,    0.203320969338,    0.373132654875,    0.203320969338,  0.00123119143588,    0.373132654875,    0.148636380864,    0.148636380864,    0.203320969338,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875,    0.203320969338,    0.198927809425,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875,    0.203320969338,    0.373132654875,    0.203320969338,    0.198927809425,    0.148636380864, 0.000234266093551,    0.373132654875, 0.000308324400072,    0.198927809425,    0.203320969338,    0.203320969338,    0.373132654875,    0.373132654875,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875, 0.000559638710434,    0.203320969338,    0.373132654875,    0.198927809425,    0.203320969338,    0.148636380864,    0.148636380864,    0.373132654875,    0.203320969338,    0.203320969338,    0.198927809425,    0.148636380864,    0.148636380864,    0.373132654875,    0.203320969338,    0.203320969338,    0.148636380864,  0.00069819918348,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.203320969338, 0.000294801585124,    0.373132654875,    0.203320969338,    0.203320969338,    0.373132654875,   0.0040021163941,    0.198927809425,    0.148636380864,    0.203320969338,    0.148636380864,    0.198927809425,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.148636380864,    0.198927809425,    0.148636380864,    0.373132654875,    0.198927809425,    0.148636380864,    0.203320969338,    0.373132654875,    0.373132654875,    0.198927809425,    0.198927809425,    0.198927809425,    0.148636380864,    0.148636380864,    0.198927809425,    0.198927809425,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.203320969338,    0.148636380864,    0.373132654875,    0.373132654875,    0.148636380864,    0.148636380864,    0.373132654875,    0.203320969338,    0.373132654875,    0.148636380864,    0.148636380864,    0.148636380864,    0.373132654875, 0.000601215055615,    0.373132654875,    0.203320969338,    0.198927809425,    0.198927809425,    0.148636380864,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.148636380864,  0.00157365674136,    0.198927809425,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,  0.00188914550983,    0.198927809425,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425, 0.000461151285612,    0.198927809425,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875,    0.198927809425,    0.203320969338,    0.373132654875,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875,    0.148636380864,  0.00188914550983,    0.373132654875,    0.373132654875,    0.148636380864,    0.203320969338,    0.203320969338,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,    0.198927809425,    0.373132654875,    0.198927809425,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875,    0.373132654875,    0.203320969338,    0.148636380864,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,  0.00409699385637, 0.000710656908097,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425, 0.000170693348389,    0.203320969338,    0.198927809425,    0.198927809425,    0.198927809425,  0.00184596854266, 0.000716922291243,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.148636380864,    0.373132654875,    0.148636380864,    0.373132654875,    0.203320969338,    0.373132654875,    0.148636380864,  0.00254236215255,    0.373132654875,    0.203320969338,    0.198927809425,    0.203320969338,    0.373132654875,    0.148636380864,    0.373132654875,    0.198927809425,    0.148636380864,    0.373132654875,    0.148636380864,    0.148636380864,    0.198927809425,    0.148636380864,  0.00157365674136,    0.373132654875,    0.373132654875,    0.373132654875,  0.00069819918348,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,  0.00155760234327,    0.198927809425,    0.198927809425,    0.373132654875,    0.203320969338,    0.148636380864,    0.373132654875,    0.373132654875,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.203320969338,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.198927809425,    0.373132654875,    0.148636380864, 8.54549458432e-05,  0.00185761444993,    0.373132654875,    0.203320969338,    0.148636380864,    0.373132654875,    0.373132654875,    0.203320969338,    0.203320969338,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.198927809425,    0.203320969338,    0.148636380864,    0.203320969338,    0.203320969338,    0.148636380864,   0.0015393299794,    0.198927809425,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.198927809425,    0.203320969338,    0.198927809425,    0.148636380864,    0.198927809425,    0.148636380864, 0.000710656908097,    0.203320969338,    0.203320969338,    0.198927809425,    0.148636380864,    0.148636380864,    0.373132654875, 9.23101471362e-05,    0.373132654875,    0.198927809425,    0.148636380864, 0.000246424537144,    0.203320969338,    0.203320969338,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.198927809425,    0.203320969338,    0.373132654875,    0.373132654875,    0.203320969338,    0.148636380864,    0.203320969338,    0.198927809425,    0.373132654875,    0.203320969338,    0.148636380864,    0.148636380864,    0.148636380864,    0.198927809425,    0.198927809425,    0.203320969338,    0.203320969338,    0.373132654875,    0.198927809425,    0.373132654875, 0.000307674050754,    0.373132654875,    0.373132654875,    0.148636380864,    0.198927809425,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875,    0.203320969338,    0.203320969338,    0.148636380864,    0.198927809425,    0.203320969338,    0.203320969338,    0.148636380864,    0.198927809425,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.148636380864,    0.148636380864,    0.373132654875,  0.00069893093925,    0.373132654875,    0.373132654875,    0.148636380864,    0.373132654875,    0.198927809425,    0.198927809425,    0.373132654875,    0.203320969338,    0.198927809425,    0.198927809425,    0.198927809425,    0.373132654875,    0.198927809425,    0.373132654875,    0.203320969338,    0.198927809425,    0.203320969338,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875, 0.000184816033708,    0.373132654875,    0.203320969338,    0.198927809425,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.198927809425,    0.148636380864,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.148636380864,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,    0.198927809425,    0.198927809425,    0.373132654875,    0.203320969338,    0.198927809425,   0.0040021163941,    0.198927809425,    0.198927809425,    0.148636380864,    0.203320969338,    0.198927809425,    0.373132654875,    0.198927809425,  0.00185761444993,    0.373132654875,    0.203320969338,    0.373132654875,    0.198927809425, 0.000294637973302,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.148636380864,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875,    0.198927809425,    0.148636380864,    0.148636380864,    0.203320969338,    0.148636380864,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.203320969338,    0.198927809425,    0.203320969338,    0.198927809425,    0.203320969338,    0.148636380864,    0.203320969338,    0.203320969338,    0.198927809425, 0.000294637973302,    0.203320969338,    0.148636380864,    0.198927809425,    0.373132654875,  0.00123119143588,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.148636380864,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.148636380864,    0.203320969338,    0.373132654875,    0.148636380864,    0.373132654875,    0.198927809425,    0.198927809425,    0.148636380864,    0.203320969338,    0.373132654875,    0.373132654875,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,  0.00121356600368,    0.373132654875,    0.148636380864,    0.373132654875,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.373132654875,    0.198927809425,    0.203320969338,    0.373132654875,    0.148636380864,  0.00124722142736,    0.373132654875,    0.373132654875,    0.148636380864,    0.373132654875,    0.198927809425,    0.203320969338,    0.148636380864,    0.198927809425,    0.203320969338,    0.203320969338,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.148636380864, 0.000652935868373,    0.203320969338,    0.198927809425,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.198927809425,    0.373132654875,    0.148636380864, 8.31136963329e-05,    0.373132654875,    0.198927809425,    0.373132654875,    0.203320969338,  0.00254236215255,    0.373132654875,    0.203320969338,    0.203320969338,    0.148636380864,    0.198927809425,    0.148636380864,    0.203320969338,    0.203320969338,    0.198927809425, 0.000902176220743,    0.373132654875,    0.198927809425,    0.148636380864, 0.000373117081846,    0.373132654875,    0.198927809425,    0.198927809425,    0.203320969338,    0.373132654875,    0.203320969338,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,    0.203320969338,    0.203320969338,    0.373132654875,    0.203320969338,    0.198927809425,    0.373132654875,    0.373132654875,    0.148636380864,    0.203320969338,    0.203320969338,    0.198927809425, 0.000605787067449, 0.000306585491208,    0.373132654875,    0.203320969338,    0.203320969338,    0.148636380864,    0.373132654875,    0.198927809425,    0.373132654875,    0.203320969338,    0.373132654875,    0.203320969338,    0.198927809425,    0.148636380864,    0.373132654875,    0.373132654875,    0.373132654875,    0.373132654875,   0.0015393299794,    0.203320969338,    0.203320969338,    0.203320969338,    0.373132654875,    0.203320969338,    0.373132654875,    0.198927809425,  0.00246871714946,    0.196124787679,    0.196124787679,    0.199213639332,    0.145615634546,    0.199213639332,    0.367814855788,  0.00117293450858,    0.367814855788,    0.196124787679,  0.00148972053735,    0.367814855788,    0.196124787679,    0.145615634546,    0.196124787679,    0.199213639332,    0.145615634546,    0.199213639332,    0.196124787679,    0.199213639332,    0.367814855788,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,    0.367814855788,    0.196124787679,    0.196124787679,    0.145615634546,    0.199213639332,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,    0.145615634546,    0.199213639332,    0.196124787679,    0.367814855788,  0.00117293450858,    0.199213639332,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.367814855788,    0.367814855788, 8.18840640544e-05,    0.196124787679,    0.199213639332,    0.145615634546,    0.367814855788,    0.367814855788,    0.199213639332,  0.00099798622181,    0.196124787679,    0.145615634546,    0.145615634546,    0.367814855788,    0.199213639332,    0.367814855788,    0.145615634546,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.196124787679,    0.199213639332,    0.367814855788,  0.00148972053735,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.196124787679,    0.367814855788,  0.00047443924668,    0.196124787679,    0.145615634546,    0.196124787679,    0.199213639332,    0.145615634546,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.199213639332,    0.367814855788,    0.199213639332,    0.199213639332,    0.196124787679,    0.145615634546,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.196124787679,    0.367814855788,  0.00103714186086,    0.145615634546,    0.367814855788,    0.199213639332,    0.199213639332,    0.145615634546,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.199213639332,    0.367814855788,    0.196124787679,    0.196124787679,    0.196124787679, 0.000461218594176,    0.199213639332,    0.145615634546,    0.199213639332,    0.196124787679,    0.367814855788,  0.00148972053735,    0.145615634546,    0.145615634546,    0.145615634546,    0.367814855788,    0.196124787679,    0.196124787679,    0.199213639332,    0.145615634546,    0.196124787679,    0.196124787679,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.196124787679,   0.0025829914353,    0.196124787679,    0.196124787679,    0.145615634546,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,    0.196124787679,    0.367814855788,    0.367814855788, 0.000687027992168,    0.196124787679,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,    0.367814855788, 0.000801200209708,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.145615634546,    0.367814855788,    0.367814855788,    0.145615634546,    0.199213639332,    0.196124787679,    0.196124787679,    0.367814855788,    0.199213639332,    0.199213639332,    0.196124787679,    0.145615634546,    0.367814855788,    0.145615634546,    0.145615634546,    0.367814855788,    0.145615634546, 0.000923499802111,  0.00153975543753,    0.145615634546,    0.145615634546,    0.199213639332,    0.196124787679,    0.367814855788,    0.196124787679,    0.199213639332,    0.367814855788,    0.196124787679,    0.145615634546,    0.196124787679,   0.0010330211928,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,  0.00102532177453,    0.199213639332,    0.196124787679,    0.196124787679,    0.367814855788,  3.5453217861e-05,    0.199213639332,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788, 0.000495938598148,    0.145615634546,    0.199213639332,    0.367814855788,    0.367814855788, 0.000282587720313,    0.145615634546, 0.000410435678792,    0.199213639332,    0.367814855788,    0.367814855788,  0.00352703319596,    0.145615634546,    0.196124787679,    0.199213639332,    0.196124787679,    0.196124787679,    0.199213639332,    0.196124787679,    0.196124787679,    0.367814855788,    0.196124787679,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,    0.199213639332,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788,    0.196124787679,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.145615634546,    0.199213639332,    0.199213639332,    0.196124787679, 0.000991524632944,    0.199213639332,    0.367814855788, 0.000161184329989,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.199213639332, 0.000239929564563,    0.367814855788,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,    0.367814855788,  0.00200241292177,    0.196124787679,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,    0.196124787679,    0.196124787679,    0.145615634546,    0.145615634546,    0.196124787679,    0.196124787679,    0.367814855788,    0.145615634546,    0.367814855788,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.145615634546,    0.145615634546,    0.196124787679,    0.196124787679,    0.196124787679,    0.367814855788,    0.367814855788,    0.196124787679,    0.196124787679,    0.199213639332,    0.196124787679,    0.199213639332,    0.367814855788, 0.000992379871039,    0.145615634546,    0.196124787679,    0.145615634546,    0.196124787679, 0.000325831311063,    0.145615634546,    0.367814855788,    0.145615634546,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.196124787679,    0.367814855788,    0.196124787679,    0.199213639332,    0.199213639332,    0.196124787679,    0.367814855788,    0.145615634546,    0.199213639332,    0.199213639332,    0.199213639332,    0.199213639332,    0.196124787679,    0.367814855788,  0.00254570507495,    0.145615634546,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.196124787679,    0.145615634546,    0.145615634546,    0.367814855788,    0.196124787679,    0.196124787679,    0.196124787679,    0.199213639332,  0.00352703319596,    0.145615634546, 0.000461218594176,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788,    0.199213639332,    0.367814855788,    0.196124787679,    0.196124787679,    0.367814855788,    0.196124787679,    0.367814855788,    0.199213639332, 0.000282854439959,    0.196124787679,    0.196124787679,    0.199213639332,    0.196124787679,    0.367814855788,  0.00148972053735,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,    0.196124787679,    0.199213639332,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788,    0.196124787679,    0.199213639332,    0.145615634546,    0.196124787679,    0.199213639332,    0.196124787679,    0.199213639332,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,    0.367814855788,    0.199213639332,    0.145615634546,    0.196124787679,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.196124787679,    0.145615634546,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.199213639332,    0.367814855788,    0.196124787679,    0.196124787679,    0.367814855788,    0.145615634546,  0.00173722234166,    0.367814855788,    0.367814855788,  0.00167614798452,    0.199213639332,    0.196124787679,    0.199213639332,    0.367814855788,    0.196124787679,  0.00173722234166,    0.145615634546,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,  0.00046983115761,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.145615634546,    0.145615634546,    0.199213639332,    0.196124787679,    0.367814855788,    0.196124787679,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788, 0.000460603250576,    0.145615634546,    0.367814855788,    0.199213639332,    0.367814855788,  0.00100892263524,    0.367814855788,  0.00106040595925,    0.196124787679,    0.367814855788,    0.367814855788,  0.00100892263524,    0.196124787679,    0.196124787679,    0.145615634546,    0.367814855788,    0.367814855788, 0.000287865605346,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.196124787679,    0.199213639332,    0.196124787679,    0.145615634546,    0.196124787679,    0.145615634546,    0.199213639332,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.196124787679,    0.199213639332,    0.196124787679,    0.367814855788,  0.00352703319596,    0.196124787679,  0.00030694144931,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332, 0.000287865605346,    0.367814855788,    0.199213639332,    0.367814855788, 0.000282672392943,    0.367814855788,    0.145615634546,    0.145615634546,    0.367814855788,    0.199213639332,    0.145615634546,    0.199213639332,    0.367814855788,  0.00101770363947,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788,    0.196124787679,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788,    0.145615634546, 0.000118788520017,    0.196124787679,    0.367814855788,    0.367814855788,    0.196124787679,    0.196124787679,    0.199213639332,    0.367814855788,    0.196124787679,    0.199213639332,    0.367814855788,    0.196124787679,    0.199213639332,  0.00363090540007,    0.367814855788,    0.145615634546,    0.145615634546,    0.145615634546,  0.00119149855674,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,    0.367814855788,    0.367814855788,    0.196124787679,    0.367814855788, 0.000687423849715,    0.367814855788,    0.196124787679,  0.00106040595925,    0.367814855788,  4.7724746302e-05,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.145615634546,    0.145615634546,    0.145615634546,    0.196124787679,    0.196124787679,  0.00025238307083,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.196124787679,    0.145615634546,    0.367814855788,    0.196124787679,    0.199213639332,    0.196124787679,    0.196124787679,    0.367814855788,    0.199213639332,    0.367814855788,    0.145615634546, 0.000992379871039,    0.145615634546,    0.196124787679,    0.367814855788,  0.00028362917292,    0.367814855788,    0.196124787679,    0.196124787679,    0.196124787679,    0.196124787679,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,  0.00153975543753,    0.199213639332,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.196124787679, 0.000801200209708,    0.196124787679,    0.196124787679,  0.00099798622181,    0.367814855788,    0.196124787679,    0.367814855788,    0.145615634546,    0.199213639332,    0.367814855788,    0.199213639332,    0.199213639332,    0.145615634546,    0.196124787679,    0.145615634546,    0.367814855788,    0.145615634546,    0.367814855788,    0.367814855788,    0.199213639332,    0.367814855788,    0.145615634546,  0.00352703319596,    0.199213639332,    0.367814855788,    0.367814855788,    0.196124787679,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.145615634546,    0.199213639332,    0.196124787679,    0.199213639332,    0.196124787679,    0.196124787679,    0.196124787679,    0.145615634546,    0.367814855788,    0.196124787679,    0.367814855788,    0.367814855788, 0.000954125988094,    0.367814855788,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,    0.145615634546,  0.00100941976891,    0.367814855788,    0.196124787679,  0.00363090540007,    0.367814855788, 0.000719762238968,    0.199213639332,    0.367814855788,    0.196124787679,    0.367814855788, 6.70606445395e-06,    0.145615634546,    0.145615634546,    0.367814855788,    0.199213639332,    0.367814855788,    0.145615634546,    0.199213639332,    0.199213639332, 0.000828125680738,    0.367814855788,    0.367814855788,    0.367814855788,    0.196124787679,    0.196124787679, 0.000600234848655,    0.145615634546,    0.199213639332,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,    0.145615634546,    0.196124787679,    0.199213639332,    0.196124787679,    0.367814855788,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.196124787679,    0.199213639332,    0.367814855788,    0.367814855788,    0.196124787679,    0.199213639332,    0.145615634546,    0.196124787679,   0.0025829914353, 0.000446280947456,    0.145615634546,    0.367814855788,    0.199213639332,    0.199213639332,    0.367814855788,    0.367814855788,    0.367814855788,    0.145615634546,    0.196124787679,    0.145615634546,    0.367814855788,    0.196124787679,    0.199213639332,    0.145615634546,    0.196124787679,  0.00200241292177,    0.367814855788,    0.367814855788,    0.196124787679,  0.00117293450858,    0.145615634546,    0.367814855788,    0.367814855788, 0.000425134539758,    0.196124787679,    0.199213639332,    0.196124787679,    0.367814855788,    0.199213639332,    0.145615634546,    0.367814855788,  0.00028266688049,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,    0.375207499486,    0.200021993652,    0.149820906803,     0.20493103781,    0.375207499486,     0.20493103781,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,  0.00090003120128,     0.20493103781,    0.200021993652,    0.200021993652,    0.149820906803,    0.200021993652,    0.149820906803,    0.149820906803,  0.00185513535972,     0.20493103781,     0.20493103781,    0.375207499486,     0.20493103781,     0.20493103781,    0.375207499486,    0.375207499486,    0.149820906803,  0.00226729137798,    0.149820906803,     0.20493103781,    0.149820906803,    0.375207499486,    0.200021993652,    0.375207499486,     0.20493103781,     0.20493103781,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,  0.00114207477299,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,     0.20493103781,    0.375207499486,  0.00181003954527,    0.149820906803,    0.200021993652,    0.375207499486,    0.375207499486,     0.20493103781,     0.20493103781,    0.200021993652,    0.375207499486,     0.20493103781,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,     0.20493103781, 0.000502513673019,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,    0.200021993652,    0.149820906803,    0.149820906803,    0.200021993652,    0.200021993652,     0.20493103781,     0.20493103781,    0.149820906803,    0.149820906803,     0.20493103781,    0.375207499486,    0.375207499486,    0.149820906803,  0.00014257084113,    0.200021993652,  0.00409865009562,    0.200021993652,  0.00135027752781,    0.149820906803,    0.149820906803,     0.20493103781,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,     0.20493103781,    0.200021993652,  0.00103371956162,    0.375207499486,    0.149820906803,    0.200021993652, 7.21397716554e-05,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,  0.00402048706183,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.149820906803,    0.200021993652,    0.200021993652,    0.200021993652,    0.149820906803,    0.375207499486,  0.00409865009562,    0.149820906803,    0.375207499486,     0.20493103781,     0.20493103781,     0.20493103781,    0.375207499486,    0.375207499486,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,    0.200021993652,    0.149820906803,    0.375207499486,    0.149820906803,    0.375207499486,     0.20493103781,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,     0.20493103781,    0.200021993652,    0.200021993652,    0.375207499486,    0.149820906803,    0.200021993652,    0.149820906803,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.149820906803,    0.375207499486,    0.200021993652,    0.200021993652,    0.375207499486,    0.375207499486, 0.000814641785298,    0.375207499486,    0.149820906803,     0.20493103781, 0.000877960457677,    0.200021993652,     0.20493103781,    0.375207499486,    0.200021993652,  0.00121075635686,     0.20493103781,     0.20493103781,  0.00090003120128,    0.200021993652,    0.200021993652,     0.20493103781,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,    0.149820906803,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.149820906803,     0.20493103781,     0.20493103781,    0.200021993652,  0.00083969567089,    0.200021993652,     0.20493103781,    0.375207499486,    0.149820906803,    0.149820906803,    0.200021993652,     0.20493103781,     0.20493103781,    0.200021993652,    0.375207499486,    0.200021993652,     0.20493103781,    0.200021993652,    0.149820906803,    0.149820906803,    0.375207499486,    0.149820906803,    0.200021993652,     0.20493103781,    0.375207499486,    0.200021993652,    0.375207499486,    0.200021993652,    0.200021993652,    0.375207499486,     0.20493103781,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,  0.00177639157228,    0.375207499486,    0.375207499486,    0.149820906803,    0.200021993652,    0.200021993652,    0.200021993652,    0.375207499486,    0.149820906803,     0.20493103781,    0.200021993652,     0.20493103781,    0.375207499486,    0.200021993652,    0.375207499486,     0.20493103781,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,    0.375207499486,    0.149820906803,  0.00114207477299,    0.200021993652,    0.149820906803,    0.149820906803,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.149820906803,    0.200021993652,     0.20493103781,    0.375207499486,    0.375207499486,    0.200021993652,    0.200021993652,    0.200021993652,    0.375207499486,    0.149820906803,     0.20493103781,    0.149820906803,    0.149820906803,     0.20493103781,    0.149820906803,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,     0.20493103781,  0.00104593901929,    0.375207499486,    0.375207499486,     0.20493103781,    0.149820906803,     0.20493103781,    0.200021993652,     0.20493103781,    0.375207499486,    0.375207499486,     0.20493103781,    0.200021993652,    0.149820906803,     0.20493103781,    0.375207499486,    0.375207499486,  0.00409865009562,    0.375207499486,    0.149820906803,    0.375207499486,    0.375207499486,    0.149820906803, 0.000447612514366,    0.200021993652,     0.20493103781,    0.149820906803,    0.200021993652, 0.000210288268402,     0.20493103781,    0.149820906803,     0.20493103781,     0.20493103781,    0.375207499486,    0.375207499486,     0.20493103781,    0.149820906803,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.200021993652,    0.375207499486,    0.149820906803,    0.200021993652,    0.200021993652,    0.375207499486,    0.200021993652,     0.20493103781, 0.000453103789075,    0.149820906803,    0.375207499486,    0.149820906803, 0.000437362350907,    0.149820906803,     0.20493103781,    0.200021993652,  0.00176642396534, 1.56676843894e-06,     0.20493103781,    0.375207499486,     0.20493103781,    0.200021993652,    0.200021993652,     0.20493103781,     0.20493103781,    0.200021993652,    0.375207499486,    0.149820906803,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,     0.20493103781,    0.149820906803,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,     0.20493103781,    0.200021993652,    0.375207499486,    0.200021993652,     0.20493103781,    0.375207499486,    0.200021993652,    0.375207499486,     0.20493103781,    0.375207499486,    0.149820906803,    0.149820906803,    0.375207499486,     0.20493103781,     0.20493103781,    0.200021993652,     0.20493103781,    0.149820906803,    0.149820906803,    0.200021993652,    0.149820906803,  0.00185513535972,    0.375207499486,     0.20493103781,    0.375207499486,  0.00176642396534,     0.20493103781,    0.375207499486,  0.00224194993669,    0.200021993652,     0.20493103781,     0.20493103781,    0.375207499486,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,    0.149820906803,    0.200021993652,    0.200021993652,    0.375207499486,    0.149820906803,  0.00131822144388,    0.375207499486,    0.200021993652,     0.20493103781,    0.200021993652,     0.20493103781,     0.20493103781,    0.200021993652,    0.375207499486,     0.20493103781,    0.149820906803,     0.20493103781,    0.200021993652,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,     0.20493103781,    0.149820906803,    0.375207499486,     0.20493103781,    0.200021993652,    0.200021993652,    0.375207499486,    0.375207499486,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,    0.375207499486,    0.200021993652,    0.149820906803,    0.375207499486,     0.20493103781,    0.375207499486,    0.200021993652,    0.200021993652,    0.375207499486,    0.375207499486,    0.200021993652,    0.375207499486,    0.375207499486,     0.20493103781,    0.375207499486,    0.375207499486,    0.149820906803,    0.149820906803,    0.149820906803,    0.149820906803,     0.20493103781,    0.375207499486,    0.375207499486}
{    0.365849961858,  0.00126611153379,    0.195072617524,    0.197683464968,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.144482471494,    0.195072617524,    0.195072617524,    0.365849961858, 0.000237208018652,    0.365849961858,    0.195072617524,    0.197683464968,    0.365849961858,    0.365849961858,  0.00486342980985,    0.365849961858,    0.365849961858,    0.195072617524,  0.00486342980985,    0.365849961858,    0.365849961858,    0.365849961858,    0.144482471494,    0.197683464968,    0.197683464968, 0.000465228742362,    0.197683464968,    0.144482471494,    0.197683464968,    0.365849961858,    0.195072617524,    0.195072617524,    0.197683464968,    0.197683464968,    0.195072617524,    0.365849961858,    0.197683464968,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.195072617524,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.144482471494,    0.195072617524,    0.365849961858, 0.000742432222202,    0.365849961858,    0.195072617524,    0.144482471494,    0.365849961858,    0.195072617524,    0.195072617524,    0.197683464968,    0.197683464968,    0.365849961858,    0.144482471494,    0.195072617524,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.197683464968,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.365849961858,    0.197683464968,    0.365849961858,    0.144482471494,    0.365849961858,    0.144482471494,    0.195072617524,    0.197683464968,    0.144482471494,    0.365849961858,    0.144482471494,    0.144482471494,    0.195072617524,    0.144482471494,    0.365849961858,    0.197683464968,    0.195072617524,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,    0.144482471494,    0.365849961858,    0.197683464968,    0.365849961858,    0.197683464968,    0.144482471494,    0.365849961858,    0.197683464968,    0.195072617524,    0.197683464968,    0.365849961858,    0.144482471494,    0.197683464968,    0.197683464968,    0.195072617524,    0.365849961858,    0.195072617524,    0.197683464968,    0.195072617524,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.195072617524,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.197683464968,    0.197683464968,    0.197683464968,    0.195072617524,    0.197683464968,    0.195072617524,    0.365849961858,  0.00472764462274,    0.197683464968,    0.195072617524,    0.195072617524,    0.365849961858,    0.195072617524,    0.365849961858,    0.144482471494,    0.144482471494,    0.195072617524,    0.144482471494,    0.197683464968,    0.365849961858,  0.00420197132495,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,  0.00135851015739, 0.000316523666645,    0.144482471494,    0.195072617524,    0.195072617524,    0.144482471494,    0.195072617524,    0.195072617524,    0.197683464968,    0.365849961858,    0.197683464968,    0.197683464968,    0.365849961858,    0.365849961858,    0.144482471494,    0.144482471494,    0.365849961858,    0.195072617524,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858, 0.000293851498412,    0.365849961858,    0.365849961858,  0.00106569747561,    0.365849961858,    0.195072617524,    0.365849961858,    0.365849961858,  0.00218116075244,    0.144482471494,    0.197683464968,    0.195072617524,  0.00420197132495,    0.144482471494,    0.365849961858,    0.365849961858,    0.197683464968,    0.195072617524,    0.365849961858,    0.195072617524,    0.197683464968,    0.365849961858,    0.195072617524,    0.365849961858,    0.195072617524,  0.00486342980985,    0.365849961858,  0.00142620610689,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.195072617524,    0.195072617524,    0.197683464968,    0.365849961858,    0.365849961858,    0.195072617524,    0.195072617524,    0.197683464968,  0.00472764462274,    0.365849961858,    0.365849961858,    0.197683464968,    0.197683464968,    0.365849961858,    0.144482471494,    0.195072617524,    0.197683464968,  0.00149702876969,  0.00029700808429,    0.195072617524,    0.365849961858,    0.197683464968,    0.365849961858,    0.197683464968,    0.144482471494,    0.197683464968,    0.365849961858,    0.195072617524,    0.195072617524,  0.00432688288985,  0.00107214595705,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858, 5.37267751028e-06,    0.365849961858,    0.144482471494,    0.144482471494,    0.144482471494,  0.00103816723025,    0.144482471494,    0.365849961858, 0.000974875780378,    0.144482471494,    0.144482471494,    0.195072617524,    0.195072617524,    0.197683464968,    0.197683464968,    0.195072617524,    0.195072617524,    0.195072617524,    0.365849961858,    0.144482471494,    0.195072617524,    0.365849961858,    0.144482471494,    0.197683464968,    0.197683464968,    0.195072617524,    0.365849961858,    0.144482471494, 0.000974875780378,    0.195072617524,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,  0.00126611153379,    0.195072617524,    0.365849961858,    0.365849961858,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.195072617524,    0.197683464968,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.365849961858,    0.144482471494,    0.197683464968,    0.144482471494,    0.144482471494, 0.000309648507406,    0.365849961858,    0.144482471494, 8.34527887989e-05,    0.195072617524,    0.365849961858,    0.195072617524,    0.195072617524,    0.195072617524,    0.365849961858,    0.365849961858,    0.197683464968,    0.197683464968,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,  0.00144884365357,    0.365849961858,    0.195072617524,    0.195072617524,    0.365849961858,  0.00105760603334,    0.197683464968,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.365849961858, 6.40382568043e-06,    0.144482471494,    0.365849961858,    0.197683464968,    0.195072617524,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.197683464968,    0.197683464968,  0.00103816723025,    0.197683464968,    0.144482471494,    0.195072617524,    0.195072617524,    0.365849961858,    0.197683464968,    0.195072617524,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.195072617524,    0.144482471494,    0.195072617524,    0.365849961858,    0.195072617524,    0.365849961858,    0.195072617524,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.365849961858,    0.197683464968, 0.000944182222971,    0.365849961858,    0.195072617524,    0.144482471494,    0.365849961858,    0.365849961858,    0.365849961858,    0.197683464968,    0.365849961858,    0.195072617524,    0.144482471494,    0.195072617524,    0.365849961858,    0.144482471494,    0.197683464968,    0.197683464968,    0.195072617524,    0.197683464968,    0.195072617524,    0.365849961858,    0.365849961858,    0.144482471494,    0.365849961858,    0.144482471494,    0.365849961858,    0.195072617524,    0.195072617524,    0.365849961858,    0.195072617524,    0.365849961858,    0.144482471494,    0.365849961858,  0.00224675562825,    0.365849961858,    0.197683464968,    0.197683464968,    0.144482471494,    0.365849961858, 9.65377086165e-05,    0.197683464968,  0.00193847445202,    0.201419084987,      0.1976312881,    0.147235817666,    0.147235817666,    0.370679814226,    0.370679814226,    0.201419084987,      0.1976312881,      0.1976312881,    0.370679814226,    0.370679814226,    0.201419084987,  0.00435371985768,    0.147235817666,    0.147235817666,    0.201419084987,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,      0.1976312881,      0.1976312881, 0.000762678488477,    0.147235817666,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,      0.1976312881,    0.201419084987,    0.370679814226,    0.370679814226,    0.147235817666,    0.201419084987,      0.1976312881,    0.147235817666,      0.1976312881,    0.370679814226,    0.147235817666,    0.370679814226,    0.201419084987,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,    0.147235817666,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,      0.1976312881,  0.00134321267498,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,      0.1976312881, 0.000560469786685,  0.00134321267498,    0.370679814226,    0.370679814226,    0.370679814226,  0.00446709463691,    0.370679814226,      0.1976312881,    0.201419084987,    0.370679814226,    0.201419084987,  0.00134321267498,    0.370679814226,    0.147235817666,    0.147235817666,    0.201419084987,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226,    0.201419084987,      0.1976312881,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226,    0.201419084987,    0.370679814226,    0.201419084987,      0.1976312881,    0.147235817666, 0.000255794941623,    0.370679814226, 0.000336603681696,      0.1976312881,    0.201419084987,    0.201419084987,    0.370679814226,    0.370679814226,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226, 0.000608494128377,    0.201419084987,    0.370679814226,      0.1976312881,    0.201419084987,    0.147235817666,    0.147235817666,    0.370679814226,    0.201419084987,    0.201419084987,      0.1976312881,    0.147235817666,    0.147235817666,    0.370679814226,    0.201419084987,    0.201419084987,    0.147235817666, 0.000761791381357,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,    0.201419084987, 0.000320662493721,    0.370679814226,    0.201419084987,    0.201419084987,    0.370679814226,  0.00435371985768,      0.1976312881,    0.147235817666,    0.201419084987,    0.147235817666,      0.1976312881,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.147235817666,      0.1976312881,    0.147235817666,    0.370679814226,      0.1976312881,    0.147235817666,    0.201419084987,    0.370679814226,    0.370679814226,      0.1976312881,      0.1976312881,      0.1976312881,    0.147235817666,    0.147235817666,      0.1976312881,      0.1976312881,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.201419084987,    0.147235817666,    0.370679814226,    0.370679814226,    0.147235817666,    0.147235817666,    0.370679814226,    0.201419084987,    0.370679814226,    0.147235817666,    0.147235817666,    0.147235817666,    0.370679814226, 0.000653685781131,    0.370679814226,    0.201419084987,      0.1976312881,      0.1976312881,    0.147235817666,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.147235817666,  0.00171816343404,      0.1976312881,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,  0.00205964751451,      0.1976312881,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881, 0.000502599605211,      0.1976312881,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226,      0.1976312881,    0.201419084987,    0.370679814226,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226,    0.147235817666,  0.00205964751451,    0.370679814226,    0.370679814226,    0.147235817666,    0.201419084987,    0.201419084987,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,      0.1976312881,    0.370679814226,      0.1976312881,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226,    0.370679814226,    0.201419084987,    0.147235817666,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,  0.00446709463691, 0.000774337687612,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881, 0.000186136664237,    0.201419084987,      0.1976312881,      0.1976312881,      0.1976312881,  0.00200805833945, 0.000781834425536,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,    0.147235817666,    0.370679814226,    0.147235817666,    0.370679814226,    0.201419084987,    0.370679814226,    0.147235817666,  0.00277429892932,    0.370679814226,    0.201419084987,      0.1976312881,    0.201419084987,    0.370679814226,    0.147235817666,    0.370679814226,      0.1976312881,    0.147235817666,    0.370679814226,    0.147235817666,    0.147235817666,      0.1976312881,    0.147235817666,  0.00171816343404,    0.370679814226,    0.370679814226,    0.370679814226, 0.000761791381357,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,  0.00169905322194,      0.1976312881,      0.1976312881,    0.370679814226,    0.201419084987,    0.147235817666,    0.370679814226,    0.370679814226,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,    0.201419084987,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,      0.1976312881,    0.370679814226,    0.147235817666, 9.32136980229e-05,  0.00202485783182,    0.370679814226,    0.201419084987,    0.147235817666,    0.370679814226,    0.370679814226,    0.201419084987,    0.201419084987,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,      0.1976312881,    0.201419084987,    0.147235817666,    0.201419084987,    0.201419084987,    0.147235817666,  0.00167720268017,      0.1976312881,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,      0.1976312881,    0.201419084987,      0.1976312881,    0.147235817666,      0.1976312881,    0.147235817666, 0.000774337687612,    0.201419084987,    0.201419084987,      0.1976312881,    0.147235817666,    0.147235817666,    0.370679814226, 0.000100638012147,    0.370679814226,      0.1976312881,    0.147235817666, 0.000268157151776,    0.201419084987,    0.201419084987,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,      0.1976312881,    0.201419084987,    0.370679814226,    0.370679814226,    0.201419084987,    0.147235817666,    0.201419084987,      0.1976312881,    0.370679814226,    0.201419084987,    0.147235817666,    0.147235817666,    0.147235817666,      0.1976312881,      0.1976312881,    0.201419084987,    0.201419084987,    0.370679814226,      0.1976312881,    0.370679814226, 0.000335549850631,    0.370679814226,    0.370679814226,    0.147235817666,      0.1976312881,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226,    0.201419084987,    0.201419084987,    0.147235817666,      0.1976312881,    0.201419084987,    0.201419084987,    0.147235817666,      0.1976312881,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,    0.147235817666,    0.147235817666,    0.370679814226, 0.000762678488477,    0.370679814226,    0.370679814226,    0.147235817666,    0.370679814226,      0.1976312881,      0.1976312881,    0.370679814226,    0.201419084987,      0.1976312881,      0.1976312881,      0.1976312881,    0.370679814226,      0.1976312881,    0.370679814226,    0.201419084987,      0.1976312881,    0.201419084987,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226, 0.000201509645467,    0.370679814226,    0.201419084987,      0.1976312881,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,      0.1976312881,    0.147235817666,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,    0.147235817666,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,      0.1976312881,      0.1976312881,    0.370679814226,    0.201419084987,      0.1976312881,  0.00435371985768,      0.1976312881,      0.1976312881,    0.147235817666,    0.201419084987,      0.1976312881,    0.370679814226,      0.1976312881,  0.00202485783182,    0.370679814226,    0.201419084987,    0.370679814226,      0.1976312881, 0.000320464785107,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.147235817666,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226,      0.1976312881,    0.147235817666,    0.147235817666,    0.201419084987,    0.147235817666,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.201419084987,      0.1976312881,    0.201419084987,      0.1976312881,    0.201419084987,    0.147235817666,    0.201419084987,    0.201419084987,      0.1976312881, 0.000320464785107,    0.201419084987,    0.147235817666,      0.1976312881,    0.370679814226,  0.00134321267498,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.147235817666,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,    0.147235817666,    0.201419084987,    0.370679814226,    0.147235817666,    0.370679814226,      0.1976312881,      0.1976312881,    0.147235817666,    0.201419084987,    0.370679814226,    0.370679814226,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,  0.00131959542196,    0.370679814226,    0.147235817666,    0.370679814226,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.370679814226,      0.1976312881,    0.201419084987,    0.370679814226,    0.147235817666,  0.00135981671826,    0.370679814226,    0.370679814226,    0.147235817666,    0.370679814226,      0.1976312881,    0.201419084987,    0.147235817666,      0.1976312881,    0.201419084987,    0.201419084987,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.147235817666, 0.000710704998214,    0.201419084987,      0.1976312881,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,      0.1976312881,    0.370679814226,    0.147235817666, 9.04158974289e-05,    0.370679814226,      0.1976312881,    0.370679814226,    0.201419084987,  0.00277429892932,    0.370679814226,    0.201419084987,    0.201419084987,    0.147235817666,      0.1976312881,    0.147235817666,    0.201419084987,    0.201419084987,      0.1976312881,  0.00098086650685,    0.370679814226,      0.1976312881,    0.147235817666, 0.000406861106628,    0.370679814226,      0.1976312881,      0.1976312881,    0.201419084987,    0.370679814226,    0.201419084987,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,    0.201419084987,    0.201419084987,    0.370679814226,    0.201419084987,      0.1976312881,    0.370679814226,    0.370679814226,    0.147235817666,    0.201419084987,    0.201419084987,      0.1976312881, 0.000659038779094, 0.000334874110314,    0.370679814226,    0.201419084987,    0.201419084987,    0.147235817666,    0.370679814226,      0.1976312881,    0.370679814226,    0.201419084987,    0.370679814226,    0.201419084987,      0.1976312881,    0.147235817666,    0.370679814226,    0.370679814226,    0.370679814226,    0.370679814226,  0.00167720268017,    0.201419084987,    0.201419084987,    0.201419084987,    0.370679814226,    0.201419084987,    0.370679814226,      0.1976312881,  0.00268627712621,    0.195261608833,    0.195261608833,    0.197954593807,    0.144688725391,    0.197954593807,    0.366181462293,  0.00122962492444,    0.366181462293,    0.195261608833,  0.00156073614949,    0.366181462293,    0.195261608833,    0.144688725391,    0.195261608833,    0.197954593807,    0.144688725391,    0.197954593807,    0.195261608833,    0.197954593807,    0.366181462293,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293,    0.366181462293,    0.195261608833,    0.195261608833,    0.144688725391,    0.197954593807,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833,    0.144688725391,    0.197954593807,    0.195261608833,    0.366181462293,  0.00122962492444,    0.197954593807,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.366181462293,    0.366181462293,  8.5852519223e-05,    0.195261608833,    0.197954593807,    0.144688725391,    0.366181462293,    0.366181462293,    0.197954593807,  0.00104593805858,    0.195261608833,    0.144688725391,    0.144688725391,    0.366181462293,    0.197954593807,    0.366181462293,    0.144688725391,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.195261608833,    0.197954593807,    0.366181462293,  0.00156073614949,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.195261608833,    0.366181462293, 0.000497656698005,    0.195261608833,    0.144688725391,    0.195261608833,    0.197954593807,    0.144688725391,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.197954593807,    0.366181462293,    0.197954593807,    0.197954593807,    0.195261608833,    0.144688725391,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.195261608833,    0.366181462293,  0.00108924272703,    0.144688725391,    0.366181462293,    0.197954593807,    0.197954593807,    0.144688725391,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.197954593807,    0.366181462293,    0.195261608833,    0.195261608833,    0.195261608833, 0.000484142079897,    0.197954593807,    0.144688725391,    0.197954593807,    0.195261608833,    0.366181462293,  0.00156073614949,    0.144688725391,    0.144688725391,    0.144688725391,    0.366181462293,    0.195261608833,    0.195261608833,    0.197954593807,    0.144688725391,    0.195261608833,    0.195261608833,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.195261608833,  0.00271020176216,    0.195261608833,    0.195261608833,    0.144688725391,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,    0.195261608833,    0.366181462293,    0.366181462293, 0.000719754630333,    0.195261608833,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293,    0.366181462293, 0.000839379892832,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.144688725391,    0.366181462293,    0.366181462293,    0.144688725391,    0.197954593807,    0.195261608833,    0.195261608833,    0.366181462293,    0.197954593807,    0.197954593807,    0.195261608833,    0.144688725391,    0.366181462293,    0.144688725391,    0.144688725391,    0.366181462293,    0.144688725391, 0.000967540647891,  0.00161603711532,    0.144688725391,    0.144688725391,    0.197954593807,    0.195261608833,    0.366181462293,    0.195261608833,    0.197954593807,    0.366181462293,    0.195261608833,    0.144688725391,    0.195261608833,  0.00108385290196,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,  0.00107616491193,    0.197954593807,    0.195261608833,    0.195261608833,    0.366181462293, 3.91703842287e-05,    0.197954593807,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293, 0.000520639496333,    0.144688725391,    0.197954593807,    0.366181462293,    0.366181462293, 0.000296109310255,    0.144688725391, 0.000430170845198,    0.197954593807,    0.366181462293,    0.366181462293,  0.00369582452928,    0.144688725391,    0.195261608833,    0.197954593807,    0.195261608833,    0.195261608833,    0.197954593807,    0.195261608833,    0.195261608833,    0.366181462293,    0.195261608833,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833,    0.197954593807,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293,    0.195261608833,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.144688725391,    0.197954593807,    0.197954593807,    0.195261608833,  0.00103879880097,    0.197954593807,    0.366181462293, 0.000168885712573,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.197954593807, 0.000251939181581,    0.366181462293,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293,    0.366181462293,  0.00209797301136,    0.195261608833,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293,    0.195261608833,    0.195261608833,    0.144688725391,    0.144688725391,    0.195261608833,    0.195261608833,    0.366181462293,    0.144688725391,    0.366181462293,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.144688725391,    0.144688725391,    0.195261608833,    0.195261608833,    0.195261608833,    0.366181462293,    0.366181462293,    0.195261608833,    0.195261608833,    0.197954593807,    0.195261608833,    0.197954593807,    0.366181462293,  0.00103971433506,    0.144688725391,    0.195261608833,    0.144688725391,    0.195261608833, 0.000341439930673,    0.144688725391,    0.366181462293,    0.144688725391,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.195261608833,    0.366181462293,    0.195261608833,    0.197954593807,    0.197954593807,    0.195261608833,    0.366181462293,    0.144688725391,    0.197954593807,    0.197954593807,    0.197954593807,    0.197954593807,    0.195261608833,    0.366181462293,  0.00266896905862,    0.144688725391,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.195261608833,    0.144688725391,    0.144688725391,    0.366181462293,    0.195261608833,    0.195261608833,    0.195261608833,    0.197954593807,  0.00369582452928,    0.144688725391, 0.000484142079897,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293,    0.197954593807,    0.366181462293,    0.195261608833,    0.195261608833,    0.366181462293,    0.195261608833,    0.366181462293,    0.197954593807,   0.0002969261726,    0.195261608833,    0.195261608833,    0.197954593807,    0.195261608833,    0.366181462293,  0.00156073614949,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,    0.195261608833,    0.197954593807,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293,    0.195261608833,    0.197954593807,    0.144688725391,    0.195261608833,    0.197954593807,    0.195261608833,    0.197954593807,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,    0.366181462293,    0.197954593807,    0.144688725391,    0.195261608833,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.195261608833,    0.144688725391,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.197954593807,    0.366181462293,    0.195261608833,    0.195261608833,    0.366181462293,    0.144688725391,   0.0018200639922,    0.366181462293,    0.366181462293,  0.00175916304509,    0.197954593807,    0.195261608833,    0.197954593807,    0.366181462293,    0.195261608833,   0.0018200639922,    0.144688725391,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833, 0.000492938714371,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.144688725391,    0.144688725391,    0.197954593807,    0.195261608833,    0.366181462293,    0.195261608833,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293, 0.000482737812385,    0.144688725391,    0.366181462293,    0.197954593807,    0.366181462293,  0.00105946029727,    0.366181462293,  0.00111154268139,    0.195261608833,    0.366181462293,    0.366181462293,  0.00105946029727,    0.195261608833,    0.195261608833,    0.144688725391,    0.366181462293,    0.366181462293, 0.000302246967154,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.195261608833,    0.197954593807,    0.195261608833,    0.144688725391,    0.195261608833,    0.144688725391,    0.197954593807,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.195261608833,    0.197954593807,    0.195261608833,    0.366181462293,  0.00369582452928,    0.195261608833, 0.000322191483643,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807, 0.000302246967154,    0.366181462293,    0.197954593807,    0.366181462293, 0.000296726761816,    0.366181462293,    0.144688725391,    0.144688725391,    0.366181462293,    0.197954593807,    0.144688725391,    0.197954593807,    0.366181462293,  0.00106773659731,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293,    0.195261608833,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293,    0.144688725391, 0.000124827823707,    0.195261608833,    0.366181462293,    0.366181462293,    0.195261608833,    0.195261608833,    0.197954593807,    0.366181462293,    0.195261608833,    0.197954593807,    0.366181462293,    0.195261608833,    0.197954593807,  0.00381066260254,    0.366181462293,    0.144688725391,    0.144688725391,    0.144688725391,  0.00125015146318,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,    0.366181462293,    0.366181462293,    0.195261608833,    0.366181462293, 0.000720185024146,    0.366181462293,    0.195261608833,  0.00111154268139,    0.366181462293, 5.01244671422e-05,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.144688725391,    0.144688725391,    0.144688725391,    0.195261608833,    0.195261608833, 0.000265273272523,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.195261608833,    0.144688725391,    0.366181462293,    0.195261608833,    0.197954593807,    0.195261608833,    0.195261608833,    0.366181462293,    0.197954593807,    0.366181462293,    0.144688725391,  0.00103971433506,    0.144688725391,    0.195261608833,    0.366181462293, 0.000297786937793,    0.366181462293,    0.195261608833,    0.195261608833,    0.195261608833,    0.195261608833,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,  0.00161603711532,    0.197954593807,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.195261608833, 0.000839379892832,    0.195261608833,    0.195261608833,  0.00104593805858,    0.366181462293,    0.195261608833,    0.366181462293,    0.144688725391,    0.197954593807,    0.366181462293,    0.197954593807,    0.197954593807,    0.144688725391,    0.195261608833,    0.144688725391,    0.366181462293,    0.144688725391,    0.366181462293,    0.366181462293,    0.197954593807,    0.366181462293,    0.144688725391,  0.00369582452928,    0.197954593807,    0.366181462293,    0.366181462293,    0.195261608833,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.144688725391,    0.197954593807,    0.195261608833,    0.197954593807,    0.195261608833,    0.195261608833,    0.195261608833,    0.144688725391,    0.366181462293,    0.195261608833,    0.366181462293,    0.366181462293,  0.00100139646108,    0.366181462293,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293,    0.144688725391,  0.00106000482745,    0.366181462293,    0.195261608833,  0.00381066260254,    0.366181462293, 0.000755744282257,    0.197954593807,    0.366181462293,    0.195261608833,    0.366181462293, 7.41072214982e-06,    0.144688725391,    0.144688725391,    0.366181462293,    0.197954593807,    0.366181462293,    0.144688725391,    0.197954593807,    0.197954593807, 0.000869144140946,    0.366181462293,    0.366181462293,    0.366181462293,    0.195261608833,    0.195261608833, 0.000628997684683,    0.144688725391,    0.197954593807,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,    0.144688725391,    0.195261608833,    0.197954593807,    0.195261608833,    0.366181462293,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.195261608833,    0.197954593807,    0.366181462293,    0.366181462293,    0.195261608833,    0.197954593807,    0.144688725391,    0.195261608833,  0.00271020176216,  0.00046762324298,    0.144688725391,    0.366181462293,    0.197954593807,    0.197954593807,    0.366181462293,    0.366181462293,    0.366181462293,    0.144688725391,    0.195261608833,    0.144688725391,    0.366181462293,    0.195261608833,    0.197954593807,    0.144688725391,    0.195261608833,  0.00209797301136,    0.366181462293,    0.366181462293,    0.195261608833,  0.00122962492444,    0.144688725391,    0.366181462293,    0.366181462293,  0.00044629383895,    0.195261608833,    0.197954593807,    0.195261608833,    0.366181462293,    0.197954593807,    0.144688725391,    0.366181462293, 0.000296720978264,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0}
{                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,    0.193786893734,    0.193786893734,     0.19580929411,    0.143109278176,     0.19580929411,    0.363391705084,  0.00132552530685,    0.363391705084,    0.193786893734,  0.00168063779911,    0.363391705084,    0.193786893734,    0.143109278176,    0.193786893734,     0.19580929411,    0.143109278176,     0.19580929411,    0.193786893734,     0.19580929411,    0.363391705084,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,    0.363391705084,    0.193786893734,    0.193786893734,    0.143109278176,     0.19580929411,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734,    0.143109278176,     0.19580929411,    0.193786893734,    0.363391705084,  0.00132552530685,     0.19580929411,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,    0.363391705084,    0.363391705084,  9.2568695073e-05,    0.193786893734,     0.19580929411,    0.143109278176,    0.363391705084,    0.363391705084,     0.19580929411,  0.00112699057087,    0.193786893734,    0.143109278176,    0.143109278176,    0.363391705084,     0.19580929411,    0.363391705084,    0.143109278176,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.193786893734,     0.19580929411,    0.363391705084,  0.00168063779911,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.193786893734,    0.363391705084, 0.000537001491444,    0.193786893734,    0.143109278176,    0.193786893734,     0.19580929411,    0.143109278176,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,     0.19580929411,    0.363391705084,     0.19580929411,     0.19580929411,    0.193786893734,    0.143109278176,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,    0.193786893734,    0.363391705084,  0.00117786279932,    0.143109278176,    0.363391705084,     0.19580929411,     0.19580929411,    0.143109278176,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,     0.19580929411,    0.363391705084,    0.193786893734,    0.193786893734,    0.193786893734, 0.000523075165186,     0.19580929411,    0.143109278176,     0.19580929411,    0.193786893734,    0.363391705084,  0.00168063779911,    0.143109278176,    0.143109278176,    0.143109278176,    0.363391705084,    0.193786893734,    0.193786893734,     0.19580929411,    0.143109278176,    0.193786893734,    0.193786893734,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,    0.193786893734,  0.00292597471696,    0.193786893734,    0.193786893734,    0.143109278176,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,    0.193786893734,    0.363391705084,    0.363391705084, 0.000775003056361,    0.193786893734,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,    0.363391705084, 0.000903837465988,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,    0.143109278176,    0.363391705084,    0.363391705084,    0.143109278176,     0.19580929411,    0.193786893734,    0.193786893734,    0.363391705084,     0.19580929411,     0.19580929411,    0.193786893734,    0.143109278176,    0.363391705084,    0.143109278176,    0.143109278176,    0.363391705084,    0.143109278176,  0.00104190138795,   0.0017455345143,    0.143109278176,    0.143109278176,     0.19580929411,    0.193786893734,    0.363391705084,    0.193786893734,     0.19580929411,    0.363391705084,    0.193786893734,    0.143109278176,    0.193786893734,  0.00117006163368,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,  0.00116248903889,     0.19580929411,    0.193786893734,    0.193786893734,    0.363391705084, 4.59356497483e-05,     0.19580929411,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084, 0.000562603630892,    0.143109278176,     0.19580929411,    0.363391705084,    0.363391705084, 0.000318950702244,    0.143109278176, 0.000463532052391,     0.19580929411,    0.363391705084,    0.363391705084,  0.00398096459675,    0.143109278176,    0.193786893734,     0.19580929411,    0.193786893734,    0.193786893734,     0.19580929411,    0.193786893734,    0.193786893734,    0.363391705084,    0.193786893734,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734,     0.19580929411,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084,    0.193786893734,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,    0.143109278176,     0.19580929411,     0.19580929411,    0.193786893734,  0.00111861787816,     0.19580929411,    0.363391705084, 0.000181892872202,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,     0.19580929411, 0.000272356077646,    0.363391705084,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,    0.363391705084,  0.00225933996447,    0.193786893734,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,    0.193786893734,    0.193786893734,    0.143109278176,    0.143109278176,    0.193786893734,    0.193786893734,    0.363391705084,    0.143109278176,    0.363391705084,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,    0.143109278176,    0.143109278176,    0.193786893734,    0.193786893734,    0.193786893734,    0.363391705084,    0.363391705084,    0.193786893734,    0.193786893734,     0.19580929411,    0.193786893734,     0.19580929411,    0.363391705084,  0.00111963991425,    0.143109278176,    0.193786893734,    0.143109278176,    0.193786893734, 0.000367811125357,    0.143109278176,    0.363391705084,    0.143109278176,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.193786893734,    0.363391705084,    0.193786893734,     0.19580929411,     0.19580929411,    0.193786893734,    0.363391705084,    0.143109278176,     0.19580929411,     0.19580929411,     0.19580929411,     0.19580929411,    0.193786893734,    0.363391705084,  0.00287754587959,    0.143109278176,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,    0.193786893734,    0.143109278176,    0.143109278176,    0.363391705084,    0.193786893734,    0.193786893734,    0.193786893734,     0.19580929411,  0.00398096459675,    0.143109278176, 0.000523075165186,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084,     0.19580929411,    0.363391705084,    0.193786893734,    0.193786893734,    0.363391705084,    0.193786893734,    0.363391705084,     0.19580929411, 0.000320828109973,    0.193786893734,    0.193786893734,     0.19580929411,    0.193786893734,    0.363391705084,  0.00168063779911,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,    0.193786893734,     0.19580929411,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084,    0.193786893734,     0.19580929411,    0.143109278176,    0.193786893734,     0.19580929411,    0.193786893734,     0.19580929411,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,    0.363391705084,     0.19580929411,    0.143109278176,    0.193786893734,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,    0.193786893734,    0.143109278176,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,     0.19580929411,    0.363391705084,    0.193786893734,    0.193786893734,    0.363391705084,    0.143109278176,  0.00195993902939,    0.363391705084,    0.363391705084,  0.00190008094349,     0.19580929411,    0.193786893734,     0.19580929411,    0.363391705084,    0.193786893734,  0.00195993902939,    0.143109278176,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734, 0.000532125450828,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,    0.143109278176,    0.143109278176,     0.19580929411,    0.193786893734,    0.363391705084,    0.193786893734,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084, 0.000520151667836,    0.143109278176,    0.363391705084,     0.19580929411,    0.363391705084,  0.00114538635842,    0.363391705084,  0.00119802077391,    0.193786893734,    0.363391705084,    0.363391705084,  0.00114538635842,    0.193786893734,    0.193786893734,    0.143109278176,    0.363391705084,    0.363391705084, 0.000326689938775,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,    0.193786893734,     0.19580929411,    0.193786893734,    0.143109278176,    0.193786893734,    0.143109278176,     0.19580929411,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,    0.193786893734,     0.19580929411,    0.193786893734,    0.363391705084,  0.00398096459675,    0.193786893734, 0.000348090766526,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411, 0.000326689938775,    0.363391705084,     0.19580929411,    0.363391705084, 0.000320597751456,    0.363391705084,    0.143109278176,    0.143109278176,    0.363391705084,     0.19580929411,    0.143109278176,     0.19580929411,    0.363391705084,  0.00115258192939,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084,    0.193786893734,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084,    0.143109278176, 0.000135116852911,    0.193786893734,    0.363391705084,    0.363391705084,    0.193786893734,    0.193786893734,     0.19580929411,    0.363391705084,    0.193786893734,     0.19580929411,    0.363391705084,    0.193786893734,     0.19580929411,  0.00411578856395,    0.363391705084,    0.143109278176,    0.143109278176,    0.143109278176,   0.0013496295514,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,    0.363391705084,    0.363391705084,    0.193786893734,    0.363391705084, 0.000775495548683,    0.363391705084,    0.193786893734,  0.00119802077391,    0.363391705084, 5.42070362415e-05,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,    0.143109278176,    0.143109278176,    0.143109278176,    0.193786893734,    0.193786893734, 0.000287248475958,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,    0.193786893734,    0.143109278176,    0.363391705084,    0.193786893734,     0.19580929411,    0.193786893734,    0.193786893734,    0.363391705084,     0.19580929411,    0.363391705084,    0.143109278176,  0.00111963991425,    0.143109278176,    0.193786893734,    0.363391705084, 0.000321847266373,    0.363391705084,    0.193786893734,    0.193786893734,    0.193786893734,    0.193786893734,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,   0.0017455345143,     0.19580929411,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,    0.193786893734, 0.000903837465988,    0.193786893734,    0.193786893734,  0.00112699057087,    0.363391705084,    0.193786893734,    0.363391705084,    0.143109278176,     0.19580929411,    0.363391705084,     0.19580929411,     0.19580929411,    0.143109278176,    0.193786893734,    0.143109278176,    0.363391705084,    0.143109278176,    0.363391705084,    0.363391705084,     0.19580929411,    0.363391705084,    0.143109278176,  0.00398096459675,     0.19580929411,    0.363391705084,    0.363391705084,    0.193786893734,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.143109278176,     0.19580929411,    0.193786893734,     0.19580929411,    0.193786893734,    0.193786893734,    0.193786893734,    0.143109278176,    0.363391705084,    0.193786893734,    0.363391705084,    0.363391705084,  0.00108164200821,    0.363391705084,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,    0.143109278176,  0.00114601534464,    0.363391705084,    0.193786893734,  0.00411578856395,    0.363391705084, 0.000816905393404,     0.19580929411,    0.363391705084,    0.193786893734,    0.363391705084, 8.69376708837e-06,    0.143109278176,    0.143109278176,    0.363391705084,     0.19580929411,    0.363391705084,    0.143109278176,     0.19580929411,     0.19580929411, 0.000938774121161,    0.363391705084,    0.363391705084,    0.363391705084,    0.193786893734,    0.193786893734, 0.000677595466899,    0.143109278176,     0.19580929411,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,    0.143109278176,    0.193786893734,     0.19580929411,    0.193786893734,    0.363391705084,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,    0.193786893734,     0.19580929411,    0.363391705084,    0.363391705084,    0.193786893734,     0.19580929411,    0.143109278176,    0.193786893734,  0.00292597471696, 0.000503672957764,    0.143109278176,    0.363391705084,     0.19580929411,     0.19580929411,    0.363391705084,    0.363391705084,    0.363391705084,    0.143109278176,    0.193786893734,    0.143109278176,    0.363391705084,    0.193786893734,     0.19580929411,    0.143109278176,    0.193786893734,  0.00225933996447,    0.363391705084,    0.363391705084,    0.193786893734,  0.00132552530685,    0.143109278176,    0.363391705084,    0.363391705084, 0.000482237606705,    0.193786893734,     0.19580929411,    0.193786893734,    0.363391705084,     0.19580929411,    0.143109278176,    0.363391705084,  0.00032059159051,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0,                 0}
};

expectedConditionalProbabilities = Transpose(expectedConditionalProbabilities);


AUTO_PARALLELIZE_OPTIMIZE = 1;

LikelihoodFunction multiPart = (part_0, tree_0, part_1, tree_1, part_2, tree_2, part_3, tree_3);

Optimize(res_multiPart,multiPart);

ExecuteAFile ("../Shared/REL_utils.bf");
marginalErrors = checkMarginalReconstruction ( expectedConditionalProbabilities, exepectedRateClassAssignments, "multiPart");

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult (Abs (res_multiPart[1][0] - _expectedLL) < 0.01 && marginalErrors[0] < 0.0001 && marginalErrors[1] == 0))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */


END;
