/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcArbitraryProfileDefWithVoids.h"
#include "ifcpp/IFC4/include/IfcCurve.h"
#include "ifcpp/IFC4/include/IfcExternalReferenceRelationship.h"
#include "ifcpp/IFC4/include/IfcLabel.h"
#include "ifcpp/IFC4/include/IfcProfileProperties.h"
#include "ifcpp/IFC4/include/IfcProfileTypeEnum.h"

// ENTITY IfcArbitraryProfileDefWithVoids 
IfcArbitraryProfileDefWithVoids::IfcArbitraryProfileDefWithVoids( int id ) { m_entity_id = id; }
IfcArbitraryProfileDefWithVoids::~IfcArbitraryProfileDefWithVoids() {}
shared_ptr<BuildingObject> IfcArbitraryProfileDefWithVoids::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcArbitraryProfileDefWithVoids> copy_self( new IfcArbitraryProfileDefWithVoids() );
	if( m_ProfileType ) { copy_self->m_ProfileType = dynamic_pointer_cast<IfcProfileTypeEnum>( m_ProfileType->getDeepCopy(options) ); }
	if( m_ProfileName ) { copy_self->m_ProfileName = dynamic_pointer_cast<IfcLabel>( m_ProfileName->getDeepCopy(options) ); }
	if( m_OuterCurve ) { copy_self->m_OuterCurve = dynamic_pointer_cast<IfcCurve>( m_OuterCurve->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_InnerCurves.size(); ++ii )
	{
		auto item_ii = m_InnerCurves[ii];
		if( item_ii )
		{
			copy_self->m_InnerCurves.emplace_back( dynamic_pointer_cast<IfcCurve>(item_ii->getDeepCopy(options) ) );
		}
	}
	return copy_self;
}
void IfcArbitraryProfileDefWithVoids::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCARBITRARYPROFILEDEFWITHVOIDS" << "(";
	if( m_ProfileType ) { m_ProfileType->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_ProfileName ) { m_ProfileName->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_OuterCurve ) { stream << "#" << m_OuterCurve->m_entity_id; } else { stream << "$"; }
	stream << ",";
	writeEntityList( stream, m_InnerCurves );
	stream << ");";
}
void IfcArbitraryProfileDefWithVoids::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcArbitraryProfileDefWithVoids::toString() const { return L"IfcArbitraryProfileDefWithVoids"; }
void IfcArbitraryProfileDefWithVoids::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 4 ){ std::stringstream err; err << "Wrong parameter count for entity IfcArbitraryProfileDefWithVoids, expecting 4, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_ProfileType = IfcProfileTypeEnum::createObjectFromSTEP( args[0], map );
	m_ProfileName = IfcLabel::createObjectFromSTEP( args[1], map );
	readEntityReference( args[2], m_OuterCurve, map );
	readEntityReferenceList( args[3], m_InnerCurves, map );
}
void IfcArbitraryProfileDefWithVoids::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcArbitraryClosedProfileDef::getAttributes( vec_attributes );
	if( !m_InnerCurves.empty() )
	{
		shared_ptr<AttributeObjectVector> InnerCurves_vec_object( new AttributeObjectVector() );
		std::copy( m_InnerCurves.begin(), m_InnerCurves.end(), std::back_inserter( InnerCurves_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "InnerCurves", InnerCurves_vec_object ) );
	}
}
void IfcArbitraryProfileDefWithVoids::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcArbitraryClosedProfileDef::getAttributesInverse( vec_attributes_inverse );
}
void IfcArbitraryProfileDefWithVoids::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcArbitraryClosedProfileDef::setInverseCounterparts( ptr_self_entity );
}
void IfcArbitraryProfileDefWithVoids::unlinkFromInverseCounterparts()
{
	IfcArbitraryClosedProfileDef::unlinkFromInverseCounterparts();
}
