/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggpagetensorfield.h"


#include "idatasubject.h"
#include "iimagefactory.h"
#include "itensorfieldviewsubject.h"
#include "iviewmodule.h"

#include "iggdatatypeprovider.h"
#include "iggframedatavariablelist.h"
#include "iggframematerialproperties.h"
#include "iggframepaletteselection.h"
#include "iggframereplicate.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeycolorselection.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetentrysubject.h"

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include "iggwidgetkeyslidertemplate.h"


using namespace iParameter;


namespace iggPageTensorField_Private
{
	//
	//  Main page
	// ************************************************
	//
	class MainPage : public iggFrameDC
	{

	public:

		MainPage(iggFrameBase *parent, iggDataTypeProvider *provider) : iggFrameDC(parent,3), mProvider(provider)
		{
			if(this->ImmediateConstruction()) this->CompleteConstruction();
		}

	protected:

		iggDataTypeProvider *mProvider;

		virtual void CompleteConstructionBody()
		{
			//
			//  Show
			//
			this->AddLine(new iggWidgetShowButton(iTensorFieldViewSubject::Type(),this));
			this->AddSpace(2);
			//
			//  Method & color
			//
			iggFrame *mc = new iggFrame(this,2);
			iggWidgetKeyRadioBox *mb = new iggWidgetKeyRadioBox(1,"Method",0,iTensorFieldViewSubject::KeyMethod(),mc);
			mb->InsertItem("Glyph");
			iggFrame *cf = new iggFrame(mc,2);
			cf->AddSpace(1);
			cf->AddLine(new iggWidgetKeyColorSelection(iTensorFieldViewSubject::KeyColor(),cf));
			cf->AddSpace(2);
			cf->SetColStretch(1,1);
			mc->AddLine(mb,cf);
			mc->SetColStretch(1,3);

			this->AddLine(mc);
			this->AddSpace(10);
			//
			//  Glyph size
			//
			this->AddLine(new iggWidgetKeySizeSlider(1.0e-5,0,"Glyph size",iTensorFieldViewSubject::KeyGlyphSize(true),RenderMode::UseGlobal,this),2);
			this->AddSpace(2);
			//
			//  Tensor magnitude and downsample
			//
			//iggWidgetKeyRelativeFloatSlider *ms = new iggWidgetKeyRelativeFloatSlider(iDataSubject::KeyMax(),0.0,1.0,100,0,5,"Tensor magnitude",iDataSubject::KeyUpperLimit(),RenderMode::UseGlobal,page0,0);
			//ms->AttachDataTypeProvider(mProvider);
			iggWidgetKeyVariableLimitsSlider *ms = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Tensor magnitude",iDataSubject::KeyUpperLimit(),0,0,RenderMode::UseGlobal,this,0);
			ms->SetStretch(5,10,0);
			this->AddLine(ms,2);
			iggWidgetKeyIntSlider *rs = new iggWidgetKeyIntSlider(1,20,5,"Sample rate",iTensorFieldViewSubject::KeyGlyphSampleRate(),RenderMode::UseGlobal,this);
			rs->SetStretch(5,10,0);
			this->AddLine(rs,2);
			this->AddSpace(10);

			this->SetColStretch(1,10);
			this->SetColStretch(2,3);
		}
	};


	//
	//  Paint page
	// ************************************************
	//
	class PaintPage : public iggFrameDC
	{

	public:

		PaintPage(iggFrameBase *parent, iggDataTypeProvider *scalar_provider) : iggFrameDC(parent,1), mScalarProvider(scalar_provider)
		{
			if(this->ImmediateConstruction()) this->CompleteConstruction();
		}

	protected:

		iggDataTypeProvider *mScalarProvider;

		virtual void CompleteConstructionBody()
		{
			const iImage *icon = iImageFactory::FindIcon("tens.png");

			//
			//  Book
			//
			iggFrameBook *pb = new iggFrameBook(this);
			this->AddLine(pb);
			//
			//  Palette page
			//
			iggFrame *pbpage0 = new iggFrame(pb,3);
			pb->AddPage("Palette",icon,pbpage0);
			{
				iggFrameDataVariableList *pl = new iggFrameDataVariableList(mScalarProvider,"Paint with...",iTensorFieldViewSubject::KeyColorBy(),&iTensorFieldViewSubject::KeyConnectedToScalars(),pbpage0);
				pl->InsertItem("None");
				pl->Complete();
				pbpage0->AddLine(pl);
				pbpage0->AddSpace(10);
				pbpage0->AddLine(new iggFramePaletteSelection(true,iTensorFieldViewSubject::KeyPalette(),pbpage0),2);
				pbpage0->AddSpace(20);
				pbpage0->SetColStretch(1,10);
				pbpage0->SetColStretch(2,3);
			}
			//
			//  Material page
			//
			iggFrame *pbpage1 = new iggFrame(pb,2);
			pb->AddPage("Material",icon,pbpage1);
			{
				pbpage1->AddLine(new iggFrameMaterialProperties(false,false,iTensorFieldViewSubject::Type(),pbpage1));
				pbpage1->AddSpace(10);
				pbpage1->SetColStretch(0,10);
				pbpage1->SetColStretch(1,3);
			}
		}
	};


	//
	//  Replicate page
	// ************************************************
	//
	class ReplicatePage : public iggFrameDC
	{

	public:

		ReplicatePage(iggFrameBase *parent) : iggFrameDC(parent,2)
		{
			if(this->ImmediateConstruction()) this->CompleteConstruction();
		}

	protected:

		virtual void CompleteConstructionBody()
		{
			//
			//  Replicate
			//
			this->AddLine(new iggFrameReplicate(iTensorFieldViewSubject::Type(),this));
			this->AddSpace(10);
			this->SetColStretch(1,3);
		}
	};
};


using namespace iggPageTensorField_Private;


iggPageTensorField::iggPageTensorField(iggFrameBase *parent) : iggPageObject(parent,ViewSubject::Id::TensorField)
{
	const iImage *icon = iImageFactory::FindIcon("tens.png");

	//
	//  Main page
	// ************************************************
	//
	MainPage *page0 = new MainPage(mBook,mProvider);
	mBook->AddPage("Main",icon,page0);

	//
	//  Paint page
	// ************************************************
	//
	PaintPage *page1 = new PaintPage(mBook,mScalarProvider);
	mBook->AddPage("Paint",icon,page1);

	//
	//  Replicate page
	// ************************************************
	//
	ReplicatePage *page2 = new ReplicatePage(mBook);
	mBook->AddPage("Replicate",icon,page2);
}

#endif
