# Header file for the non-linear curve fitting package.

# Function types and dimensionality separator.
define	NLFUNCTIONS  "|bbody|powerlaw|composite|twobbody|galprof|galbulge|galdisk|Gaussians|cgauss|user|twodgaus"

# Functions of one variable.
define	BBODY		1		# black body
define	POWERLAW	2		# power law
define	COMPOSITE	3		# black body + power law
define	TWOBBODY	4		# black body + black body
define	GALPROF		5		# galaxy brightness profile
define	GALBULGE	6		# bulge brightness profile
define	GALDISK		7		# disk brightness profile
define	GAUSSIANS	8		# multiple Gaussians
define	CGAUSS		9		# multiple constrained Gaussians
define	USER		10		# user

# Functions of two variables.
define	TWODGAUSS	11		# 2-dim Gaussian

define	NLTWODSEP	11		# First function of two variables.
define	NUPAR		10		# Maximum number of coefficients in 
					# user function.


# Minimization algorithms.
define	NLMETHODS  "|amoeba|Levenberg-Marquardt"
define	AMOEBA		1
define	MARQUARDT	2


# X axis physical units

define	NLUNITS		"|*|Angstrom|meter|cm|Hz|KeV|linear|4th-root"

define	AUTO		1		# these are specific for Planck
define	ANGSTROM	2		# function
define	METER		3
define	CM		4
define	HZ		5
define	KEV		6
define	LINEAR		7		# these are specific for galaxy
define	FOURTH_ROOT	8		# brigthness profile


# Error calculation mode

define	NLERRORS	"|uniform|bars|ccd"

define	UNIFORM		1
define	BARS		2
define	CCD		3

define	DEF_RESTART	   2		# Default # of restarts
define	DEF_REPLIC	  20		# Default # of bootstrap samples.
define	MAXITER		 500		# Default maximum number of iterations

# NLFIT control structure

define	LEN_NLSTRUCT	39

define	NL_FITFUNC	Memi[$1+0]	# Type of curve to be fitted.
define	NL_NPAR		Memi[$1+1]	# Total no. of parameters in function.
define	NL_NPTS		Memi[$1+2]	# Total number of data points.
define	NL_DIM		Memi[$1+3]	# Function and data dimensionality
define	NL_DUMMY	Memr[P2R($1+4)]	# Not used
define	NL_NREJECT	Memi[$1+5]	# Number of rejected points.
define	NL_SIGMA	Memr[P2R($1+6)]	# Common error bar on all data points.
define	NL_EPADU	Memr[P2R($1+7)]	# ccd gain
define	NL_RNOISE	Memr[P2R($1+8)]	# ccd readout noise
define	NL_CHISQ	Memr[P2R($1+9)]	# chi-sq of present fit.
define	NL_RMS		Memr[P2R($1+10)] # rms of present fit.
define	NL_XSCALE	Memr[P2R($1+11)] # Scaling applied to X values.
define	NL_YSCALE	Memr[P2R($1+12)] # Scaling applied to Y values.
define	NL_ZSCALE	Memr[P2R($1+13)] # Scaling applied to Z values.
define	NL_WSCALE	Memr[P2R($1+14)] # Scaling applied to weigths.
define	NL_ERR		Memb[$1+15]	# Compute parameter errors ?
define	NL_ERRTYP	Memi[$1+16]	# Type of error calculation
define	NL_REPLI	Memi[$1+17]	# # of replications in boot-resampling
define	NL_UNIT		Memi[$1+18]	# X units
define	NL_MAXIT	Memi[$1+19]	# Max. number of iterartions
define	NL_RESTART	Memi[$1+20]	# # of restarts
define	NL_VERB		Memb[$1+21]	# Print iteration info ?
define	NL_ALPHA	Memr[P2R($1+22)] # Constants wich control the amount
define	NL_BETA		Memr[P2R($1+23)] # of simplex expansion/contraction.
define	NL_GAMMA	Memr[P2R($1+24)]
define	NL_METHOD	Memr[P2R($1+25)] # Minimization algorithm

# Array pointers

define	NL_PARAMS	Memi[$1+26]	# Parameters array.
define	NL_PFLAGS	Memi[$1+27]	# Parameter flags.
define	NL_SPARAMS	Memi[$1+28]	# Scaled parameters array.
define	NL_PARSCALE	Memi[$1+29]	# Scaling factors applied to params.
define	NL_PERRORS	Memi[$1+30]	# Parameter error
define	NL_SX		Memi[$1+31]	# Scaled independent X variable.
define	NL_SY		Memi[$1+32]	# Scaled independent Y variable.
define	NL_SZ		Memi[$1+33]	# Scaled dependent variable.
define	NL_SW		Memi[$1+34]	# Scaled weigths.
define	NL_REJFLAG	Memi[$1+35]	# Rejection flags.
define	NL_AUX		Memi[$1+36]	# Auxiliary storage for function values.

# String pointers

define	NL_USERFUNC	Memi[$1+37]	# String with user function.
define	NL_UCODE	Memi[$1+38]	# Code generated by vex parser.

# Function coefficient offsets in array

define	NL_GA		0		# Gauss, cgaus
define	NL_GB		1
define	NL_GAMPL	3 * ($1 - 1) + 2
define	NL_GCENT	3 * ($1 - 1) + 3
define	NL_GFWHM	3 * ($1 - 1) + 4
define	NL_G2A		0		# 2-d Gaussian
define	NL_G2AMPL	1
define	NL_G2XC		2
define	NL_G2YC		3
define	NL_G2FWHM	4
define	NL_G2ELL	5
define	NL_G2TETA	6
define	NL_PINDEX	0		# powerlaw
define	NL_PAMPL	1
define	NL_PREF		2
define	NL_BTEMP	0		# bbody
define	NL_BAMPL	1
define	NL_BREF		2
define	NL_CINDEX	0		# composite
define	NL_CPAMPL	1
define	NL_CPREF	2
define	NL_CTEMP	3
define	NL_CBAMPL	4
define	NL_CBREF	5
define	NL_TTEMP1	0		# twobbody
define	NL_TAMPL1	1
define	NL_TREF1	2
define	NL_TTEMP2	3
define	NL_TAMPL2	4
define	NL_TREF2	5
define	NL_GBME		0		# galaxy brigthness profile
define	NL_GBRE		1
define	NL_GDM0		2
define	NL_GDR0		3
define	NL_GDRH		4
define	NL_GBACKGR	5
