
/*
 * Janino - An embedded Java[TM] compiler
 *
 * Copyright (c) 2001-2010, Arno Unkrig
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *       following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *       following disclaimer in the documentation and/or other materials provided with the distribution.
 *    3. The name of the author may not be used to endorse or promote products derived from this software without
 *       specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package org.codehaus.commons.compiler;

/**
 * A helper class that wraps primitive values in their wrapper classes.
 */
public final
class PrimitiveWrapper {

    private PrimitiveWrapper() {}

    // CHECKSTYLE JavadocMethod:OFF
    public static Boolean   wrap(boolean v) { return v ? Boolean.TRUE : Boolean.FALSE; }
    public static Byte      wrap(byte    v) { return new Byte(v);      }
    public static Short     wrap(short   v) { return new Short(v);     }
    public static Integer   wrap(int     v) { return new Integer(v);   }
    public static Long      wrap(long    v) { return new Long(v);      }
    public static Character wrap(char    v) { return new Character(v); }
    public static Float     wrap(float   v) { return new Float(v);     }
    public static Double    wrap(double  v) { return new Double(v);    }
    public static Object    wrap(Object  v) { return v;                }
    // CHECKSTYLE JavadocMethod:ON
}
