/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingParameter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.bean.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBindingFactory {
    private static final UrlBindingFactory instance = new UrlBindingFactory();
    private final Map<Class<? extends ActionBean>, UrlBinding> classCache = new HashMap<Class<? extends ActionBean>, UrlBinding>();
    private final Map<String, UrlBinding> pathCache = new HashMap<String, UrlBinding>();
    private final Map<String, UrlBinding> prefixCache = new TreeMap<String, UrlBinding>(new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            int cmp = b.length() - a.length();
            return cmp == 0 ? a.compareTo(b) : cmp;
        }
    });

    public static UrlBindingFactory getInstance() {
        return instance;
    }

    protected UrlBindingFactory() {
    }

    public Collection<Class<? extends ActionBean>> getActionBeanClasses() {
        return Collections.unmodifiableSet(this.classCache.keySet());
    }

    public UrlBinding getBindingPrototype(Class<? extends ActionBean> type) {
        UrlBinding binding = this.classCache.get(type);
        if (binding != null) {
            return binding;
        }
        binding = UrlBindingFactory.parseUrlBinding(type);
        if (binding != null) {
            this.addBinding(type, binding);
        }
        return binding;
    }

    public UrlBinding getBindingPrototype(String uri) {
        UrlBinding prototype = this.pathCache.get(uri);
        if (prototype != null) {
            return prototype;
        }
        for (Map.Entry<String, UrlBinding> entry : this.prefixCache.entrySet()) {
            if (!uri.startsWith(entry.getKey())) continue;
            prototype = entry.getValue();
            break;
        }
        return prototype;
    }

    public UrlBinding getBindingPrototype(HttpServletRequest request) {
        return this.getBindingPrototype(this.trimContextPath(request));
    }

    public UrlBinding getBinding(String uri) {
        Object component;
        int length;
        UrlBinding prototype = this.getBindingPrototype(uri);
        if (prototype == null) {
            return null;
        }
        for (length = uri.length(); length > 0 && uri.charAt(length - 1) == '/'; --length) {
        }
        String suffix = prototype.getSuffix();
        if (suffix != null && uri.endsWith(suffix)) {
            length -= suffix.length();
        }
        ArrayList<Object> components = new ArrayList<Object>(prototype.getComponents().size());
        int index = prototype.getPath().length();
        UrlBindingParameter current = null;
        String value = null;
        Iterator<Object> iter = prototype.getComponents().iterator();
        while (index < length && iter.hasNext()) {
            component = iter.next();
            if (component instanceof String) {
                String literal = (String)component;
                int end = uri.indexOf(literal, index);
                if (end >= 0) {
                    value = uri.substring(index, end);
                    index = end + literal.length();
                } else {
                    value = uri.substring(index, length);
                    index = length;
                }
                if (current == null || value == null || value.length() <= 0) continue;
                components.add(new UrlBindingParameter(current, value));
                components.add(component);
                current = null;
                value = null;
                continue;
            }
            if (!(component instanceof UrlBindingParameter)) continue;
            current = (UrlBindingParameter)component;
        }
        if (index < length) {
            value = uri.substring(index, length);
        }
        if (current != null && value != null && value.length() > 0) {
            components.add(new UrlBindingParameter(current, value));
        }
        while (iter.hasNext()) {
            component = iter.next();
            if (component instanceof UrlBindingParameter) {
                components.add(new UrlBindingParameter((UrlBindingParameter)component));
                continue;
            }
            components.add(component);
        }
        return new UrlBinding(prototype.getBeanType(), prototype.getPath(), components);
    }

    public UrlBinding getBinding(HttpServletRequest request) {
        return this.getBinding(this.trimContextPath(request));
    }

    public HashMap<String, Class<? extends ActionBean>> getPathMap() {
        HashMap<String, Class<? extends ActionBean>> map = new HashMap<String, Class<? extends ActionBean>>();
        for (Map.Entry<String, UrlBinding> entry : this.pathCache.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getBeanType());
        }
        return map;
    }

    public void addBinding(Class<? extends ActionBean> beanType, UrlBinding binding) {
        this.pathCache.put(binding.getPath(), binding);
        if (binding.getSuffix() != null) {
            this.pathCache.put(binding.getPath() + binding.getSuffix(), binding);
        }
        this.prefixCache.put(binding.getPath() + '/', binding);
        List<Object> components = binding.getComponents();
        if (components != null && !components.isEmpty() && components.get(0) instanceof String) {
            this.prefixCache.put(binding.getPath() + components.get(0), binding);
        }
        this.classCache.put(beanType, binding);
    }

    /*
     * Unable to fully structure code
     */
    protected static UrlBinding parseUrlBinding(Class<? extends ActionBean> beanType) {
        annotation = beanType.getAnnotation(net.sourceforge.stripes.action.UrlBinding.class);
        if (annotation == null) {
            return null;
        }
        pattern = annotation.value();
        if (pattern == null || pattern.length() < 1) {
            return null;
        }
        path = null;
        components = new ArrayList<Object>();
        braceLevel = 0;
        escape = false;
        chars = pattern.toCharArray();
        buf = new StringBuilder(pattern.length());
        c = '\u0000';
        block5: for (i = 0; i < chars.length; ++i) {
            c = chars[i];
            if (escape) ** GOTO lbl-1000
            switch (c) {
                case '{': {
                    if (++braceLevel == 1) {
                        if (path == null) {
                            for (end = buf.length() - 1; end >= 0 && !Character.isJavaIdentifierPart(buf.charAt(end)); --end) {
                            }
                            if (end < 0) {
                                path = buf.toString();
                            } else {
                                path = buf.substring(0, ++end);
                                components.add(buf.substring(end));
                            }
                        } else {
                            components.add(buf.toString());
                        }
                        buf.setLength(0);
                        continue block5;
                    }
                    ** GOTO lbl47
                }
                case '}': {
                    if (braceLevel > 0) {
                        --braceLevel;
                    }
                    if (braceLevel == 0) {
                        components.add(UrlBindingFactory.parseUrlBindingParameter(beanType, buf.toString()));
                        buf.setLength(0);
                        continue block5;
                    }
                    ** GOTO lbl47
                }
                case '\\': {
                    escape = true;
                    continue block5;
                }
lbl47:
                // 3 sources

                default: lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                    escape = false;
                }
            }
        }
        if (buf.length() > 0) {
            if (escape) {
                throw new ParseException(pattern, "Expression must not end with escape character");
            }
            if (braceLevel > 0) {
                throw new ParseException(pattern, "Unterminated left brace ('{') in expression");
            }
            if (path == null) {
                path = buf.toString();
            } else if (c == '}') {
                components.add(UrlBindingFactory.parseUrlBindingParameter(beanType, buf.toString()));
            } else {
                components.add(buf.toString());
            }
        }
        return new UrlBinding(beanType, path, components);
    }

    /*
     * Unable to fully structure code
     */
    protected static UrlBindingParameter parseUrlBindingParameter(Class<? extends ActionBean> beanClass, String string) {
        chars = string.toCharArray();
        c = '\u0000';
        escape = false;
        name = new StringBuilder();
        defaultValue = new StringBuilder();
        current = name;
        block4: for (i = 0; i < chars.length; ++i) {
            c = chars[i];
            if (escape) ** GOTO lbl-1000
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block4;
                }
                case '=': {
                    current = defaultValue;
                    continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    current.append(c);
                    escape = false;
                }
            }
        }
        v0 = dflt = defaultValue.length() < 1 ? null : defaultValue.toString();
        if (dflt != null && "$event".equals(name.toString())) {
            throw new ParseException(string, "In ActionBean class " + beanClass.getName() + ", the " + "$event" + " parameter may not be assigned a default value. Its default value is" + " determined by the @DefaultHandler annotation.");
        }
        return new UrlBindingParameter((Class)beanClass, name.toString(), null, dflt){

            public String getValue() {
                throw new UnsupportedOperationException("getValue() is not implemented for URL parameter prototypes");
            }
        };
    }

    protected String trimContextPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath.length() > 1) {
            uri = uri.substring(contextPath.length());
        }
        try {
            String encoding = request.getCharacterEncoding();
            uri = URLDecoder.decode(uri, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException(e);
        }
        return uri;
    }

    public String toString() {
        return String.valueOf(this.classCache);
    }
}

