
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVideoEncoderSettingsControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QVideoEncoderSettingsControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QVideoEncoderSettings>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVideoEncoderSettingsControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QVideoEncoderSettingsControl::staticMetaObject);
}


// void QVideoEncoderSettingsControl::setVideoSettings(const QVideoEncoderSettings &settings)


static void _init_f_setVideoSettings_3450 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoSettings_3450 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl *)cls)->setVideoSettings (arg1);
}


// QList<qreal> QVideoEncoderSettingsControl::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)


static void _init_f_supportedFrameRates_c4392 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "nullptr");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<qreal> > ();
}

static void _call_f_supportedFrameRates_c4392 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (nullptr, heap);
  ret.write<QList<qreal> > ((QList<qreal>)((QVideoEncoderSettingsControl *)cls)->supportedFrameRates (arg1, arg2));
}


// QList<QSize> QVideoEncoderSettingsControl::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)


static void _init_f_supportedResolutions_c4392 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "nullptr");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QSize> > ();
}

static void _call_f_supportedResolutions_c4392 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (nullptr, heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QVideoEncoderSettingsControl *)cls)->supportedResolutions (arg1, arg2));
}


// QStringList QVideoEncoderSettingsControl::supportedVideoCodecs()


static void _init_f_supportedVideoCodecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedVideoCodecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QVideoEncoderSettingsControl *)cls)->supportedVideoCodecs ());
}


// QString QVideoEncoderSettingsControl::videoCodecDescription(const QString &codec)


static void _init_f_videoCodecDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_videoCodecDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QVideoEncoderSettingsControl *)cls)->videoCodecDescription (arg1));
}


// QVideoEncoderSettings QVideoEncoderSettingsControl::videoSettings()


static void _init_f_videoSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoEncoderSettings > ();
}

static void _call_f_videoSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoEncoderSettings > ((QVideoEncoderSettings)((QVideoEncoderSettingsControl *)cls)->videoSettings ());
}


// static QString QVideoEncoderSettingsControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QVideoEncoderSettingsControl::tr (arg1, arg2, arg3));
}


// static QString QVideoEncoderSettingsControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QVideoEncoderSettingsControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QVideoEncoderSettingsControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("setVideoSettings|videoSettings=", "@brief Method void QVideoEncoderSettingsControl::setVideoSettings(const QVideoEncoderSettings &settings)\n", false, &_init_f_setVideoSettings_3450, &_call_f_setVideoSettings_3450);
  methods += new qt_gsi::GenericMethod ("supportedFrameRates", "@brief Method QList<qreal> QVideoEncoderSettingsControl::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedFrameRates_c4392, &_call_f_supportedFrameRates_c4392);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Method QList<QSize> QVideoEncoderSettingsControl::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedResolutions_c4392, &_call_f_supportedResolutions_c4392);
  methods += new qt_gsi::GenericMethod ("supportedVideoCodecs", "@brief Method QStringList QVideoEncoderSettingsControl::supportedVideoCodecs()\n", true, &_init_f_supportedVideoCodecs_c0, &_call_f_supportedVideoCodecs_c0);
  methods += new qt_gsi::GenericMethod ("videoCodecDescription", "@brief Method QString QVideoEncoderSettingsControl::videoCodecDescription(const QString &codec)\n", true, &_init_f_videoCodecDescription_c2025, &_call_f_videoCodecDescription_c2025);
  methods += new qt_gsi::GenericMethod (":videoSettings", "@brief Method QVideoEncoderSettings QVideoEncoderSettingsControl::videoSettings()\n", true, &_init_f_videoSettings_c0, &_call_f_videoSettings_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QVideoEncoderSettingsControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QVideoEncoderSettingsControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QVideoEncoderSettingsControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QVideoEncoderSettingsControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QVideoEncoderSettingsControl> decl_QVideoEncoderSettingsControl (qtdecl_QMediaControl (), "QtMultimedia", "QVideoEncoderSettingsControl_Native",
  methods_QVideoEncoderSettingsControl (),
  "@hide\n@alias QVideoEncoderSettingsControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QVideoEncoderSettingsControl> &qtdecl_QVideoEncoderSettingsControl () { return decl_QVideoEncoderSettingsControl; }

}


class QVideoEncoderSettingsControl_Adaptor : public QVideoEncoderSettingsControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QVideoEncoderSettingsControl_Adaptor();

  //  [adaptor ctor] QVideoEncoderSettingsControl::QVideoEncoderSettingsControl()
  QVideoEncoderSettingsControl_Adaptor() : QVideoEncoderSettingsControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QVideoEncoderSettingsControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QVideoEncoderSettingsControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QVideoEncoderSettingsControl::isSignalConnected(signal);
  }

  //  [expose] int QVideoEncoderSettingsControl::receivers(const char *signal)
  int fp_QVideoEncoderSettingsControl_receivers_c1731 (const char *signal) const {
    return QVideoEncoderSettingsControl::receivers(signal);
  }

  //  [expose] QObject *QVideoEncoderSettingsControl::sender()
  QObject * fp_QVideoEncoderSettingsControl_sender_c0 () const {
    return QVideoEncoderSettingsControl::sender();
  }

  //  [expose] int QVideoEncoderSettingsControl::senderSignalIndex()
  int fp_QVideoEncoderSettingsControl_senderSignalIndex_c0 () const {
    return QVideoEncoderSettingsControl::senderSignalIndex();
  }

  //  [emitter impl] void QVideoEncoderSettingsControl::destroyed(QObject *)
  void emitter_QVideoEncoderSettingsControl_destroyed_1302(QObject *arg1)
  {
    emit QVideoEncoderSettingsControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QVideoEncoderSettingsControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QVideoEncoderSettingsControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QVideoEncoderSettingsControl_Adaptor, bool, QEvent *>(&QVideoEncoderSettingsControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QVideoEncoderSettingsControl::event(_event);
    }
  }

  //  [adaptor impl] bool QVideoEncoderSettingsControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QVideoEncoderSettingsControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QVideoEncoderSettingsControl_Adaptor, bool, QObject *, QEvent *>(&QVideoEncoderSettingsControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QVideoEncoderSettingsControl::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QVideoEncoderSettingsControl::objectNameChanged(const QString &objectName)
  void emitter_QVideoEncoderSettingsControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QVideoEncoderSettingsControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QVideoEncoderSettingsControl::setVideoSettings(const QVideoEncoderSettings &settings)
  void cbs_setVideoSettings_3450_0(const QVideoEncoderSettings &settings)
  {
    __SUPPRESS_UNUSED_WARNING (settings);
    throw qt_gsi::AbstractMethodCalledException("setVideoSettings");
  }

  virtual void setVideoSettings(const QVideoEncoderSettings &settings)
  {
    if (cb_setVideoSettings_3450_0.can_issue()) {
      cb_setVideoSettings_3450_0.issue<QVideoEncoderSettingsControl_Adaptor, const QVideoEncoderSettings &>(&QVideoEncoderSettingsControl_Adaptor::cbs_setVideoSettings_3450_0, settings);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVideoSettings");
    }
  }

  //  [adaptor impl] QList<qreal> QVideoEncoderSettingsControl::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)
  QList<qreal> cbs_supportedFrameRates_c4392_1(const QVideoEncoderSettings &settings, bool *continuous) const
  {
    __SUPPRESS_UNUSED_WARNING (settings);
    __SUPPRESS_UNUSED_WARNING (continuous);
    throw qt_gsi::AbstractMethodCalledException("supportedFrameRates");
  }

  virtual QList<qreal> supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous) const
  {
    if (cb_supportedFrameRates_c4392_1.can_issue()) {
      return cb_supportedFrameRates_c4392_1.issue<QVideoEncoderSettingsControl_Adaptor, QList<qreal>, const QVideoEncoderSettings &, bool *>(&QVideoEncoderSettingsControl_Adaptor::cbs_supportedFrameRates_c4392_1, settings, continuous);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedFrameRates");
    }
  }

  //  [adaptor impl] QList<QSize> QVideoEncoderSettingsControl::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)
  QList<QSize> cbs_supportedResolutions_c4392_1(const QVideoEncoderSettings &settings, bool *continuous) const
  {
    __SUPPRESS_UNUSED_WARNING (settings);
    __SUPPRESS_UNUSED_WARNING (continuous);
    throw qt_gsi::AbstractMethodCalledException("supportedResolutions");
  }

  virtual QList<QSize> supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous) const
  {
    if (cb_supportedResolutions_c4392_1.can_issue()) {
      return cb_supportedResolutions_c4392_1.issue<QVideoEncoderSettingsControl_Adaptor, QList<QSize>, const QVideoEncoderSettings &, bool *>(&QVideoEncoderSettingsControl_Adaptor::cbs_supportedResolutions_c4392_1, settings, continuous);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedResolutions");
    }
  }

  //  [adaptor impl] QStringList QVideoEncoderSettingsControl::supportedVideoCodecs()
  QStringList cbs_supportedVideoCodecs_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("supportedVideoCodecs");
  }

  virtual QStringList supportedVideoCodecs() const
  {
    if (cb_supportedVideoCodecs_c0_0.can_issue()) {
      return cb_supportedVideoCodecs_c0_0.issue<QVideoEncoderSettingsControl_Adaptor, QStringList>(&QVideoEncoderSettingsControl_Adaptor::cbs_supportedVideoCodecs_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedVideoCodecs");
    }
  }

  //  [adaptor impl] QString QVideoEncoderSettingsControl::videoCodecDescription(const QString &codec)
  QString cbs_videoCodecDescription_c2025_0(const QString &codec) const
  {
    __SUPPRESS_UNUSED_WARNING (codec);
    throw qt_gsi::AbstractMethodCalledException("videoCodecDescription");
  }

  virtual QString videoCodecDescription(const QString &codec) const
  {
    if (cb_videoCodecDescription_c2025_0.can_issue()) {
      return cb_videoCodecDescription_c2025_0.issue<QVideoEncoderSettingsControl_Adaptor, QString, const QString &>(&QVideoEncoderSettingsControl_Adaptor::cbs_videoCodecDescription_c2025_0, codec);
    } else {
      throw qt_gsi::AbstractMethodCalledException("videoCodecDescription");
    }
  }

  //  [adaptor impl] QVideoEncoderSettings QVideoEncoderSettingsControl::videoSettings()
  QVideoEncoderSettings cbs_videoSettings_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("videoSettings");
  }

  virtual QVideoEncoderSettings videoSettings() const
  {
    if (cb_videoSettings_c0_0.can_issue()) {
      return cb_videoSettings_c0_0.issue<QVideoEncoderSettingsControl_Adaptor, QVideoEncoderSettings>(&QVideoEncoderSettingsControl_Adaptor::cbs_videoSettings_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("videoSettings");
    }
  }

  //  [adaptor impl] void QVideoEncoderSettingsControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QVideoEncoderSettingsControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QVideoEncoderSettingsControl_Adaptor, QChildEvent *>(&QVideoEncoderSettingsControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QVideoEncoderSettingsControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QVideoEncoderSettingsControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QVideoEncoderSettingsControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QVideoEncoderSettingsControl_Adaptor, QEvent *>(&QVideoEncoderSettingsControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QVideoEncoderSettingsControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QVideoEncoderSettingsControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QVideoEncoderSettingsControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QVideoEncoderSettingsControl_Adaptor, const QMetaMethod &>(&QVideoEncoderSettingsControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QVideoEncoderSettingsControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QVideoEncoderSettingsControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QVideoEncoderSettingsControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QVideoEncoderSettingsControl_Adaptor, QTimerEvent *>(&QVideoEncoderSettingsControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QVideoEncoderSettingsControl::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_setVideoSettings_3450_0;
  gsi::Callback cb_supportedFrameRates_c4392_1;
  gsi::Callback cb_supportedResolutions_c4392_1;
  gsi::Callback cb_supportedVideoCodecs_c0_0;
  gsi::Callback cb_videoCodecDescription_c2025_0;
  gsi::Callback cb_videoSettings_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QVideoEncoderSettingsControl_Adaptor::~QVideoEncoderSettingsControl_Adaptor() { }

//  Constructor QVideoEncoderSettingsControl::QVideoEncoderSettingsControl() (adaptor class)

static void _init_ctor_QVideoEncoderSettingsControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVideoEncoderSettingsControl_Adaptor> ();
}

static void _call_ctor_QVideoEncoderSettingsControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoEncoderSettingsControl_Adaptor *> (new QVideoEncoderSettingsControl_Adaptor ());
}


// void QVideoEncoderSettingsControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QVideoEncoderSettingsControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QVideoEncoderSettingsControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->emitter_QVideoEncoderSettingsControl_destroyed_1302 (arg1);
}


// void QVideoEncoderSettingsControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QVideoEncoderSettingsControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QVideoEncoderSettingsControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QVideoEncoderSettingsControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QVideoEncoderSettingsControl_Adaptor *)cls)->fp_QVideoEncoderSettingsControl_isSignalConnected_c2394 (arg1));
}


// emitter void QVideoEncoderSettingsControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->emitter_QVideoEncoderSettingsControl_objectNameChanged_4567 (arg1);
}


// exposed int QVideoEncoderSettingsControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QVideoEncoderSettingsControl_Adaptor *)cls)->fp_QVideoEncoderSettingsControl_receivers_c1731 (arg1));
}


// exposed QObject *QVideoEncoderSettingsControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QVideoEncoderSettingsControl_Adaptor *)cls)->fp_QVideoEncoderSettingsControl_sender_c0 ());
}


// exposed int QVideoEncoderSettingsControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoEncoderSettingsControl_Adaptor *)cls)->fp_QVideoEncoderSettingsControl_senderSignalIndex_c0 ());
}


// void QVideoEncoderSettingsControl::setVideoSettings(const QVideoEncoderSettings &settings)

static void _init_cbs_setVideoSettings_3450_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVideoSettings_3450_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = args.read<const QVideoEncoderSettings & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_setVideoSettings_3450_0 (arg1);
}

static void _set_callback_cbs_setVideoSettings_3450_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_setVideoSettings_3450_0 = cb;
}


// QList<qreal> QVideoEncoderSettingsControl::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)

static void _init_cbs_supportedFrameRates_c4392_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<qreal> > ();
}

static void _call_cbs_supportedFrameRates_c4392_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = args.read<const QVideoEncoderSettings & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<QList<qreal> > ((QList<qreal>)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_supportedFrameRates_c4392_1 (arg1, arg2));
}

static void _set_callback_cbs_supportedFrameRates_c4392_1 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_supportedFrameRates_c4392_1 = cb;
}


// QList<QSize> QVideoEncoderSettingsControl::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)

static void _init_cbs_supportedResolutions_c4392_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QSize> > ();
}

static void _call_cbs_supportedResolutions_c4392_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = args.read<const QVideoEncoderSettings & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_supportedResolutions_c4392_1 (arg1, arg2));
}

static void _set_callback_cbs_supportedResolutions_c4392_1 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_supportedResolutions_c4392_1 = cb;
}


// QStringList QVideoEncoderSettingsControl::supportedVideoCodecs()

static void _init_cbs_supportedVideoCodecs_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_supportedVideoCodecs_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_supportedVideoCodecs_c0_0 ());
}

static void _set_callback_cbs_supportedVideoCodecs_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_supportedVideoCodecs_c0_0 = cb;
}


// void QVideoEncoderSettingsControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QString QVideoEncoderSettingsControl::videoCodecDescription(const QString &codec)

static void _init_cbs_videoCodecDescription_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_videoCodecDescription_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QString > ((QString)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_videoCodecDescription_c2025_0 (arg1));
}

static void _set_callback_cbs_videoCodecDescription_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_videoCodecDescription_c2025_0 = cb;
}


// QVideoEncoderSettings QVideoEncoderSettingsControl::videoSettings()

static void _init_cbs_videoSettings_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoEncoderSettings > ();
}

static void _call_cbs_videoSettings_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoEncoderSettings > ((QVideoEncoderSettings)((QVideoEncoderSettingsControl_Adaptor *)cls)->cbs_videoSettings_c0_0 ());
}

static void _set_callback_cbs_videoSettings_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVideoEncoderSettingsControl_Adaptor *)cls)->cb_videoSettings_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QVideoEncoderSettingsControl> &qtdecl_QVideoEncoderSettingsControl ();

static gsi::Methods methods_QVideoEncoderSettingsControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVideoEncoderSettingsControl::QVideoEncoderSettingsControl()\nThis method creates an object of class QVideoEncoderSettingsControl.", &_init_ctor_QVideoEncoderSettingsControl_Adaptor_0, &_call_ctor_QVideoEncoderSettingsControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QVideoEncoderSettingsControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QVideoEncoderSettingsControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QVideoEncoderSettingsControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QVideoEncoderSettingsControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QVideoEncoderSettingsControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QVideoEncoderSettingsControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QVideoEncoderSettingsControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QVideoEncoderSettingsControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QVideoEncoderSettingsControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QVideoEncoderSettingsControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QVideoEncoderSettingsControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVideoSettings", "@brief Virtual method void QVideoEncoderSettingsControl::setVideoSettings(const QVideoEncoderSettings &settings)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVideoSettings_3450_0, &_call_cbs_setVideoSettings_3450_0);
  methods += new qt_gsi::GenericMethod ("setVideoSettings", "@hide", false, &_init_cbs_setVideoSettings_3450_0, &_call_cbs_setVideoSettings_3450_0, &_set_callback_cbs_setVideoSettings_3450_0);
  methods += new qt_gsi::GenericMethod ("supportedFrameRates", "@brief Virtual method QList<qreal> QVideoEncoderSettingsControl::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedFrameRates_c4392_1, &_call_cbs_supportedFrameRates_c4392_1);
  methods += new qt_gsi::GenericMethod ("supportedFrameRates", "@hide", true, &_init_cbs_supportedFrameRates_c4392_1, &_call_cbs_supportedFrameRates_c4392_1, &_set_callback_cbs_supportedFrameRates_c4392_1);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Virtual method QList<QSize> QVideoEncoderSettingsControl::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedResolutions_c4392_1, &_call_cbs_supportedResolutions_c4392_1);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@hide", true, &_init_cbs_supportedResolutions_c4392_1, &_call_cbs_supportedResolutions_c4392_1, &_set_callback_cbs_supportedResolutions_c4392_1);
  methods += new qt_gsi::GenericMethod ("supportedVideoCodecs", "@brief Virtual method QStringList QVideoEncoderSettingsControl::supportedVideoCodecs()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedVideoCodecs_c0_0, &_call_cbs_supportedVideoCodecs_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedVideoCodecs", "@hide", true, &_init_cbs_supportedVideoCodecs_c0_0, &_call_cbs_supportedVideoCodecs_c0_0, &_set_callback_cbs_supportedVideoCodecs_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QVideoEncoderSettingsControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("videoCodecDescription", "@brief Virtual method QString QVideoEncoderSettingsControl::videoCodecDescription(const QString &codec)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_videoCodecDescription_c2025_0, &_call_cbs_videoCodecDescription_c2025_0);
  methods += new qt_gsi::GenericMethod ("videoCodecDescription", "@hide", true, &_init_cbs_videoCodecDescription_c2025_0, &_call_cbs_videoCodecDescription_c2025_0, &_set_callback_cbs_videoCodecDescription_c2025_0);
  methods += new qt_gsi::GenericMethod ("videoSettings", "@brief Virtual method QVideoEncoderSettings QVideoEncoderSettingsControl::videoSettings()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_videoSettings_c0_0, &_call_cbs_videoSettings_c0_0);
  methods += new qt_gsi::GenericMethod ("videoSettings", "@hide", true, &_init_cbs_videoSettings_c0_0, &_call_cbs_videoSettings_c0_0, &_set_callback_cbs_videoSettings_c0_0);
  return methods;
}

gsi::Class<QVideoEncoderSettingsControl_Adaptor> decl_QVideoEncoderSettingsControl_Adaptor (qtdecl_QVideoEncoderSettingsControl (), "QtMultimedia", "QVideoEncoderSettingsControl",
  methods_QVideoEncoderSettingsControl_Adaptor (),
  "@qt\n@brief Binding of QVideoEncoderSettingsControl");

}

