// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2010 Konrad Twardowski

#include "test.h"

#include "../config.h"
#include "../udialog.h"
#include "../utils.h"

#include <QFormLayout>

#ifdef KS_KF5
	#include <KMessageBox>
#endif // KS_KF5

// TestAction

// public

TestAction::TestAction() :
	Action(i18n("Show Message (no shutdown)"), "dialog-ok", "test")
{
// TODO: sound beep
	setCanBookmark(true);
	setCommandLineOption({ "test" });
	setVisibleInMainMenu(false);
	setVisibleInSystemTrayMenu(false);

	// TEST: setEnabled(false, "Test", InfoWidget::Type::Info);
}

void TestAction::initContainerWidget() {
	m_textEdit = new QPlainTextEdit(m_defaultText);
	m_textEdit->setFixedHeight(70_px);
	m_textEdit->setPlaceholderText(i18n("Enter a message"));

	auto *layout = makeFormLayout();
	layout->addRow(i18n("Text:"), m_textEdit);
}

bool TestAction::onAction() {
	QString text = (m_textEdit != nullptr) ? m_textEdit->toPlainText() : "";
	text = text.trimmed();

	if (text.isEmpty())
		text = Utils::makeHTML("<h1 style=\"background-color: red; color: white\">" + i18n("Test") + "</h1>");

	#ifdef KS_KF5
	KMessageBox::information(nullptr, text); // with sound!
	#else
	UDialog::info(nullptr, text);
	#endif // KS_KF5
	
	return true;
}

void TestAction::readConfig() {
	m_defaultText = Config::readString(configGroup(), "Text", "");
}

void TestAction::writeConfig() {
	if (m_textEdit != nullptr)
		Config::writeString(configGroup(), "Text", m_textEdit->toPlainText());
}
