/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcas_defines.h
    \brief  Internal header file with some common defines for LCAS.
    \author Martijn Steenbakkers for the EU DataGrid.
    \internal
*/

#ifndef _LCAS_DEFINES_H
#define _LCAS_DEFINES_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcas_defines.h"

/******************************************************************************
                               Define constants
******************************************************************************/
#define LCAS_MAXPATHLEN    500 /*!< maximum path lengths of files, used in plugin
                               and database structures. \internal */
#define LCAS_MAXARGSTRING  2000 /*!< maximum length of the plugin argument string as
                               specified in the LCAS database. \internal */
#define LCAS_MAXARGS       51  /*!< maximum number of arguments (+1) to be passed to
                               LCAS authorization plugins/modules. \internal */

#endif /* _LCAS_DEFINES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/src/_lcas_defines.h,v $
    $Date: 2010-05-03 10:42:49 $
    $Revision: 2.9 $
    $Author: okoeroo $
******************************************************************************/
