package tests::ConfigOutputFormatSpecTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::Config::ConfigSpec;
use Lire::Config::OutputFormatSpec;
use Lire::PluginManager;
use Lire::OutputFormat;
use Lire::Test::Mock;

sub new {
    my $self = shift->SUPER::new( @_ );
    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'avail'} = new_proxy Lire::Test::Mock( 'Lire::OutputFormat' );
    $self->{'avail'}->set_result( 'name' => 'avail',
                                  'title' => 'Available OutputFormat',
                                  'description' => '<para>Description.</para>' );

    $self->{'non_avail'} = new_proxy Lire::Test::Mock( 'Lire::OutputFormat' );
    $self->{'non_avail'}->set_result( 'name' => 'non_avail',
                                      'missing_requirements' =>
                                      sub { return ( 'Unavailable' ) },
                                      'title' => 'Non-Available OutputFormat',
                                      'description' => '<para>Description.</para>' );

    $self->set_up_plugin_mgr();
    foreach my $key ( qw/avail non_avail/ ) {
        Lire::PluginManager->register_plugin( $self->{$key} );
    }

    $self->{'cfg'}{'_lr_config_spec'} = new Lire::Config::ConfigSpec();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_options {
    my $self = $_[0];

    my $spec = new Lire::Config::OutputFormatSpec( 'name' => 'test' );
    my @options = $spec->options();
    $self->assert_num_equals( 1 , scalar @options );
    $self->assert_str_equals( 'avail', $options[0]->name() );

    return;
}

1;

