package tests::ErrorTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Error qw/ an_error_occured
                    directory_already_exists file_empty
                    invalid_option missing_command
                    missing_argument missing_argument_usage
                    too_many_arguments unknown_command_usage /;

sub new {
    my $self = shift()->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = shift;

    $self->SUPER::set_up( @_ );

    return;
}

sub tear_down {
    my $self = shift;

    $self->SUPER::tear_down( @_ );

    return;
}

sub test_an_error_occured {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'error\' parameter/,
                        sub { an_error_occured() } );
    $self->assert_str_equals( "An error occured: wawa was dancing reggae",
                              an_error_occured( 'wawa was dancing reggae' ) );

    return;
}

sub test_invalid_option {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'option\' parameter/,
                        sub { invalid_option() } );
    $self->assert_str_equals( "invalid option: 'optional_wawa'",
                              invalid_option( 'optional_wawa' ) );

    return;
}

sub test_missing_argument {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'argument\' parameter/,
                        sub { missing_argument() } );
    $self->assert_str_equals( "missing 'wawa' argument",
                              missing_argument( 'wawa' ) );

    return;
}

sub test_missing_argument_usage {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'argument\' parameter/,
                        sub { missing_argument_usage() } );
    $self->assert_str_equals( "Missing 'wawa' argument.\n",
                              missing_argument_usage( 'wawa' ) );

    return;
}

sub test_directory_already_exists {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'directory\' parameter/,
                        sub { directory_already_exists() } );
    $self->assert_str_equals( "directory 'wawadir' already exists",
                              directory_already_exists( 'wawadir' ) );

    return;
}

sub test_file_empty {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'file\' parameter/,
                        sub { file_empty() } );
    $self->assert_str_equals( "file 'wawa_file' is empty",
                              file_empty( 'wawa_file' ) );

    return;
}

sub test_unknown_command_usage {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'command\' parameter/,
                        sub { unknown_command_usage() } );
    $self->assert_str_equals( "Unknown command: 'zoukwawa'.\n",
                              unknown_command_usage( 'zoukwawa' ) );

    return;
}

sub test_too_many_arguments {
    my $self = $_[0];

    $self->assert_str_equals( "too many arguments", too_many_arguments() );

    return;
}

sub test_missing_command {
    my $self = $_[0];

    $self->assert_dies( qr/missing \'command\' parameter/,
                        sub { missing_command() } );
    $self->assert_str_equals( "missing 'wawa' command",
                              missing_command( 'wawa' ) );
    $self->assert_str_equals( "missing Topnotch 'wawa' command",
                              missing_command( 'wawa', 'Topnotch' ) );

    return;
}

1;
