/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.actions.GenerateConstructor;
import org.lisaac.ldt.wizards.AbstractNewFileWizardPage;
import org.lisaac.ldt.wizards.InputParentDialog;

class NewPrototypeWizardPage
extends AbstractNewFileWizardPage {
    private final String INITIAL_PROTOTYPE_NAME = "prototype.li";
    protected Text commentField;
    protected Button styleNone;
    protected Button styleExpanded;
    protected Button styleStrict;
    protected Table tableInherit;
    protected Button generateConstructor;
    protected Button generateMain;

    protected NewPrototypeWizardPage(IStructuredSelection selection) {
        super(NewPrototypeWizardPage.class.getName(), selection);
        this.setTitle(LisaacMessages.getString("NewPrototypeWizard_2"));
        this.setDescription(LisaacMessages.getString("NewPrototypeWizard_3"));
        this.setFileExtension(".li");
    }

    public String getPrototypeDescription() {
        return this.commentField.getText();
    }

    protected InputStream getInitialContents(String filename) {
        try {
            int index = filename.lastIndexOf(46);
            if (index != -1) {
                filename = filename.substring(0, index);
            }
            return new ByteArrayInputStream(this.getPrototypeStream(filename));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getPrototypeStream(String filename) throws IOException {
        String username;
        boolean isExpanded = this.styleExpanded.getSelection();
        boolean isStrict = this.styleExpanded.getSelection();
        String contents = "\nSection Header\n\n";
        contents = String.valueOf(contents) + "  + name    := ";
        if (isExpanded) {
            contents = String.valueOf(contents) + "Expanded ";
        } else if (isStrict) {
            contents = String.valueOf(contents) + "Strict ";
        }
        contents = String.valueOf(contents) + filename.toUpperCase() + ";\n";
        String descr = this.getPrototypeDescription();
        if (descr != null && descr.length() > 0) {
            contents = String.valueOf(contents) + "  - comment := \"" + descr + "\";\n";
        }
        if ((username = LisaacPlugin.getDefault().getPreferenceStore().getString("lisaac_user")) != null && username.length() > 0) {
            contents = String.valueOf(contents) + "\n  - author := \"" + username + "\";\n";
        }
        contents = !isExpanded ? String.valueOf(contents) + "\nSection Inherit\n\n" : String.valueOf(contents) + "\nSection Insert\n\n";
        int n = this.tableInherit.getItemCount();
        if (n > 0) {
            int i = 0;
            while (i < n) {
                TableItem item = this.tableInherit.getItem(i);
                String type = item.getText(1);
                contents = type.equals("Shared") || type.equals("Shared Expanded") ? String.valueOf(contents) + "  - " : String.valueOf(contents) + "  + ";
                contents = String.valueOf(contents) + "parent_";
                contents = String.valueOf(contents) + item.getText(0).toLowerCase() + ":";
                contents = type.equals("Shared Expanded") || type.equals("Non Shared Expanded") ? String.valueOf(contents) + "Expanded " + item.getText(0) : String.valueOf(contents) + item.getText(0) + " := " + item.getText(0);
                contents = String.valueOf(contents) + ";\n";
                ++i;
            }
        } else {
            contents = String.valueOf(contents) + "  - parent_object:OBJECT := OBJECT;\n";
        }
        contents = String.valueOf(contents) + "\nSection Public\n\n";
        if (this.generateConstructor.getSelection()) {
            contents = String.valueOf(contents) + GenerateConstructor.getConstructor();
        }
        if (this.generateMain.getSelection()) {
            contents = String.valueOf(contents) + "  - main <- \n";
            contents = String.valueOf(contents) + "  // Main entry point.\n";
            contents = String.valueOf(contents) + "  (\n\n";
            contents = String.valueOf(contents) + "    \n";
            contents = String.valueOf(contents) + "  );\n";
        }
        return contents.getBytes();
    }

    public void createAdvancedControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LisaacMessages.getString("NewPrototypeWizard_25"));
        label.setFont(parent.getFont());
        Composite radioGroup = new Composite(parent, 0);
        radioGroup.setLayout((Layout)new RowLayout());
        this.styleNone = new Button(radioGroup, 16);
        this.styleNone.setFont(parent.getFont());
        this.styleNone.setSelection(true);
        this.styleNone.setText(LisaacMessages.getString("NewPrototypeWizard_26"));
        this.styleExpanded = new Button(radioGroup, 16);
        this.styleExpanded.setFont(parent.getFont());
        this.styleExpanded.setText(LisaacMessages.getString("NewPrototypeWizard_27"));
        this.styleStrict = new Button(radioGroup, 16);
        this.styleStrict.setFont(parent.getFont());
        this.styleStrict.setText(LisaacMessages.getString("NewPrototypeWizard_28"));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        radioGroup.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setText(LisaacMessages.getString("NewPrototypeWizard_29"));
        label.setFont(parent.getFont());
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.commentField = new Text(parent, 2048);
        this.commentField.setLayoutData((Object)new GridData(256));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.commentField.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setText(LisaacMessages.getString("NewPrototypeWizard_30"));
        label.setFont(parent.getFont());
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        Composite tableGroup = new Composite(parent, 0);
        tableGroup.setLayout((Layout)new RowLayout());
        Table table = new Table(tableGroup, 67844);
        TableColumn c1 = new TableColumn(table, 16384);
        c1.setText("Prototype");
        c1.setWidth(150);
        TableColumn c2 = new TableColumn(table, 16384);
        c2.setText(LisaacMessages.getString("NewPrototypeWizard_32"));
        c2.setWidth(100);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableItem itemDefault = new TableItem(table, 0);
        itemDefault.setText(new String[]{"OBJECT", "Shared"});
        Composite buttonGroup = new Composite(tableGroup, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        Button tableAdd = new Button(buttonGroup, 8);
        tableAdd.setFont(parent.getFont());
        tableAdd.setText(LisaacMessages.getString("NewPrototypeWizard_34"));
        tableAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputParentDialog input = new InputParentDialog(NewPrototypeWizardPage.this.getShell(), "New Parent...");
                if (input.open() == 0) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(new String[]{input.getParentName(), input.getParentType()});
                }
            }
        });
        Button tableRemove = new Button(buttonGroup, 8);
        tableRemove.setFont(parent.getFont());
        tableRemove.setText(LisaacMessages.getString("NewPrototypeWizard_35"));
        tableRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = table.getSelectionIndices();
                if (indices != null && indices.length > 0) {
                    int index = indices[0];
                    table.remove(index);
                }
            }
        });
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        tableGroup.setLayoutData((Object)gridData);
        this.tableInherit = table;
        label = new Label(parent, 0);
        label.setText(LisaacMessages.getString("NewPrototypeWizard_36"));
        label.setFont(parent.getFont());
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 0x1000000;
        this.generateMain = new Button(parent, 32);
        this.generateMain.setText(LisaacMessages.getString("NewPrototypeWizard_37"));
        this.generateMain.setLayoutData((Object)gridData);
        this.generateConstructor = new Button(parent, 32);
        this.generateConstructor.setText(LisaacMessages.getString("NewPrototypeWizard_38"));
        this.generateConstructor.setLayoutData((Object)gridData);
    }

    protected String getInitialFileName() {
        return "prototype.li";
    }
}

