; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel \
; RUN:     -verify-machineinstrs %s -o -| FileCheck %s

define float @float_add(float %a, float %b) {
; CHECK-LABEL: float_add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add.s $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = fadd float %a, %b
  ret float %add
}

define float @float_sub(float %a, float %b) {
; CHECK-LABEL: float_sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sub.s $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %sub = fsub float %a, %b
  ret float %sub
}

define float @float_mul(float %a, float %b) {
; CHECK-LABEL: float_mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mul.s $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %mul = fmul float %a, %b
  ret float %mul
}

define float @float_div(float %a, float %b) {
; CHECK-LABEL: float_div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    div.s $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %div = fdiv float %a, %b
  ret float %div
}

define double @double_add(double %a, double %b) {
; CHECK-LABEL: double_add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add.d $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = fadd double %a, %b
  ret double %add
}

define double @double_sub(double %a, double %b) {
; CHECK-LABEL: double_sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sub.d $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %sub = fsub double %a, %b
  ret double %sub
}

define double @double_mul(double %a, double %b) {
; CHECK-LABEL: double_mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mul.d $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %mul = fmul double %a, %b
  ret double %mul
}

define double @double_div(double %a, double %b) {
; CHECK-LABEL: double_div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    div.d $f0, $f12, $f14
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %div = fdiv double %a, %b
  ret double %div
}
