#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f1(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_char('@', str, off, len)) return false;
    if (!ptime_at(dst, str, off, len)) return false;
    return true;
}

bool ptime_f2(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f3(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f4(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f5(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

bool ptime_f6(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f7(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f8(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('Z', str, off, len)) return false;
    return true;
}

bool ptime_f9(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f10(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f11(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f12(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f13(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f14(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f15(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

bool ptime_f16(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    return true;
}

bool ptime_f17(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    return true;
}

bool ptime_f18(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f19(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

bool ptime_f20(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

bool ptime_f21(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

bool ptime_f22(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    return true;
}

bool ptime_f23(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    return true;
}

bool ptime_f24(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_char('+', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    return true;
}

bool ptime_f25(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f26(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f27(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto_end(str, off, len)) return false;
    return true;
}

bool ptime_f28(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f29(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    return true;
}

bool ptime_f30(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(',', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    return true;
}

bool ptime_f31(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f32(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_k(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f33(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f34(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_e(dst, str, off, len)) return false;
    if (!ptime_char(',', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    return true;
}

bool ptime_f35(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f36(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_I(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto_end(str, off, len)) return false;
    return true;
}

bool ptime_f37(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_I(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto_end(str, off, len)) return false;
    return true;
}

bool ptime_f38(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto_end(str, off, len)) return false;
    return true;
}

bool ptime_f39(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_e(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_I(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    return true;
}

bool ptime_f40(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_e(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    return true;
}

bool ptime_f41(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f42(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f43(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f44(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f45(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f46(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    return true;
}

bool ptime_f47(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    return true;
}

bool ptime_f48(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    return true;
}

bool ptime_f49(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    return true;
}

bool ptime_f50(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_s(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    return true;
}

void ftime_f1(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_char(dst, off_inout, len, '@');
    ftime_at(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f2(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f3(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f4(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f5(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f6(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f7(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f8(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'Z');
    dst[off_inout] = '\0';
}

void ftime_f9(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f10(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f11(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, 'T');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f12(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f13(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f14(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f15(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f16(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f17(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f18(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f19(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f20(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f21(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f22(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    dst[off_inout] = '\0';
}

void ftime_f23(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_a(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    dst[off_inout] = '\0';
}

void ftime_f24(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_char(dst, off_inout, len, '+');
    ftime_char(dst, off_inout, len, '0');
    ftime_char(dst, off_inout, len, '0');
    ftime_char(dst, off_inout, len, '0');
    ftime_char(dst, off_inout, len, '0');
    dst[off_inout] = '\0';
}

void ftime_f25(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f26(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f27(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f28(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f29(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f30(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_L(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f31(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f32(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_k(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f33(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f34(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ',');
    ftime_char(dst, off_inout, len, ' ');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f35(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f36(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_L(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f37(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f38(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_Z(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f39(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_I(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f40(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_e(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_l(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_p(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f41(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_b(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f42(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f43(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f44(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f45(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ' ');
    ftime_H(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_M(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, ':');
    ftime_S(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f46(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_d(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f47(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '-');
    ftime_m(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f48(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_d(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f49(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_Y(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '/');
    ftime_m(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

void ftime_f50(char *dst, off_t &off_inout, size_t len, const struct exttm &tm) {
    ftime_s(dst, off_inout, len, tm);
    ftime_char(dst, off_inout, len, '.');
    ftime_f(dst, off_inout, len, tm);
    dst[off_inout] = '\0';
}

struct ptime_fmt PTIMEC_FORMATS[] = {
    { "@%@", ptime_f1, ftime_f1 },
    { "%Y-%m-%d %H:%M:%S", ptime_f2, ftime_f2 },
    { "%Y-%m-%d %H:%M:%S%z", ptime_f3, ftime_f3 },
    { "%Y-%m-%d %H:%M:%S %z", ptime_f4, ftime_f4 },
    { "%Y-%m-%d %H:%M", ptime_f5, ftime_f5 },
    { "%Y-%m-%dT%H:%M:%S.%f%z", ptime_f6, ftime_f6 },
    { "%y-%m-%dT%H:%M:%S.%f%z", ptime_f7, ftime_f7 },
    { "%Y-%m-%dT%H:%M:%SZ", ptime_f8, ftime_f8 },
    { "%Y-%m-%dT%H:%M:%S%z", ptime_f9, ftime_f9 },
    { "%Y-%m-%dT%H:%M:%S", ptime_f10, ftime_f10 },
    { "%Y-%m-%dT%H:%M:%S%z", ptime_f11, ftime_f11 },
    { "%Y/%m/%d %H:%M:%S", ptime_f12, ftime_f12 },
    { "%Y/%m/%d %H:%M:%S %z", ptime_f13, ftime_f13 },
    { "%Y/%m/%d %H:%M:%S%z", ptime_f14, ftime_f14 },
    { "%Y/%m/%d %H:%M", ptime_f15, ftime_f15 },
    { "%Y %b %d %a %H:%M:%S.%L", ptime_f16, ftime_f16 },
    { "%Y %b %d %H:%M:%S.%L", ptime_f17, ftime_f17 },
    { "%Y %b %d %H:%M:%S", ptime_f18, ftime_f18 },
    { "%a %b %d %H:%M:%S %Y", ptime_f19, ftime_f19 },
    { "%a %b %d %H:%M:%S.%f %Y", ptime_f20, ftime_f20 },
    { "%a %b %d %H:%M:%S %Z %Y", ptime_f21, ftime_f21 },
    { "%a %b %d %H:%M:%S ", ptime_f22, ftime_f22 },
    { "%a %b %d %H:%M:%S.%L ", ptime_f23, ftime_f23 },
    { "%d/%b/%Y:%H:%M:%S +0000", ptime_f24, ftime_f24 },
    { "%d/%b/%Y:%H:%M:%S %z", ptime_f25, ftime_f25 },
    { "%d-%b-%Y %H:%M:%S %z", ptime_f26, ftime_f26 },
    { "%d-%b-%Y %H:%M:%S %Z", ptime_f27, ftime_f27 },
    { "%d %b %Y %H:%M:%S", ptime_f28, ftime_f28 },
    { "%d %b %Y %H:%M:%S.%L", ptime_f29, ftime_f29 },
    { "%d %b %Y %H:%M:%S,%L", ptime_f30, ftime_f30 },
    { "%b %d %H:%M:%S", ptime_f31, ftime_f31 },
    { "%b %d %k:%M:%S", ptime_f32, ftime_f32 },
    { "%b %d %l:%M:%S", ptime_f33, ftime_f33 },
    { "%b %e, %Y %l:%M:%S %p", ptime_f34, ftime_f34 },
    { "%m/%d/%y %H:%M:%S", ptime_f35, ftime_f35 },
    { "%m/%d/%Y %I:%M:%S:%L %p %Z", ptime_f36, ftime_f36 },
    { "%m/%d/%Y %I:%M:%S %p %Z", ptime_f37, ftime_f37 },
    { "%m/%d/%Y %l:%M:%S %p %Z", ptime_f38, ftime_f38 },
    { "%m/%e/%Y %I:%M:%S %p", ptime_f39, ftime_f39 },
    { "%m/%e/%Y %l:%M:%S %p", ptime_f40, ftime_f40 },
    { "%d/%b/%y %H:%M:%S", ptime_f41, ftime_f41 },
    { "%m%d %H:%M:%S", ptime_f42, ftime_f42 },
    { "%H:%M:%S", ptime_f43, ftime_f43 },
    { "%M:%S", ptime_f44, ftime_f44 },
    { "%m/%d %H:%M:%S", ptime_f45, ftime_f45 },
    { "%Y-%m-%d", ptime_f46, ftime_f46 },
    { "%Y-%m", ptime_f47, ftime_f47 },
    { "%Y/%m/%d", ptime_f48, ftime_f48 },
    { "%Y/%m", ptime_f49, ftime_f49 },
    { "%s.%f", ptime_f50, ftime_f50 },

    { NULL, NULL }
};
const char *PTIMEC_FORMAT_STR[] = {
    "@%@",
    "%Y-%m-%d %H:%M:%S",
    "%Y-%m-%d %H:%M:%S%z",
    "%Y-%m-%d %H:%M:%S %z",
    "%Y-%m-%d %H:%M",
    "%Y-%m-%dT%H:%M:%S.%f%z",
    "%y-%m-%dT%H:%M:%S.%f%z",
    "%Y-%m-%dT%H:%M:%SZ",
    "%Y-%m-%dT%H:%M:%S%z",
    "%Y-%m-%dT%H:%M:%S",
    "%Y-%m-%dT%H:%M:%S%z",
    "%Y/%m/%d %H:%M:%S",
    "%Y/%m/%d %H:%M:%S %z",
    "%Y/%m/%d %H:%M:%S%z",
    "%Y/%m/%d %H:%M",
    "%Y %b %d %a %H:%M:%S.%L",
    "%Y %b %d %H:%M:%S.%L",
    "%Y %b %d %H:%M:%S",
    "%a %b %d %H:%M:%S %Y",
    "%a %b %d %H:%M:%S.%f %Y",
    "%a %b %d %H:%M:%S %Z %Y",
    "%a %b %d %H:%M:%S ",
    "%a %b %d %H:%M:%S.%L ",
    "%d/%b/%Y:%H:%M:%S +0000",
    "%d/%b/%Y:%H:%M:%S %z",
    "%d-%b-%Y %H:%M:%S %z",
    "%d-%b-%Y %H:%M:%S %Z",
    "%d %b %Y %H:%M:%S",
    "%d %b %Y %H:%M:%S.%L",
    "%d %b %Y %H:%M:%S,%L",
    "%b %d %H:%M:%S",
    "%b %d %k:%M:%S",
    "%b %d %l:%M:%S",
    "%b %e, %Y %l:%M:%S %p",
    "%m/%d/%y %H:%M:%S",
    "%m/%d/%Y %I:%M:%S:%L %p %Z",
    "%m/%d/%Y %I:%M:%S %p %Z",
    "%m/%d/%Y %l:%M:%S %p %Z",
    "%m/%e/%Y %I:%M:%S %p",
    "%m/%e/%Y %l:%M:%S %p",
    "%d/%b/%y %H:%M:%S",
    "%m%d %H:%M:%S",
    "%H:%M:%S",
    "%M:%S",
    "%m/%d %H:%M:%S",
    "%Y-%m-%d",
    "%Y-%m",
    "%Y/%m/%d",
    "%Y/%m",
    "%s.%f",

    NULL
};
