/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.BcelObjectType;

final class BcelField
extends ResolvedMemberImpl {
    private static int AccSynthetic = 4096;
    private Field field;
    private boolean isAjSynthetic;
    private boolean isSynthetic = false;
    private AnnotationX[] annotations;
    private World world;
    private BcelObjectType bcelObjectType;
    private UnresolvedType genericFieldType = null;
    private boolean unpackedGenericSignature = false;

    BcelField(BcelObjectType declaringType, Field field) {
        super(Member.FIELD, declaringType.getResolvedTypeX(), field.getAccessFlags(), field.getName(), field.getSignature());
        this.field = field;
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.bcelObjectType = declaringType;
        this.unpackAttributes(this.world);
        this.checkedExceptions = UnresolvedType.NONE;
    }

    private void unpackAttributes(World world) {
        Attribute[] attrs = this.field.getAttributes();
        List as = BcelAttributes.readAjAttributes(this.getDeclaringType().getClassName(), attrs, this.getSourceContext(world), world, this.bcelObjectType.getWeaverVersionAttribute());
        as.addAll(AtAjAttributes.readAj5FieldAttributes(this.field, this, world.resolve(this.getDeclaringType()), this.getSourceContext(world), world.getMessageHandler()));
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            throw new BCException("weird field attribute " + a);
        }
        this.isAjSynthetic = false;
        for (int i = attrs.length - 1; i >= 0; --i) {
            if (!(attrs[i] instanceof Synthetic)) continue;
            this.isSynthetic = true;
        }
        if ((this.field.getModifiers() & AccSynthetic) != 0) {
            this.isSynthetic = true;
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationTypesRetrieved();
        Iterator iter = this.annotationTypes.iterator();
        while (iter.hasNext()) {
            ResolvedType aType = (ResolvedType)iter.next();
            if (!aType.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        ResolvedType[] ret = new ResolvedType[this.annotationTypes.size()];
        this.annotationTypes.toArray(ret);
        return ret;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null) {
            Annotation[] annos = this.field.getAnnotations();
            if (annos == null || annos.length == 0) {
                this.annotationTypes = Collections.EMPTY_SET;
                this.annotations = AnnotationX.NONE;
            } else {
                this.annotationTypes = new HashSet();
                this.annotations = new AnnotationX[annos.length];
                for (int i = 0; i < annos.length; ++i) {
                    Annotation annotation = annos[i];
                    this.annotationTypes.add(this.world.resolve(UnresolvedType.forSignature(annotation.getTypeSignature())));
                    this.annotations[i] = new AnnotationX(annotation, this.world);
                }
            }
        }
    }

    public void addAnnotation(AnnotationX annotation) {
        this.ensureAnnotationTypesRetrieved();
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        if (this.annotationTypes == Collections.EMPTY_SET) {
            this.annotationTypes = new HashSet();
        }
        this.annotationTypes.add(UnresolvedType.forName(annotation.getTypeName()).resolve(this.world));
        this.field.addAnnotation(annotation.getBcelAnnotation());
    }

    public UnresolvedType getGenericReturnType() {
        this.unpackGenericSignature();
        return this.genericFieldType;
    }

    private void unpackGenericSignature() {
        if (this.unpackedGenericSignature) {
            return;
        }
        if (!this.world.isInJava5Mode()) {
            this.genericFieldType = this.getReturnType();
            return;
        }
        this.unpackedGenericSignature = true;
        String gSig = this.field.getGenericSignature();
        if (gSig != null) {
            Signature.FieldTypeSignature fts = new GenericSignatureParser().parseAsFieldSignature(gSig);
            Signature.ClassSignature genericTypeSig = this.bcelObjectType.getGenericClassTypeSignature();
            Signature.FormalTypeParameter[] parentFormals = this.bcelObjectType.getAllFormals();
            Signature.FormalTypeParameter[] typeVars = genericTypeSig == null ? new Signature.FormalTypeParameter[]{} : genericTypeSig.formalTypeParameters;
            Signature.FormalTypeParameter[] formals = new Signature.FormalTypeParameter[parentFormals.length + typeVars.length];
            System.arraycopy(typeVars, 0, formals, 0, typeVars.length);
            System.arraycopy(parentFormals, 0, formals, typeVars.length, parentFormals.length);
            try {
                this.genericFieldType = BcelGenericSignatureToTypeXConverter.fieldTypeSignature2TypeX(fts, formals, this.world);
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determing the generic field type of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
            }
        } else {
            this.genericFieldType = this.getReturnType();
        }
    }

    public void evictWeavingState() {
        if (this.field != null) {
            this.unpackGenericSignature();
            this.unpackAttributes(this.world);
            this.ensureAnnotationTypesRetrieved();
            this.field = null;
        }
    }
}

