/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class TimeValue
extends CalendarValue
implements Comparable {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public TimeValue(GregorianCalendar gregorianCalendar, boolean bl) {
        this.calendar = gregorianCalendar;
        this.zoneSpecified = bl;
    }

    public TimeValue(CharSequence charSequence) throws XPathException {
        this.zoneSpecified = false;
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-:.+Z", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            String string = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("hour must be two digits");
            }
            if (n > 23) {
                this.badTime("hour is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!stringTokenizer.nextElement().equals(":")) {
                this.badTime("wrong delimiter after hour");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n2 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("minute must be two digits");
            }
            if (n2 > 59) {
                this.badTime("minute is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!stringTokenizer.nextElement().equals(":")) {
                this.badTime("wrong delimiter after minute");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("second must be two digits");
            }
            if (n > 61) {
                this.badTime("second is out of range");
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (stringTokenizer.hasMoreElements()) {
                if (n6 == 9) {
                    this.badTime("characters after the end");
                }
                if (((String)(object = (String)stringTokenizer.nextElement())).equals(".")) {
                    if (n6 != 0) {
                        this.badTime("decimal separator occurs twice");
                    }
                    string = (String)stringTokenizer.nextElement();
                    double d = Double.parseDouble("." + string);
                    n4 = (int)Math.round(d * 1000.0);
                    n6 = 1;
                    continue;
                }
                if (((String)object).equals("Z")) {
                    if (n6 > 1) {
                        this.badTime("Z cannot occur here");
                    }
                    this.zoneSpecified = true;
                    n5 = 0;
                    n6 = 9;
                    continue;
                }
                if (((String)object).equals("+") || ((String)object).equals("-")) {
                    if (n6 > 1) {
                        this.badTime((String)object + " cannot occur here");
                    }
                    n6 = 2;
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badTime("missing timezone");
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badTime("timezone hour must be two digits");
                    }
                    if ((n5 = Integer.parseInt(string) * 60) > 840) {
                        this.badTime("timezone hour is out of range");
                    }
                    if (!((String)object).equals("-")) continue;
                    n5 = -n5;
                    continue;
                }
                if (((String)object).equals(":")) {
                    if (n6 != 2) {
                        this.badTime("colon cannot occur here");
                    }
                    n6 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n7 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badTime("timezone minute must be two digits");
                    }
                    if (n7 > 59) {
                        this.badTime("timezone minute is out of range");
                    }
                    if (n5 < 0) {
                        n7 = -n7;
                    }
                    n5 += n7;
                    continue;
                }
                this.badTime("timezone format is incorrect");
            }
            if (n6 == 2 || n6 == 3) {
                this.badTime("timezone incomplete");
            }
            object = new SimpleTimeZone(n5 * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.setLenient(false);
            this.calendar.set(2000, 0, 1, n, n2, n3);
            this.calendar.set(14, n4);
            this.calendar.set(15, n5 * 60000);
            this.calendar.set(16, 0);
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badTime("time components out of range");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badTime("non-numeric component");
        }
    }

    private void badTime(String string) throws XPathException {
        throw new XPathException.Dynamic("Invalid time value (" + string + ")");
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 520: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 519: {
                return new DateTimeValue(this.calendar, this.zoneSpecified);
            }
        }
        throw new XPathException.Dynamic("Cannot convert time to " + StandardNames.getDisplayName(n));
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        DateTimeValue.appendString(stringBuffer, this.calendar.get(11), 2);
        stringBuffer.append(':');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(12), 2);
        stringBuffer.append(':');
        DateTimeValue.appendSeconds(this.calendar, stringBuffer);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.calendar, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public ItemType getItemType() {
        return Type.TIME_TYPE;
    }

    public CalendarValue removeTimezone() throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519)).removeTimezone().convert(520);
    }

    public CalendarValue setTimezone(SecondsDurationValue secondsDurationValue) throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519)).setTimezone(secondsDurationValue).convert(520);
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = TimeValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return 0;
        }
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = TimeValue.class$("java.util.Date")) : class$java$util$Date)) {
            return 1;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TimeValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 3;
        }
        return super.conversionPreference(clazz);
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = TimeValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TimeValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz);
        if (object == null) {
            throw new XPathException.Dynamic("Conversion of time to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 4: {
                return new IntegerValue(this.calendar.get(11));
            }
            case 5: {
                return new IntegerValue(this.calendar.get(12));
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer();
                DateTimeValue.appendSeconds(this.calendar, stringBuffer);
                return new DecimalValue(stringBuffer.toString());
            }
            case 7: {
                if (this.zoneSpecified) {
                    int n2 = (this.calendar.get(15) + this.calendar.get(16)) / 1000;
                    return SecondsDurationValue.fromSeconds(n2);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + object.getClass());
        }
        GregorianCalendar gregorianCalendar = ((TimeValue)object).calendar;
        return this.calendar.getTime().compareTo(gregorianCalendar.getTime());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.calendar.getTime().hashCode();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            double d = durationValue.getLengthInSeconds();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(13, (int)d);
            gregorianCalendar.add(14, (int)(d % 1.0 * 1000.0));
            return new TimeValue(gregorianCalendar, this.zoneSpecified);
        }
        throw new XPathException.Type("Time+Duration arithmetic is supported only for xdt:dayTimeDuration");
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue) throws XPathException {
        if (!(calendarValue instanceof TimeValue)) {
            throw new XPathException.Type("First operand of '-' is a time, but the second is not");
        }
        return super.subtract(calendarValue);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "time (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

