import GPS
import sys

def test_myclass():
    sys.stdout.write("start test_myclass\n")
    sys.stdout.flush()

    c = GPS.MyClass()
    sys.stdout.write("c.refcount=%d\n" % (sys.getrefcount(c), ))
    sys.stdout.flush()
    c = None

    c2 = GPS.MyClass.get()
    sys.stdout.write("c2.refcount=%d\n" % (sys.getrefcount(c2), ))
    sys.stdout.flush()
    c2 = None

    sys.stdout.write("finish test_myclass\n")
    sys.stdout.flush()

def test_cache():
    sys.stdout.write("start test_cache\n")
    sys.stdout.flush()

    c = GPS.Cache.get()
    sys.stdout.write("c.value=%s  c.refcount=%d\n" % (c.value(), sys.getrefcount(c)))
    sys.stdout.flush()
    c.foo = 1
    c = None

    c2 = GPS.Cache.get()
    sys.stdout.write("c2.foo=%s\n" % getattr(c2, "foo", None))
    sys.stdout.write("c2.value=%s  c2.refcount=%d\n" % (c2.value(), sys.getrefcount(c2)))
    sys.stdout.flush()

    c2.destroy()    # Simulate a free from Ada
    c2 = None       # The last ref was hold by python

    sys.stdout.write("finish test_cache\n")
    sys.stdout.flush()

test_myclass()
sys.stdout.write("\n")
test_cache()
