Name:           librep
Version:        0.92.7
Release:        1%{?dist}
Summary:        A lightweight Lisp environment
License:        GPLv2+
URL:            http://sawfish.wikia.com/
Source0:        http://download.tuxfamily.org/%{name}/%{name}_%{version}.tar.bz2

BuildRequires:  gmp-devel
BuildRequires:  gdbm-devel
BuildRequires:  readline-devel
BuildRequires:  libffi-devel
BuildRequires:  autoconf
BuildRequires:  libtool
BuildRequires:  texinfo
BuildRequires:  chrpath
BuildRequires:  emacs
Requires:       emacs-filesystem >= %{_emacs_version}
Obsoletes:      emacs-librep
Obsoletes:      emacs-librep-el

%description
This is a lightweight Lisp environment for UNIX. It contains a Lisp
interpreter, byte-code compiler and virtual machine. Applications may
use the Lisp interpreter as an extension language, or it may be used
for standalone scripts.

Originally inspired by Emacs Lisp, the language dialect combines many
of the Emacs Lisp features while trying to remove some of the main
deficiencies, with features from Common Lisp and Scheme.

%package devel
Summary:        Development files for librep
Group:          Development/Languages
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description devel
Link libraries and C header files for librep development.

%prep
%setup -q -n %{name}_%{version}

%build
./autogen.sh --nocfg
%configure --with-readline --enable-shared --disable-static
make %{?_smp_mflags}
%{_emacs_bytecompile} rep-debugger.el

%install
make install DESTDIR=%{buildroot}
rm -f %{buildroot}%{_infodir}/dir
chrpath --delete %{buildroot}%{_bindir}/rep
install -m 644 rep-debugger.elc %{buildroot}%{_emacs_sitelispdir}
find %{buildroot}%{_libdir} -name \*.la -exec rm '{}' \;

%post
/sbin/ldconfig
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir || :

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/%{name}.info %{_infodir}/dir || :
fi

%postun -p /sbin/ldconfig

%files
%license COPYING
%doc NEWS README TODO
%{_bindir}/rep
%{_bindir}/rep-remote
%{_libdir}/librep.so.*
%{_libdir}/rep/
%{_datadir}/rep/
%{_datadir}/man/man1/rep-remote.1.gz
%{_datadir}/man/man1/rep.1.gz
%{_infodir}/librep.info.gz
%{_emacs_sitelispdir}/rep-debugger.el
%{_emacs_sitelispdir}/rep-debugger.elc
%exclude %{_libdir}/rep/install-aliases
%exclude %{_libdir}/rep/libtool
%exclude %{_libdir}/rep/rules.mk

%files devel
%{_bindir}/rep-xgettext
%{_bindir}/repdoc
%{_includedir}/rep/
%{_libdir}/librep.so
%{_libdir}/pkgconfig/librep.pc
%{_libdir}/rep/install-aliases
%{_libdir}/rep/libtool
%{_libdir}/rep/rules.mk
%{_datadir}/man/man1/rep-xgettext.1.gz
%{_datadir}/man/man1/repdoc.1.gz

%changelog
* Sat Aug 13 2016 Kim B. Heino <b@bbbs.net> - 0.92.6-1
- Merge all changes from Fedora's librep.spec

* Mon Aug  1 2016 Allan Duncan <sawfish@lists.tuxfamily.org> - 0.92.6-1
- Merged librep.spec from Fedora 0.92.5-2 SRPM to include emacs files to main package
- Altered tar file name to use '_' instead of older '-'
- Included "autogen.sh" as prelim to "configure" for %prep

* Mon Aug 22 2011 Kim B. Heino <b@bbbs.net> - 0.92.1-1
- Update to 0.92.1

* Tue May  3 2011 Kim B. Heino <b@bbbs.net> - 0.92.0-1
- Update to 0.92.0

* Tue Apr 19 2011 Dan Horák <dan[at]danny.cz> - 0.91.1-5
- don't use %%{_host} which can be modified by configure on non-x86 arches

* Tue Apr 12 2011 Kim B. Heino <b@bbbs.net> - 0.91.1-4
- Add emacs-librep subpackage

* Sat Apr  2 2011 Kim B. Heino <b@bbbs.net> - 0.91.1-3
- Fix dynamic loading

* Fri Apr  1 2011 Kim B. Heino <b@bbbs.net> - 0.91.1-2
- Fix Fedora packaging guideline errors

* Thu Mar 31 2011 Kim B. Heino <b@bbbs.net> - 0.91.1-1
- Update to 0.91.1

* Sat Sep 25 2010 Kim B. Heino <b@bbbs.net> - 0.91.0-1
- fix rpath again
- fix doc-files, url, misc fixes

* Sun Jan 10 2010 Kim B. Heino <b@bbbs.net> - 0.90.6-1
- fix devel package, fix rpmlint warnings

* Sat Sep 05 2009 Kim B. Heino <b@bbbs.net>
- add dist-tag, update buildrequires

* Sun Jan 18 2009 Christopher Bratusek <zanghar@freenet.de>
- several updates

* Fri Jan 02 2009 Christopher Bratusek <nano-master@gmx.de>
- source archive is a .tar.bz2

* Thu Dec 18 2008 Christopher Bratusek <nano-master@gmx.de>
- rep.m4 no longer available
- install librep.pc

* Tue Jun 13 2000 John Harper <john@dcs.warwick.ac.uk>
- use better macros

* Wed Nov 10 1999 Michael K. Johnson <johnsonm@redhat.com>
- post{,un} use -p

* Mon Sep 13 1999 Aron Griffis <agriffis@bigfoot.com>
- 0.5 spec file update: added buildroot
