////////////////////////////////////////////////////////////////////////////////
//
//	Pico Technology USB Device Driver
//
///	\file     PicoUsbDevice_MacOSX.cpp
///	\brief    Generic Pico USB device class
//
//	Copyright (c) 2007, Pico Technology.
//	All rights reserved.
//   
//	Redistribution and use in source and binary forms, with or without
//	modification, are permitted provided that the following conditions are met:
//		* Redistributions of source code must retain the above copyright
//		  notice, this list of conditions and the following disclaimer.
//		* Redistributions in binary form must reproduce the above copyright
//		  notice, this list of conditions and the following disclaimer in the
//		  documentation and/or other materials provided with the distribution.
//		* The name of Pico Technology may not be used to endorse or promote
//		  products derived from this software without specific prior written
//		  permission.
//
//	THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY ``AS IS'' AND ANY
//	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//	DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
//	DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//	ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
//	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//	Version $Id: PicoUsbDevice_MacOSX.h,v 1.4 2007/08/01 16:54:49 douglas Exp $
//
////////////////////////////////////////////////////////////////////////////////

#include "PicoPortability.h"

/* Avoid including this header if we are not compiling for Mac OSX */
#ifdef PICO_OS_MACOSX

/* Avoid including this header more than once */
#ifndef PICOUSBDEVICE_MACOSX_H
#define PICOUSBDEVICE_MACOSX_H

#include <assert.h>
#include <pthread.h>
#include <stdio.h>
#include <mach/mach.h>

#include <CoreFoundation/CFNumber.h>

#include <IOKit/IOKitLib.h>
#include <IOKit/IOCFPlugIn.h>
#include <IOKit/usb/IOUSBLib.h>

#include "PicoUsbDevice.h"
#include "PicoUsbID.h"

//#define DEBUG 1
class PicoUsbDevice_MacOSX : PicoUsbDevice {
public:
	PicoUsbDevice_MacOSX(IOUSBDeviceInterface **newDevice);
	PicoUsbDevice_MacOSX(IOUSBDeviceInterface **newDevice,CFMutableDictionaryRef deviceProperties);
	~PicoUsbDevice_MacOSX(void);
	
	PICODEVICE_STATES Open (void);
	void              Close(void);
	
	// Getting device information
	int GetPID(void);
	int GetDID(void);
	int GetPipes(void);
	short GetHandle(void);

	const char *      GetSerialString(void);
	PICODEVICE_STATES GetDeviceState (void);
	PicoUsbDevice::PipeInformation GetPipeInformation(int pipeNumber);
	
	// Data transfer
	PICO_RETURNS ReadPipe (int pipeNumber,void *buf, unsigned int *size);
	PICO_RETURNS WritePipe(int pipeNumber,void *buf, unsigned int size);
	PICO_RETURNS ResetPipe(int pipeNumber);

public:
		
		static mach_port_t masterPort;
	
private:
		IOUSBDeviceInterface **device;
	CFMutableDictionaryRef properties;
	IOUSBInterfaceInterface **interface;
	volatile PICODEVICE_STATES state;
	pthread_mutex_t mutex;

	/// Mutex to protect deviceHandles array
	static pthread_mutex_t handlesMutex;
	/// Has the handles array been initialized?
	static bool handlesInitialized;
	/// Array of bitfields to indicate whether each device handle is in use
	static unsigned char * deviceHandles;
	/// Handle of this device (for use with C API)
	short handle;		

	char *serialString;
	// Private functions
private:
		int SetInterface(int interfaceNum);
		int setInterface(int interfaceNum);

};

#endif // not defined PICOUSBDEVICE_MACOSX_H

#endif // defined PICO_OS_MACOSX
