# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set import DataSet


class PointSet(DataSet):
    r"""
    PointSet - concrete class for storing a set of points
    
    Superclass: DataSet
    
    PointSet is an concrete class representing a set of points that
    specifies the interface for datasets that explicitly use "point"
    arrays to represent geometry. For example, PolyData,
    UnstructuredGrid, and StructuredGrid require point arrays to
    specify point positions, while ImageData represents point
    positions implicitly (and hence is not a subclass of ImageData).
    
    Note: The PolyData and UnstructuredGrid datasets (derived
    classes of PointSet) are often used in geometric computation
    (e.g., Delaunay2D).  In most cases during filter execution the
    output geometry and/or topology is created once and provided as
    output; however in a very few cases the underlying geometry/topology
    may be created and then incrementally modified. This has implications
    on the use of supporting classes like locators and cell links
    topological structures which may be required to support incremental
    editing operations. Consequently, there is a flag, Editable, that
    controls whether the dataset can be incrementally edited after it is
    initially created. By default, and for performance reasons,
    PointSet derived classes are created as non-editable.  The few
    methods that require incremental editing capabilities are documented
    in derived classes.
    
    Another important feature of PointSet classes is the use of an
    internal locator to speed up certain operations like find_cell().
    Depending on the application and desired performance, different
    locators (either a cell or point locator) of different locator types
    may be used, along with different strategies for using the locators
    to perform various operations. See the class FindCellStrategy for
    more information
    
    @sa
    PolyData StructuredGrid UnstructuredGrid FindCellStrategy
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPointSet, obj, update, **traits)
    
    editable = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify whether this dataset is editable after creation. Meaning,
        once the points and cells are defined, can the dataset be
        incrementally modified. By default, this dataset is non-editable
        (i.e., "static") after construction. The reason for this is
        performance: cell links and locators can be built (and destroyed)
        much faster is it is known that the data is static (see
        StaticCellLinks, StaticPointLocator, StaticCellLocator).
        """
    )

    def _editable_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEditable,
                        self.editable_)

    def _get_cell_locator(self):
        return wrap_vtk(self._vtk_obj.GetCellLocator())
    def _set_cell_locator(self, arg):
        old_val = self._get_cell_locator()
        self._wrap_call(self._vtk_obj.SetCellLocator,
                        deref_vtk(arg))
        self.trait_property_changed('cell_locator', old_val, arg)
    cell_locator = traits.Property(_get_cell_locator, _set_cell_locator, desc=\
        r"""
        
        """
    )

    def _get_point_locator(self):
        return wrap_vtk(self._vtk_obj.GetPointLocator())
    def _set_point_locator(self, arg):
        old_val = self._get_point_locator()
        self._wrap_call(self._vtk_obj.SetPointLocator,
                        deref_vtk(arg))
        self.trait_property_changed('point_locator', old_val, arg)
    point_locator = traits.Property(_get_point_locator, _set_point_locator, desc=\
        r"""
        
        """
    )

    def _get_points(self):
        return wrap_vtk(self._vtk_obj.GetPoints())
    def _set_points(self, arg):
        old_val = self._get_points()
        my_arg = deref_array([arg], [['vtkPoints']])
        self._wrap_call(self._vtk_obj.SetPoints,
                        my_arg[0])
        self.trait_property_changed('points', old_val, arg)
    points = traits.Property(_get_points, _set_points, desc=\
        r"""
        
        """
    )

    def build_cell_locator(self):
        """
        build_cell_locator(self) -> None
        C++: void build_cell_locator()
        Build the cell locator. In a multi-threaded environment, call
        this method in a single thread before using find_cell().
        """
        ret = self._vtk_obj.BuildCellLocator()
        return ret
        

    def build_locator(self):
        """
        build_locator(self) -> None
        C++: void build_locator()"""
        ret = self._vtk_obj.BuildLocator()
        return ret
        

    def build_point_locator(self):
        """
        build_point_locator(self) -> None
        C++: void build_point_locator()
        Build the internal point locator . In a multi-threaded
        environment, call this method in a single thread before using
        find_cell() or find_point().
        """
        ret = self._vtk_obj.BuildPointLocator()
        return ret
        

    def extended_new(self):
        """
        extended_new() -> PointSet
        C++: static PointSet *extended_new()"""
        ret = wrap_vtk(self._vtk_obj.ExtendedNew())
        return ret
        

    _updateable_traits_ = \
    (('editable', 'GetEditable'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'editable', 'global_release_data_flag',
    'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PointSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PointSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['editable', 'global_release_data_flag'], [], ['object_name']),
            title='Edit PointSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PointSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

