/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.h2;

import com.carrotsearch.junitbenchmarks.AutocloseConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.h2.DbVersions;
import com.carrotsearch.junitbenchmarks.h2.HistoryChartVisitor;
import com.carrotsearch.junitbenchmarks.h2.IChartAnnotationVisitor;
import com.carrotsearch.junitbenchmarks.h2.MethodChartVisitor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.h2.jdbcx.JdbcDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class H2Consumer
extends AutocloseConsumer
implements Closeable {
    private static final int RUN_ID;
    private static final int CLASSNAME;
    private static final int NAME;
    private static final int BENCHMARK_ROUNDS;
    private static final int WARMUP_ROUNDS;
    private static final int ROUND_AVG;
    private static final int ROUND_STDDEV;
    private static final int GC_AVG;
    private static final int GC_STDDEV;
    private static final int GC_INVOCATIONS;
    private static final int GC_TIME;
    private static final int TIME_BENCHMARK;
    private static final int TIME_WARMUP;
    private Connection connection;
    int runId;
    private PreparedStatement newTest;
    File chartsDir;
    private List<? extends IChartAnnotationVisitor> chartVisitors;

    public H2Consumer() {
        this(H2Consumer.getDefaultDbName());
    }

    public H2Consumer(File dbFileName) {
        this(dbFileName, H2Consumer.getDefaultChartsDir(), H2Consumer.getDefaultCustomKey());
    }

    public H2Consumer(File dbFileName, File chartsDir, String customKeyValue) {
        try {
            JdbcDataSource ds = new JdbcDataSource();
            ds.setURL("jdbc:h2:" + dbFileName.getAbsolutePath() + ";DB_CLOSE_ON_EXIT=FALSE");
            ds.setUser("sa");
            this.chartsDir = chartsDir;
            this.chartVisitors = this.newChartVisitors();
            this.connection = ds.getConnection();
            this.connection.setAutoCommit(false);
            AutocloseConsumer.addAutoclose(this);
            this.checkSchema();
            this.runId = this.getRunID(customKeyValue);
            this.newTest = this.connection.prepareStatement(H2Consumer.getResource("003-new-result.sql"));
            this.newTest.setInt(RUN_ID, this.runId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot initialize H2 database.", e);
        }
    }

    private List<? extends IChartAnnotationVisitor> newChartVisitors() {
        return Arrays.asList(new MethodChartVisitor(), new HistoryChartVisitor());
    }

    @Override
    public void accept(Result result) {
        Class<?> clazz = result.getTestClass();
        Method method = result.getTestMethod();
        for (IChartAnnotationVisitor iChartAnnotationVisitor : this.chartVisitors) {
            iChartAnnotationVisitor.visit(clazz, method, result);
        }
        try {
            this.newTest.setString(CLASSNAME, result.getTestClassName());
            this.newTest.setString(NAME, result.getTestMethodName());
            this.newTest.setInt(BENCHMARK_ROUNDS, result.benchmarkRounds);
            this.newTest.setInt(WARMUP_ROUNDS, result.warmupRounds);
            this.newTest.setDouble(ROUND_AVG, result.roundAverage.avg);
            this.newTest.setDouble(ROUND_STDDEV, result.roundAverage.stddev);
            this.newTest.setDouble(GC_AVG, result.gcAverage.avg);
            this.newTest.setDouble(GC_STDDEV, result.gcAverage.stddev);
            this.newTest.setInt(GC_INVOCATIONS, (int)result.gcInfo.accumulatedInvocations());
            this.newTest.setDouble(GC_TIME, (double)result.gcInfo.accumulatedTime() / 1000.0);
            this.newTest.setDouble(TIME_WARMUP, (double)result.warmupTime / 1000.0);
            this.newTest.setDouble(TIME_BENCHMARK, (double)result.benchmarkTime / 1000.0);
            this.newTest.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while saving the benchmark result to H2.", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                if (!this.connection.isClosed()) {
                    this.doClose();
                }
                this.connection = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close H2 consumer.", e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
            this.chartVisitors = this.newChartVisitors();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not rollback.", e);
        }
    }

    DbVersions getDbVersion() throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet rs = s.executeQuery("SHOW TABLES");
        HashSet<String> tables = new HashSet<String>();
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        if (!tables.contains("DBVERSION")) {
            if (tables.contains("RUNS")) {
                return DbVersions.VERSION_1;
            }
            return DbVersions.UNINITIALIZED;
        }
        rs = s.executeQuery("SELECT VERSION FROM DBVERSION");
        if (!rs.next()) {
            throw new RuntimeException("Missing version row in DBVERSION table.");
        }
        DbVersions version = DbVersions.fromInt(rs.getInt(1));
        if (rs.next()) {
            throw new RuntimeException("More than one row in DBVERSION table.");
        }
        return version;
    }

    static String getResource(String resourceName) {
        try {
            int cnt;
            InputStream is = H2Consumer.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new IOException();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((cnt = is.read(buffer)) > 0) {
                baos.write(buffer, 0, cnt);
            }
            is.close();
            baos.close();
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Required resource missing: " + resourceName);
        }
    }

    private static File getDefaultDbName() {
        String dbPath = System.getProperty("jub.db.file");
        if (dbPath != null && !dbPath.trim().equals("")) {
            return new File(dbPath);
        }
        throw new IllegalArgumentException("Missing global property: jub.db.file");
    }

    private static String getDefaultCustomKey() {
        return System.getProperty("jub.customkey");
    }

    private static File getDefaultChartsDir() {
        return new File(System.getProperty("jub.charts.dir", "."));
    }

    private int getRunID(String customKeyValue) throws SQLException {
        PreparedStatement s = this.connection.prepareStatement(H2Consumer.getResource("002-new-run.sql"), 1);
        s.setString(1, System.getProperty("java.runtime.version", "?"));
        s.setString(2, System.getProperty("os.arch", "?"));
        s.setString(3, customKeyValue);
        s.executeUpdate();
        ResultSet rs = s.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("No autogenerated keys?");
        }
        int key = rs.getInt(1);
        if (rs.next()) {
            throw new SQLException("More than one autogenerated key?");
        }
        rs.close();
        s.close();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws Exception {
        try {
            for (IChartAnnotationVisitor iChartAnnotationVisitor : this.chartVisitors) {
                iChartAnnotationVisitor.generate(this);
            }
        }
        finally {
            if (!this.connection.isClosed()) {
                this.connection.commit();
                this.connection.close();
            }
        }
    }

    private void checkSchema() throws SQLException {
        DbVersions dbVersion = this.getDbVersion();
        Statement s = this.connection.createStatement();
        switch (dbVersion) {
            case UNINITIALIZED: {
                s.execute(H2Consumer.getResource("000-create-runs.sql"));
                s.execute(H2Consumer.getResource("001-create-tests.sql"));
            }
            case VERSION_1: {
                s.execute(H2Consumer.getResource("004-create-dbversion.sql"));
                s.execute(H2Consumer.getResource("005-add-custom-key.sql"));
                this.updateDbVersion(DbVersions.VERSION_2);
            }
            case VERSION_2: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected database version: " + (Object)((Object)dbVersion));
            }
        }
        this.connection.commit();
    }

    private void updateDbVersion(DbVersions newVersion) throws SQLException {
        Statement s = this.connection.createStatement();
        s.executeUpdate("DELETE FROM DBVERSION");
        s.executeUpdate("INSERT INTO DBVERSION (VERSION) VALUES (" + newVersion.version + ")");
    }

    Connection getConnection() {
        return this.connection;
    }

    static {
        int column = 1;
        RUN_ID = column++;
        CLASSNAME = column++;
        NAME = column++;
        BENCHMARK_ROUNDS = column++;
        WARMUP_ROUNDS = column++;
        ROUND_AVG = column++;
        ROUND_STDDEV = column++;
        GC_AVG = column++;
        GC_STDDEV = column++;
        GC_INVOCATIONS = column++;
        GC_TIME = column++;
        TIME_BENCHMARK = column++;
        TIME_WARMUP = column++;
    }
}

