/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * SSHKeysPanel.java
 *
 * Created on 25.04.2010, 22:12:13
 */

package org.netbeans.modules.nativeexecution.support.ui;

import java.io.File;
import javax.swing.JFileChooser;

/**
 *
 * @author ak119685
 */
public class SSHKeysPanel extends javax.swing.JPanel {

    /** Creates new form SSHKeysPanel */
    public SSHKeysPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        fldIdentity = new javax.swing.JTextField();
        btnBrowseIdentity = new javax.swing.JButton();
        fldHosts = new javax.swing.JTextField();
        btnBrowseHosts = new javax.swing.JButton();

        jLabel1.setLabelFor(fldIdentity);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.jLabel1.text")); // NOI18N

        jLabel2.setLabelFor(fldHosts);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseIdentity, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.btnBrowseIdentity.text")); // NOI18N
        btnBrowseIdentity.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBrowseIdentityActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseHosts, org.openide.util.NbBundle.getMessage(SSHKeysPanel.class, "SSHKeysPanel.btnBrowseHosts.text")); // NOI18N
        btnBrowseHosts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBrowseHostsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 104, Short.MAX_VALUE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fldIdentity, javax.swing.GroupLayout.DEFAULT_SIZE, 263, Short.MAX_VALUE)
                    .addComponent(fldHosts, javax.swing.GroupLayout.DEFAULT_SIZE, 263, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(btnBrowseIdentity)
                    .addComponent(btnBrowseHosts)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(fldIdentity, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnBrowseIdentity))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(fldHosts, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnBrowseHosts)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnBrowseIdentityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBrowseIdentityActionPerformed
        File file = openFile();
        if (file != null) {
            fldIdentity.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_btnBrowseIdentityActionPerformed

    private void btnBrowseHostsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBrowseHostsActionPerformed
         File file = openFile();
        if (file != null) {
            fldHosts.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_btnBrowseHostsActionPerformed

    private File openFile() {
        String home = System.getProperty("user.home"); // NOI18N
        JFileChooser chooser = new JFileChooser(home);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        int dlgResult = chooser.showOpenDialog(this);
        if (JFileChooser.APPROVE_OPTION == dlgResult) {
            File result = chooser.getSelectedFile();
            if (result != null && !result.exists()) {
                result = null;
            }
            return result;
        } else {
            return null;
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnBrowseHosts;
    private javax.swing.JButton btnBrowseIdentity;
    private javax.swing.JTextField fldHosts;
    private javax.swing.JTextField fldIdentity;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables

}
