/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1

Item {
    id: item

    readonly property string type: "image"

    property string source
    signal clicked(bool atTop)
    signal activateClipboard()

    height: image.height

    UbuntuShape {
        id: image
        anchors.top: parent.top
        anchors.left: parent.left

        width: (img.sourceSize.width > item.width) ? item.width : img.sourceSize.width
        height: (img.sourceSize.height / img.sourceSize.width) * width

        image: Image {
            id: img
            source: item.source ? "image://cache/" + item.source : ""
            fillMode: Image.PreserveAspectFit
        }
    }

    MouseArea {
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        height: parent.height / 2

        onClicked: item.clicked(true)
        onPressAndHold: item.activateClipboard()
    }

    MouseArea {
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        height: parent.height / 2

        onClicked: item.clicked(false)
        onPressAndHold: item.activateClipboard()
    }
}

