/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.basicsearch;

import com.sourceforge.knecs.dsm.basicsearch.BasicSearchQuery;
import com.sourceforge.knecs.dsm.basicsearch.OrderBy;
import java.util.Enumeration;
import java.util.Vector;
import org.jdom.Element;

public class OrderByClause {
    private Vector mOrders = new Vector();

    public boolean empty() {
        return this.mOrders.isEmpty();
    }

    public Element getElement() {
        Element ret = new Element("orderby", BasicSearchQuery.DAV_NS);
        Enumeration e = this.mOrders.elements();
        while (e.hasMoreElements()) {
            OrderBy order = (OrderBy)e.nextElement();
            if (order.getProp() == null) continue;
            Element orderElement = new Element("order", BasicSearchQuery.DAV_NS);
            Element propElement = new Element("prop", BasicSearchQuery.DAV_NS);
            Element property = new Element(order.getProp().getLocalName(), order.getProp().getNamespaceURI());
            Element ordering = order.getAscending() ? new Element("ascending", BasicSearchQuery.DAV_NS) : new Element("ascending", BasicSearchQuery.DAV_NS);
            propElement.addContent(property);
            orderElement.addContent(propElement);
            orderElement.addContent(ordering);
            ret.addContent(orderElement);
        }
        return ret;
    }

    public Vector getOrders() {
        return this.mOrders;
    }

    public void setOrders(Vector orders) {
        this.mOrders = orders;
    }

    public void addOrder(OrderBy order) {
        this.mOrders.add(order);
    }

    public void removeOrder(OrderBy order) {
        this.mOrders.remove(order);
    }

    public void clearOrders() {
        this.mOrders.clear();
    }
}

