/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToGamessUSInput
extends AbstractBasisSetXmlToText {
    String mTitle;

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        int len = this.mTitle.length();
        if (len < 8) {
            this.mTitle = this.mTitle + "GBASIS00".substring(0, 8 - len);
        } else if (len > 8) {
            this.mTitle = this.mTitle.substring(0, 8);
        }
        output.append("$DATA");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("$END\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        output.append("\n" + elementName.toUpperCase() + "\n");
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            Matrix[] matricesList = null;
            if (!shell.equalsIgnoreCase("SP")) {
                matricesList = this.splitMatrixNcolumnTo2column(matrix);
            } else {
                matricesList = new Matrix[]{new Matrix(rows, columns)};
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        matricesList[0].setValue(i, j, matrix.getValue(i, j));
                    }
                }
            }
            try {
                for (int m = 0; m < matricesList.length; ++m) {
                    int rows2 = matricesList[m].getNumRows();
                    int columns2 = matricesList[m].getNumColumns();
                    String gshell = shell.equals("SP") ? "L" : shell;
                    output.append(gshell + "   " + rows2 + "\n");
                    for (int i = 0; i < rows2; ++i) {
                        output.append(this.formatInteger(i + 1, 3));
                        for (int j = 0; j < columns2; ++j) {
                            String value = this.formattedValue(matricesList[m].getValue(i, j));
                            output.append(value);
                        }
                        output.append("\n");
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

